/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfo {
    protected static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected final DBMeta _dbmeta;
    protected final String _columnDbName;
    protected final String _columnAlias;
    protected final boolean _notNull;
    protected final String _propertyName;
    protected final Class<?> _propertyType;
    protected final boolean _primary;
    protected final boolean _autoIncrement;
    protected final String _columnDbType;
    protected final Integer _columnSize;
    protected final Integer _columnDecimalDigits;
    protected final boolean _commonColumn;
    protected final DBMeta.OptimisticLockType _optimisticLockType;
    protected final String _columnComment;
    protected final List<String> _foreignPropList;
    protected final List<String> _refererrPropList;

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String columnAlias, boolean notNull, String propertyName, Class<?> propertyType, boolean primary, boolean autoIncrement, String columnDbType, Integer columnSize, Integer columnDecimalDigits, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType, String columnComment, List<String> foreignPropList, List<String> refererrPropList) {
        this.assertObjectNotNull("dbmeta", dbmeta);
        this.assertObjectNotNull("columnDbName", columnDbName);
        this.assertObjectNotNull("propertyName", propertyName);
        this.assertObjectNotNull("propertyType", propertyType);
        this._dbmeta = dbmeta;
        this._columnDbName = columnDbName;
        this._columnAlias = columnAlias;
        this._notNull = notNull;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._primary = primary;
        this._autoIncrement = autoIncrement;
        this._columnSize = columnSize;
        this._columnDbType = columnDbType;
        this._columnDecimalDigits = columnDecimalDigits;
        this._commonColumn = commonColumn;
        this._optimisticLockType = optimisticLockType != null ? optimisticLockType : DBMeta.OptimisticLockType.NONE;
        this._columnComment = columnComment;
        this._foreignPropList = foreignPropList != null ? foreignPropList : EMPTY_LIST;
        this._refererrPropList = refererrPropList != null ? refererrPropList : EMPTY_LIST;
    }

    public Method findSetter() {
        return this.findMethod(this._dbmeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{this._propertyType});
    }

    public Method findGetter() {
        return this.findMethod(this._dbmeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    protected String buildInitCapPropertyName() {
        return this.initCap(this._propertyName);
    }

    protected String initCap(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._dbmeta.hashCode() + this._columnDbName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo target = (ColumnInfo)obj;
        if (!this._dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        return this._columnDbName.equals(target.getColumnDbName());
    }

    public String toString() {
        return this._dbmeta.getTableDbName() + "." + this._columnDbName;
    }

    public DBMeta getDBMeta() {
        return this._dbmeta;
    }

    public String getColumnDbName() {
        return this._columnDbName;
    }

    public String getColumnAlias() {
        return this._columnAlias;
    }

    public boolean isNotNull() {
        return this._notNull;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Class<?> getPropertyType() {
        return this._propertyType;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public boolean isAutoIncrement() {
        return this._autoIncrement;
    }

    public String getColumnDbType() {
        return this._columnDbType;
    }

    public Integer getColumnSize() {
        return this._columnSize;
    }

    public Integer getColumnDecimalDigits() {
        return this._columnDecimalDigits;
    }

    public boolean isCommonColumn() {
        return this._commonColumn;
    }

    public boolean isOptimisticLock() {
        return this.isVersionNo() || this.isUpdateDate();
    }

    public boolean isVersionNo() {
        return DBMeta.OptimisticLockType.VERSION_NO == this._optimisticLockType;
    }

    public boolean isUpdateDate() {
        return DBMeta.OptimisticLockType.UPDATE_DATE == this._optimisticLockType;
    }

    public String getColumnComment() {
        return this._columnComment;
    }

    public List<ForeignInfo> getForeignInfoList() {
        ArrayList<ForeignInfo> foreignInfoList = new ArrayList<ForeignInfo>();
        for (String foreignProp : this._foreignPropList) {
            foreignInfoList.add(this.getDBMeta().findForeignInfo(foreignProp));
        }
        return Collections.unmodifiableList(foreignInfoList);
    }

    public List<ReferrerInfo> getReferrerInfoList() {
        ArrayList<ReferrerInfo> referrerInfoList = new ArrayList<ReferrerInfo>();
        for (String fkProp : this._refererrPropList) {
            referrerInfoList.add(this.getDBMeta().findReferrerInfo(fkProp));
        }
        return Collections.unmodifiableList(referrerInfoList);
    }
}

