/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.bs;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.texen.ant.TexenTask;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfEnvironmentType;
import org.seasar.dbflute.config.DfSpecifiedSqlFile;
import org.seasar.dbflute.friends.torque.DfAntTaskUtil;
import org.seasar.dbflute.friends.velocity.DfGenerator;
import org.seasar.dbflute.friends.velocity.DfOriginalLog4JLogSystem;
import org.seasar.dbflute.helper.jdbc.connection.DfSimpleDataSourceCreator;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;
import org.seasar.dbflute.logic.outsidesql.DfSqlFileCollector;
import org.seasar.dbflute.logic.scmconn.DfCurrentSchemaConnector;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfRefreshProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractTexenTask
extends TexenTask {
    public static final Log _log = LogFactory.getLog(DfAbstractTexenTask.class);
    protected String _driver;
    protected String _url;
    protected String _schema;
    protected String _userId;
    protected String _password;
    protected Properties _connectionProperties;
    protected DfSimpleDataSourceCreator _dataSourceCreator = new DfSimpleDataSourceCreator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute() {
        block42: {
            long before;
            block40: {
                before = System.currentTimeMillis();
                this.initializeDatabaseInfo();
                if (this.isUseDataSource()) {
                    this.setupDataSource();
                }
                this.doExecute();
                Object var6_2 = null;
                if (!this.isUseDataSource()) break block40;
                this.commitDataSource();
                Object var9_6 = null;
                try {
                    this.destroyDataSource();
                }
                catch (SQLException ignored2) {
                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                }
                break block40;
                {
                    catch (SQLException ignored) {
                        var9_6 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (SQLException ignored2) {
                            _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                        }
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    try {
                        this.destroyDataSource();
                    }
                    catch (SQLException ignored2) {
                        _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                    }
                    throw throwable;
                }
            }
            long after = System.currentTimeMillis();
            String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
            StringBuilder sb = new StringBuilder();
            String ln = this.ln();
            sb.append(ln);
            sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
            sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
            sb.append(ln);
            sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
            sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
            sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
            sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
            sb.append(ln);
            sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
            sb.append(ln).append("    driver = " + this._driver);
            sb.append(ln).append("    url    = " + this._url);
            sb.append(ln).append("    schema = " + this._schema);
            sb.append(ln).append("    user   = " + this._userId);
            sb.append(ln).append("    props  = " + this._connectionProperties);
            String finalInformation = this.getFinalInformation();
            if (finalInformation != null) {
                sb.append(ln);
                sb.append(finalInformation);
            }
            sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
            _log.info((Object)sb.toString());
            {
                break block42;
                catch (Exception e) {
                    block43: {
                        try {
                            this.logException(e);
                        }
                        catch (Throwable ignored) {
                            _log.warn((Object)"Ignored exception occured!", ignored);
                            _log.error((Object)"Failed to execute DBFlute Task!", (Throwable)e);
                        }
                        this.throwTaskFailure();
                        Object var6_3 = null;
                        if (this.isUseDataSource()) {
                            this.commitDataSource();
                            Object var9_8 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (SQLException ignored2) {
                                _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                            }
                            break block43;
                            {
                                catch (SQLException ignored) {
                                    var9_8 = null;
                                    try {
                                        this.destroyDataSource();
                                    }
                                    catch (SQLException ignored2) {
                                        _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                    }
                                    break block43;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (SQLException ignored2) {
                                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    after = System.currentTimeMillis();
                    environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                    sb = new StringBuilder();
                    ln = this.ln();
                    sb.append(ln);
                    sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                    sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                    sb.append(ln);
                    sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                    sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                    sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                    sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                    sb.append(ln);
                    sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                    sb.append(ln).append("    driver = " + this._driver);
                    sb.append(ln).append("    url    = " + this._url);
                    sb.append(ln).append("    schema = " + this._schema);
                    sb.append(ln).append("    user   = " + this._userId);
                    sb.append(ln).append("    props  = " + this._connectionProperties);
                    finalInformation = this.getFinalInformation();
                    if (finalInformation != null) {
                        sb.append(ln);
                        sb.append(finalInformation);
                    }
                    sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                    _log.info((Object)sb.toString());
                    break block42;
                }
                catch (Error e) {
                    block45: {
                        try {
                            this.logError(e);
                        }
                        catch (Throwable ignored) {
                            _log.warn((Object)"Ignored exception occured!", ignored);
                            _log.error((Object)"Failed to execute DBFlute Task!", (Throwable)e);
                        }
                        this.throwTaskFailure();
                        Object var6_4 = null;
                        if (this.isUseDataSource()) {
                            this.commitDataSource();
                            Object var9_10 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (SQLException ignored2) {
                                _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                            }
                            break block45;
                            {
                                catch (SQLException ignored) {
                                    var9_10 = null;
                                    try {
                                        this.destroyDataSource();
                                    }
                                    catch (SQLException ignored2) {
                                        _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                    }
                                    break block45;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (SQLException ignored2) {
                                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    after = System.currentTimeMillis();
                    environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                    sb = new StringBuilder();
                    ln = this.ln();
                    sb.append(ln);
                    sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                    sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                    sb.append(ln);
                    sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                    sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                    sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                    sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                    sb.append(ln);
                    sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                    sb.append(ln).append("    driver = " + this._driver);
                    sb.append(ln).append("    url    = " + this._url);
                    sb.append(ln).append("    schema = " + this._schema);
                    sb.append(ln).append("    user   = " + this._userId);
                    sb.append(ln).append("    props  = " + this._connectionProperties);
                    finalInformation = this.getFinalInformation();
                    if (finalInformation != null) {
                        sb.append(ln);
                        sb.append(finalInformation);
                    }
                    sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                    _log.info((Object)sb.toString());
                }
            }
            catch (Throwable throwable) {
                block47: {
                    Object var6_5 = null;
                    if (this.isUseDataSource()) {
                        this.commitDataSource();
                        Object var9_12 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (SQLException ignored2) {
                            _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                        }
                        break block47;
                        {
                            catch (SQLException ignored) {
                                var9_12 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (SQLException ignored2) {
                                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            Object var9_13 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (SQLException ignored2) {
                                _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                            }
                            throw throwable2;
                        }
                    }
                }
                after = System.currentTimeMillis();
                environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                sb = new StringBuilder();
                ln = this.ln();
                sb.append(ln);
                sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                sb.append(ln);
                sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                sb.append(ln);
                sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                sb.append(ln).append("    driver = " + this._driver);
                sb.append(ln).append("    url    = " + this._url);
                sb.append(ln).append("    schema = " + this._schema);
                sb.append(ln).append("    user   = " + this._userId);
                sb.append(ln).append("    props  = " + this._connectionProperties);
                finalInformation = this.getFinalInformation();
                if (finalInformation != null) {
                    sb.append(ln);
                    sb.append(finalInformation);
                }
                sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                _log.info((Object)sb.toString());
                throw throwable;
            }
        }
    }

    protected void logException(Exception e) {
        DfAntTaskUtil.logException(e, this.getDisplayTaskName());
    }

    protected void logError(Error e) {
        DfAntTaskUtil.logError(e, this.getDisplayTaskName());
    }

    protected String getDisplayTaskName() {
        String taskName = this.getTaskName();
        return DfAntTaskUtil.getDisplayTaskName(taskName);
    }

    protected String getFinalInformation() {
        return null;
    }

    protected void throwTaskFailure() {
        DfAntTaskUtil.throwTaskFailure(this.getDisplayTaskName());
    }

    protected void initializeDatabaseInfo() {
        this._driver = this.getDatabaseProperties().getDatabaseDriver();
        this._url = this.getDatabaseProperties().getDatabaseUrl();
        this._userId = this.getDatabaseProperties().getDatabaseUser();
        this._schema = this.getDatabaseProperties().getDatabaseSchema();
        this._password = this.getDatabaseProperties().getDatabasePassword();
        this._connectionProperties = this.getDatabaseProperties().getDatabaseConnectionProperties();
    }

    protected abstract void doExecute();

    protected String getPerformanceView(long mil) {
        if (mil < 0L) {
            return String.valueOf(mil);
        }
        long sec = mil / 1000L;
        long min = sec / 60L;
        sec %= 60L;
        mil %= 1000L;
        StringBuffer sb = new StringBuffer();
        if (min >= 10L) {
            sb.append(min).append("m");
        } else if (min < 10L && min >= 0L) {
            sb.append("0").append(min).append("m");
        }
        if (sec >= 10L) {
            sb.append(sec).append("s");
        } else if (sec < 10L && sec >= 0L) {
            sb.append("0").append(sec).append("s");
        }
        if (mil >= 100L) {
            sb.append(mil).append("ms");
        } else if (mil < 100L && mil >= 10L) {
            sb.append("0").append(mil).append("ms");
        } else if (mil < 10L && mil >= 0L) {
            sb.append("00").append(mil).append("ms");
        }
        return sb.toString();
    }

    protected void fireVelocityProcess() {
        this.assertBasicAntParameter();
        this.setInputEncoding(this.getBasicProperties().getTemplateFileEncoding());
        this.setOutputEncoding(this.getBasicProperties().getSourceFileEncoding());
        try {
            this.initializeVelocityInstance();
            DfGenerator generator = this.setupGenerator();
            Context ctx = this.setupControlContext();
            _log.info((Object)("generator.parse(\"" + this.controlTemplate + "\", c);"));
            generator.parse(this.controlTemplate, ctx);
            generator.shutdown();
            this.cleanup();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            String msg = "Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'.";
            throw new IllegalStateException(msg, e.getWrappedThrowable());
        }
        catch (ParseErrorException e) {
            throw new IllegalStateException("Velocity syntax error.", e);
        }
        catch (ResourceNotFoundException e) {
            throw new IllegalStateException("Resource not found.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Generation failed.", e);
        }
    }

    private void assertBasicAntParameter() {
        if (this.templatePath == null && !this.useClasspath) {
            String msg = "The template path needs to be defined if you are not using the classpath for locating templates!";
            throw new IllegalStateException(msg);
        }
        if (this.controlTemplate == null) {
            throw new IllegalStateException("The control template needs to be defined!");
        }
    }

    private void initializeVelocityInstance() {
        if (this.templatePath != null) {
            this.log("Using templatePath: " + this.templatePath, 3);
            this.setupVelocityTemplateProperty();
        }
        if (this.useClasspath) {
            this.log("Using classpath");
            this.setupVelocityClasspathProperty();
        }
        this.setupVelocityLogProperty();
        try {
            Velocity.init();
        }
        catch (Exception e) {
            String msg = "Failed to initialize Velocity:";
            msg = msg + " templatePath=" + this.templatePath + " useClasspath=" + this.useClasspath;
            throw new IllegalStateException(msg, e);
        }
    }

    private void setupVelocityTemplateProperty() {
        Velocity.setProperty((String)"file.resource.loader.path", (Object)this.templatePath);
    }

    private void setupVelocityClasspathProperty() {
        String resourceLoaderName = "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader";
        Velocity.addProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"classpath.resource.loader.cache", (Object)"false");
        Velocity.setProperty((String)"classpath.resource.loader.modificationCheckInterval", (Object)"2");
    }

    private void setupVelocityLogProperty() {
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)DfOriginalLog4JLogSystem.class.getName());
    }

    private DfGenerator setupGenerator() {
        DfGenerator generator = this.getGeneratorHandler();
        generator.setInputEncoding(this.inputEncoding);
        generator.setOutputEncoding(this.outputEncoding);
        if (this.templatePath != null) {
            generator.setTemplatePath(this.templatePath);
        }
        return generator;
    }

    private Context setupControlContext() {
        Context ctx;
        try {
            ctx = this.initControlContext();
        }
        catch (Exception e) {
            String msg = "Failed to initialize control context:";
            msg = msg + " templatePath=" + this.templatePath + " useClasspath=" + this.useClasspath;
            throw new IllegalStateException(msg, e);
        }
        try {
            this.populateInitialContext(ctx);
        }
        catch (Exception e) {
            String msg = "Failed to populate initial context:";
            msg = msg + " templatePath=" + this.templatePath + " useClasspath=" + this.useClasspath;
            throw new IllegalStateException(msg, e);
        }
        if (this.contextProperties != null) {
            Iterator i = this.contextProperties.getKeys();
            while (i.hasNext()) {
                String property = (String)i.next();
                String value = this.contextProperties.getString(property);
                try {
                    ctx.put(property, (Object)new Integer(value));
                }
                catch (NumberFormatException nfe) {
                    String booleanString = this.contextProperties.testBoolean(value);
                    if (booleanString != null) {
                        ctx.put(property, (Object)Boolean.valueOf(booleanString));
                        continue;
                    }
                    if (property.endsWith("file.contents")) {
                        String canonicalPath;
                        try {
                            canonicalPath = this.getProject().resolveFile(value).getCanonicalPath();
                        }
                        catch (IOException e) {
                            String msg = "Failed to get the canonical path:";
                            msg = msg + " property=" + property + " value=" + value;
                            throw new IllegalStateException(msg, e);
                        }
                        value = DfAbstractTexenTask.fileContentsToString(canonicalPath);
                        property = property.substring(0, property.indexOf("file.contents") - 1);
                    }
                    ctx.put(property, (Object)value);
                }
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String fileContentsToString(String file) {
        String contents = "";
        File f = new File(file);
        if (!f.exists()) return contents;
        FileReader fr = null;
        fr = new FileReader(f);
        char[] template = new char[(int)f.length()];
        fr.read(template);
        contents = new String(template);
        Object var6_6 = null;
        if (fr == null) return contents;
        try {
            fr.close();
            return contents;
        }
        catch (IOException ignored) {}
        return contents;
        {
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
                Object var6_7 = null;
                if (fr == null) return contents;
                try {
                    fr.close();
                    return contents;
                }
                catch (IOException ignored) {}
                return contents;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fr == null) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected abstract boolean isUseDataSource();

    protected void setupDataSource() throws SQLException {
        this._dataSourceCreator.setUserId(this._userId);
        this._dataSourceCreator.setPassword(this._password);
        this._dataSourceCreator.setDriver(this._driver);
        this._dataSourceCreator.setUrl(this._url);
        this._dataSourceCreator.setConnectionProperties(this._connectionProperties);
        this._dataSourceCreator.setAutoCommit(true);
        this._dataSourceCreator.create();
        this.connectSchema();
    }

    protected void commitDataSource() throws SQLException {
        this._dataSourceCreator.commit();
    }

    protected void destroyDataSource() throws SQLException {
        this._dataSourceCreator.destroy();
        if (this.getBasicProperties().isDatabaseDerby()) {
            DfAntTaskUtil.shutdownIfDerbyEmbedded(this._driver);
        }
    }

    protected DataSource getDataSource() {
        return DfDataSourceContext.getDataSource();
    }

    protected void connectSchema() throws SQLException {
        DfCurrentSchemaConnector connector = new DfCurrentSchemaConnector(this._schema, this.getBasicProperties());
        connector.connectSchema(this.getDataSource());
    }

    public void setContextProperties(String file) {
        try {
            Properties prop = DfAntTaskUtil.getBuildProperties(file, this.getProject());
            DfBuildProperties.getInstance().setProperties(prop);
            this.contextProperties = new ExtendedProperties();
            Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                this.contextProperties.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        catch (RuntimeException e) {
            String msg = "Failed to set context properties:";
            msg = msg + " file=" + file + " contextProperties=" + this.contextProperties;
            _log.warn((Object)msg, (Throwable)e);
            throw e;
        }
    }

    protected List<File> collectSqlFileList() {
        String sqlDirectory = this.getProperties().getOutsideSqlProperties().getSqlDirectory();
        DfSqlFileCollector sqlFileCollector = new DfSqlFileCollector(sqlDirectory, this.getBasicProperties());
        return sqlFileCollector.collectSqlFileList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void refreshResources() {
        if (!this.isRefresh()) {
            return;
        }
        String projectName = this.getRefreshProjectName();
        StringBuilder sb = new StringBuilder().append("refresh?");
        sb.append(projectName).append("=INFINITE");
        URL url = this.getRefreshRequestURL(sb.toString());
        if (url == null) {
            return;
        }
        InputStream is = null;
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        _log.info((Object)("...Refreshing the project: " + projectName));
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(this.getRefreshRequestReadTimeout());
        connection.connect();
        is = connection.getInputStream();
        _log.info((Object)"");
        _log.info((Object)"    --> OK, Look the refreshed project!");
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)"");
        Object var7_7 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException ignored2) {}
        return;
        {
            catch (IOException ignored) {
                _log.info((Object)"");
                _log.info((Object)("    --> Oh, no! " + ignored.getMessage() + ": " + url));
                _log.info((Object)"- - - - - - - - - -/");
                _log.info((Object)"");
                Object var7_8 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException ignored2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignored2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean isRefresh() {
        DfRefreshProperties prop = this.getProperties().getRefreshProperties();
        return prop.hasRefreshDefinition();
    }

    protected int getRefreshRequestReadTimeout() {
        return 3000;
    }

    protected String getRefreshProjectName() {
        DfRefreshProperties prop = this.getProperties().getRefreshProperties();
        return prop.getProjectName();
    }

    protected URL getRefreshRequestURL(String path) {
        DfRefreshProperties prop = this.getProperties().getRefreshProperties();
        String requestUrl = prop.getRequestUrl();
        if (requestUrl.length() > 0) {
            if (!requestUrl.endsWith("/")) {
                requestUrl = requestUrl + "/";
            }
            try {
                return new URL(requestUrl + path);
            }
            catch (MalformedURLException e) {
                _log.warn((Object)("The URL was invalid: " + requestUrl), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected void showTargetSqlFileInformation(List<File> sqlFileList) {
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        _log.info((Object)("Target SQL files: " + sqlFileList.size()));
        _log.info((Object)" ");
        for (File sqlFile : sqlFileList) {
            _log.info((Object)("  " + sqlFile.getName()));
        }
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)" ");
        String specifiedSqlFile = DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile();
        if (specifiedSqlFile != null) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)("Specified SQL file: " + specifiedSqlFile));
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)" ");
        }
    }

    protected void showSkippedFileInformation() {
        boolean skipGenerateIfSameFile = this.getProperties().getLittleAdjustmentProperties().isSkipGenerateIfSameFile();
        if (!skipGenerateIfSameFile) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)"All class files have been generated. (overrided)");
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)"");
            return;
        }
        List<String> parseFileNameList = DfGenerator.getInstance().getParseFileNameList();
        int parseSize = parseFileNameList.size();
        if (parseSize == 0) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)"No class file has been parsed.");
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)"");
            return;
        }
        List<String> skipFileNameList = DfGenerator.getInstance().getSkipFileNameList();
        int skipSize = skipFileNameList.size();
        if (skipSize == 0) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)"All class files have been generated. (overrided)");
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)"");
            return;
        }
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        if (skipSize == parseSize) {
            _log.info((Object)"All class files have been skipped generating");
            _log.info((Object)"                because they have no change.");
        } else {
            _log.info((Object)"Several class files have been skipped generating");
            _log.info((Object)"                    because they have no change.");
        }
        _log.info((Object)"");
        _log.info((Object)("    --> " + skipSize + " skipped (in " + parseSize + " files)"));
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)"");
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    public DfGenerator getGeneratorHandler() {
        return DfGenerator.getInstance();
    }

    protected String ln() {
        return "\n";
    }

    public String getTargetDatabase() {
        return this.getBasicProperties().getDatabaseType();
    }

    public void setEnvironmentType(String environmentType) {
        DfEnvironmentType.getInstance().setEnvironmentType(environmentType);
    }
}

