/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.dbflute.s2dao.rowcreator.TnRowCreator;
import org.seasar.dbflute.s2dao.rshandler.TnAbstractBeanMetaDataResultSetHandler;
import org.seasar.dbflute.s2dao.rshandler.TnRelationKey;
import org.seasar.dbflute.s2dao.rshandler.TnRelationRowCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBeanListMetaDataResultSetHandler
extends TnAbstractBeanMetaDataResultSetHandler {
    public TnBeanListMetaDataResultSetHandler(TnBeanMetaData beanMetaData, TnRowCreator rowCreator, TnRelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        final ArrayList list = new ArrayList();
        this.mappingBean(rs, new BeanRowHandler(){

            public void handle(Object row) throws SQLException {
                list.add(row);
            }
        });
        return list;
    }

    protected void mappingBean(ResultSet rs, BeanRowHandler handler) throws SQLException {
        Set<String> columnNames = null;
        Map<String, TnPropertyType> propertyCache = null;
        Map<String, Map<String, TnPropertyType>> relationPropertyCache = null;
        TnRelationRowCache relRowCache = null;
        int relSize = this.getBeanMetaData().getRelationPropertyTypeSize();
        boolean hasCB = this.hasConditionBean();
        boolean emptyRelation = this.isSelectedForeignInfoEmpty();
        boolean hasOSC = this.hasOutsideSqlContext();
        boolean specifiedOutsideSql = this.isSpecifiedOutsideSql();
        boolean skipRelationLoop = hasCB && emptyRelation || hasOSC && specifiedOutsideSql;
        Map<String, Integer> selectIndexMap = ResourceContext.getSelectIndexMap();
        while (rs.next()) {
            if (columnNames == null) {
                columnNames = this.createColumnNames(rs);
            }
            if (propertyCache == null) {
                propertyCache = this.createPropertyCache(columnNames);
            }
            Object row = this.createRow(rs, propertyCache);
            if (skipRelationLoop) {
                this.postCreateRow(row);
                handler.handle(row);
                continue;
            }
            if (relationPropertyCache == null) {
                relationPropertyCache = this.createRelationPropertyCache(columnNames);
            }
            if (relRowCache == null) {
                relRowCache = this.createRelationRowCache(relSize);
            }
            for (int i = 0; i < relSize; ++i) {
                TnRelationPropertyType rpt = this.getBeanMetaData().getRelationPropertyType(i);
                if (rpt == null || hasCB && !this.hasSelectedForeignInfo(this.buildRelationNoSuffix(rpt))) continue;
                HashMap<String, Object> relKeyValues = new HashMap<String, Object>();
                TnRelationKey relKey = this.createRelationKey(rs, rpt, columnNames, relKeyValues, selectIndexMap);
                Object relationRow = null;
                if (relKey != null && (relationRow = relRowCache.getRelationRow(i, relKey)) == null && (relationRow = this.createRelationRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache)) != null) {
                    relRowCache.addRelationRow(i, relKey, relationRow);
                    this.postCreateRow(relationRow);
                }
                if (relationRow == null) continue;
                DfPropertyDesc pd = rpt.getPropertyDesc();
                pd.setValue(row, relationRow);
            }
            this.postCreateRow(row);
            handler.handle(row);
        }
    }

    protected TnRelationRowCache createRelationRowCache(int relSize) {
        return new TnRelationRowCache(relSize);
    }

    protected TnRelationKey createRelationKey(ResultSet rs, TnRelationPropertyType rpt, Set<String> columnNames, Map<String, Object> relKeyValues, Map<String, Integer> selectIndexMap) throws SQLException {
        ArrayList<Object> keyList = new ArrayList<Object>();
        TnBeanMetaData bmd = rpt.getBeanMetaData();
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            ValueType valueType;
            TnPropertyType pt;
            String columnName = rpt.getMyKey(i);
            if (columnNames.contains(columnName)) {
                pt = this.getBeanMetaData().getPropertyTypeByColumnName(columnName);
                valueType = pt.getValueType();
            } else {
                pt = bmd.getPropertyTypeByColumnName(rpt.getYourKey(i));
                columnName = pt.getColumnName() + this.buildRelationNoSuffix(rpt);
                if (columnNames.contains(columnName)) {
                    valueType = pt.getValueType();
                } else {
                    return null;
                }
            }
            Object value = selectIndexMap != null ? ResourceContext.getValue(rs, columnName, valueType, selectIndexMap) : valueType.getValue(rs, columnName);
            if (value == null) {
                return null;
            }
            relKeyValues.put(columnName, value);
            keyList.add(value);
        }
        if (keyList.size() > 0) {
            Object[] keys = keyList.toArray();
            return new TnRelationKey(keys);
        }
        return null;
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected boolean isSelectedForeignInfoEmpty() {
        if (!this.hasConditionBean()) {
            return true;
        }
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().isSelectedForeignInfoEmpty();
    }

    protected boolean hasSelectedForeignInfo(String relationNoSuffix) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().hasSelectedForeignInfo(relationNoSuffix);
    }

    protected String buildRelationNoSuffix(TnRelationPropertyType rpt) {
        return "_" + rpt.getRelationNo();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected boolean isSpecifiedOutsideSql() {
        if (!this.hasOutsideSqlContext()) {
            return false;
        }
        OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
        return context.isSpecifiedOutsideSql();
    }

    protected static interface BeanRowHandler {
        public void handle(Object var1) throws SQLException;
    }
}

