/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.mapping;

import java.util.Map;
import org.apache.torque.engine.database.model.TypeMap;
import org.seasar.dbflute.exception.DfJDBCTypeNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfJdbcTypeMapper {
    protected Map<String, String> _nameToJdbcTypeMap;
    protected Resource _resource;

    public DfJdbcTypeMapper(Map<String, String> nameToJdbcTypeMap, Resource resource) {
        this._nameToJdbcTypeMap = nameToJdbcTypeMap;
        this._resource = resource;
    }

    public String getColumnJdbcType(int jdbcDefValue, String dbTypeName) {
        String torqueType;
        if (dbTypeName != null && this._nameToJdbcTypeMap != null && !this._nameToJdbcTypeMap.isEmpty() && (torqueType = this._nameToJdbcTypeMap.get(dbTypeName)) != null) {
            return torqueType;
        }
        String adjustment = this.processForcedAdjustment(jdbcDefValue, dbTypeName);
        if (adjustment != null) {
            return adjustment;
        }
        if (!this.isOtherType(jdbcDefValue)) {
            try {
                return this.getJdbcType(jdbcDefValue);
            }
            catch (DfJDBCTypeNotFoundException ignored) {
                // empty catch block
            }
        }
        if (dbTypeName == null) {
            return this.getVarcharJdbcType();
        }
        if (dbTypeName.toLowerCase().contains("varchar")) {
            return this.getVarcharJdbcType();
        }
        if (dbTypeName.toLowerCase().contains("char")) {
            return this.getCharJdbcType();
        }
        if (dbTypeName.toLowerCase().contains("timestamp")) {
            return this.getTimestampJdbcType();
        }
        if (dbTypeName.toLowerCase().contains("date")) {
            return this.getDateJdbcType();
        }
        if (dbTypeName.toLowerCase().contains("clob")) {
            return this.getClobJdbcType();
        }
        if (this._resource.isTargetLanguageJava() && dbTypeName.toLowerCase().contains("uuid")) {
            return "UUID";
        }
        return this.getVarcharJdbcType();
    }

    protected String processForcedAdjustment(int jdbcDefValue, String dbTypeName) {
        if (this.isPostgreSQL_Oid(dbTypeName)) {
            return this.getBlobJdbcType();
        }
        if (this.isPostgreSQL_Interval(dbTypeName)) {
            return this.getTimeJdbcType();
        }
        if (this.isOracle_CompatibleDate(jdbcDefValue, dbTypeName)) {
            return this.getDateJdbcType();
        }
        return null;
    }

    public boolean isOracle_CompatibleDate(int jdbcType, String dbTypeName) {
        return this._resource.isDatabaseOracle() && 93 == jdbcType && "date".equalsIgnoreCase(dbTypeName);
    }

    public boolean isOracle_Clob(String dbTypeName) {
        return this._resource.isDatabaseOracle() && "clob".equalsIgnoreCase(dbTypeName);
    }

    public boolean isOracle_BinaryFloatDouble(int jdbcType, String dbTypeName) {
        return this._resource.isDatabaseOracle() && ("binary_float".equalsIgnoreCase(dbTypeName) || "binary_double".equalsIgnoreCase(dbTypeName));
    }

    public boolean isPostgreSQL_Oid(String dbTypeName) {
        return this._resource.isDatabasePostgreSQL() && "oid".equalsIgnoreCase(dbTypeName);
    }

    public boolean isPostgreSQL_Interval(String dbTypeName) {
        return this._resource.isDatabasePostgreSQL() && "interval".equalsIgnoreCase(dbTypeName);
    }

    public boolean isUUID(String dbTypeName) {
        return "uuid".equalsIgnoreCase(dbTypeName);
    }

    protected boolean isOtherType(int jdbcDefValue) {
        return 1111 == jdbcDefValue;
    }

    protected String getJdbcType(int jdbcDefValue) {
        return TypeMap.findJdbcTypeByJdbcDefValue(jdbcDefValue);
    }

    protected String getVarcharJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(12);
    }

    protected String getCharJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(1);
    }

    protected String getTimestampJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(93);
    }

    protected String getTimeJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(92);
    }

    protected String getDateJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(91);
    }

    protected String getClobJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(2005);
    }

    protected String getBlobJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(2004);
    }

    public String toString() {
        return this._nameToJdbcTypeMap + ":" + this._resource;
    }

    public static interface Resource {
        public boolean isTargetLanguageJava();

        public boolean isDatabaseOracle();

        public boolean isDatabasePostgreSQL();
    }
}

