/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import org.seasar.dbflute.exception.IfCommentWrongExpressionException;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.ContainerNode;
import org.seasar.dbflute.twowaysql.node.ElseNode;
import org.seasar.dbflute.twowaysql.node.IfCommentEvaluator;
import org.seasar.dbflute.twowaysql.node.ParameterFinder;
import org.seasar.dbflute.util.DfStringUtil;

public class IfNode
extends ContainerNode {
    protected String _expression;
    protected ElseNode _elseNode;
    protected String _specifiedSql;

    public IfNode(String expression, String specifiedSql) {
        this._expression = expression;
        this._specifiedSql = specifiedSql;
    }

    public void accept(CommandContext ctx) {
        this.doAcceptByEvaluator(ctx);
    }

    protected void doAcceptByEvaluator(CommandContext ctx) {
        IfCommentEvaluator evaluator = this.createIfCommentEvaluator(ctx, this._expression);
        boolean result = false;
        try {
            result = evaluator.evaluate();
        }
        catch (IfCommentWrongExpressionException e) {
            String replaced = this.replace(this._expression, "pmb.", "pmb.parameterMap.");
            IfCommentEvaluator another = this.createIfCommentEvaluator(ctx, replaced);
            try {
                result = another.evaluate();
            }
            catch (IfCommentWrongExpressionException ignored) {
                throw e;
            }
        }
        if (result) {
            super.accept(ctx);
            ctx.setEnabled(true);
        } else if (this._elseNode != null) {
            this._elseNode.accept(ctx);
            ctx.setEnabled(true);
        }
    }

    protected IfCommentEvaluator createIfCommentEvaluator(final CommandContext ctx, String expression) {
        return new IfCommentEvaluator(new ParameterFinder(){

            public Object find(String name) {
                return ctx.getArg(name);
            }
        }, expression, this._specifiedSql);
    }

    protected String replace(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    public String getExpression() {
        return this._expression;
    }

    public ElseNode getElseNode() {
        return this._elseNode;
    }

    public void setElseNode(ElseNode elseNode) {
        this._elseNode = elseNode;
    }
}

