/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.initializer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfPropertySettingColumnNotFoundException;
import org.seasar.dbflute.exception.DfPropertySettingTableNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.properties.DfAdditionalUniqueKeyProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAdditionalUniqueKeyInitializer {
    private static final Log _log = LogFactory.getLog(DfAdditionalUniqueKeyInitializer.class);
    protected Database _database;

    public DfAdditionalUniqueKeyInitializer(Database database) {
        this._database = database;
    }

    public void initializeAdditionalUniqueKey() {
        _log.info((Object)"/=======================================");
        _log.info((Object)"...Initializing additional unique keys.");
        Map<String, Map<String, String>> additionalUniqueKeyMap = this.getAdditionalUniqueKeyMap();
        Set<String> uniqueKeyNameSet = additionalUniqueKeyMap.keySet();
        for (String uniqueKeyName : uniqueKeyNameSet) {
            String tableName = this.getTableName(uniqueKeyName);
            this.assertTable(uniqueKeyName, tableName);
            List<String> columnNameList = this.getLocalColumnNameList(uniqueKeyName);
            this.assertColumnList(uniqueKeyName, tableName, columnNameList);
            Table table = this.getTable(tableName);
            Unique unique = new Unique();
            unique.setAdditional(true);
            unique.setName(uniqueKeyName);
            unique.setTable(table);
            for (String columnName : columnNameList) {
                unique.addColumn(columnName);
            }
            table.addUnique(unique);
            this.showResult(uniqueKeyName, table, columnNameList);
        }
        _log.info((Object)"==========/");
    }

    protected void showResult(String uniqueKeyName, Table table, List<String> columnNameList) {
        _log.info((Object)("  " + uniqueKeyName));
        if (columnNameList.size() == 1) {
            _log.info((Object)("    Add unique key " + table.getName() + "." + columnNameList.get(0)));
        } else {
            _log.info((Object)("    Add unique key " + table.getName() + "." + columnNameList));
        }
    }

    protected DfAdditionalUniqueKeyProperties getProperties() {
        return DfBuildProperties.getInstance().getAdditionalUniqueKeyProperties();
    }

    protected void assertTable(String primaryKeyName, String tableName) {
        if (this.getTable(tableName) != null) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found table by the tableName of additionalUniqueKey.");
        br.addItem("Additional UQ");
        br.addElement((Object)primaryKeyName);
        br.addItem("NotFound Table");
        br.addElement((Object)tableName);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingTableNotFoundException(msg);
    }

    protected void assertColumnList(String primaryKeyName, String tableName, List<String> columnNameList) {
        if (this.getTable(tableName).containsColumn(columnNameList)) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found table by the tableName of additionalUniqueKey.");
        br.addItem("Additional UQ");
        br.addElement((Object)primaryKeyName);
        br.addItem("Table");
        br.addElement((Object)tableName);
        br.addItem("NotFound Column");
        br.addElement(columnNameList);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingColumnNotFoundException(msg);
    }

    protected String getTableName(String primaryKeyName) {
        return this.getProperties().findTableName(primaryKeyName);
    }

    protected List<String> getLocalColumnNameList(String primaryKeyName) {
        return this.getProperties().findColumnNameList(primaryKeyName);
    }

    protected Map<String, Map<String, String>> getAdditionalUniqueKeyMap() {
        return this.getProperties().getAdditionalUniqueKeyMap();
    }

    protected Table getTable(String tableName) {
        return this.getDatabase().getTable(tableName);
    }

    protected Table[] getTables() {
        return this.getDatabase().getTables();
    }

    protected Database getDatabase() {
        return this._database;
    }
}

