/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.exception.DfIllegalPropertyTypeException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSequenceMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.factory.DfSequenceExtractorFactory;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfSequenceIdentityProperties
extends DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfSequenceIdentityProperties.class);
    protected static final String KEY_sequenceDefinitionMap = "sequenceDefinitionMap";
    protected Map<String, String> _sequenceDefinitionMap;
    protected Map<String, DfSequenceMetaInfo> _sequenceMap;
    protected static final String KEY_identityDefinitionMap = "identityDefinitionMap";
    protected Map<String, Object> _identityDefinitionMap;

    public DfSequenceIdentityProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, String> getSequenceDefinitionMap() {
        if (this._sequenceDefinitionMap != null) {
            return this._sequenceDefinitionMap;
        }
        StringKeyMap flexibleMap = StringKeyMap.createAsFlexibleOrdered();
        Map<String, Object> originalMap = this.mapProp("torque.sequenceDefinitionMap", DEFAULT_EMPTY_MAP);
        Set<Map.Entry<String, Object>> entrySet = originalMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String tableName = entry.getKey();
            Object sequenceName = entry.getValue();
            if (!(sequenceName instanceof String)) {
                String msg = "The value of sequence map should be string:";
                msg = msg + " sequenceName=" + sequenceName + " map=" + originalMap;
                throw new DfIllegalPropertyTypeException(msg);
            }
            flexibleMap.put(tableName, (String)sequenceName);
        }
        this._sequenceDefinitionMap = flexibleMap;
        return this._sequenceDefinitionMap;
    }

    public Map<String, String> getTableSequenceMap() {
        Map<String, String> sequenceDefinitionMap = this.getSequenceDefinitionMap();
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Set<String> keySet = sequenceDefinitionMap.keySet();
        for (String tableName : keySet) {
            resultMap.put(tableName, this.getSequenceName(tableName));
        }
        return resultMap;
    }

    public String getSequenceName(String tableName) {
        String sequenceProp = this.getSequenceDefinitionMap().get(tableName);
        if (sequenceProp == null || sequenceProp.trim().length() == 0) {
            return null;
        }
        String hintMark = ":";
        int hintMarkIndex = sequenceProp.lastIndexOf(":");
        if (hintMarkIndex < 0) {
            return sequenceProp;
        }
        String sequenceName = sequenceProp.substring(0, hintMarkIndex);
        if (sequenceName == null || sequenceName.trim().length() == 0) {
            return null;
        }
        return sequenceName;
    }

    protected String getSequenceProp(String tableName) {
        String sequenceProp = this.getSequenceDefinitionMap().get(tableName);
        if (sequenceProp == null || sequenceProp.trim().length() == 0) {
            return null;
        }
        return sequenceProp;
    }

    public void checkSequenceDefinitionMap(SequenceDefinitionMapChecker checker) {
        Map<String, String> sequenceDefinitionMap = this.getSequenceDefinitionMap();
        Set<String> keySet = sequenceDefinitionMap.keySet();
        ArrayList<String> notFoundTableNameList = new ArrayList<String>();
        for (String tableName : keySet) {
            if (checker.hasTable(tableName)) continue;
            notFoundTableNameList.add(tableName);
        }
        if (!notFoundTableNameList.isEmpty()) {
            this.throwSequenceDefinitionMapNotFoundTableException(notFoundTableNameList);
        }
    }

    protected void throwSequenceDefinitionMapNotFoundTableException(List<String> notFoundTableNameList) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The table name on the sequence definition was NOT FOUND!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Not Found Table]" + this.ln();
        for (String tableName : notFoundTableNameList) {
            msg = msg + tableName + this.ln();
        }
        msg = msg + this.ln();
        msg = msg + "[Sequence Definition]" + this.ln() + this._sequenceDefinitionMap + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new SequenceDefinitionMapTableNotFoundException(msg);
    }

    public String getSequenceReturnType() {
        return this.getBasicProperties().getLanguageDependencyInfo().getDefaultSequenceType();
    }

    protected Map<String, DfSequenceMetaInfo> getSequenceMap(DataSource dataSource) {
        if (this._sequenceMap != null) {
            return this._sequenceMap;
        }
        DfSequenceExtractorFactory factory = this.createSequenceExtractorFactory(dataSource);
        DfSequenceExtractor sequenceExtractor = factory.createSequenceExtractor();
        Map<String, DfSequenceMetaInfo> sequenceMap = null;
        if (sequenceExtractor != null) {
            try {
                sequenceMap = sequenceExtractor.getSequenceMap();
            }
            catch (RuntimeException continued) {
                _log.info((Object)("*Failed to get sequence map: " + continued.getMessage()));
            }
        }
        this._sequenceMap = sequenceMap != null ? sequenceMap : DfCollectionUtil.emptyMap();
        return this._sequenceMap;
    }

    protected DfSequenceExtractorFactory createSequenceExtractorFactory(DataSource dataSource) {
        return new DfSequenceExtractorFactory(dataSource, this.getBasicProperties(), this.getDatabaseProperties());
    }

    protected DfSequenceMetaInfo getSequenceElement(UnifiedSchema unifiedSchema, String sequenceName, Map<String, DfSequenceMetaInfo> sequenceMap) {
        DfSequenceMetaInfo info = sequenceMap.get(sequenceName);
        if (info != null) {
            return info;
        }
        if (sequenceName.contains(".")) {
            sequenceName = Srl.substringLastRear((String)sequenceName, (String[])new String[]{"."});
        }
        if ((info = sequenceMap.get(unifiedSchema.buildFullQualifiedName(sequenceName))) != null) {
            return info;
        }
        info = sequenceMap.get(unifiedSchema.buildSchemaQualifiedName(sequenceName));
        if (info != null) {
            return info;
        }
        return info;
    }

    public BigDecimal getSequenceMinimumValueByTableName(DataSource dataSource, UnifiedSchema unifiedSchema, String tableName) {
        String sequenceName = this.getSequenceName(tableName);
        if (sequenceName == null) {
            return null;
        }
        return this.getSequenceMinimumValueBySequenceName(dataSource, unifiedSchema, sequenceName);
    }

    public BigDecimal getSequenceMinimumValueBySequenceName(DataSource dataSource, UnifiedSchema unifiedSchema, String sequenceName) {
        Map<String, DfSequenceMetaInfo> sequenceMap = this.getSequenceMap(dataSource);
        return this.getSequenceMinimumValue(unifiedSchema, sequenceName, sequenceMap);
    }

    protected BigDecimal getSequenceMinimumValue(UnifiedSchema unifiedSchema, String sequenceName, Map<String, DfSequenceMetaInfo> sequenceMap) {
        DfSequenceMetaInfo info = this.getSequenceElement(unifiedSchema, sequenceName, sequenceMap);
        if (info != null) {
            BigDecimal minimumValue = info.getMinimumValue();
            if (minimumValue != null) {
                return minimumValue;
            }
            return null;
        }
        return null;
    }

    public BigDecimal getSequenceMaximumValueByTableName(DataSource dataSource, UnifiedSchema unifiedSchema, String tableName) {
        String sequenceName = this.getSequenceName(tableName);
        if (sequenceName == null) {
            return null;
        }
        return this.getSequenceMaximumValueBySequenceName(dataSource, unifiedSchema, sequenceName);
    }

    public BigDecimal getSequenceMaximumValueBySequenceName(DataSource dataSource, UnifiedSchema unifiedSchema, String sequenceName) {
        Map<String, DfSequenceMetaInfo> sequenceMap = this.getSequenceMap(dataSource);
        return this.getSequenceMaximumValue(unifiedSchema, sequenceName, sequenceMap);
    }

    protected BigDecimal getSequenceMaximumValue(UnifiedSchema unifiedSchema, String sequenceName, Map<String, DfSequenceMetaInfo> sequenceMap) {
        DfSequenceMetaInfo info = this.getSequenceElement(unifiedSchema, sequenceName, sequenceMap);
        if (info != null) {
            BigDecimal maximumValue = info.getMaximumValue();
            if (maximumValue != null) {
                return maximumValue;
            }
            return null;
        }
        return null;
    }

    public Integer getSequenceIncrementSizeByTableName(DataSource dataSource, UnifiedSchema unifiedSchema, String tableName) {
        String sequenceName = this.getSequenceName(tableName);
        if (sequenceName == null) {
            return null;
        }
        return this.getSequenceIncrementSizeBySequenceName(dataSource, unifiedSchema, sequenceName);
    }

    public Integer getSequenceIncrementSizeBySequenceName(DataSource dataSource, UnifiedSchema unifiedSchema, String sequenceName) {
        Map<String, DfSequenceMetaInfo> sequenceMap = this.getSequenceMap(dataSource);
        return this.getSequenceIncrementSize(unifiedSchema, sequenceName, sequenceMap);
    }

    protected Integer getSequenceIncrementSize(UnifiedSchema unifiedSchema, String sequenceName, Map<String, DfSequenceMetaInfo> sequenceMap) {
        DfSequenceMetaInfo info = this.getSequenceElement(unifiedSchema, sequenceName, sequenceMap);
        if (info != null) {
            Integer incrementSize = info.getIncrementSize();
            if (incrementSize != null) {
                return incrementSize;
            }
            return null;
        }
        return null;
    }

    public Integer getSequenceCacheSize(DataSource dataSource, UnifiedSchema unifiedSchema, String tableName) {
        String sequenceProp = this.getSequenceProp(tableName);
        if (sequenceProp == null) {
            return null;
        }
        String hintMark = ":";
        int hintMarkIndex = sequenceProp.lastIndexOf(":");
        if (hintMarkIndex < 0) {
            return null;
        }
        String hint = sequenceProp.substring(hintMarkIndex + ":".length()).trim();
        String cacheMark = "dfcache(";
        int cacheMarkIndex = hint.indexOf("dfcache(");
        if (cacheMarkIndex < 0) {
            return null;
        }
        String cacheValue = hint.substring(cacheMarkIndex + "dfcache(".length()).trim();
        String endMark = ")";
        int endMarkIndex = cacheValue.indexOf(")");
        if (endMarkIndex < 0) {
            String msg = "The increment size setting needs end mark ')':";
            msg = msg + " sequence=" + sequenceProp;
            throw new IllegalStateException(msg);
        }
        String cacheSizeProp = cacheValue.substring(0, endMarkIndex).trim();
        String sequenceName = this.getSequenceName(tableName);
        Map<String, DfSequenceMetaInfo> sequenceMap = this.getSequenceMap(dataSource);
        Integer incrementSize = this.getSequenceIncrementSize(unifiedSchema, sequenceName, sequenceMap);
        if (cacheSizeProp != null && cacheSizeProp.trim().length() > 0) {
            Integer cacheSize = this.castCacheSize(cacheSizeProp, tableName, sequenceProp, sequenceName);
            this.assertCacheSizeOverOne(cacheSize, unifiedSchema, tableName, sequenceProp, sequenceName, incrementSize);
            if (incrementSize != null) {
                this.assertIncrementSizeNotDecrement(incrementSize, unifiedSchema, tableName, sequenceProp, sequenceName);
                this.assertExtraValueZero(cacheSize, incrementSize, unifiedSchema, tableName, sequenceProp, sequenceName);
                return cacheSize;
            }
            return cacheSize;
        }
        this.assertIncrementSizeExistsIfNoCacheSize(incrementSize, unifiedSchema, tableName, sequenceProp, sequenceName);
        this.assertIncrementSizeNotDecrement(incrementSize, unifiedSchema, tableName, sequenceProp, sequenceName);
        this.assertCacheSizeOverOne(incrementSize, unifiedSchema, tableName, sequenceProp, sequenceName, incrementSize);
        return incrementSize;
    }

    protected Integer castCacheSize(String cacheSize, String tableName, String sequenceProp, String sequenceName) {
        try {
            return Integer.valueOf(cacheSize);
        }
        catch (NumberFormatException e) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "Failed to cast the cache size to integer:" + this.ln();
            msg = msg + this.ln();
            msg = msg + "table = " + tableName + this.ln();
            msg = msg + "sequenceProp = " + sequenceProp + this.ln();
            msg = msg + "sequenceName = " + sequenceName + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected void assertCacheSizeOverOne(Integer cacheSize, UnifiedSchema unifiedSchema, String tableName, String sequenceProp, String sequenceName, Integer incrementSize) {
        if (cacheSize <= 1) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "The cacheSize should be over 1. (not minus, not zero, not one)" + this.ln();
            msg = msg + this.ln();
            msg = msg + "schema = " + unifiedSchema + this.ln() + "table = " + tableName + this.ln();
            msg = msg + "sequenceProp = " + sequenceProp + this.ln();
            msg = msg + "sequenceName = " + sequenceName + this.ln();
            msg = msg + "cacheSize = " + cacheSize + this.ln();
            msg = msg + "incrementSize = " + incrementSize + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected void assertIncrementSizeNotDecrement(Integer incrementSize, UnifiedSchema unifiedSchema, String tableName, String sequenceProp, String sequenceName) {
        if (incrementSize <= 0) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "The incrementSize should be increment! (NOT decrement)" + this.ln();
            msg = msg + this.ln();
            msg = msg + "schema = " + unifiedSchema + this.ln() + "table = " + tableName + this.ln();
            msg = msg + "sequenceProp = " + sequenceProp + this.ln();
            msg = msg + "sequenceName = " + sequenceName + this.ln();
            msg = msg + "incrementSize = " + incrementSize + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected void assertExtraValueZero(Integer cacheSize, Integer incrementSize, UnifiedSchema unifiedSchema, String tableName, String sequenceProp, String sequenceName) {
        Integer extraValue = cacheSize % incrementSize;
        if (extraValue != 0) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "The cacheSize cannot be divided by incrementSize!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "schema = " + unifiedSchema + this.ln() + "table = " + tableName + this.ln();
            msg = msg + "sequenceProp = " + sequenceProp + this.ln();
            msg = msg + "sequenceName = " + sequenceName + this.ln();
            msg = msg + "cacheSize = " + cacheSize + this.ln();
            msg = msg + "incrementSize = " + incrementSize + this.ln();
            msg = msg + "extraValue = " + extraValue + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected void assertIncrementSizeExistsIfNoCacheSize(Integer incrementSize, UnifiedSchema unifiedSchema, String tableName, String sequenceProp, String sequenceName) {
        if (incrementSize == null) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "Failed to get the cache size of sequence(by no increment size):" + this.ln();
            msg = msg + this.ln();
            msg = msg + "schema = " + unifiedSchema + this.ln() + "table = " + tableName + this.ln();
            msg = msg + "sequenceProp = " + sequenceProp + this.ln();
            msg = msg + "sequenceName = " + sequenceName + this.ln();
            msg = msg + "incrementSize = " + incrementSize + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected Map<String, Object> getIdentityDefinitionMap() {
        if (this._identityDefinitionMap == null) {
            this._identityDefinitionMap = this.mapProp("torque.identityDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this._identityDefinitionMap;
    }

    public String getIdentityColumnName(String flexibleTableName) {
        StringKeyMap flexibleMap = StringKeyMap.createAsFlexibleOrdered();
        flexibleMap.putAll(this.getIdentityDefinitionMap());
        return (String)flexibleMap.get(flexibleTableName);
    }

    public static class SequenceDefinitionMapTableNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SequenceDefinitionMapTableNotFoundException(String msg) {
            super(msg);
        }
    }

    public static interface SequenceDefinitionMapChecker {
        public boolean hasTable(String var1);
    }
}

