/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSequenceMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorBase;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceExtractorDB2
extends DfSequenceExtractorBase {
    private static final Log _log = LogFactory.getLog(DfSequenceExtractorDB2.class);

    public DfSequenceExtractorDB2(DataSource dataSource, List<UnifiedSchema> unifiedSchemaList) {
        super(dataSource, unifiedSchemaList);
    }

    @Override
    protected Map<String, DfSequenceMetaInfo> doGetSequenceMap() {
        _log.info((Object)"...Loading sequence informations");
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String sql = this.buildMetaSelectSql();
        if (sql == null) {
            return DfCollectionUtil.emptyMap();
        }
        _log.info((Object)sql);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("SEQSCHEMA");
        columnList.add("SEQNAME");
        columnList.add("MINVALUE");
        columnList.add("MAXVALUE");
        columnList.add("INCREMENT");
        List<Map<String, String>> resultList = facade.selectStringList(sql, columnList);
        StringBuilder logSb = new StringBuilder();
        logSb.append(this.ln()).append("[SEQUENCE]");
        for (Map<String, String> recordMap : resultList) {
            DfSequenceMetaInfo info = new DfSequenceMetaInfo();
            String sequenceSchema = recordMap.get("SEQSCHEMA");
            sequenceSchema = sequenceSchema != null ? sequenceSchema.trim() : null;
            info.setSequenceSchema(sequenceSchema);
            String sequenceName = recordMap.get("SEQNAME");
            info.setSequenceName(sequenceName);
            String minValue = recordMap.get("MINVALUE");
            info.setMinimumValue(minValue != null ? new BigDecimal(minValue) : null);
            String maxValue = recordMap.get("MAXVALUE");
            info.setMaximumValue(maxValue != null ? new BigDecimal(maxValue) : null);
            String incrementSize = recordMap.get("INCREMENT");
            info.setIncrementSize(incrementSize != null ? Integer.valueOf(incrementSize) : null);
            String key = this.buildSequenceMapKey(null, sequenceSchema, sequenceName);
            resultMap.put(key, info);
            logSb.append(this.ln()).append(" ").append(key).append(" = ").append(info.toString());
        }
        _log.info((Object)logSb.toString());
        return resultMap;
    }

    protected String buildMetaSelectSql() {
        StringBuilder sb;
        if (!this._unifiedSchemaList.isEmpty()) {
            sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : this._unifiedSchemaList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            }
        } else {
            return null;
        }
        String schemaCondition = sb.toString();
        return "select * from SYSCAT.SEQUENCES where SEQSCHEMA in (" + schemaCondition + ")";
    }
}

