/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata;

import java.util.LinkedHashMap;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractMetaDataExtractor {
    protected String filterSchemaName(String schemaName) {
        if (Srl.isTrimmedEmpty((String)schemaName)) {
            return null;
        }
        return schemaName;
    }

    protected UnifiedSchema createAsDynamicSchema(String catalog, String schema) {
        return UnifiedSchema.createAsDynamicSchema(catalog, schema);
    }

    protected boolean isPrimaryKeyExtractingUnsupported() {
        return this.getBasicProperties().isDatabaseAsPrimaryKeyExtractingUnsupported();
    }

    protected boolean isForeignKeyExtractingUnsupported() {
        return this.getBasicProperties().isDatabaseAsForeignKeyExtractingUnsupported();
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return DfBuildProperties.getInstance().getDatabaseProperties();
    }

    protected boolean isDatabaseMySQL() {
        return this.getBasicProperties().isDatabaseMySQL();
    }

    protected boolean isDatabasePostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    protected boolean isDatabaseOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    protected boolean isDatabaseDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    protected boolean isDatabaseSQLServer() {
        return this.getBasicProperties().isDatabaseSQLServer();
    }

    protected boolean isDatabaseSQLite() {
        return this.getBasicProperties().isDatabaseSQLite();
    }

    protected boolean isDatabaseMsAccess() {
        return this.getBasicProperties().isDatabaseMSAccess();
    }

    protected boolean isDatabaseFirebird() {
        return this.getBasicProperties().isDatabaseFirebird();
    }

    protected boolean isDatabaseSybase() {
        return this.getBasicProperties().isDatabaseSybase();
    }

    protected boolean checkMetaTableDiffIfNeeds(String tableName, String metaTableName) {
        if (!this.needsToCheckMetaTable()) {
            return false;
        }
        return !Srl.equalsFlexibleTrimmed((String)tableName, (String[])new String[]{metaTableName});
    }

    protected boolean needsToCheckMetaTable() {
        return this.isDatabaseFirebird();
    }

    protected String ln() {
        return "\n";
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }
}

