/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.xls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.dataset.DfDataColumn;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.DfDataSet;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnType;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnTypes;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfXlsReader {
    private static final Log _log = LogFactory.getLog(DfXlsReader.class);
    protected DfDataSet _dataSet;
    protected HSSFWorkbook _workbook;
    protected HSSFDataFormat _dataFormat;
    protected final Map<String, String> _tableNameMap;
    protected final Map<String, List<String>> _notTrimTableColumnMap;
    protected final Map<String, List<String>> _emptyStringTableColumnMap;
    protected final Pattern _skipSheetPattern;

    public DfXlsReader(File file) {
        this(file, null, null, null, null);
    }

    public DfXlsReader(File file, Map<String, String> tableNameMap, Map<String, List<String>> notTrimTableColumnMap, Map<String, List<String>> emptyStringTableColumnMap, Pattern skipSheetPattern) {
        this(DfXlsReader.create(file), tableNameMap, notTrimTableColumnMap, emptyStringTableColumnMap, skipSheetPattern);
    }

    protected DfXlsReader(InputStream in, Map<String, String> tableNameMap, Map<String, List<String>> notTrimTableColumnMap, Map<String, List<String>> emptyStringTableColumnMap, Pattern skipSheetPattern) {
        this._tableNameMap = tableNameMap != null ? tableNameMap : StringKeyMap.createAsFlexible();
        this._notTrimTableColumnMap = notTrimTableColumnMap != null ? notTrimTableColumnMap : StringKeyMap.createAsFlexible();
        this._emptyStringTableColumnMap = emptyStringTableColumnMap != null ? emptyStringTableColumnMap : StringKeyMap.createAsFlexible();
        this._skipSheetPattern = skipSheetPattern;
        this.setupWorkbook(in);
    }

    protected static InputStream create(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setupWorkbook(InputStream in) {
        try {
            this._workbook = new HSSFWorkbook(in);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this._dataFormat = this._workbook.createDataFormat();
        this._dataSet = new DfDataSet();
        for (int i = 0; i < this._workbook.getNumberOfSheets(); ++i) {
            String sheetName = this._workbook.getSheetName(i);
            if (this.isCommentOutSheet(sheetName)) {
                _log.info((Object)("*The sheet has comment-out mark so skip it: " + sheetName));
                continue;
            }
            if (this.isSkipSheet(sheetName)) {
                _log.info((Object)("*The sheet name matched skip-sheet specification so skip it: " + sheetName));
                continue;
            }
            this.createTable(sheetName, this._workbook.getSheetAt(i));
        }
    }

    protected DfDataTable createTable(String sheetName, HSSFSheet sheet) {
        String tableName = sheetName;
        if (this._tableNameMap != null && !this._tableNameMap.isEmpty() && sheetName.startsWith("$")) {
            String realTableName = this._tableNameMap.get(sheetName);
            if (realTableName == null && (realTableName = this._tableNameMap.get(sheetName.substring("$".length()))) == null) {
                String msg = "The sheetName[" + sheetName + "] was not found in the tableNameMap: " + this._tableNameMap;
                throw new IllegalStateException(msg);
            }
            tableName = realTableName;
        }
        DfDataTable table = this._dataSet.addTable(tableName);
        int rowCount = sheet.getLastRowNum();
        HSSFRow nameRow = sheet.getRow(0);
        if (nameRow == null) {
            String msg = "The first row of the sheet should be column definition but it is null:";
            msg = msg + " sheet=" + tableName;
            throw new IllegalStateException(msg);
        }
        if (rowCount > 0) {
            this.setupColumns(table, nameRow, sheet.getRow(1));
            this.setupRows(table, sheet);
        } else if (rowCount == 0) {
            this.setupColumns(table, nameRow, null);
        }
        return table;
    }

    protected void setupColumns(DfDataTable table, HSSFRow nameRow, HSSFRow valueRow) {
        String columnName;
        HSSFRichTextString richStringCellValue;
        HSSFCell nameCell;
        int i = 0;
        while ((nameCell = nameRow.getCell(i)) != null && (richStringCellValue = nameCell.getRichStringCellValue()) != null && (columnName = richStringCellValue.getString().trim()).length() != 0) {
            HSSFCell valueCell = null;
            if (valueRow != null) {
                valueCell = valueRow.getCell(i);
            }
            if (valueCell != null) {
                table.addColumn(columnName, this.getColumnType(valueCell));
            } else {
                table.addColumn(columnName);
            }
            ++i;
        }
    }

    protected void setupRows(DfDataTable table, HSSFSheet sheet) {
        HSSFRow row;
        int i = 1;
        while ((row = sheet.getRow((int)((short)i))) != null) {
            this.setupRow(table, row);
            ++i;
        }
    }

    protected void setupRow(DfDataTable table, HSSFRow row) {
        DfDataRow dataRow = table.addRow();
        HSSFCell cell = null;
        Object value = null;
        DfDataColumn column = null;
        try {
            for (int i = 0; i < table.getColumnSize(); ++i) {
                cell = row.getCell(i);
                value = this.getValue(i, cell, table);
                column = table.getColumn(i);
                String columnName = column.getColumnName();
                try {
                    dataRow.addValue(columnName, value);
                    continue;
                }
                catch (NumberFormatException e) {
                    if (cell.getCellType() != 1) {
                        throw e;
                    }
                    String msg = "...Changing the column type to STRING type:";
                    msg = msg + " name=" + columnName + " value=" + value;
                    _log.info((Object)msg);
                    column.setColumnType(DfDtsColumnTypes.STRING);
                    dataRow.addValue(columnName, value);
                }
            }
        }
        catch (RuntimeException e) {
            this.throwCellValueHandlingException(table, column, row, cell, value, e);
        }
    }

    protected void throwCellValueHandlingException(DfDataTable table, DfDataColumn column, HSSFRow row, HSSFCell cell, Object value, RuntimeException e) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
        msg = msg + "Failed to handling the cell value!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table]" + this.ln() + table.getTableName() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Column]" + this.ln() + (column != null ? column.getColumnName() : null) + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Row Number]" + this.ln() + row.getRowNum() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Cell Object]" + this.ln() + cell + this.ln();
        msg = msg + this.ln();
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    msg = msg + "[Cell Type]" + this.ln() + "CELL_TYPE_NUMERIC" + this.ln();
                    break;
                }
                case 1: {
                    msg = msg + "[Cell Type]" + this.ln() + "CELL_TYPE_STRING" + this.ln();
                    break;
                }
                case 2: {
                    msg = msg + "[Cell Type]" + this.ln() + "CELL_TYPE_FORMULA" + this.ln();
                    break;
                }
                case 3: {
                    msg = msg + "[Cell Type]" + this.ln() + "CELL_TYPE_BLANK" + this.ln();
                    break;
                }
                case 4: {
                    msg = msg + "[Cell Type]" + this.ln() + "CELL_TYPE_BOOLEAN" + this.ln();
                    break;
                }
                case 5: {
                    msg = msg + "[Cell Type]" + this.ln() + "CELL_TYPE_ERROR" + this.ln();
                    break;
                }
                default: {
                    msg = msg + "[Cell Type]" + this.ln() + cell.getCellType() + this.ln();
                }
            }
        }
        msg = msg + this.ln();
        msg = msg + "[Cell Value]" + this.ln() + value + this.ln();
        msg = msg + "- - - - - - - - - -/";
        throw new IllegalStateException(msg, e);
    }

    public DfDataSet read() {
        return this._dataSet;
    }

    public Object getValue(int columnIndex, HSSFCell cell, DfDataTable table) {
        if (cell == null) {
            if (this.isEmptyStringTarget(columnIndex, table)) {
                return "\"\"";
            }
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return DfTypeUtil.toTimestamp((Object)cell.getDateCellValue());
                }
                double numericCellValue = cell.getNumericCellValue();
                if (this.isInt(numericCellValue)) {
                    return new BigDecimal((int)numericCellValue);
                }
                return new BigDecimal(Double.toString(numericCellValue));
            }
            case 1: {
                String s = cell.getRichStringCellValue().getString();
                if (s != null) {
                    if (this.isNotTrimTarget(cell, table)) {
                        if (s.length() != s.trim().length()) {
                            s = "\"" + s + "\"";
                        }
                    } else {
                        s = Srl.rtrim((String)s);
                    }
                }
                if ("".equals(s)) {
                    s = null;
                }
                if (this.isEmptyStringTarget(columnIndex, table) && s == null) {
                    s = "\"\"";
                }
                if (this.isCellBase64Formatted(cell)) {
                    return DfTypeUtil.decodeAsBase64((String)s);
                }
                return s;
            }
            case 4: {
                boolean b = cell.getBooleanCellValue();
                return b;
            }
        }
        if (this.isEmptyStringTarget(columnIndex, table)) {
            return "\"\"";
        }
        return null;
    }

    public boolean isNotTrimTarget(HSSFCell cell, DfDataTable table) {
        String tableName = table.getTableName();
        if (!this._notTrimTableColumnMap.containsKey(tableName)) {
            return false;
        }
        List<String> notTrimTargetColumnList = this._notTrimTableColumnMap.get(tableName);
        DfDataColumn column = table.getColumn(cell.getColumnIndex());
        String targetColumnName = column.getColumnName();
        for (String currentColumnName : notTrimTargetColumnList) {
            if (!targetColumnName.equalsIgnoreCase(currentColumnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmptyStringTarget(int columnIndex, DfDataTable table) {
        String tableName = table.getTableName();
        if (!this._emptyStringTableColumnMap.containsKey(tableName)) {
            return false;
        }
        List<String> emptyStringTargetColumnList = this._emptyStringTableColumnMap.get(tableName);
        DfDataColumn column = table.getColumn(columnIndex);
        String targetColumnName = column.getColumnName();
        for (String currentColumnName : emptyStringTargetColumnList) {
            if (!targetColumnName.equalsIgnoreCase(currentColumnName)) continue;
            return true;
        }
        return false;
    }

    protected DfDtsColumnType getColumnType(HSSFCell cell) {
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return DfDtsColumnTypes.TIMESTAMP;
                }
                return DfDtsColumnTypes.BIGDECIMAL;
            }
            case 4: {
                return DfDtsColumnTypes.BOOLEAN;
            }
            case 1: {
                if (this.isCellBase64Formatted(cell)) {
                    return DfDtsColumnTypes.BINARY;
                }
                return DfDtsColumnTypes.STRING;
            }
        }
        return DfDtsColumnTypes.STRING;
    }

    protected boolean isCellBase64Formatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        return "\\B\\:@".equals(this._dataFormat.getFormat(dfNum));
    }

    protected boolean isCellDateFormatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        String format = this._dataFormat.getFormat(dfNum);
        if (format == null || format.length() == 0) {
            return false;
        }
        return format.indexOf(47) > 0 || format.indexOf(121) > 0 || format.indexOf(109) > 0 || format.indexOf(100) > 0;
    }

    protected boolean isInt(double numericCellValue) {
        return (double)((int)numericCellValue) == numericCellValue;
    }

    protected boolean isCommentOutSheet(String sheetName) {
        return sheetName.startsWith("#");
    }

    protected boolean isSkipSheet(String sheetName) {
        if (this._skipSheetPattern == null) {
            return false;
        }
        return this._skipSheetPattern.matcher(sheetName).matches();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

