/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.seasar.dbflute.util.Srl;
import org.xml.sax.Attributes;

public class AppData {
    private List<Database> _dbList = new ArrayList<Database>(5);
    private String _databaseType;
    private String _name;
    private boolean _isInitialized;

    public AppData(String databaseType) {
        this._databaseType = databaseType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getShortName() {
        return Srl.replace((String)this._name, (String)"-schema", (String)"");
    }

    public Database getDatabase() throws EngineException {
        this.doFinalInitialization();
        return this._dbList.get(0);
    }

    public Database[] getDatabases() throws EngineException {
        this.doFinalInitialization();
        int size = this._dbList.size();
        Database[] dbs = new Database[size];
        for (int i = 0; i < size; ++i) {
            dbs[i] = this._dbList.get(i);
        }
        return dbs;
    }

    public boolean hasMultipleDatabases() {
        return this._dbList.size() > 1;
    }

    public Database getDatabase(String name) throws EngineException {
        this.doFinalInitialization();
        for (Database db : this._dbList) {
            if (!db.getName().equals(name)) continue;
            return db;
        }
        return null;
    }

    public Database addDatabase(Attributes attrib) {
        Database db = new Database();
        db.loadFromXML(attrib);
        this.addDatabase(db);
        return db;
    }

    public void addDatabase(Database db) {
        db.setAppData(this);
        if (db.getName() == null) {
            db.setName("default");
        }
        if (db.getDatabaseType() == null) {
            db.setDatabaseType(this._databaseType);
        }
        this._dbList.add(db);
    }

    private void doFinalInitialization() throws EngineException {
        if (!this._isInitialized) {
            Iterator<Database> dbs = this._dbList.iterator();
            while (dbs.hasNext()) {
                dbs.next().doFinalInitialization();
            }
            this._isInitialized = true;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>\n");
        result.append("<!DOCTYPE database SYSTEM \"http://dbflute.sandbox.seasar.org/meta/database.dtd\">\n");
        result.append("<!-- Autogenerated by SQLToXMLSchema! -->\n");
        Iterator<Database> i = this._dbList.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        return result.toString();
    }
}

