/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfUniqueKeyHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfUniqueKeyHandler.class);

    public DfPrimaryKeyMetaInfo getPrimaryKey(DatabaseMetaData metaData, String schemaName, DfTableMetaInfo tableMetaInfo) throws SQLException {
        schemaName = this.filterSchemaName(schemaName);
        schemaName = tableMetaInfo.selectMetaExtractingSchemaName(schemaName);
        String tableName = tableMetaInfo.getTableName();
        return this.getPrimaryKey(metaData, schemaName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DfPrimaryKeyMetaInfo getPrimaryKey(DatabaseMetaData metaData, String schemaName, String tableName) throws SQLException {
        ResultSet upperSpare;
        ResultSet lowerSpare;
        DfPrimaryKeyMetaInfo info;
        block14: {
            schemaName = this.filterSchemaName(schemaName);
            info = new DfPrimaryKeyMetaInfo();
            if (!this.isPrimaryKeyExtractingSupported()) {
                return info;
            }
            ResultSet parts = null;
            lowerSpare = null;
            upperSpare = null;
            try {
                String pkName;
                String columnName;
                parts = this.getPrimaryKeyResultSetFromDBMeta(metaData, schemaName, tableName);
                if (parts != null) {
                    while (parts.next()) {
                        columnName = this.getPrimaryKeyColumnNameFromDBMeta(parts);
                        pkName = this.getPrimaryKeyNameFromDBMeta(parts);
                        info.addPrimaryKeyList(columnName, pkName);
                    }
                }
                if (!info.hasPrimaryKey() && (lowerSpare = this.getPrimaryKeyResultSetFromDBMeta(metaData, schemaName, tableName.toLowerCase())) != null) {
                    while (lowerSpare.next()) {
                        columnName = this.getPrimaryKeyColumnNameFromDBMeta(lowerSpare);
                        pkName = this.getPrimaryKeyNameFromDBMeta(lowerSpare);
                        info.addPrimaryKeyList(columnName, pkName);
                    }
                }
                if (!info.hasPrimaryKey() && (upperSpare = this.getPrimaryKeyResultSetFromDBMeta(metaData, schemaName, tableName.toUpperCase())) != null) {
                    while (upperSpare.next()) {
                        columnName = this.getPrimaryKeyColumnNameFromDBMeta(upperSpare);
                        pkName = this.getPrimaryKeyNameFromDBMeta(upperSpare);
                        info.addPrimaryKeyList(columnName, pkName);
                    }
                }
                this.assertPrimaryKeyNotExcepted(info, schemaName, tableName);
                Object var11_10 = null;
                if (parts == null) break block14;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (parts != null) {
                    parts.close();
                }
                if (lowerSpare != null) {
                    lowerSpare.close();
                }
                if (upperSpare != null) {
                    upperSpare.close();
                }
                throw throwable;
            }
            parts.close();
        }
        if (lowerSpare != null) {
            lowerSpare.close();
        }
        if (upperSpare != null) {
            upperSpare.close();
        }
        return info;
    }

    protected ResultSet getPrimaryKeyResultSetFromDBMeta(DatabaseMetaData dbMeta, String schemaName, String tableName) {
        try {
            return dbMeta.getPrimaryKeys(null, schemaName, tableName);
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    protected String getPrimaryKeyColumnNameFromDBMeta(ResultSet resultSet) throws SQLException {
        return resultSet.getString(4);
    }

    protected String getPrimaryKeyNameFromDBMeta(ResultSet resultSet) throws SQLException {
        return resultSet.getString(6);
    }

    protected void assertPrimaryKeyNotExcepted(DfPrimaryKeyMetaInfo info, String schemaName, String tableName) {
        List<String> primaryKeyList = info.getPrimaryKeyList();
        for (String primaryKey : primaryKeyList) {
            if (!this.isColumnExcept(schemaName, tableName, primaryKey)) continue;
            String msg = "PK columns are unsupported on 'columnExcept' property:";
            msg = msg + " schemaName=" + schemaName + " tableName=" + tableName;
            msg = msg + " primaryKey=" + primaryKey;
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    public Map<String, Map<Integer, String>> getUniqueKeyMap(DatabaseMetaData dbMeta, String schemaName, DfTableMetaInfo tableMetaInfo) throws SQLException {
        schemaName = this.filterSchemaName(schemaName);
        schemaName = tableMetaInfo.selectMetaExtractingSchemaName(schemaName);
        String tableName = tableMetaInfo.getTableName();
        if (tableMetaInfo.isTableTypeView()) {
            return new LinkedHashMap<String, Map<Integer, String>>();
        }
        DfPrimaryKeyMetaInfo pkInfo = this.getPrimaryKey(dbMeta, schemaName, tableMetaInfo);
        return this.getUniqueKeyMap(dbMeta, schemaName, tableName, pkInfo.getPrimaryKeyList());
    }

    public Map<String, Map<Integer, String>> getUniqueKeyMap(DatabaseMetaData dbMeta, String schemaName, String tableName, List<String> pkList) throws SQLException {
        Map<String, Map<Integer, String>> resultMap = this.doGetUniqueKeyMap(dbMeta, schemaName, tableName, pkList);
        if (resultMap.isEmpty()) {
            resultMap = this.doGetUniqueKeyMap(dbMeta, schemaName, tableName.toLowerCase(), pkList);
        }
        if (resultMap.isEmpty()) {
            resultMap = this.doGetUniqueKeyMap(dbMeta, schemaName, tableName.toUpperCase(), pkList);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Map<Integer, String>> doGetUniqueKeyMap(DatabaseMetaData dbMeta, String schemaName, String tableName, List<String> pkList) throws SQLException {
        StringSet pkSet = StringSet.createAsFlexible();
        pkSet.addAll(pkList);
        LinkedHashMap<String, Map<Integer, String>> uniqueMap = new LinkedHashMap<String, Map<Integer, String>>();
        ResultSet parts = null;
        try {
            boolean uniqueKeyOnly = true;
            parts = dbMeta.getIndexInfo(null, schemaName, tableName, true, true);
            while (parts.next()) {
                Map<Integer, String> uniqueElementMap;
                Integer ordinalPosition;
                boolean isNonUnique;
                String nonUnique = parts.getString(4);
                boolean bl = isNonUnique = nonUnique != null && nonUnique.equalsIgnoreCase("true");
                if (isNonUnique) continue;
                String indexType = parts.getString(7);
                String columnName = parts.getString(9);
                if (columnName == null || columnName.trim().length() == 0 || pkSet.contains((Object)columnName)) continue;
                if (this.isColumnExcept(schemaName, tableName, columnName)) {
                    this.assertUQColumnNotExcepted(schemaName, tableName, columnName);
                }
                String indexName = parts.getString(6);
                String ordinalPositionString = parts.getString(8);
                if (ordinalPositionString == null) {
                    String msg = "The unique columnName should have ordinal-position but null: ";
                    msg = msg + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                try {
                    ordinalPosition = Integer.parseInt(ordinalPositionString);
                }
                catch (NumberFormatException e) {
                    String msg = "The unique column should have ordinal-position as number but: ";
                    msg = msg + ordinalPositionString + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                if (uniqueMap.containsKey(indexName)) {
                    uniqueElementMap = (Map)uniqueMap.get(indexName);
                    uniqueElementMap.put(ordinalPosition, columnName);
                    continue;
                }
                uniqueElementMap = new LinkedHashMap();
                uniqueElementMap.put(ordinalPosition, columnName);
                uniqueMap.put(indexName, uniqueElementMap);
            }
            Object var18_18 = null;
            if (parts == null) return uniqueMap;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (parts == null) throw throwable;
            parts.close();
            throw throwable;
        }
        parts.close();
        return uniqueMap;
    }

    protected void assertUQColumnNotExcepted(String schemaName, String tableName, String columnName) {
        if (this.isColumnExcept(schemaName, tableName, columnName)) {
            String msg = "UQ columns are unsupported on 'columnExcept' property:";
            msg = msg + " schemaName=" + schemaName;
            msg = msg + " tableName=" + tableName;
            msg = msg + " columnName=" + columnName;
            throw new DfIllegalPropertySettingException(msg);
        }
    }
}

