/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.exception.DfTableColumnNameNonCompilableConnectorException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfLittleAdjustmentProperties
extends DfAbstractHelperProperties {
    public static final String KEY_littleAdjustmentMap = "littleAdjustmentMap";
    protected Map<String, Object> _littleAdjustmentMap;
    protected Set<String> _quoteTableNameSet;
    protected Set<String> _quoteColumnNameSet;
    protected List<String> _pgReservColumnList;

    public DfLittleAdjustmentProperties(Properties prop) {
        super(prop);
    }

    public Map<String, Object> getLittleAdjustmentMap() {
        if (this._littleAdjustmentMap == null) {
            this._littleAdjustmentMap = this.mapProp("torque.littleAdjustmentMap", DEFAULT_EMPTY_MAP);
        }
        return this._littleAdjustmentMap;
    }

    public String getProperty(String key, String defaultValue) {
        return this.getPropertyIfNotBuildProp(key, defaultValue, this.getLittleAdjustmentMap());
    }

    public boolean isProperty(String key, boolean defaultValue) {
        return this.isPropertyIfNotBuildProp(key, defaultValue, this.getLittleAdjustmentMap());
    }

    public boolean isAvailableAddingSchemaToTableSqlName() {
        return this.isProperty("isAvailableAddingSchemaToTableSqlName", false);
    }

    public boolean isAvailableAddingCatalogToTableSqlName() {
        return this.isProperty("isAvailableAddingCatalogToTableSqlName", false);
    }

    public boolean isAvailableDatabaseDependency() {
        return this.isProperty("isAvailableDatabaseDependency", false);
    }

    public boolean isAvailableDatabaseNativeJDBC() {
        return this.isProperty("isAvailableDatabaseNativeJDBC", false);
    }

    public boolean isAvailableNonPrimaryKeyWritable() {
        return this.isProperty("isAvailableNonPrimaryKeyWritable", false);
    }

    public boolean isCheckSelectedClassification() {
        return this.isProperty("isCheckSelectedClassification", false);
    }

    public boolean isForceClassificationSetting() {
        return this.isProperty("isForceClassificationSetting", false);
    }

    public boolean isCDefToStringReturnsName() {
        return this.isProperty("isCDefToStringReturnsName", false);
    }

    public boolean isMakeEntityOldStyleClassify() {
        return this.isProperty("isMakeEntityOldStyleClassify", true);
    }

    public boolean isMakeEntityChaseRelation() {
        return this.isProperty("isMakeEntityChaseRelation", false);
    }

    public boolean isEntityConvertEmptyStringToNull() {
        return this.isProperty("isEntityConvertEmptyStringToNull", false);
    }

    public boolean isMakeConditionQueryEqualEmptyString() {
        return this.isProperty("isMakeConditionQueryEqualEmptyString", false);
    }

    public boolean isMakeConditionQueryNotEqualAsStandard() {
        return this.isProperty("isMakeConditionQueryNotEqualAsStandard", true);
    }

    public String getConditionQueryNotEqualDefinitionName() {
        return this.isMakeConditionQueryNotEqualAsStandard() ? "CK_NES" : "CK_NET";
    }

    public boolean isMakeDeprecated() {
        return this.isProperty("isMakeDeprecated", false);
    }

    public boolean isMakeRecentlyDeprecated() {
        return this.isProperty("isMakeRecentlyDeprecated", true);
    }

    public boolean hasExtendedImplementedInvokerAssistantClass() {
        String str = this.getExtendedImplementedInvokerAssistantClass();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getExtendedImplementedInvokerAssistantClass() {
        return this.getProperty("extendedImplementedInvokerAssistantClass", null);
    }

    public boolean hasExtendedImplementedCommonColumnAutoSetupperClass() {
        String str = this.getExtendedImplementedCommonColumnAutoSetupperClass();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getExtendedImplementedCommonColumnAutoSetupperClass() {
        return this.getProperty("extendedImplementedCommonColumnAutoSetupperClass", null);
    }

    public boolean hasExtendedS2DaoSettingClassValid() {
        String str = this.getExtendedS2DaoSettingClass();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getExtendedS2DaoSettingClass() {
        return this.getProperty("extendedS2DaoSettingClass", null);
    }

    public boolean isShortCharHandlingValid() {
        return !this.getShortCharHandlingMode().equalsIgnoreCase("NONE");
    }

    public String getShortCharHandlingMode() {
        String property = this.getProperty("shortCharHandlingMode", "NONE");
        return property.toUpperCase();
    }

    public String getShortCharHandlingModeCode() {
        return this.getShortCharHandlingMode().substring(0, 1);
    }

    protected Set<String> getQuoteTableNameSet() {
        if (this._quoteTableNameSet != null) {
            return this._quoteTableNameSet;
        }
        Map<String, Object> littleAdjustmentMap = this.getLittleAdjustmentMap();
        Object obj = littleAdjustmentMap.get("quoteTableNameList");
        if (obj != null) {
            List list = this.castToList(obj, "littleAdjustmentMap.quoteTableNameList");
            this._quoteTableNameSet = StringSet.createAsFlexible();
            this._quoteTableNameSet.addAll(list);
        } else {
            this._quoteTableNameSet = new HashSet<String>();
        }
        return this._quoteTableNameSet;
    }

    public boolean isQuoteTable(String tableName) {
        return this.getQuoteTableNameSet().contains(tableName);
    }

    public String quoteTableNameIfNeeds(String tableName) {
        return this.quoteTableNameIfNeeds(tableName, false);
    }

    public String quoteTableNameIfNeeds(String tableName, boolean directUse) {
        if (!this.isQuoteTable(tableName) && !this.containsNonCompilableConnector(tableName)) {
            return tableName;
        }
        return this.doQuoteName(tableName, directUse);
    }

    protected Set<String> getQuoteColumnNameSet() {
        if (this._quoteColumnNameSet != null) {
            return this._quoteColumnNameSet;
        }
        Map<String, Object> littleAdjustmentMap = this.getLittleAdjustmentMap();
        Object obj = littleAdjustmentMap.get("quoteColumnNameList");
        if (obj != null) {
            List list = this.castToList(obj, "littleAdjustmentMap.quoteColumnNameList");
            this._quoteColumnNameSet = StringSet.createAsFlexible();
            this._quoteColumnNameSet.addAll(list);
        } else {
            this._quoteColumnNameSet = new HashSet<String>();
        }
        return this._quoteColumnNameSet;
    }

    public boolean isQuoteColumn(String columnName) {
        return this.getQuoteColumnNameSet().contains(columnName);
    }

    public String quoteColumnNameIfNeeds(String columnName) {
        return this.quoteColumnNameIfNeeds(columnName, false);
    }

    public String quoteColumnNameIfNeeds(String columnName, boolean directUse) {
        if (!this.isQuoteColumn(columnName) && !this.containsNonCompilableConnector(columnName)) {
            return columnName;
        }
        return this.doQuoteName(columnName, directUse);
    }

    protected String doQuoteName(String name, boolean directUse) {
        String endQuote;
        String beginQuote;
        if (this.getBasicProperties().isDatabaseSQLServer()) {
            beginQuote = "[";
            endQuote = "]";
        } else {
            endQuote = beginQuote = directUse ? "\"" : "\\\"";
        }
        return beginQuote + name + endQuote;
    }

    public boolean isSuppressNonCompilableConnectorLimiter() {
        return this.isProperty("isSuppressNonCompilableConnectorLimiter", false);
    }

    public String filterJavaNameNonCompilableConnector(String javaName, NonCompilableChecker checker) {
        this.checkNonCompilableConnector(checker.name(), checker.disp());
        List<String> connectorList = this.getNonCompilableConnectorList();
        for (String connector : connectorList) {
            javaName = Srl.replace((String)javaName, (String)connector, (String)"_");
        }
        return javaName;
    }

    public void checkNonCompilableConnector(String name, String disp) {
        if (this.isSuppressNonCompilableConnectorLimiter()) {
            return;
        }
        if (this.containsNonCompilableConnector(name)) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Non-compilable connectors in a table/column name were found.");
            br.addItem("Advice");
            br.addElement((Object)"Non-compilable connectors are unsupported.");
            br.addElement((Object)"For example, 'HYPHEN-TABLE' and 'SPACE COLUMN' and so on...");
            br.addElement((Object)"You should change the names like this:");
            br.addElement((Object)"  'HYPHEN-TABLE' -> HYPHEN_TABLE");
            br.addElement((Object)"  'SPACE COLUMN' -> SPACE_COLUMN");
            br.addElement((Object)"");
            br.addElement((Object)"If you cannot change by any possibility, you can suppress its limiter.");
            br.addElement((Object)" -> isSuppressNonCompilableConnectorLimiter in littleAdjustmentMap.dfprop.");
            br.addElement((Object)"However several functions may not work. It's a restriction.");
            br.addItem("Target Object");
            br.addElement((Object)disp);
            String msg = br.buildExceptionMessage();
            throw new DfTableColumnNameNonCompilableConnectorException(msg);
        }
    }

    protected boolean containsNonCompilableConnector(String tableName) {
        List<String> connectorList = this.getNonCompilableConnectorList();
        return Srl.containsAny((String)tableName, (String[])connectorList.toArray(new String[0]));
    }

    protected List<String> getNonCompilableConnectorList() {
        return DfCollectionUtil.newArrayList((Object[])new String[]{"-", " "});
    }

    public List<String> getPgReservColumnList() {
        if (this._pgReservColumnList != null) {
            return this._pgReservColumnList;
        }
        Map<String, Object> littleAdjustmentMap = this.getLittleAdjustmentMap();
        Object obj = littleAdjustmentMap.get("pgReservColumnList");
        this._pgReservColumnList = obj != null ? this.castToList(obj, "littleAdjustmentMap.pgReservColumnList") : new ArrayList<String>();
        return this._pgReservColumnList;
    }

    public boolean isPgReservColumn(String columnName) {
        List<String> pgReservColumnList = this.getPgReservColumnList();
        if (pgReservColumnList.isEmpty()) {
            if (this.isTargetLanguageJava()) {
                return Srl.equalsIgnoreCase((String)columnName, (String[])this.getDefaultJavaPgReservColumn());
            }
            if (this.isTargetLanguageCSharp()) {
                return Srl.equalsIgnoreCase((String)columnName, (String[])this.getDefaultCSharpPgReservColumn());
            }
            return false;
        }
        return Srl.equalsIgnoreCase((String)columnName, (String[])pgReservColumnList.toArray(new String[0]));
    }

    protected String[] getDefaultJavaPgReservColumn() {
        return new String[]{"class", "case", "package", "default", "new", "native", "void", "public", "protected", "private", "interface", "abstract", "final", "finally", "return", "double", "float", "short"};
    }

    protected String[] getDefaultCSharpPgReservColumn() {
        return new String[]{"class"};
    }

    public String resolvePgReservColumn(String columnName) {
        if (this.isPgReservColumn(columnName)) {
            return columnName + (this.getBasicProperties().isColumnNameCamelCase() ? "Synonym" : "_SYNONYM");
        }
        return columnName;
    }

    public boolean isUseAnsiStringTypeToNotUnicode() {
        return this.isProperty("isUseAnsiStringTypeToNotUnicode", false);
    }

    public boolean isAlternateGenerateControlValid() {
        String str = this.getAlternateGenerateControl();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getAlternateGenerateControl() {
        return this.getProperty("alternateGenerateControl", null);
    }

    public boolean isAlternateSql2EntityControlValid() {
        String str = this.getAlternateSql2EntityControl();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getAlternateSql2EntityControl() {
        return this.getProperty("alternateSql2EntityControl", null);
    }

    public boolean isStopGenerateExtendedBhv() {
        return this.isProperty("isStopGenerateExtendedBhv", false);
    }

    public boolean isStopGenerateExtendedDao() {
        return this.isProperty("isStopGenerateExtendedDao", false);
    }

    public boolean isStopGenerateExtendedEntity() {
        return this.isProperty("isStopGenerateExtendedEntity", false);
    }

    public boolean isDeleteOldTableClass() {
        return this.isProperty("isDeleteOldTableClass", true);
    }

    public boolean isSkipGenerateIfSameFile() {
        return this.isProperty("isSkipGenerateIfSameFile", true);
    }

    public boolean isAvailableToLowerInGeneratorUnderscoreMethod() {
        return this.isProperty("isAvailableToLowerInGeneratorUnderscoreMethod", true);
    }

    public boolean isMakeFlatExpansion() {
        return this.isProperty("isMakeFlatExpansion", false);
    }

    public boolean isMakeDaoInterface() {
        if (this.isTargetLanguageCSharp()) {
            return true;
        }
        boolean makeDaoInterface = this.booleanProp("torque.isMakeDaoInterface", false);
        if (makeDaoInterface) {
            String msg = "Dao interfaces are unsupported since DBFlute-0.8.7!";
            throw new UnsupportedOperationException(msg);
        }
        return false;
    }

    protected boolean isTargetLanguageJava() {
        return this.getBasicProperties().isTargetLanguageJava();
    }

    protected boolean isTargetLanguageCSharp() {
        return this.getBasicProperties().isTargetLanguageCSharp();
    }

    public boolean isCompatibleAutoMappingOldStyle() {
        return this.isProperty("isCompatibleAutoMappingOldStyle", false);
    }

    public static interface NonCompilableChecker {
        public String name();

        public String disp();
    }
}

