/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.bqp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfBehaviorNotFoundException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.language.grammar.DfGrammarInfo;
import org.seasar.dbflute.logic.generate.packagepath.DfPackagePathHandler;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfOutsideSqlMarkAnalyzer;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfBehaviorQueryPathSetupper {
    private static final Log _log = LogFactory.getLog(DfBehaviorQueryPathSetupper.class);
    protected DfBuildProperties _buildProperties;
    protected String _flatDirectoryPackage;

    public DfBehaviorQueryPathSetupper(DfBuildProperties buildProperties) {
        this._buildProperties = buildProperties;
    }

    public void setupBehaviorQueryPath(List<File> sqlFileList) {
        if (this.getOutsideSqlProperties().isSuppressBehaviorQueryPath()) {
            _log.info((Object)"*Behavior Query Path is suppressed!");
            return;
        }
        if (sqlFileList.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> behaviorQueryPathMap = this.createBehaviorQueryPathMap(sqlFileList);
        this.reflectBehaviorQueryPath(behaviorQueryPathMap);
    }

    public Map<String, Map<String, Map<String, String>>> extractTableBqpMap(List<File> sqlFileList) {
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        if (sqlFileList.isEmpty()) {
            return resultMap;
        }
        Map<String, Map<String, String>> bqpMap = this.createBehaviorQueryPathMap(sqlFileList);
        Map<File, Map<String, Map<String, String>>> resourceMap = this.createReflectResourceMap(bqpMap);
        Set<Map.Entry<File, Map<String, Map<String, String>>>> entrySet = resourceMap.entrySet();
        for (Map.Entry<File, Map<String, Map<String, String>>> entry : entrySet) {
            String basePrefix;
            String projectPrefix;
            String bhvSuffix;
            File bsbhvFile = entry.getKey();
            String tableKeyName = bsbhvFile.getName();
            int extIndex = tableKeyName.lastIndexOf(".");
            if (extIndex >= 0) {
                tableKeyName = tableKeyName.substring(0, extIndex);
            }
            DfBasicProperties basicProperties = this.getBasicProperties();
            if (this.isApplicationBehaviorProject()) {
                bhvSuffix = "Bhv" + this.getApplicationBehaviorAdditionalSuffix();
                projectPrefix = this.getLibraryProjectPrefix();
            } else {
                bhvSuffix = "Bhv";
                projectPrefix = basicProperties.getProjectPrefix();
            }
            if (tableKeyName.endsWith(bhvSuffix)) {
                tableKeyName = tableKeyName.substring(0, tableKeyName.length() - bhvSuffix.length());
            }
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)projectPrefix) && tableKeyName.startsWith(projectPrefix)) {
                tableKeyName = tableKeyName.substring(projectPrefix.length());
            }
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)(basePrefix = basicProperties.getBasePrefix())) && tableKeyName.startsWith(basePrefix)) {
                tableKeyName = tableKeyName.substring(basePrefix.length(), tableKeyName.length());
            }
            resultMap.put(tableKeyName, entry.getValue());
        }
        return resultMap;
    }

    protected InputStreamReader newInputStreamReader(File sqlFile) {
        String encoding = this.getProperties().getOutsideSqlProperties().getSqlFileEncoding();
        try {
            return new InputStreamReader((InputStream)new FileInputStream(sqlFile), encoding);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("The file does not exist: " + sqlFile, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("The encoding is unsupported: " + encoding, e);
        }
    }

    protected Map<String, Map<String, String>> createBehaviorQueryPathMap(List<File> sqlFileList) {
        String exbhvPackage = this.getBasicProperties().getExtendedBehaviorPackage();
        if (exbhvPackage.contains(".")) {
            exbhvPackage = exbhvPackage.substring(exbhvPackage.lastIndexOf(".") + ".".length());
        }
        String exbhvName = exbhvPackage;
        LinkedHashMap<String, Map<String, String>> behaviorQueryPathMap = new LinkedHashMap<String, Map<String, String>>();
        this.gatherBehaviorQueryPathInfo(behaviorQueryPathMap, sqlFileList, exbhvName);
        return behaviorQueryPathMap;
    }

    protected void gatherBehaviorQueryPathInfo(Map<String, Map<String, String>> behaviorQueryPathMap, List<File> sqlFileList, String exbhvName) {
        String exbhvMark = "/" + exbhvName + "/";
        String exbhvSuffix = "Bhv";
        Pattern behaviorQueryPathPattern = Pattern.compile(".+" + exbhvMark + ".+" + "Bhv" + "_.+.sql$");
        for (File sqlFile : sqlFileList) {
            String path = this.getSlashPath(sqlFile);
            Matcher matcher = behaviorQueryPathPattern.matcher(path);
            if (!matcher.matches()) continue;
            String subDirectoryPath = null;
            String simpleFileName = path.substring(path.lastIndexOf(exbhvMark) + exbhvMark.length());
            if (simpleFileName.contains("/")) {
                subDirectoryPath = simpleFileName.substring(0, simpleFileName.lastIndexOf("/"));
                simpleFileName = simpleFileName.substring(simpleFileName.lastIndexOf("/") + "/".length());
            }
            int behaviorNameMarkIndex = simpleFileName.indexOf("Bhv_");
            int behaviorNameEndIndex = behaviorNameMarkIndex + "Bhv".length();
            int behaviorQueryPathStartIndex = behaviorNameMarkIndex + "Bhv_".length();
            int behaviorQueryPathEndIndex = simpleFileName.lastIndexOf(".sql");
            String entityName = simpleFileName.substring(0, behaviorNameMarkIndex);
            String behaviorName = simpleFileName.substring(0, behaviorNameEndIndex);
            String behaviorQueryPath = simpleFileName.substring(behaviorQueryPathStartIndex, behaviorQueryPathEndIndex);
            LinkedHashMap<String, String> behaviorQueryElement = new LinkedHashMap<String, String>();
            behaviorQueryElement.put("path", path);
            behaviorQueryElement.put("subDirectoryPath", subDirectoryPath);
            behaviorQueryElement.put("entityName", entityName);
            behaviorQueryElement.put("behaviorName", behaviorName);
            behaviorQueryElement.put("behaviorQueryPath", behaviorQueryPath);
            behaviorQueryPathMap.put(path, behaviorQueryElement);
            this.setupInfoInSqlFile(sqlFile, behaviorQueryElement);
        }
    }

    protected void setupInfoInSqlFile(File sqlFile, Map<String, String> elementMap) {
        DfOutsideSqlMarkAnalyzer analyzer = new DfOutsideSqlMarkAnalyzer();
        BufferedReader reader = new BufferedReader(this.newInputStreamReader(sqlFile));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(this.ln());
            }
        }
        catch (IOException e) {
            String msg = "Failed to read the SQL: " + sqlFile;
            throw new IllegalStateException(msg, e);
        }
        String sql = sb.toString();
        String customizeEntity = analyzer.getCustomizeEntityName(sql);
        String parameterBean = analyzer.getParameterBeanName(sql);
        elementMap.put("customizeEntity", customizeEntity);
        elementMap.put("parameterBean", parameterBean);
        elementMap.put("cursor", analyzer.isCursor(sql) ? "cursor" : null);
        elementMap.put("title", analyzer.getTitle(sql));
        elementMap.put("description", analyzer.getDescription(sql));
    }

    protected void reflectBehaviorQueryPath(Map<String, Map<String, String>> behaviorQueryPathMap) {
        Map<File, Map<String, Map<String, String>>> reflectResourceMap = this.createReflectResourceMap(behaviorQueryPathMap);
        if (reflectResourceMap.isEmpty()) {
            return;
        }
        this.handleReflectResource(reflectResourceMap);
    }

    protected Map<File, Map<String, Map<String, String>>> createReflectResourceMap(Map<String, Map<String, String>> behaviorQueryPathMap) {
        if (behaviorQueryPathMap.isEmpty()) {
            return new HashMap<File, Map<String, Map<String, String>>>();
        }
        String tmp = this.getBasicProperties().getGenerateOutputDirectory();
        if (tmp.endsWith("/")) {
            tmp = tmp.substring(0, tmp.length() - "/".length());
        }
        String outputDir = tmp;
        String bsbhvPackage = this.getBasicProperties().getBaseBehaviorPackage();
        DfPackagePathHandler packagePathHandler = new DfPackagePathHandler(this.getBasicProperties());
        packagePathHandler.setFileSeparatorSlash(true);
        String bsbhvPathBase = outputDir + "/" + packagePathHandler.getPackageAsPath(bsbhvPackage);
        File bsbhvDir = new File(bsbhvPathBase);
        if (!bsbhvDir.exists()) {
            _log.warn((Object)("The base behavior directory was not found: bsbhvDir=" + bsbhvDir));
            return new HashMap<File, Map<String, Map<String, String>>>();
        }
        Map<String, File> bsbhvFileMap = this.createBsBhvFileMap(bsbhvDir);
        HashMap<File, Map<String, Map<String, String>>> reflectResourceMap = new HashMap<File, Map<String, Map<String, String>>>();
        Set<Map.Entry<String, Map<String, String>>> entrySet = behaviorQueryPathMap.entrySet();
        for (Map.Entry<String, Map<String, String>> entry : entrySet) {
            LinkedHashMap<String, Map<String, String>> resourceElementMap;
            Map<String, String> behaviorQueryElementMap = entry.getValue();
            String behaviorName = behaviorQueryElementMap.get("behaviorName");
            String behaviorQueryPath = behaviorQueryElementMap.get("behaviorQueryPath");
            File bsbhvFile = bsbhvFileMap.get(behaviorName);
            if (bsbhvFile == null) {
                if (this.isApplicationBehaviorProject()) {
                    String retryName = behaviorName;
                    String projectPrefixLib = this.getLibraryProjectPrefix();
                    if (retryName.startsWith(projectPrefixLib)) {
                        retryName.substring(projectPrefixLib.length());
                    }
                    String projectPrefixAp = this.getBasicProperties().getProjectPrefix();
                    retryName = projectPrefixAp + retryName;
                    String additionalSuffix = this.getApplicationBehaviorAdditionalSuffix();
                    retryName = retryName + additionalSuffix;
                    bsbhvFile = bsbhvFileMap.get(retryName);
                }
                if (bsbhvFile == null) {
                    this.throwBehaviorNotFoundException(bsbhvFileMap, behaviorQueryElementMap, bsbhvPathBase);
                }
            }
            if ((resourceElementMap = (LinkedHashMap<String, Map<String, String>>)reflectResourceMap.get(bsbhvFile)) == null) {
                resourceElementMap = new LinkedHashMap<String, Map<String, String>>();
                reflectResourceMap.put(bsbhvFile, resourceElementMap);
            }
            if (resourceElementMap.containsKey(behaviorQueryPath)) continue;
            resourceElementMap.put(behaviorQueryPath, behaviorQueryElementMap);
        }
        return reflectResourceMap;
    }

    protected Map<String, File> createBsBhvFileMap(File bsbhvDir) {
        final String classFileExtension = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo().getClassFileExtension();
        FileFilter filefilter = new FileFilter(){

            public boolean accept(File file) {
                String path = file.getPath();
                if (DfBehaviorQueryPathSetupper.this.isApplicationBehaviorProject()) {
                    String additionalSuffix = DfBehaviorQueryPathSetupper.this.getApplicationBehaviorAdditionalSuffix();
                    String bhvSuffix = "Bhv" + additionalSuffix;
                    return path.endsWith(bhvSuffix + "." + classFileExtension);
                }
                return path.endsWith("Bhv." + classFileExtension);
            }
        };
        List<File> bsbhvFileList = Arrays.asList(bsbhvDir.listFiles(filefilter));
        HashMap<String, File> bsbhvFileMap = new HashMap<String, File>();
        for (File bsbhvFile : bsbhvFileList) {
            String path = this.getSlashPath(bsbhvFile);
            String bsbhvSimpleName = (path = path.substring(0, path.lastIndexOf("." + classFileExtension))).contains("/") ? path.substring(path.lastIndexOf("/") + "/".length()) : path;
            String behaviorName = this.removeBasePrefix(bsbhvSimpleName);
            bsbhvFileMap.put(behaviorName, bsbhvFile);
        }
        return bsbhvFileMap;
    }

    protected void throwBehaviorNotFoundException(Map<String, File> bsbhvFileMap, Map<String, String> behaviorQueryElementMap, String bsbhvPathBase) {
        String path = behaviorQueryElementMap.get("path");
        String behaviorName = behaviorQueryElementMap.get("behaviorName");
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The behavior was Not Found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the existence of the behavior." + this.ln();
        msg = msg + "And confirm your SQL file name." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Your SQL File]" + this.ln() + path + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Not Found Behavior]" + this.ln() + behaviorName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Behavior Directory]" + this.ln() + bsbhvPathBase + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Behavior List]" + this.ln() + bsbhvFileMap.keySet() + this.ln();
        msg = msg + "* * * * * * * * * */" + this.ln();
        throw new DfBehaviorNotFoundException(msg);
    }

    protected void handleReflectResource(Map<File, Map<String, Map<String, String>>> reflectResourceMap) {
        _log.info((Object)" ");
        _log.info((Object)"[Behavior Query Path]");
        Set<Map.Entry<File, Map<String, Map<String, String>>>> entrySet = reflectResourceMap.entrySet();
        for (Map.Entry<File, Map<String, Map<String, String>>> entry : entrySet) {
            File bsbhvFile = entry.getKey();
            Map<String, Map<String, String>> resourceElementMap = entry.getValue();
            this.writeBehaviorQueryPath(bsbhvFile, resourceElementMap);
        }
        _log.info((Object)" ");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeBehaviorQueryPath(File bsbhvFile, Map<String, Map<String, String>> resourceElementMap) {
        String msg;
        StringBuilder sb;
        String encoding;
        block29: {
            String lineString;
            BufferedReader bufferedReader;
            block28: {
                encoding = this.getBasicProperties().getSourceFileEncoding();
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bsbhvFile), encoding));
                }
                catch (UnsupportedEncodingException e) {
                    String msg2 = "The encoding is unsupported: encoding=" + encoding;
                    throw new IllegalStateException(msg2, e);
                }
                catch (FileNotFoundException e) {
                    String msg3 = "The file of base behavior was Not Found: bsbhvFile=" + bsbhvFile;
                    throw new IllegalStateException(msg3, e);
                }
                StringBuilder logSb = new StringBuilder();
                String path = this.getSlashPath(bsbhvFile);
                if (path.contains("/")) {
                    logSb.append(path.substring(path.lastIndexOf("/") + "/".length()));
                } else {
                    logSb.append(path);
                }
                DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
                String behaviorQueryPathBeginMark = this.getBasicProperties().getBehaviorQueryPathBeginMark();
                String behaviorQueryPathEndMark = this.getBasicProperties().getBehaviorQueryPathEndMark();
                DfDocumentProperties docprop = this.getDocumentProperties();
                lineString = null;
                sb = new StringBuilder();
                boolean targetArea = false;
                boolean done = false;
                while (true) {
                    if ((lineString = bufferedReader.readLine()) == null) {
                        if (!targetArea) break;
                        msg = "The end mark of behavior query path was NOT found: bsbhvFile=" + bsbhvFile;
                        throw new IllegalStateException(msg);
                    }
                    if (targetArea) {
                        if (!lineString.contains(behaviorQueryPathEndMark)) continue;
                        targetArea = false;
                    }
                    sb.append(lineString).append("\n");
                    if (done || !lineString.contains(behaviorQueryPathBeginMark)) continue;
                    targetArea = true;
                    Set<String> behaviorQueryPathSet = resourceElementMap.keySet();
                    for (String behaviorQueryPath : behaviorQueryPathSet) {
                        Map<String, String> behaviorQueryElementMap = resourceElementMap.get(behaviorQueryPath);
                        StringBuilder definitionLineSb = new StringBuilder();
                        String indent = lineString.substring(0, lineString.indexOf(behaviorQueryPathBeginMark));
                        String title = behaviorQueryElementMap.get("title");
                        if (title != null && title.trim().length() > 0) {
                            String resolvedTitle = docprop.resolveTextForJavaDoc(title, indent);
                            String commentExp = this.getBasicProperties().isTargetLanguageCSharp() ? indent + "/// <summary>" + resolvedTitle + " </summary>\n" : indent + "/** " + resolvedTitle + " */\n";
                            definitionLineSb.append(commentExp);
                        }
                        definitionLineSb.append(indent);
                        definitionLineSb.append(grammarInfo.getPublicStaticDefinition());
                        String subDirectoryPath = behaviorQueryElementMap.get("subDirectoryPath");
                        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)subDirectoryPath)) {
                            String subDirectoryName = Srl.replace((String)subDirectoryPath, (String)"/", (String)"_");
                            String subDirectoryValue = Srl.replace((String)subDirectoryPath, (String)"/", (String)":");
                            definitionLineSb.append(" String PATH_");
                            definitionLineSb.append(subDirectoryName).append("_").append(behaviorQueryPath);
                            definitionLineSb.append(" = \"");
                            definitionLineSb.append(subDirectoryValue).append(":").append(behaviorQueryPath);
                            definitionLineSb.append("\";");
                        } else {
                            definitionLineSb.append(" String PATH_").append(behaviorQueryPath);
                            definitionLineSb.append(" = \"").append(behaviorQueryPath).append("\";");
                        }
                        String tmp4log = definitionLineSb.toString();
                        logSb.append("\n").append(tmp4log.substring(tmp4log.indexOf(" PATH_")));
                        definitionLineSb.append("\n");
                        sb.append((CharSequence)definitionLineSb);
                    }
                    done = true;
                }
                _log.info((Object)logSb.toString());
                if (done) break block28;
                _log.info((Object)"  --> The mark of behavior query path was Not Found!");
            }
            Object var26_35 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException ignored) {
                _log.warn((Object)ignored.getMessage());
            }
            break block29;
            {
                catch (IOException e) {
                    String msg4 = "bufferedReader.readLine() threw the exception: current line=" + lineString;
                    throw new IllegalStateException(msg4, e);
                }
            }
            catch (Throwable throwable) {
                Object var26_36 = null;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    _log.warn((Object)ignored.getMessage());
                }
                throw throwable;
            }
        }
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(bsbhvFile), encoding));
        bufferedWriter.write(sb.toString());
        bufferedWriter.flush();
        Object var29_40 = null;
        if (bufferedWriter == null) return;
        try {
            bufferedWriter.close();
            return;
        }
        catch (IOException ignored) {
            _log.warn((Object)ignored.getMessage());
        }
        return;
        {
            catch (UnsupportedEncodingException e) {
                msg = "The encoding is unsupported: encoding=" + encoding;
                throw new IllegalStateException(msg, e);
            }
            catch (FileNotFoundException e) {
                msg = "The file of base behavior was not found: bsbhvFile=" + bsbhvFile;
                throw new IllegalStateException(msg, e);
            }
            catch (IOException e) {
                msg = "bufferedWriter.write() threw the exception: bsbhvFile=" + bsbhvFile;
                throw new IllegalStateException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var29_41 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException ignored) {
                _log.warn((Object)ignored.getMessage());
            }
            throw throwable;
        }
    }

    protected String removeBasePrefix(String bsbhvSimpleName) {
        String projectPrefix = this.getBasicProperties().getProjectPrefix();
        String basePrefix = this.getBasicProperties().getBasePrefix();
        String prefix = projectPrefix + basePrefix;
        if (!bsbhvSimpleName.startsWith(prefix)) {
            return bsbhvSimpleName;
        }
        int prefixLength = prefix.length();
        if (!Character.isUpperCase(bsbhvSimpleName.substring(prefixLength).charAt(0))) {
            return bsbhvSimpleName;
        }
        if (bsbhvSimpleName.length() <= prefixLength) {
            return bsbhvSimpleName;
        }
        return projectPrefix + bsbhvSimpleName.substring(prefixLength);
    }

    public String replaceString(String text, String fromText, String toText) {
        return Srl.replace((String)text, (String)fromText, (String)toText);
    }

    public String getSlashPath(File file) {
        return this.replaceString(file.getPath(), this.getFileSeparator(), "/");
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String ln() {
        return "\n";
    }

    protected DfBuildProperties getProperties() {
        return this._buildProperties;
    }

    protected DfBasicProperties getBasicProperties() {
        return this._buildProperties.getBasicProperties();
    }

    protected DfOutsideSqlProperties getOutsideSqlProperties() {
        return this._buildProperties.getOutsideSqlProperties();
    }

    protected DfDocumentProperties getDocumentProperties() {
        return this._buildProperties.getDocumentProperties();
    }

    protected DfLittleAdjustmentProperties getLittleAdjustmentProperties() {
        return this.getProperties().getLittleAdjustmentProperties();
    }

    protected boolean isApplicationBehaviorProject() {
        return this.getBasicProperties().isApplicationBehaviorProject();
    }

    protected String getLibraryProjectPrefix() {
        return this.getBasicProperties().getLibraryProjectPrefix();
    }

    protected String getApplicationBehaviorAdditionalSuffix() {
        return this.getBasicProperties().getApplicationBehaviorAdditionalSuffix();
    }

    public String getFlatDirectoryPackage() {
        return this._flatDirectoryPackage;
    }

    public void setFlatDirectoryPackage(String flatDirectoryPackage) {
        this._flatDirectoryPackage = flatDirectoryPackage;
    }
}

