/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.schemainitializer;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.replaceschema.schemainitializer.DfSchemaInitializerJdbc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerDB2
extends DfSchemaInitializerJdbc {
    private static final Log _log = LogFactory.getLog(DfSchemaInitializerDB2.class);

    @Override
    protected boolean isSkipDropForeignKey(DfTableMetaInfo tableMetaInfo) {
        return tableMetaInfo.isTableTypeAlias();
    }

    @Override
    protected void setupDropTable(StringBuilder sb, DfTableMetaInfo metaInfo) {
        if (metaInfo.isTableTypeAlias()) {
            String tableName = this.filterTableName(metaInfo.getTableName());
            sb.append("drop alias ").append(tableName);
        } else {
            super.setupDropTable(sb, metaInfo);
        }
    }

    @Override
    protected void dropSequence(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        if (!this._unifiedSchema.hasSchema()) {
            return;
        }
        String schema = this._unifiedSchema.getPureSchema();
        ArrayList<String> sequenceNameList = new ArrayList<String>();
        DfJdbcFacade jdbcFacade = new DfJdbcFacade(conn);
        String sequenceColumnName = "sequence_name";
        StringBuilder sb = new StringBuilder();
        sb.append("select SEQNAME as ").append("sequence_name").append(" from SYSCAT.SEQUENCES");
        sb.append(" where SEQSCHEMA = '").append(schema).append("'");
        List<Map<String, String>> resultList = jdbcFacade.selectStringList(sb.toString(), Arrays.asList("sequence_name"));
        for (Map<String, String> recordMap : resultList) {
            sequenceNameList.add(recordMap.get("sequence_name"));
        }
        for (String sequenceName : sequenceNameList) {
            String dropSequenceSql = "drop sequence " + schema + "." + sequenceName;
            _log.info((Object)dropSequenceSql);
            jdbcFacade.execute(dropSequenceSql);
        }
    }
}

