/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.procedure;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeArrayInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeStructInfo;
import org.seasar.dbflute.logic.jdbc.metadata.procedure.DfProcedureParameterExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.procedure.DfProcedureSupplementExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.various.array.DfArrayExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.various.struct.DfStructExtractorOracle;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureSupplementExtractorOracle
implements DfProcedureSupplementExtractor {
    private static final Log _log = LogFactory.getLog(DfProcedureSupplementExtractorOracle.class);
    protected final DataSource _dataSource;
    protected final Map<UnifiedSchema, StringKeyMap<DfTypeArrayInfo>> _arrayInfoMapMap = DfCollectionUtil.newHashMap();
    protected final Map<UnifiedSchema, StringKeyMap<DfTypeArrayInfo>> _flatArrayInfoMapMap = DfCollectionUtil.newHashMap();
    protected final Map<UnifiedSchema, StringKeyMap<DfTypeStructInfo>> _structInfoMapMap = DfCollectionUtil.newHashMap();
    protected final Map<UnifiedSchema, StringSet> _arrayTypeSetMap = DfCollectionUtil.newHashMap();
    protected final Map<UnifiedSchema, List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo>> _argumentInfoListMap = DfCollectionUtil.newHashMap();
    protected boolean _suppressLogging;

    public DfProcedureSupplementExtractorOracle(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public StringKeyMap<Integer> extractParameterOverloadInfoMap() {
        UnifiedSchema mainSchema = this.getMainSchema();
        List<UnifiedSchema> additionalSchemaList = this.getAdditionalSchemaList();
        StringKeyMap<Integer> resultMap = this.findParameterOverloadInfoMap(mainSchema);
        for (UnifiedSchema additionalSchema : additionalSchemaList) {
            StringKeyMap<Integer> additionalMap = this.findParameterOverloadInfoMap(additionalSchema);
            resultMap.putAll(additionalMap);
        }
        return resultMap;
    }

    public StringKeyMap<Integer> findParameterOverloadInfoMap(UnifiedSchema unifiedSchema) {
        List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> infoList = this.findProcedureArgumentInfoList(unifiedSchema);
        StringKeyMap infoMap = StringKeyMap.createAsFlexibleOrdered();
        for (int i = 0; i < infoList.size(); ++i) {
            DfProcedureParameterExtractorOracle.ProcedureArgumentInfo info = infoList.get(i);
            String argumentName = info.getArgumentName();
            String overload = info.getOverload();
            if (Srl.is_Null_or_TrimmedEmpty((String)argumentName) || Srl.is_Null_or_TrimmedEmpty((String)overload)) continue;
            String key = this.generateParameterInfoMapKey(info.getPackageName(), info.getObjectName(), argumentName);
            infoMap.put(key, (Object)DfTypeUtil.toInteger((Object)overload));
        }
        return infoMap;
    }

    public StringKeyMap<DfTypeArrayInfo> extractParameterArrayInfoMap() {
        UnifiedSchema mainSchema = this.getMainSchema();
        List<UnifiedSchema> additionalSchemaList = this.getAdditionalSchemaList();
        StringKeyMap<DfTypeArrayInfo> resultMap = this.findParameterArrayInfoMap(mainSchema);
        for (UnifiedSchema additionalSchema : additionalSchemaList) {
            StringKeyMap<DfTypeArrayInfo> additionalMap = this.findParameterArrayInfoMap(additionalSchema);
            resultMap.putAll(additionalMap);
        }
        return resultMap;
    }

    protected StringKeyMap<DfTypeArrayInfo> findParameterArrayInfoMap(UnifiedSchema unifiedSchema) {
        StringKeyMap parameterArrayInfoMap = this._arrayInfoMapMap.get(unifiedSchema);
        if (parameterArrayInfoMap != null) {
            return parameterArrayInfoMap;
        }
        List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> argInfoList = this.findProcedureArgumentInfoList(unifiedSchema);
        parameterArrayInfoMap = StringKeyMap.createAsFlexibleOrdered();
        StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap = this.findFlatArrayInfoMap(unifiedSchema);
        for (int i = 0; i < argInfoList.size(); ++i) {
            String realTypeName;
            DfTypeArrayInfo foundInfo;
            DfProcedureParameterExtractorOracle.ProcedureArgumentInfo argInfo = argInfoList.get(i);
            String argumentName = argInfo.getArgumentName();
            if (Srl.is_Null_or_TrimmedEmpty((String)argumentName) || (foundInfo = (DfTypeArrayInfo)flatArrayInfoMap.get((Object)(realTypeName = this.buildArrayTypeName(argInfo)))) == null) continue;
            DfTypeArrayInfo arrayInfo = new DfTypeArrayInfo(foundInfo.getUnifiedSchema(), foundInfo.getTypeName());
            arrayInfo.setElementType(foundInfo.getElementType());
            this.processArrayNestedElement(unifiedSchema, flatArrayInfoMap, arrayInfo);
            String packageName = argInfo.getPackageName();
            String objectName = argInfo.getObjectName();
            String key = this.generateParameterInfoMapKey(packageName, objectName, argumentName);
            parameterArrayInfoMap.put(key, (Object)arrayInfo);
        }
        this.log("Array Parameter: " + unifiedSchema);
        for (Map.Entry entry : parameterArrayInfoMap.entrySet()) {
            this.log("  " + (String)entry.getKey() + " = " + entry.getValue());
        }
        this._arrayInfoMapMap.put(unifiedSchema, (StringKeyMap<DfTypeArrayInfo>)parameterArrayInfoMap);
        return this._arrayInfoMapMap.get(unifiedSchema);
    }

    protected void processArrayNestedElement(UnifiedSchema unifiedSchema, StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap, DfTypeArrayInfo arrayInfo) {
        StringKeyMap<DfTypeStructInfo> structInfoMap;
        DfTypeStructInfo structInfo;
        DfTypeArrayInfo foundInfo = (DfTypeArrayInfo)flatArrayInfoMap.get((Object)arrayInfo.getElementType());
        if (foundInfo != null) {
            DfTypeArrayInfo nestedInfo = new DfTypeArrayInfo(foundInfo.getUnifiedSchema(), foundInfo.getTypeName());
            nestedInfo.setElementType(foundInfo.getElementType());
            arrayInfo.setNestedArrayInfo(nestedInfo);
            this.processArrayNestedElement(unifiedSchema, flatArrayInfoMap, nestedInfo);
        }
        if ((structInfo = (DfTypeStructInfo)(structInfoMap = this.findStructInfoMap(unifiedSchema)).get((Object)arrayInfo.getElementType())) != null) {
            arrayInfo.setElementStructInfo(structInfo);
        }
    }

    protected String buildArrayTypeName(DfProcedureParameterExtractorOracle.ProcedureArgumentInfo argInfo) {
        return argInfo.buildArrayTypeName();
    }

    @Override
    public StringKeyMap<DfTypeStructInfo> extractStructInfoMap() {
        UnifiedSchema mainSchema = this.getMainSchema();
        List<UnifiedSchema> additionalSchemaList = this.getAdditionalSchemaList();
        StringKeyMap<DfTypeStructInfo> resultMap = this.findStructInfoMap(mainSchema);
        for (UnifiedSchema additionalSchema : additionalSchemaList) {
            StringKeyMap<DfTypeStructInfo> additionalMap = this.findStructInfoMap(additionalSchema);
            resultMap.putAll(additionalMap);
        }
        return resultMap;
    }

    protected StringKeyMap<DfTypeStructInfo> findStructInfoMap(UnifiedSchema unifiedSchema) {
        StringKeyMap<DfTypeStructInfo> structInfoMap = this._structInfoMapMap.get(unifiedSchema);
        if (structInfoMap != null) {
            return structInfoMap;
        }
        DfStructExtractorOracle extractor = new DfStructExtractorOracle(this._dataSource, this._suppressLogging);
        structInfoMap = extractor.extractStructInfoMap(unifiedSchema);
        this.resolveStructAttributeInfo(unifiedSchema, structInfoMap);
        this.log("Struct Info: " + unifiedSchema);
        for (DfTypeStructInfo structInfo : structInfoMap.values()) {
            this.log("  " + structInfo.toString());
        }
        this._structInfoMapMap.put(unifiedSchema, structInfoMap);
        return this._structInfoMapMap.get(unifiedSchema);
    }

    protected void resolveStructAttributeInfo(UnifiedSchema unifiedSchema, StringKeyMap<DfTypeStructInfo> structInfoMap) {
        StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap = this.findFlatArrayInfoMap(unifiedSchema);
        for (DfTypeStructInfo structInfo : structInfoMap.values()) {
            this.doResolveStructAttributeInfo(unifiedSchema, structInfoMap, flatArrayInfoMap, structInfo);
        }
    }

    protected void doResolveStructAttributeInfo(UnifiedSchema unifiedSchema, StringKeyMap<DfTypeStructInfo> structInfoMap, StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap, DfTypeStructInfo structInfo) {
        for (DfColumnMetaInfo columnInfo : structInfo.getAttributeInfoMap().values()) {
            this.doResolveStructAttributeInfo(unifiedSchema, structInfoMap, flatArrayInfoMap, structInfo, columnInfo);
        }
    }

    protected void doResolveStructAttributeInfo(UnifiedSchema unifiedSchema, StringKeyMap<DfTypeStructInfo> structInfoMap, StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap, DfTypeStructInfo structInfo, DfColumnMetaInfo columnInfo) {
        DfTypeStructInfo nestedStructInfo;
        String attrTypeName = columnInfo.getDbTypeName();
        DfTypeArrayInfo arrayInfo = this.doResolveStructAttributeArray(structInfoMap, flatArrayInfoMap, attrTypeName);
        if (arrayInfo != null) {
            columnInfo.setTypeArrayInfo(arrayInfo);
        }
        if ((nestedStructInfo = (DfTypeStructInfo)structInfoMap.get((Object)attrTypeName)) != null) {
            columnInfo.setTypeStructInfo(nestedStructInfo);
        }
        columnInfo.setProcedureParameter(true);
    }

    protected DfTypeArrayInfo doResolveStructAttributeArray(StringKeyMap<DfTypeStructInfo> structInfoMap, StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap, String attrTypeName) {
        if (!flatArrayInfoMap.containsKey((Object)attrTypeName)) {
            return null;
        }
        DfTypeArrayInfo foundInfo = (DfTypeArrayInfo)flatArrayInfoMap.get((Object)attrTypeName);
        DfTypeArrayInfo typeArrayInfo = new DfTypeArrayInfo(foundInfo.getUnifiedSchema(), foundInfo.getTypeName());
        String elementType = foundInfo.getElementType();
        typeArrayInfo.setElementType(elementType);
        if (flatArrayInfoMap.containsKey((Object)elementType)) {
            DfTypeArrayInfo nestedArrayInfo = this.doResolveStructAttributeArray(structInfoMap, flatArrayInfoMap, elementType);
            typeArrayInfo.setNestedArrayInfo(nestedArrayInfo);
        } else if (structInfoMap.containsKey((Object)elementType)) {
            DfTypeStructInfo elementStructInfo = (DfTypeStructInfo)structInfoMap.get((Object)elementType);
            typeArrayInfo.setElementStructInfo(elementStructInfo);
        }
        return typeArrayInfo;
    }

    @Override
    public String generateParameterInfoMapKey(String catalog, String procedureName, String parameterName) {
        StringBuilder keySb = new StringBuilder();
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)catalog)) {
            keySb.append(catalog).append(".");
        }
        keySb.append(procedureName).append(".").append(parameterName);
        return keySb.toString();
    }

    protected StringKeyMap<DfTypeArrayInfo> findFlatArrayInfoMap(UnifiedSchema unifiedSchema) {
        StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap = this._flatArrayInfoMapMap.get(unifiedSchema);
        if (flatArrayInfoMap != null) {
            return flatArrayInfoMap;
        }
        DfArrayExtractorOracle extractor = new DfArrayExtractorOracle(this._dataSource, this._suppressLogging);
        flatArrayInfoMap = extractor.extractFlatArrayInfoMap(unifiedSchema);
        this._flatArrayInfoMapMap.put(unifiedSchema, flatArrayInfoMap);
        return this._flatArrayInfoMapMap.get(unifiedSchema);
    }

    protected List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> findProcedureArgumentInfoList(UnifiedSchema unifiedSchema) {
        List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> argInfoList = this._argumentInfoListMap.get(unifiedSchema);
        if (argInfoList != null) {
            return argInfoList;
        }
        DfProcedureParameterExtractorOracle extractor = this.createProcedureParameterExtractorOracle();
        argInfoList = extractor.extractProcedureArgumentInfoList(unifiedSchema);
        this._argumentInfoListMap.put(unifiedSchema, argInfoList);
        return this._argumentInfoListMap.get(unifiedSchema);
    }

    protected DfProcedureParameterExtractorOracle createProcedureParameterExtractorOracle() {
        return new DfProcedureParameterExtractorOracle(this._dataSource, this._suppressLogging);
    }

    protected UnifiedSchema getMainSchema() {
        return this.getDatabaseProperties().getDatabaseSchema();
    }

    protected List<UnifiedSchema> getAdditionalSchemaList() {
        return this.getDatabaseProperties().getAdditionalSchemaList();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return DfBuildProperties.getInstance().getDatabaseProperties();
    }

    protected void log(String msg) {
        if (this._suppressLogging) {
            return;
        }
        _log.info((Object)msg);
    }

    public void suppressLogging() {
        this._suppressLogging = true;
    }
}

