/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import java.util.Map;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeArrayInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeStructInfo;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureColumnMetaInfo {
    protected String _columnName;
    protected int _jdbcDefType;
    protected String _dbTypeName;
    protected Integer _columnSize;
    protected Integer _decimalDigits;
    protected Integer _overloadNo;
    protected String _columnComment;
    protected DfProcedureColumnType _procedureColumnType;
    protected Map<String, DfColumnMetaInfo> _resultSetColumnInfoMap;
    protected DfTypeArrayInfo _typeArrayInfo;
    protected DfTypeStructInfo _typeStructInfo;
    protected final DfColumnHandler _columnHandler = new DfColumnHandler();

    public boolean hasColumnComment() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this._columnComment);
    }

    public boolean hasResultSetColumnInfo() {
        return this._resultSetColumnInfoMap != null && !this._resultSetColumnInfoMap.isEmpty();
    }

    public boolean hasTypeArrayInfo() {
        return this._typeArrayInfo != null;
    }

    public boolean hasTypeArrayElementJavaNative() {
        return this.hasTypeArrayInfo() && this._typeArrayInfo.hasElementJavaNative();
    }

    public boolean hasTypeStructInfo() {
        return this._typeStructInfo != null;
    }

    public boolean hasTypeStructEntityType() {
        return this.hasTypeStructInfo() && this._typeStructInfo.hasEntityType();
    }

    public String getColumnDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColumnNameDisp());
        sb.append(": ");
        sb.append(this._dbTypeName);
        if (this.hasTypeArrayInfo()) {
            sb.append("(").append(this.getTypeArrayInfo().toString()).append(")");
        }
        sb.append(this.getColumnSizeDisp());
        sb.append(" as ").append(this._procedureColumnType.alias());
        return sb.toString();
    }

    public String getColumnDisplayNameForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColumnNameDisp());
        sb.append(" - ");
        sb.append(this._dbTypeName);
        sb.append(this.getColumnSizeDisp());
        if (this.hasTypeArrayInfo()) {
            sb.append(" <span class=\"attrs\">{");
            sb.append(this.getTypeArrayInfo().toStringForHtml());
            sb.append("}</span>");
        } else if (this.hasTypeStructInfo()) {
            sb.append(" <span class=\"attrs\">{");
            sb.append(this.getTypeStructInfo().toStringAttributeOnlyForHtml());
            sb.append("}</span>");
        }
        sb.append(" <span class=\"type\">(").append(this._procedureColumnType.alias()).append(")</span>");
        return sb.toString();
    }

    public String getColumnNameDisp() {
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._columnName)) {
            return this._columnName;
        }
        if (DfProcedureColumnType.procedureColumnReturn.equals((Object)this._procedureColumnType)) {
            return "(return)";
        }
        return "(arg)";
    }

    public String getColumnSizeDisp() {
        StringBuilder sb = new StringBuilder();
        if (DfColumnHandler.isColumnSizeValid(this._columnSize)) {
            sb.append("(").append(this._columnSize);
            if (DfColumnHandler.isDecimalDigitsValid(this._decimalDigits)) {
                sb.append(", ").append(this._decimalDigits);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getColumnDefinitionLineDisp() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._dbTypeName);
        if (DfColumnHandler.isColumnSizeValid(this._columnSize)) {
            sb.append("(").append(this._columnSize);
            if (DfColumnHandler.isDecimalDigitsValid(this._decimalDigits)) {
                sb.append(", ").append(this._decimalDigits);
            }
            sb.append(")");
        }
        sb.append(" as ").append(this._procedureColumnType.alias());
        return sb.toString();
    }

    public String getColumnCommentForSchemaHtml() {
        DfDocumentProperties prop = DfBuildProperties.getInstance().getDocumentProperties();
        String comment = this._columnComment;
        comment = prop.resolvePreTextForSchemaHtml(comment);
        return comment;
    }

    public boolean isBindParameter() {
        DfProcedureColumnType columnType = this._procedureColumnType;
        return !DfProcedureColumnType.procedureColumnResult.equals((Object)columnType) && !this.isSQLServerTableReturnValue();
    }

    public boolean isInputParameter() {
        DfProcedureColumnType columnType = this._procedureColumnType;
        if (DfProcedureColumnType.procedureColumnReturn.equals((Object)columnType) || DfProcedureColumnType.procedureColumnResult.equals((Object)columnType) || this.isSQLServerTableReturnValue()) {
            return false;
        }
        return DfProcedureColumnType.procedureColumnIn.equals((Object)columnType) || DfProcedureColumnType.procedureColumnInOut.equals((Object)columnType);
    }

    public boolean isConceptTypeStringClob() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isConceptTypeStringClob(dbTypeName);
    }

    public boolean isConceptTypeBytesOid() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isConceptTypeBytesOid(dbTypeName);
    }

    public boolean isConceptTypeFixedLengthString() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isConceptTypeFixedLengthString(dbTypeName);
    }

    public boolean isConceptTypeObjectBindingBigDecimal() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isConceptTypeObjectBindingBigDecimal(dbTypeName);
    }

    public boolean isPostgreSQLUuid() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isPostgreSQLUuid(dbTypeName);
    }

    public boolean isPostgreSQLOid() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isPostgreSQLOid(dbTypeName);
    }

    public boolean isPostgreSQLCursor() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isPostgreSQLCursor(dbTypeName);
    }

    public boolean isOracleNCharOrNVarchar() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isOracleNCharOrNVarchar(dbTypeName);
    }

    public boolean isOracleNumber() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isOracleNumber(dbTypeName);
    }

    public boolean isOracleCursor() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isOracleCursor(dbTypeName);
    }

    public boolean isOracleStruct() {
        return this._typeStructInfo != null;
    }

    public boolean isOracleTreatedAsArray() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isOracleTreatedAsArray(dbTypeName);
    }

    public boolean isSQLServerUniqueIdentifier() {
        String dbTypeName = this.getDbTypeName();
        return this._columnHandler.isSQLServerUniqueIdentifier(dbTypeName);
    }

    public boolean isSQLServerTableReturnValue() {
        if (!this.getBasicProperties().isDatabaseSQLServer()) {
            return false;
        }
        return "@TABLE_RETURN_VALUE".equalsIgnoreCase(this.getColumnName());
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    public String toString() {
        return "{" + this._columnName + ", " + (Object)((Object)this._procedureColumnType) + ", " + this._jdbcDefType + ", " + this._dbTypeName + "(" + this._columnSize + ", " + this._decimalDigits + ")" + this._columnComment + "}";
    }

    public String getColumnName() {
        return this._columnName;
    }

    public void setColumnName(String columnName) {
        this._columnName = columnName;
    }

    public DfProcedureColumnType getProcedureColumnType() {
        return this._procedureColumnType;
    }

    public void setProcedureColumnType(DfProcedureColumnType procedureColumnType) {
        this._procedureColumnType = procedureColumnType;
    }

    public int getJdbcDefType() {
        return this._jdbcDefType;
    }

    public void setJdbcDefType(int jdbcDefType) {
        this._jdbcDefType = jdbcDefType;
    }

    public String getDbTypeName() {
        return this._dbTypeName;
    }

    public void setDbTypeName(String dbTypeName) {
        this._dbTypeName = dbTypeName;
    }

    public Integer getColumnSize() {
        return this._columnSize;
    }

    public void setColumnSize(Integer columnSize) {
        this._columnSize = columnSize;
    }

    public Integer getDecimalDigits() {
        return this._decimalDigits;
    }

    public void setDecimalDigits(Integer decimalDigits) {
        this._decimalDigits = decimalDigits;
    }

    public Integer getOverloadNo() {
        return this._overloadNo;
    }

    public void setOverloadNo(Integer overloadNo) {
        this._overloadNo = overloadNo;
    }

    public String getColumnComment() {
        return this._columnComment;
    }

    public void setColumnComment(String columnComment) {
        this._columnComment = columnComment;
    }

    public Map<String, DfColumnMetaInfo> getResultSetColumnInfoMap() {
        return this._resultSetColumnInfoMap;
    }

    public void setResultSetColumnInfoMap(Map<String, DfColumnMetaInfo> resultSetColumnInfoMap) {
        this._resultSetColumnInfoMap = resultSetColumnInfoMap;
    }

    public DfTypeArrayInfo getTypeArrayInfo() {
        return this._typeArrayInfo;
    }

    public void setTypeArrayInfo(DfTypeArrayInfo typeArrayInfo) {
        this._typeArrayInfo = typeArrayInfo;
    }

    public DfTypeStructInfo getTypeStructInfo() {
        return this._typeStructInfo;
    }

    public void setTypeStructInfo(DfTypeStructInfo typeStructInfo) {
        this._typeStructInfo = typeStructInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DfProcedureColumnType {
        procedureColumnUnknown("Unknown"),
        procedureColumnIn("In"),
        procedureColumnInOut("InOut"),
        procedureColumnOut("Out"),
        procedureColumnReturn("Return"),
        procedureColumnResult("Result");

        private final String _alias;

        private DfProcedureColumnType(String alias) {
            this._alias = alias;
        }

        public String alias() {
            return this._alias;
        }
    }
}

