/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.comment.factory;

import javax.sql.DataSource;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorMySQL;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorSQLServer;
import org.seasar.dbflute.properties.DfBasicProperties;

public class DfDbCommentExtractorFactory {
    protected DfBasicProperties _basicProperties;
    protected DataSource _dataSource;
    protected UnifiedSchema _unifiedSchema;

    public DfDbCommentExtractorFactory(DfBasicProperties basicProperties, DataSource dataSource, UnifiedSchema unifiedSchema) {
        this._basicProperties = basicProperties;
        this._dataSource = dataSource;
        this._unifiedSchema = unifiedSchema;
    }

    public DfDbCommentExtractor createDbCommentExtractor() {
        if (this._basicProperties.isDatabaseMySQL()) {
            DfDbCommentExtractorMySQL extractor = new DfDbCommentExtractorMySQL();
            extractor.setDataSource(this._dataSource);
            extractor.setUnifiedSchema(this._unifiedSchema);
            return extractor;
        }
        if (this._basicProperties.isDatabaseOracle()) {
            DfDbCommentExtractorOracle extractor = new DfDbCommentExtractorOracle();
            extractor.setDataSource(this._dataSource);
            extractor.setUnifiedSchema(this._unifiedSchema);
            return extractor;
        }
        if (this._basicProperties.isDatabaseSQLServer()) {
            DfDbCommentExtractorSQLServer extractor = new DfDbCommentExtractorSQLServer();
            extractor.setDataSource(this._dataSource);
            extractor.setUnifiedSchema(this._unifiedSchema);
            return extractor;
        }
        return null;
    }
}

