/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.generate.deletefile;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.friends.velocity.DfGenerator;
import org.seasar.dbflute.helper.language.properties.DfGeneratedClassPackageDefault;
import org.seasar.dbflute.logic.generate.deletefile.DfOldTableClassDeletor;
import org.seasar.dbflute.logic.generate.packagepath.DfPackagePathHandler;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfOldClassHandler {
    private static final Log _log = LogFactory.getLog(Database.class);
    protected DfGenerator _generator;
    protected DfBasicProperties _basicProperties;
    protected DfLittleAdjustmentProperties _littleAdjustmentProperties;
    protected DfGeneratedClassPackageDefault _generatedClassPackageDefault;
    protected List<Table> _tableList;
    protected Map<String, DfPmbMetaData> _pmbMetaDataMap;
    protected List<String> _deletedOldTableBaseBehaviorList;
    protected List<String> _deletedOldTableBaseDaoList;
    protected List<String> _deletedOldTableBaseEntityList;
    protected List<String> _deletedOldCustomizeBaseEntityList;
    protected List<String> _deletedOldCustomizeBaseCursorList;
    protected List<String> _deletedOldCustomizeBaseCursorHandlerList;
    protected List<String> _deletedOldCustomizeBaseParameterBeanList;

    public DfOldClassHandler(DfGenerator generator, DfBasicProperties basicProperties, DfLittleAdjustmentProperties littleAdjustmentProperties, List<Table> tableList) {
        this._generator = generator;
        this._basicProperties = basicProperties;
        this._littleAdjustmentProperties = littleAdjustmentProperties;
        this._generatedClassPackageDefault = basicProperties.getLanguageDependencyInfo().getGeneratedClassPackageInfo();
        this._tableList = tableList;
    }

    public void deleteOldTableClass() {
        this.info("");
        this.info("// /- - - - - - - - - - - - -");
        this.info("// Delete old table classes!");
        this.info("// - - - - - - - - - -/");
        this.deleteOldTableClass_for_BaseBehavior();
        this.deleteOldTableClass_for_BaseDao();
        this.deleteOldTableClass_for_BaseEntity();
        this.deleteOldTableClass_for_DBMeta();
        this.deleteOldTableClass_for_BaseConditionBean();
        this.deleteOldTableClass_for_AbstractBaseConditionQuery();
        this.deleteOldTableClass_for_BaseConditionQuery();
        this.deleteOldTableClass_for_NestSelectSetupper();
        this.deleteOldTableClass_for_ExtendedConditionBean();
        this.deleteOldTableClass_for_ExtendedConditionQuery();
        this.deleteOldTableClass_for_ExtendedConditionInlineQuery();
        this.deleteOldTableClass_for_ExtendedBehavior();
        this.deleteOldTableClass_for_ExtendedDao();
        this.deleteOldTableClass_for_ExtendedEntity();
        this.info("");
    }

    public void deleteOldTableClass_for_BaseBehavior() {
        String classSuffix;
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                if (DfOldClassHandler.this._basicProperties.isApplicationBehaviorProject()) {
                    return table.getBaseBehaviorApClassName();
                }
                return table.getBaseBehaviorClassName();
            }
        };
        String packagePath = this.getBaseBehaviorPackage();
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        if (this._basicProperties.isApplicationBehaviorProject()) {
            String additionalSuffix = this._basicProperties.getApplicationBehaviorAdditionalSuffix();
            classSuffix = "Bhv" + additionalSuffix;
        } else {
            classSuffix = "Bhv";
        }
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, classSuffix, setupper);
        this._deletedOldTableBaseBehaviorList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldTableBaseBehaviorList);
    }

    protected String getBaseBehaviorPackage() {
        return this._basicProperties.getBaseBehaviorPackage();
    }

    public void deleteOldTableClass_for_BaseDao() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseDaoClassName();
            }
        };
        String packagePath = this.getBaseDaoPackage();
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "Dao", setupper);
        this._deletedOldTableBaseDaoList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldTableBaseDaoList);
    }

    protected String getBaseDaoPackage() {
        return this._basicProperties.getBaseDaoPackage();
    }

    public void deleteOldTableClass_for_BaseEntity() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseEntityClassName();
            }
        };
        String packagePath = this.getBaseEntityPackage();
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, null, setupper);
        this._deletedOldTableBaseEntityList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldTableBaseEntityList);
    }

    protected String getBaseEntityPackage() {
        return this._basicProperties.getBaseEntityPackage();
    }

    public void deleteOldTableClass_for_DBMeta() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getDBMetaClassName();
            }
        };
        String packagePath = this.getDBMetaPackage();
        String classPrefix = this.getProjectPrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "Dbm", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    protected String getDBMetaPackage() {
        return this._basicProperties.getDBMetaPackage();
    }

    public void deleteOldTableClass_for_BaseConditionBean() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseConditionBeanClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage() + ".bs";
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "CB", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    protected String getConditionBeanPackage() {
        return this._basicProperties.getConditionBeanPackage();
    }

    public void deleteOldTableClass_for_AbstractBaseConditionQuery() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getAbstractBaseConditionQueryClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage() + ".cq.bs";
        String classPrefix = this.getProjectPrefix() + "Abstract" + this.getBasePrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "CQ", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldTableClass_for_BaseConditionQuery() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseConditionQueryClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage() + ".cq.bs";
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "CQ", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldTableClass_for_NestSelectSetupper() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getNestSelectSetupperClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage() + ".nss";
        String classPrefix = this.getProjectPrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "Nss", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldTableClass_for_ExtendedConditionBean() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getExtendedConditionBeanClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage();
        String classPrefix = this.getProjectPrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "CB", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldTableClass_for_ExtendedConditionQuery() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getExtendedConditionQueryClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage() + ".cq";
        String classPrefix = this.getProjectPrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "CQ", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldTableClass_for_ExtendedConditionInlineQuery() {
        NotDeleteTCNSetupper setupper = new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getExtendedConditionInlineQueryClassName();
            }
        };
        String packagePath = this.getConditionBeanPackage() + ".cq.ciq";
        String classPrefix = this.getProjectPrefix();
        DfOldTableClassDeletor deletor = this.createTCD(packagePath, classPrefix, "CIQ", setupper);
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldTableClass_for_ExtendedBehavior() {
        if (this._deletedOldTableBaseBehaviorList == null || this._deletedOldTableBaseBehaviorList.isEmpty()) {
            return;
        }
        String outputPath = this._generator.getOutputPath();
        String packagePath = this.getExtendedBehaviorPackage();
        DfPackagePathHandler packagePathHandler = this.createPackagePathHandler();
        String dirPath = outputPath + "/" + packagePathHandler.getPackageAsPath(packagePath);
        for (String baseClassName : this._deletedOldTableBaseBehaviorList) {
            int prefixLength = this.getProjectPrefix().length() + this.getBasePrefix().length();
            String extendedClassName = this.getProjectPrefix() + baseClassName.substring(prefixLength);
            File file = new File(dirPath + "/" + extendedClassName + "." + this.getClassFileExtension());
            if (!file.exists()) continue;
            file.delete();
            _log.info((Object)("deleteOldTableClass('" + extendedClassName + "');"));
        }
    }

    protected String getExtendedBehaviorPackage() {
        return this._basicProperties.getExtendedBehaviorPackage();
    }

    public void deleteOldTableClass_for_ExtendedDao() {
        if (this._deletedOldTableBaseDaoList == null || this._deletedOldTableBaseDaoList.isEmpty()) {
            return;
        }
        String outputPath = this._generator.getOutputPath();
        String packagePath = this.getExtendedDaoPackage();
        DfPackagePathHandler packagePathHandler = this.createPackagePathHandler();
        String dirPath = outputPath + "/" + packagePathHandler.getPackageAsPath(packagePath);
        for (String baseClassName : this._deletedOldTableBaseDaoList) {
            int prefixLength = this.getProjectPrefix().length() + this.getBasePrefix().length();
            String extendedClassName = this.getProjectPrefix() + baseClassName.substring(prefixLength);
            File file = new File(dirPath + "/" + extendedClassName + "." + this.getClassFileExtension());
            if (!file.exists()) continue;
            file.delete();
            this.info("deleteOldTableClass('" + extendedClassName + "');");
        }
    }

    protected String getExtendedDaoPackage() {
        return this._basicProperties.getExtendedDaoPackage();
    }

    public void deleteOldTableClass_for_ExtendedEntity() {
        if (this._deletedOldTableBaseEntityList == null || this._deletedOldTableBaseEntityList.isEmpty()) {
            return;
        }
        String outputPath = this._generator.getOutputPath();
        String packagePath = this.getExtendedEntityPackage();
        DfPackagePathHandler packagePathHandler = this.createPackagePathHandler();
        String dirPath = outputPath + "/" + packagePathHandler.getPackageAsPath(packagePath);
        for (String baseClassName : this._deletedOldTableBaseEntityList) {
            int prefixLength = this.getProjectPrefix().length() + this.getBasePrefix().length();
            String extendedClassName = this.getProjectPrefix() + baseClassName.substring(prefixLength);
            File file = new File(dirPath + "/" + extendedClassName + "." + this.getClassFileExtension());
            if (!file.exists()) continue;
            file.delete();
            this.info("deleteOldTableClass('" + extendedClassName + "');");
        }
    }

    protected String getExtendedEntityPackage() {
        return this._basicProperties.getExtendedEntityPackage();
    }

    protected void showDeleteOldTableFile(List<String> deletedClassNameList) {
        for (String className : deletedClassNameList) {
            this.info("deleteOldTableClass('" + className + "');");
        }
    }

    protected DfOldTableClassDeletor createTCD(String packagePath, String classPrefix, String classSuffix, NotDeleteTCNSetupper setupper) {
        DfOldTableClassDeletor deletor = new DfOldTableClassDeletor(this._generator, this.createPackagePathHandler());
        deletor.addPackagePath(packagePath);
        deletor.setClassPrefix(classPrefix);
        deletor.setClassSuffix(classSuffix);
        deletor.setClassExtension(this.getClassFileExtension());
        deletor.setNotDeleteClassNameSet(this.createNotDeleteTCNSet(setupper));
        return deletor;
    }

    protected Set<String> createNotDeleteTCNSet(NotDeleteTCNSetupper setupper) {
        HashSet<String> notDeleteClassNameSet = new HashSet<String>();
        List<Table> tableList = this.getTableList();
        for (Table table : tableList) {
            notDeleteClassNameSet.add(setupper.setup(table));
        }
        return notDeleteClassNameSet;
    }

    public void deleteOldCustomizeClass() {
        this.info("");
        this.info("// /- - - - - - - - - - - - - - -");
        this.info("// Delete old customize classes!");
        this.info("// - - - - - - - - - -/");
        this.deleteOldCustomizeClass_for_BaseCustomizeEntity();
        this.deleteOldCustomizeClass_for_DBMeta();
        this.deleteOldCustomizeClass_for_BaseCursor();
        this.deleteOldCustomizeClass_for_BaseCursorHandler();
        this.deleteOldCustomizeClass_for_BaseParameterBean();
        this.deleteOldCustomizeClass_for_ExtendedCustomizeEntity();
        this.deleteOldCustomizeClass_for_ExtendedCursor();
        this.deleteOldCustomizeClass_for_ExtendedCursorHandler();
        this.deleteOldCustomizeClass_for_ExtendedParameterBean();
        this.info("");
    }

    public void deleteOldCustomizeClass_for_BaseCustomizeEntity() {
        String customizePackageName = this._generatedClassPackageDefault.getCustomizeEntitySimplePackageName();
        String packagePath = this.getBaseEntityPackage() + "." + customizePackageName;
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        DfOldTableClassDeletor deletor = this.createCCD(packagePath, classPrefix, null, new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseEntityClassName();
            }
        });
        this._deletedOldCustomizeBaseEntityList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldCustomizeBaseEntityList);
    }

    public void deleteOldCustomizeClass_for_DBMeta() {
        String customizePackageName = this._generatedClassPackageDefault.getCustomizeEntitySimplePackageName();
        String dbmetaSimplePackageName = this._generatedClassPackageDefault.getDBMetaSimplePackageName();
        String packagePath = this.getBaseEntityPackage() + "." + customizePackageName + "." + dbmetaSimplePackageName;
        String classPrefix = this.getProjectPrefix();
        DfOldTableClassDeletor deletor = this.createCCD(packagePath, classPrefix, "Dbm", new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getDBMetaClassName();
            }
        });
        this.showDeleteOldTableFile(deletor.deleteOldTableClass());
    }

    public void deleteOldCustomizeClass_for_BaseCursor() {
        String cursorPackageName = this._generatedClassPackageDefault.getCursorSimplePackageName();
        String packagePath = this.getBaseBehaviorPackage() + "." + cursorPackageName;
        String oldStylePackagePath = this.getBaseDaoPackage() + "." + cursorPackageName;
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        String classSuffix = "Cursor";
        DfOldTableClassDeletor deletor = this.createCCD(packagePath, classPrefix, "Cursor", new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseEntityClassName() + "Cursor";
            }
        });
        deletor.addPackagePath(oldStylePackagePath);
        this._deletedOldCustomizeBaseCursorList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldCustomizeBaseCursorList);
    }

    public void deleteOldCustomizeClass_for_BaseCursorHandler() {
        String cursorPackageName = this._generatedClassPackageDefault.getCursorSimplePackageName();
        String packagePath = this.getBaseBehaviorPackage() + "." + cursorPackageName;
        String oldStylePackagePath = this.getBaseDaoPackage() + "." + cursorPackageName;
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        String classSuffix = "CursorHandler";
        DfOldTableClassDeletor deletor = this.createCCD(packagePath, classPrefix, "CursorHandler", new NotDeleteTCNSetupper(){

            public String setup(Table table) {
                return table.getBaseEntityClassName() + "CursorHandler";
            }
        });
        deletor.addPackagePath(oldStylePackagePath);
        this._deletedOldCustomizeBaseCursorHandlerList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldCustomizeBaseCursorHandlerList);
    }

    public void deleteOldCustomizeClass_for_BaseParameterBean() {
        String parameterBeanPackageName = this._generatedClassPackageDefault.getParameterBeanSimplePackageName();
        String packagePath = this.getBaseBehaviorPackage() + "." + parameterBeanPackageName;
        String oldStylePackagePath = this.getBaseDaoPackage() + "." + parameterBeanPackageName;
        String classPrefix = this.getProjectPrefix() + this.getBasePrefix();
        HashSet<String> notDeleteClassNameSet = new HashSet<String>();
        Map<String, DfPmbMetaData> pmbMetaDataMap = this.getPmbMetaDataMap();
        if (pmbMetaDataMap != null && !pmbMetaDataMap.isEmpty()) {
            Set<String> pmbNameSet = pmbMetaDataMap.keySet();
            for (String pmbName : pmbNameSet) {
                notDeleteClassNameSet.add(this.getProjectPrefix() + this.getBasePrefix() + pmbName);
            }
        }
        DfOldTableClassDeletor deletor = this.createCCD(packagePath, classPrefix, null, notDeleteClassNameSet);
        deletor.addPackagePath(oldStylePackagePath);
        this._deletedOldCustomizeBaseParameterBeanList = deletor.deleteOldTableClass();
        this.showDeleteOldTableFile(this._deletedOldCustomizeBaseParameterBeanList);
    }

    public void deleteOldCustomizeClass_for_ExtendedCustomizeEntity() {
        if (this._deletedOldCustomizeBaseEntityList == null || this._deletedOldCustomizeBaseEntityList.isEmpty()) {
            return;
        }
        String customizePackageName = this._generatedClassPackageDefault.getCustomizeEntitySimplePackageName();
        String packagePath = this.getExtendedEntityPackage() + "." + customizePackageName;
        this.deleteCustomizeExtendedClass(this._deletedOldCustomizeBaseEntityList, packagePath);
    }

    public void deleteOldCustomizeClass_for_ExtendedCursor() {
        if (this._deletedOldCustomizeBaseCursorList == null || this._deletedOldCustomizeBaseCursorList.isEmpty()) {
            return;
        }
        String cursorPackageName = this._generatedClassPackageDefault.getCursorSimplePackageName();
        String packagePath = this.getExtendedBehaviorPackage() + "." + cursorPackageName;
        String oldStylePackagePath = this.getExtendedDaoPackage() + "." + cursorPackageName;
        this.deleteCustomizeExtendedClass(this._deletedOldCustomizeBaseCursorList, packagePath, oldStylePackagePath);
    }

    public void deleteOldCustomizeClass_for_ExtendedCursorHandler() {
        if (this._deletedOldCustomizeBaseCursorHandlerList == null || this._deletedOldCustomizeBaseCursorHandlerList.isEmpty()) {
            return;
        }
        String cursorPackageName = this._generatedClassPackageDefault.getCursorSimplePackageName();
        String packagePath = this.getExtendedBehaviorPackage() + "." + cursorPackageName;
        String oldStylePackagePath = this.getExtendedDaoPackage() + "." + cursorPackageName;
        this.deleteCustomizeExtendedClass(this._deletedOldCustomizeBaseCursorHandlerList, packagePath, oldStylePackagePath);
    }

    public void deleteOldCustomizeClass_for_ExtendedParameterBean() {
        if (this._deletedOldCustomizeBaseParameterBeanList == null || this._deletedOldCustomizeBaseParameterBeanList.isEmpty()) {
            return;
        }
        String parameterBeanPackageName = this._generatedClassPackageDefault.getParameterBeanSimplePackageName();
        String packagePath = this.getExtendedBehaviorPackage() + "." + parameterBeanPackageName;
        String oldStylePackagePath = this.getExtendedDaoPackage() + "." + parameterBeanPackageName;
        this.deleteCustomizeExtendedClass(this._deletedOldCustomizeBaseParameterBeanList, packagePath, oldStylePackagePath);
    }

    protected DfOldTableClassDeletor createCCD(String packagePath, String classPrefix, String classSuffix, NotDeleteTCNSetupper setupper) {
        return this.createCCD(packagePath, classPrefix, classSuffix, this.createNotDeleteTCNSet(setupper));
    }

    protected DfOldTableClassDeletor createCCD(String packagePath, String classPrefix, String classSuffix, Set<String> notDeleteClassNameSet) {
        DfPackagePathHandler packagePathHandler = new DfPackagePathHandler(this._basicProperties);
        DfOldTableClassDeletor deletor = new DfOldTableClassDeletor(this._generator, packagePathHandler);
        deletor.addPackagePath(packagePath);
        deletor.setClassPrefix(classPrefix);
        deletor.setClassSuffix(classSuffix);
        deletor.setClassExtension(this.getClassFileExtension());
        deletor.setNotDeleteClassNameSet(notDeleteClassNameSet);
        return deletor;
    }

    protected void deleteCustomizeExtendedClass(List<String> baseClassList, String ... packagePathList) {
        String outputPath = this._generator.getOutputPath();
        DfPackagePathHandler packagePathHandler = this.createPackagePathHandler();
        for (String packagePath : packagePathList) {
            String dirPath = outputPath + "/" + packagePathHandler.getPackageAsPath(packagePath);
            for (String baseClassName : baseClassList) {
                int prefixLength = this.getProjectPrefix().length() + this.getBasePrefix().length();
                String extendedClassName = this.getProjectPrefix() + baseClassName.substring(prefixLength);
                File file = new File(dirPath + "/" + extendedClassName + "." + this.getClassFileExtension());
                if (!file.exists()) continue;
                file.delete();
                _log.info((Object)("deleteOldCustoimzeClass('" + extendedClassName + "');"));
            }
        }
    }

    protected DfPackagePathHandler createPackagePathHandler() {
        return new DfPackagePathHandler(this._basicProperties);
    }

    protected String getProjectPrefix() {
        return this._basicProperties.getProjectPrefix();
    }

    protected String getBasePrefix() {
        return this._basicProperties.getBasePrefix();
    }

    protected String getClassFileExtension() {
        return this._basicProperties.getClassFileExtension();
    }

    protected List<Table> getTableList() {
        return this._tableList;
    }

    public void info(String msg) {
        _log.info((Object)msg);
    }

    public void debug(String msg) {
        _log.debug((Object)msg);
    }

    public Map<String, DfPmbMetaData> getPmbMetaDataMap() {
        return this._pmbMetaDataMap;
    }

    public void setPmbMetaDataMap(Map<String, DfPmbMetaData> pmbMetaDataMap) {
        this._pmbMetaDataMap = pmbMetaDataMap;
    }

    protected static interface NotDeleteTCNSetupper {
        public String setup(Table var1);
    }
}

