/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfFixedConditionInvalidClassificationEmbeddedCommentException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.generate.column.DfColumnListToStringUtil;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPropertyTypePackageResolver;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfClassificationProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.properties.DfMultipleFKPropertyProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKey {
    protected String _name;
    protected Table _localTable;
    protected String _foreignTableName;
    protected String _fixedCondition;
    protected String _fixedSuffix;
    protected String _comment;
    protected boolean _additionalForeignKey;
    protected String _foreignPropertyNamePrefix;
    protected final List<String> _localColumns = new ArrayList<String>(3);
    protected final List<String> _foreignColumns = new ArrayList<String>(3);
    protected final Map<String, String> _localForeignMap = StringKeyMap.createAsFlexibleOrdered();
    protected final Map<String, String> _foreignLocalMap = StringKeyMap.createAsFlexibleOrdered();
    protected final Map<String, String> _dynamicFixedConditionMap = DfCollectionUtil.newLinkedHashMap();

    public void loadFromXML(Attributes attrib) {
        this._foreignTableName = attrib.getValue("foreignTable");
        this._name = attrib.getValue("name");
    }

    public void setForeignPropertyNamePrefix(String propertyNamePrefix) {
        this._foreignPropertyNamePrefix = propertyNamePrefix;
    }

    public void addReference(Attributes attrib) {
        String localColumn = attrib.getValue("local");
        String foreignColumn = attrib.getValue("foreign");
        this.addReference(localColumn, foreignColumn);
    }

    public void addReference(String local, String foreign) {
        this._localColumns.add(local);
        this._foreignColumns.add(foreign);
        this._localForeignMap.put(local, foreign);
        this._foreignLocalMap.put(foreign, local);
    }

    public void addReference(List<String> localColumnNameList, List<String> foreignColumnNameList) {
        this._localColumns.addAll(localColumnNameList);
        this._foreignColumns.addAll(foreignColumnNameList);
        for (int i = 0; i < localColumnNameList.size(); ++i) {
            this._localForeignMap.put(localColumnNameList.get(i), foreignColumnNameList.get(i));
            this._foreignLocalMap.put(foreignColumnNameList.get(i), localColumnNameList.get(i));
        }
    }

    public String getForeignTableExtendedEntityClassName() {
        return this.getForeignTable().getExtendedEntityClassName();
    }

    public String getForeignTableDBMetaClassName() {
        return this.getForeignTable().getDBMetaClassName();
    }

    public String getForeignTableExtendedConditionBeanClassName() {
        return this.getForeignTable().getExtendedConditionBeanClassName();
    }

    public String getForeignTableExtendedConditionQueryClassName() {
        return this.getForeignTable().getExtendedConditionQueryClassName();
    }

    public String getForeignTableNestSelectSetupperClassName() {
        return this.getForeignTable().getNestSelectSetupperClassName();
    }

    public String getForeignTableNestSelectSetupperTerminalClassName() {
        return this.getForeignTable().getNestSelectSetupperTerminalClassName();
    }

    public String getReferrerTableExtendedEntityClassName() {
        return this.getTable().getExtendedEntityClassName();
    }

    public String getReferrerTableExtendedBehaviorClassName() {
        return this.getTable().getExtendedBehaviorClassName();
    }

    public String getReferrerTableDBMetaClassName() {
        return this.getTable().getDBMetaClassName();
    }

    public String getReferrerTableExtendedConditionBeanClassName() {
        return this.getTable().getExtendedConditionBeanClassName();
    }

    public String getReferrerTableExtendedConditionQueryClassName() {
        return this.getTable().getExtendedConditionQueryClassName();
    }

    public String getReferrerTableNestSelectSetupperClassName() {
        return this.getTable().getNestSelectSetupperClassName();
    }

    public String getReferrerTableNestSelectSetupperTerminalClassName() {
        return this.getTable().getNestSelectSetupperTerminalClassName();
    }

    public boolean isOneToOne() {
        List<Column> localPrimaryColumnList;
        List<Column> localColumnList = this.getLocalColumnObjectList();
        if (((Object)localColumnList).equals(localPrimaryColumnList = this.getTable().getPrimaryKey())) {
            return true;
        }
        List<Unique> uniqueList = this.getTable().getUniqueList();
        for (Unique unique : uniqueList) {
            if (!unique.hasSameColumnSet(localColumnList)) continue;
            return true;
        }
        return false;
    }

    public boolean isBizOneToOne() {
        return this.isOneToOne() && this.hasFixedCondition();
    }

    public boolean isSimpleKeyFK() {
        return this._localColumns.size() == 1;
    }

    public boolean isTwoOrMoreKeyFK() {
        return this._localColumns.size() > 1;
    }

    public boolean isSelfReference() {
        return this._localTable.getName().equals(this._foreignTableName);
    }

    public boolean canBeReferrer() {
        if (this.hasFixedCondition()) {
            return false;
        }
        return this.isForeignColumnPrimaryKey() || this.isForeignColumnUnique();
    }

    public boolean isLocalColumnPrimaryKey() {
        return this.isColumnPrimaryKey(this.getLocalColumnList());
    }

    public boolean isForeignColumnPrimaryKey() {
        return this.isColumnPrimaryKey(this.getForeignColumnList());
    }

    public boolean isForeignColumnUnique() {
        return this.isColumnUnique(this.getForeignColumnList());
    }

    protected boolean isColumnPrimaryKey(List<Column> columnList) {
        for (Column column : columnList) {
            if (column.isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    protected boolean isColumnUnique(List<Column> columnList) {
        for (Column column : columnList) {
            if (column.isUnique()) continue;
            return false;
        }
        return true;
    }

    public Table getForeignTable() {
        Table foreignTable = this.getTable().getDatabase().getTable(this.getForeignTableName());
        if (foreignTable == null) {
            String msg = "The database does not contain the foreign table name: " + this.getForeignTableName();
            throw new IllegalStateException(msg);
        }
        return foreignTable;
    }

    public List<String> getLocalColumns() {
        return this._localColumns;
    }

    public List<Column> getLocalColumnList() {
        return this.getLocalColumnObjectList();
    }

    public Column getLocalColumnAsOne() {
        return this.getTable().getColumn(this.getLocalColumnNameAsOne());
    }

    public String getLocalColumnNameAsOne() {
        if (this.getLocalColumns().size() != 1) {
            String msg = "This method is for only-one foreign-key:";
            msg = msg + " getForeignColumns().size()=" + this.getLocalColumns().size();
            msg = msg + " baseTable=" + this.getTable().getName() + " foreignTable=" + this.getForeignTable().getName();
            throw new IllegalStateException(msg);
        }
        return this.getLocalColumns().get(0);
    }

    public String getLocalColumnJavaNameAsOne() {
        return this.getLocalColumnAsOne().getJavaName();
    }

    public List<String> getLocalColumnJavaNameList() {
        ArrayList<String> resultList = new ArrayList<String>();
        List<Column> localColumnList = this.getLocalColumnList();
        for (Column column : localColumnList) {
            resultList.add(column.getJavaName());
        }
        return resultList;
    }

    public List<Column> getLocalColumnObjectList() {
        List<String> columnList = this.getLocalColumns();
        if (columnList == null || columnList.isEmpty()) {
            String msg = "The localColumnList is null or empty." + columnList;
            throw new IllegalStateException(msg);
        }
        ArrayList<Column> resultList = new ArrayList<Column>();
        for (String name : columnList) {
            Column col = this.getTable().getColumn(name);
            if (col == null) {
                String msg = "The columnName is not existing at the table: ";
                msg = msg + "columnName=" + name + " tableName=" + this.getTable().getName();
                throw new IllegalStateException(msg);
            }
            resultList.add(col);
        }
        return resultList;
    }

    public Column getLocalColumnByForeignColumn(Column foreignColumn) {
        String localColumnName = this.getForeignLocalMapping().get(foreignColumn.getName());
        return this.getTable().getColumn(localColumnName);
    }

    public boolean hasLocalColumnExceptPrimaryKey() {
        List<Column> localColumnList = this.getLocalColumnList();
        for (Column column : localColumnList) {
            if (column.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public List<Column> getForeignColumnList() {
        return this.getForeignColumnObjectList();
    }

    public List<String> getForeignColumnNameList() {
        return this._foreignColumns;
    }

    public List<String> getForeignColumns() {
        return this._foreignColumns;
    }

    public Column getForeignColumnAsOne() {
        return this.getForeignTable().getColumn(this.getForeignColumnNameAsOne());
    }

    public String getForeignColumnNameAsOne() {
        if (this.getForeignColumns().size() != 1) {
            String msg = "This method is for only-one foreign-key:";
            msg = msg + " getForeignColumns().size()=" + this.getForeignColumns().size();
            msg = msg + " baseTable=" + this.getTable().getName();
            msg = msg + " foreignTable=" + this.getForeignTable().getName();
            throw new IllegalStateException(msg);
        }
        return this.getForeignColumns().get(0);
    }

    public String getForeignColumnJavaNameAsOne() {
        String columnName = this.getForeignColumnNameAsOne();
        Table foreignTable = this.getForeignTable();
        return foreignTable.getColumn(columnName).getJavaName();
    }

    public List<Column> getForeignColumnObjectList() {
        Table foreignTable = this.getTable().getDatabase().getTable(this.getForeignTableName());
        List<String> columnList = this.getForeignColumns();
        if (columnList == null || columnList.isEmpty()) {
            String msg = "The getForeignColumns() is null or empty." + columnList;
            throw new IllegalStateException(msg);
        }
        ArrayList<Column> resultList = new ArrayList<Column>();
        for (String name : columnList) {
            Column foreignCol = foreignTable.getColumn(name);
            resultList.add(foreignCol);
        }
        return resultList;
    }

    public Column getForeignColumnByLocalColumn(Column localColumn) {
        String foreignColumnName = this.getLocalForeignMapping().get(localColumn.getName());
        return this.getForeignTable().getColumn(foreignColumnName);
    }

    public Map<String, String> getLocalForeignMapping() {
        return this._localForeignMap;
    }

    public Map<String, String> getForeignLocalMapping() {
        return this._foreignLocalMap;
    }

    public String getLocalColumnNames() {
        return Column.makeList(this.getLocalColumns());
    }

    public String getForeignColumnNames() {
        return Column.makeList(this.getForeignColumns());
    }

    public String getFirstLocalColumnName() {
        return this.getLocalColumns().get(0);
    }

    public String getFirstForeignColumnName() {
        return this.getForeignColumns().get(0);
    }

    public String getForeignPropertyName() {
        return this.getForeignPropertyName(false);
    }

    public String getForeignJavaBeansRulePropertyName() {
        return this.getForeignPropertyName(true);
    }

    public String getForeignJavaBeansRulePropertyNameInitCap() {
        return this.initCap(this.getForeignPropertyName(true));
    }

    protected String getForeignPropertyName(boolean isJavaBeansRule) {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String name = "";
        if (this.hasFixedSuffix()) {
            name = this.getFixedSuffix();
        } else {
            ArrayList<String> multipleFKColumnNameList = new ArrayList<String>();
            for (Column col : localColumnList) {
                if (!col.isMultipleFK()) continue;
                multipleFKColumnNameList.add(col.getName());
                name = name + col.getJavaName();
            }
            if (name.trim().length() > 0) {
                String aliasName = this.getMultipleFKPropertyColumnAliasName(this.getTable().getName(), multipleFKColumnNameList);
                if (aliasName != null && aliasName.trim().length() > 0) {
                    String firstUpper = aliasName.substring(0, 1).toUpperCase();
                    name = aliasName.trim().length() == 1 ? "By" + firstUpper : "By" + firstUpper + aliasName.substring(1, aliasName.length());
                } else {
                    name = "By" + name;
                }
            }
        }
        if (this.getForeignTable().getName().equals(this.getTable().getName())) {
            name = name + "Self";
        }
        name = isJavaBeansRule ? this.getForeignTable().getJavaBeansRulePropertyName() + name : this.getForeignTable().getUncapitalisedJavaName() + name;
        if (this._foreignPropertyNamePrefix != null) {
            name = this._foreignPropertyNamePrefix + name;
        }
        return name;
    }

    protected String getMultipleFKPropertyColumnAliasName(String tableName, List<String> multipleFKColumnNameList) {
        DfMultipleFKPropertyProperties prop = DfBuildProperties.getInstance().getMultipleFKPropertyProperties();
        String columnAliasName = prop.getMultipleFKPropertyColumnAliasName(this.getTable().getName(), multipleFKColumnNameList);
        return columnAliasName;
    }

    public String getReferrerPropertyName() {
        return this.getReferrerPropertyName(false);
    }

    public String getReferrerJavaBeansRulePropertyName() {
        return this.getReferrerPropertyName(true);
    }

    public String getReferrerJavaBeansRulePropertyNameInitCap() {
        String referrerPropertyName = this.getReferrerPropertyName(true);
        return this.initCap(referrerPropertyName);
    }

    public String getReferrerPropertyName(boolean isJavaBeansRule) {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        ArrayList<String> columnNameList = new ArrayList<String>();
        String result = "";
        if (this.hasFixedSuffix()) {
            result = this.getFixedSuffix();
        } else {
            for (Column col : localColumnList) {
                if (!col.isMultipleFK()) continue;
                columnNameList.add(col.getName());
                result = result + col.getJavaName();
            }
            if (result.trim().length() != 0) {
                String aliasName = this.getMultipleFKPropertyColumnAliasName(this.getForeignTable().getName(), columnNameList);
                if (aliasName != null && aliasName.trim().length() != 0) {
                    String firstUpper = aliasName.substring(0, 1).toUpperCase();
                    result = aliasName.trim().length() == 1 ? "By" + firstUpper : "By" + firstUpper + aliasName.substring(1, aliasName.length());
                } else {
                    result = "By" + result;
                }
            }
        }
        if (this.getTable().getName().equals(this.getForeignTable().getName())) {
            result = result + "Self";
        }
        if (isJavaBeansRule) {
            return this.getTable().getJavaBeansRulePropertyName() + result + "List";
        }
        return this.getTable().getUncapitalisedJavaName() + result + "List";
    }

    public String getReferrerPropertyNameAsOne() {
        return this.getReferrerPropertyNameAsOne(false);
    }

    public String getReferrerPropertyNameAsOneInitCap() {
        return this.initCap(this.getReferrerPropertyNameAsOne());
    }

    public String getReferrerPropertyNameInitCapAsOne() {
        return this.getReferrerPropertyNameAsOneInitCap();
    }

    public String getReferrerJavaBeansRulePropertyNameAsOne() {
        return this.getReferrerPropertyNameAsOne(true);
    }

    public String getReferrerJavaBeansRulePropertyNameAsOneInitCap() {
        return this.initCap(this.getReferrerPropertyNameAsOne(true));
    }

    protected String getReferrerPropertyNameAsOne(boolean isJavaBeansRule) {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String result = "";
        for (Column col : localColumnList) {
            if (!col.isMultipleFK()) continue;
            result = result + col.getJavaName();
        }
        if (result.trim().length() != 0) {
            result = "By" + result;
        }
        if (this.getTable().getName().equals(this.getForeignTable().getName())) {
            result = result + "Self";
        }
        if (isJavaBeansRule) {
            return this.getTable().getJavaBeansRulePropertyName() + result + "AsOne";
        }
        return this.getTable().getUncapitalisedJavaName() + result + "AsOne";
    }

    public String getForeignPropertyNameInitCap() {
        String foreignPropertyName = this.getForeignPropertyName();
        return foreignPropertyName.substring(0, 1).toUpperCase() + foreignPropertyName.substring(1);
    }

    public String getReferrerPropertyNameInitCap() {
        String referrerPropertyName = this.getReferrerPropertyName();
        return referrerPropertyName.substring(0, 1).toUpperCase() + referrerPropertyName.substring(1);
    }

    public String getReferrerPropertyNameAsOneS2Jdbc() {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String result = "";
        for (Column col : localColumnList) {
            if (!col.isMultipleFK()) continue;
            result = result + col.getJavaName();
        }
        if (result.trim().length() != 0) {
            result = "By" + result;
        }
        if (this.getTable().getName().equals(this.getForeignTable().getName())) {
            result = result + "Self";
        }
        return this.getTable().getUncapitalisedJavaName() + result;
    }

    public String getLocalColumnNameCommaString() {
        return DfColumnListToStringUtil.getColumnNameCommaString(this.getLocalColumnList());
    }

    public String getLocalColumnGetterCommaString() {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String result = "";
        for (Column col : localColumnList) {
            String getterString = "get" + col.getJavaName() + "()";
            if ("".equals(result)) {
                result = getterString;
                continue;
            }
            result = result + ", " + getterString;
        }
        return result;
    }

    public String getForeignTableBeanSetupString(String setterSuffix) {
        return this.getForeignTableBeanSetupString(setterSuffix, "set");
    }

    public String getForeignTableBeanSetupString(String setterSuffix, String setterPrefix) {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String result = "";
        for (Column localCol : localColumnList) {
            Column foreignCol = this.getForeignColumnByLocalColumn(localCol);
            String setterName = setterPrefix + foreignCol.getJavaName() + setterSuffix;
            String getterName = "(_" + localCol.getUncapitalisedJavaName() + ")";
            if ("".equals(result)) {
                result = setterName + getterName;
                continue;
            }
            result = result + "." + setterName + getterName;
        }
        return result;
    }

    public String getChildrenTableBeanSetupString(String setterSuffix) {
        return this.getChildrenTableBeanSetupString(setterSuffix, "set");
    }

    public String getChildrenTableBeanSetupString(String setterSuffix, String setterPrefix) {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String result = "";
        for (Column localCol : localColumnList) {
            Column foreignCol = this.getForeignColumnByLocalColumn(localCol);
            String setterName = setterPrefix + localCol.getJavaName() + setterSuffix;
            String getterName = "(_" + foreignCol.getUncapitalisedJavaName() + ")";
            if ("".equals(result)) {
                result = setterName + getterName;
                continue;
            }
            result = result + "." + setterName + getterName;
        }
        return result;
    }

    public String getRelationKeysCommaString() {
        List<Column> localColumnList = this.getLocalColumnObjectList();
        String result = "";
        for (Column localCol : localColumnList) {
            Column foreignCol = this.getForeignColumnByLocalColumn(localCol);
            String localName = localCol.getName();
            String foreignName = foreignCol.getName();
            if ("".equals(result)) {
                result = localName + ":" + foreignName;
                continue;
            }
            result = result + ", " + localName + ":" + foreignName;
        }
        return result;
    }

    public String getRelationKeysCommaStringForOneToOneReferrer() {
        List<Column> foreignColumnList = this.getForeignColumnObjectList();
        String result = "";
        for (Column foreignCol : foreignColumnList) {
            Column localCol = this.getLocalColumnByForeignColumn(foreignCol);
            String foreignName = foreignCol.getName();
            String localName = localCol.getName();
            if ("".equals(result)) {
                result = foreignName + ":" + localName;
                continue;
            }
            result = result + ", " + foreignName + ":" + localName;
        }
        return result;
    }

    public String getChildKeysCommaString() {
        List<Column> foreignColumnList = this.getForeignColumnObjectList();
        String result = "";
        for (Column foreignCol : foreignColumnList) {
            Column localCol = this.getLocalColumnByForeignColumn(foreignCol);
            String foreignName = foreignCol.getName();
            String localName = localCol.getName();
            if ("".equals(result)) {
                result = foreignName + ":" + localName;
                continue;
            }
            result = result + ", " + foreignName + ":" + localName;
        }
        return result;
    }

    public boolean hasFixedCondition() {
        return this._fixedCondition != null && this._fixedCondition.trim().length() > 0;
    }

    public boolean hasFixedSuffix() {
        return this._fixedSuffix != null && this._fixedSuffix.trim().length() > 0;
    }

    public boolean hasDynamicFixedCondition() {
        this.analyzeDynamicFixedConditionIfNeeds();
        return this.hasFixedCondition() && !this._dynamicFixedConditionMap.isEmpty();
    }

    protected void analyzeDynamicFixedConditionIfNeeds() {
        int startIndex;
        int endIndex;
        if (!this._dynamicFixedConditionMap.isEmpty()) {
            return;
        }
        if (!(this.hasFixedCondition() && this._fixedCondition.contains("/*") && this._fixedCondition.contains("*/"))) {
            return;
        }
        LinkedHashMap<String, String> fixedConditionReplacementMap = new LinkedHashMap<String, String>();
        for (String currentString = this._fixedCondition; currentString != null && currentString.trim().length() != 0 && (startIndex = currentString.indexOf("/*")) >= 0 && (endIndex = currentString.indexOf("*/")) >= 0 && startIndex < endIndex; currentString = currentString.substring(endIndex + "*/".length())) {
            int typeEndIndex;
            String peace = currentString.substring(startIndex + "/*".length(), endIndex);
            int typeStartIndex = peace.indexOf("(");
            if (typeStartIndex < 0 || (typeEndIndex = peace.indexOf(")")) < 0 || typeStartIndex >= typeEndIndex) continue;
            String parameterType = peace.substring(typeStartIndex + "(".length(), typeEndIndex);
            if (peace.startsWith("$cls")) {
                String code = this.extractFixedConditionEmbeddedCommentClassification(peace, parameterType);
                String expression = "/*" + peace + "*/";
                fixedConditionReplacementMap.put(expression + "null", expression);
                fixedConditionReplacementMap.put(expression + "Null", expression);
                fixedConditionReplacementMap.put(expression + "NULL", expression);
                fixedConditionReplacementMap.put(expression, code);
                continue;
            }
            parameterType = this.filterDynamicFixedConditionParameterType(parameterType);
            String parameterName = peace.substring(0, typeStartIndex);
            this._dynamicFixedConditionMap.put(parameterName, parameterType);
            String parameterMapName = "parameterMap" + this.getForeignPropertyNameInitCap();
            String after = "/*$$locationBase$$." + parameterMapName + "." + parameterName + "*/";
            fixedConditionReplacementMap.put("/*" + peace + "*/", after);
        }
        if (fixedConditionReplacementMap.isEmpty()) {
            return;
        }
        Set replaceSet = fixedConditionReplacementMap.entrySet();
        for (Map.Entry replaceEntry : replaceSet) {
            String key = (String)replaceEntry.getKey();
            String value = (String)replaceEntry.getValue();
            this._fixedCondition = this.replace(this._fixedCondition, key, value);
        }
    }

    protected String extractFixedConditionEmbeddedCommentClassification(String peace, String parameterType) {
        if (!parameterType.contains(".")) {
            String msg = "The classification expression should be 'classificationName.elementName':";
            msg = msg + " expression=" + parameterType + " embeddedComment=" + peace;
            throw new DfFixedConditionInvalidClassificationEmbeddedCommentException(msg);
        }
        String classificationName = parameterType.substring(0, parameterType.indexOf("."));
        String elementName = parameterType.substring(parameterType.indexOf(".") + ".".length());
        Map<String, List<Map<String, String>>> definitionMap = this.getClassificationProperties().getClassificationDefinitionMap();
        List<Map<String, String>> elementMapList = definitionMap.get(classificationName);
        if (elementMapList == null) {
            String msg = "The classification name was NOT FOUND:";
            msg = msg + " classificationName=" + classificationName + " embeddedComment=" + peace;
            msg = msg + " classificationList=" + definitionMap.keySet();
            throw new DfFixedConditionInvalidClassificationEmbeddedCommentException(msg);
        }
        String code = null;
        for (Map<String, String> elementMap : elementMapList) {
            String name = elementMap.get("name");
            if (!elementName.equals(name)) continue;
            code = elementMap.get("code");
            break;
        }
        if (code == null) {
            String msg = "The classification element name was NOT FOUND:";
            msg = msg + " elementName=" + elementName + " embeddedComment=" + peace;
            msg = msg + " elementMapList=" + elementMapList;
            throw new DfFixedConditionInvalidClassificationEmbeddedCommentException(msg);
        }
        Map<String, Map<String, String>> topMap = this.getClassificationProperties().getClassificationTopDefinitionMap();
        Map<String, String> map = topMap.get(classificationName);
        String codeType = map.get("codeType");
        if (codeType == null || !codeType.equals("Number")) {
            code = "'" + code + "'";
        }
        return code;
    }

    protected String filterDynamicFixedConditionParameterType(String parameterType) {
        DfPropertyTypePackageResolver packageResolver = new DfPropertyTypePackageResolver();
        return packageResolver.resolvePackageName(parameterType);
    }

    public String getDynamicFixedConditionArgs() {
        return this.buildDynamicFixedConditionArgs(false);
    }

    public String getDynamicFixedConditionFinalArgs() {
        return this.buildDynamicFixedConditionArgs(true);
    }

    protected String buildDynamicFixedConditionArgs(boolean finalArg) {
        Set<String> parameterNameSet = this._dynamicFixedConditionMap.keySet();
        StringBuilder sb = new StringBuilder();
        for (String parameterName : parameterNameSet) {
            String paramterType = this._dynamicFixedConditionMap.get(parameterName);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (finalArg) {
                sb.append("final ");
            }
            sb.append(paramterType).append(" ").append(parameterName);
        }
        return sb.toString();
    }

    public String getDynamicFixedConditionVariables() {
        Set<String> parameterNameSet = this._dynamicFixedConditionMap.keySet();
        StringBuilder sb = new StringBuilder();
        for (String parameterName : parameterNameSet) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(parameterName);
        }
        return sb.toString();
    }

    public String getDynamicFixedConditionParameterMapSetup() {
        Set<Map.Entry<String, String>> entrySet = this._dynamicFixedConditionMap.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : entrySet) {
            String parameterName = entry.getKey();
            String parameterType = entry.getValue();
            sb.append("parameterMap.put(\"").append(parameterName).append("\", ");
            if (Date.class.getName().equals(parameterType)) {
                sb.append("fCTPD(").append(parameterName).append(")");
            } else {
                sb.append(parameterName);
            }
            sb.append(");");
        }
        return sb.toString();
    }

    public String getDynamicFixedConditionArgsJavaDocString() {
        Set<Map.Entry<String, String>> entrySet = this._dynamicFixedConditionMap.entrySet();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            String parameterName = entry.getKey();
            if (count > 0) {
                sb.append("     * ");
            }
            sb.append("@param ").append(parameterName).append(" ");
            sb.append("The bind parameter of fixed condition for ").append(parameterName).append(". (NotNull)");
            sb.append(this.getBasicProperties().getSourceCodeLineSeparator());
            ++count;
        }
        String result = Srl.rtrim((String)sb.toString());
        return result;
    }

    public String getForeignDispForJavaDoc() {
        return this.doGetForeignDispForJavaDoc("    ");
    }

    public String getForeignDispForJavaDocNest() {
        return this.doGetForeignDispForJavaDoc("        ");
    }

    public String doGetForeignDispForJavaDoc(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getForeignSimpleDisp()).append(".");
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._comment)) {
            String comment = this.resolveCommentForJavaDoc(this._comment, indent);
            sb.append(" <br />").append(this.ln()).append(indent).append(" * ").append(comment);
        }
        return sb.toString();
    }

    public String getForeignSimpleDisp() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getForeignTable().getAliasExpression());
        sb.append(this.getForeignTable().getName());
        sb.append(" as '").append(this.getForeignJavaBeansRulePropertyName()).append("'");
        return sb.toString();
    }

    public String getReferrerDispAsOneForJavaDoc() {
        return this.doGetReferrerDispAsOneForJavaDoc("    ");
    }

    public String getReferrerDispAsOneForJavaDocNest() {
        return this.doGetReferrerDispAsOneForJavaDoc("        ");
    }

    public String doGetReferrerDispAsOneForJavaDoc(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReferrerSimpleDispAsOne()).append(".");
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._comment)) {
            String comment = this.resolveCommentForJavaDoc(this._comment, indent);
            sb.append(" <br />").append(this.ln()).append(indent).append(" * ").append(comment);
        }
        return sb.toString();
    }

    public String getReferrerSimpleDispAsOne() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTable().getAliasExpression());
        sb.append(this.getTable().getName());
        sb.append(" as '").append(this.getReferrerJavaBeansRulePropertyNameAsOne()).append("'");
        return sb.toString();
    }

    public String getReferrerDispForJavaDoc() {
        return this.doGetReferrerDispForJavaDoc("    ");
    }

    public String getReferrerDispForJavaDocNest() {
        return this.doGetReferrerDispForJavaDoc("        ");
    }

    public String doGetReferrerDispForJavaDoc(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReferrerSimpleDisp()).append(".");
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._comment)) {
            String comment = this.resolveCommentForJavaDoc(this._comment, indent);
            sb.append(" <br />").append(this.ln()).append(indent).append(" * ").append(comment);
        }
        return sb.toString();
    }

    public String getReferrerSimpleDisp() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTable().getAliasExpression());
        sb.append(this.getTable().getName());
        sb.append(" as '").append(this.getReferrerJavaBeansRulePropertyName()).append("'");
        return sb.toString();
    }

    protected String resolveCommentForJavaDoc(String comment, String indent) {
        return this.getDocumentProperties().resolveTextForJavaDoc(comment, indent);
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace((String)text, (String)fromText, (String)toText);
    }

    protected String initCap(String str) {
        return Srl.initCap((String)str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap((String)str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected DfClassificationProperties getClassificationProperties() {
        return DfBuildProperties.getInstance().getClassificationProperties();
    }

    protected DfDocumentProperties getDocumentProperties() {
        return DfBuildProperties.getInstance().getDocumentProperties();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    <foreign-key");
        sb.append(" foreignTable=\"").append(this.getForeignTableName()).append("\"");
        sb.append(" name=\"").append(this.getName()).append("\"");
        sb.append(">\n");
        for (int i = 0; i < this._localColumns.size(); ++i) {
            sb.append("        <reference local=\"").append(this._localColumns.get(i));
            sb.append("\" foreign=\"").append(this._foreignColumns.get(i)).append("\"/>\n");
        }
        sb.append("    </foreign-key>");
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getForeignTableName() {
        return this._foreignTableName;
    }

    public void setForeignTableName(String tableName) {
        this._foreignTableName = tableName;
    }

    public void setTable(Table baseTable) {
        this._localTable = baseTable;
    }

    public Table getTable() {
        return this._localTable;
    }

    public boolean isAdditionalForeignKey() {
        return this._additionalForeignKey;
    }

    public void setAdditionalForeignKey(boolean additionalForeignKey) {
        this._additionalForeignKey = additionalForeignKey;
    }

    public String getFixedCondition() {
        return this._fixedCondition;
    }

    public void setFixedCondition(String fixedCondition) {
        this._fixedCondition = fixedCondition;
    }

    public String getFixedSuffix() {
        return this._fixedSuffix;
    }

    public void setFixedSuffix(String fixedSuffix) {
        this._fixedSuffix = fixedSuffix;
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }
}

