/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.util.List;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.AbstractNode;
import org.seasar.dbflute.twowaysql.node.LoopAcceptable;
import org.seasar.dbflute.twowaysql.node.LoopInfo;
import org.seasar.dbflute.twowaysql.node.NodeUtil;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableNode
extends AbstractNode
implements LoopAcceptable {
    protected final String _expression;
    protected final String _testValue;
    protected final String _option;
    protected final List<String> _nameList;
    protected final String _specifiedSql;
    protected final boolean _blockNullParameter;

    public VariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        if (expression.contains(":")) {
            this._expression = Srl.substringFirstFront(expression, ":").trim();
            this._option = Srl.substringFirstRear(expression, ":").trim();
        } else {
            this._expression = expression;
            this._option = null;
        }
        this._testValue = testValue;
        this._nameList = Srl.splitList(this._expression, ".");
        this._specifiedSql = specifiedSql;
        this._blockNullParameter = blockNullParameter;
    }

    @Override
    public void accept(CommandContext ctx) {
        this.doAccept(ctx, null);
    }

    @Override
    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        if (firstName.equals("#current")) {
            Object parameter = loopInfo.getCurrentParameter();
            Class<?> parameterType = loopInfo.getCurrentParameterType();
            this.doAccept(ctx, parameter, parameterType, loopInfo, true);
        } else {
            this.doAccept(ctx, loopInfo);
        }
    }

    protected void doAccept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        this.assertFirstNameAsNormal(ctx, firstName);
        Object firstValue = ctx.getArg(firstName);
        Class<?> firstType = ctx.getArgType(firstName);
        this.doAccept(ctx, firstValue, firstType, loopInfo, false);
    }

    protected void doAccept(CommandContext ctx, Object firstValue, Class<?> firstType, LoopInfo loopInfo, boolean inheritLoop) {
        this.assertInLoopOption(loopInfo);
        ValueAndType valueAndType = new ValueAndType();
        valueAndType.setFirstValue(firstValue);
        valueAndType.setFirstType(firstType);
        this.setupValueAndType(valueAndType);
        if (this.isAcceptableLike()) {
            LikeSearchOption inLoopLikeSearchOption = this.getInLoopLikeSearchOption();
            if (inLoopLikeSearchOption != null) {
                valueAndType.setLikeSearchOption(inLoopLikeSearchOption);
            } else if (inheritLoop) {
                valueAndType.inheritLikeSearchOptionIfNeeds(loopInfo);
            }
            valueAndType.filterValueByOptionIfNeeds();
        }
        if (this._blockNullParameter && valueAndType.getTargetValue() == null) {
            this.throwBindOrEmbeddedCommentParameterNullValueException(valueAndType);
        }
        this.doProcess(ctx, valueAndType);
    }

    protected abstract void doProcess(CommandContext var1, ValueAndType var2);

    protected void assertFirstNameAsNormal(CommandContext ctx, String firstName) {
        if (NodeUtil.isCurrentVariableOutOfScope(firstName, false)) {
            this.throwLoopCurrentVariableOutOfForCommentException();
        }
        if (NodeUtil.isWrongParameterBeanName(firstName, ctx)) {
            this.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException();
        }
    }

    protected void throwLoopCurrentVariableOutOfForCommentException() {
        NodeUtil.throwLoopCurrentVariableOutOfForCommentException(this._expression, this._specifiedSql);
    }

    protected void setupValueAndType(ValueAndType valueAndType) {
        ValueAndTypeSetupper.CommentType type = this.getCommentType();
        ValueAndTypeSetupper setuper = new ValueAndTypeSetupper(this._nameList, this._expression, this._specifiedSql, type);
        setuper.setupValueAndType(valueAndType);
    }

    protected abstract ValueAndTypeSetupper.CommentType getCommentType();

    protected void assertInLoopOption(LoopInfo loopInfo) {
        if (loopInfo == null && Srl.is_NotNull_and_NotTrimmedEmpty(this._option)) {
            this.throwInLoopOptionOutOfLoopException();
        }
    }

    protected boolean isAcceptableLike() {
        if (Srl.is_Null_or_TrimmedEmpty(this._option)) {
            return true;
        }
        List<String> optionList = Srl.splitListTrimmed(this._option, "|");
        for (String option : optionList) {
            if (!option.equals("notLike")) continue;
            return false;
        }
        return true;
    }

    protected LikeSearchOption getInLoopLikeSearchOption() {
        if (Srl.is_Null_or_TrimmedEmpty(this._option)) {
            return null;
        }
        List<String> optionList = Srl.splitListTrimmed(this._option, "|");
        for (String option : optionList) {
            if (option.equals("likePrefix")) {
                return new LikeSearchOption().likePrefix();
            }
            if (option.equals("likeContain")) {
                return new LikeSearchOption().likeContain();
            }
            if (!option.equals("likeSuffix")) continue;
            return new LikeSearchOption().likeSuffix();
        }
        return null;
    }

    protected void setupRearOption(CommandContext ctx, ValueAndType valueAndType) {
        String rearOption = valueAndType.buildRearOptionOnSql();
        if (Srl.is_NotNull_and_NotTrimmedEmpty(rearOption)) {
            ctx.addSql(rearOption);
        }
    }

    protected boolean isInScope() {
        if (this._testValue == null) {
            return false;
        }
        return this._testValue.startsWith("(") && this._testValue.endsWith(")");
    }

    protected void throwBindOrEmbeddedCommentParameterNullValueException(ValueAndType valueAndType) {
        Class<?> targetType = valueAndType.getTargetType();
        NodeUtil.throwBindOrEmbeddedCommentParameterNullValueException(this._expression, targetType, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentInScopeNotListException(ValueAndType valueAndType) {
        Class<?> targetType = valueAndType.getTargetType();
        NodeUtil.throwBindOrEmbeddedCommentInScopeNotListException(this._expression, targetType, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException() {
        NodeUtil.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentParameterEmptyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterEmptyListException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentParameterNullOnlyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterNullOnlyListException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwInLoopOptionOutOfLoopException() {
        NodeUtil.throwInLoopOptionOutOfLoopException(this._expression, this._specifiedSql, this._option);
    }

    protected boolean isBind() {
        return this.getCommentType().equals((Object)ValueAndTypeSetupper.CommentType.BIND);
    }

    public boolean isBlockNullParameter() {
        return this._blockNullParameter;
    }
}

