/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnUpdateAutoHandler;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnUpdateAutoDynamicCommand
extends TnAbstractSqlCommand {
    private static final Integer NON_UPDATE = 1;
    protected TnBeanMetaData _beanMetaData;
    protected DBMeta _targetDBMeta;
    protected String[] _propertyNames;
    protected boolean _optimisticLockHandling;
    protected boolean _versionNoAutoIncrementOnMemory;

    public TnUpdateAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        Object bean = args[0];
        UpdateOption option = args.length > 1 ? (UpdateOption)args[1] : null;
        TnBeanMetaData bmd = this.getBeanMetaData();
        TnPropertyType[] propertyTypes = this.createUpdatePropertyTypes(bmd, bean, this.getPropertyNames(), option);
        if (propertyTypes.length == 0) {
            if (this.isLogEnabled()) {
                this.log(this.createNonUpdateLogMessage(bean, bmd));
            }
            return NON_UPDATE;
        }
        String sql = this.createUpdateSql(bmd, propertyTypes, bean, option);
        TnUpdateAutoHandler handler = this.createUpdateAutoHandler(bmd, propertyTypes, sql, option);
        Object[] realArgs = new Object[]{bean};
        handler.setExceptionMessageSqlArgs(realArgs);
        int result = handler.execute(realArgs);
        return result;
    }

    protected TnUpdateAutoHandler createUpdateAutoHandler(TnBeanMetaData bmd, TnPropertyType[] boundPropTypes, String sql, UpdateOption<ConditionBean> option) {
        TnUpdateAutoHandler handler = new TnUpdateAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, boundPropTypes);
        handler.setSql(sql);
        handler.setOptimisticLockHandling(this._optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this._versionNoAutoIncrementOnMemory);
        handler.setUpdateOption(option);
        return handler;
    }

    protected abstract TnPropertyType[] createUpdatePropertyTypes(TnBeanMetaData var1, Object var2, String[] var3, UpdateOption<ConditionBean> var4);

    protected String createNonUpdateLogMessage(Object bean, TnBeanMetaData bmd) {
        StringBuilder sb = new StringBuilder();
        String tableDbName = this._targetDBMeta.getTableDbName();
        sb.append("...Skipping update because of non-modification: table=").append(tableDbName);
        int size = bmd.getPrimaryKeySize();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append(", primaryKey={");
            } else {
                sb.append(", ");
            }
            String keyName = bmd.getPrimaryKeyDbName(i);
            sb.append(keyName).append("=");
            sb.append(bmd.getPropertyTypeByColumnName(keyName).getPropertyDesc().getValue(bean));
            if (i != size - 1) continue;
            sb.append("}");
        }
        return sb.toString();
    }

    protected String createUpdateSql(TnBeanMetaData bmd, TnPropertyType[] propertyTypes, Object bean, UpdateOption<ConditionBean> option) {
        int i;
        TableSqlName tableSqlName = this._targetDBMeta.getTableSqlName();
        if (bmd.getPrimaryKeySize() == 0) {
            String msg = "The table '" + tableSqlName + "' does not have primary keys!";
            throw new IllegalStateException(msg);
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("update ").append(tableSqlName).append(" set ");
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            String columnDbName = pt.getColumnDbName();
            ColumnSqlName columnSqlName = pt.getColumnSqlName();
            String propertyName = pt.getPropertyName();
            if (i > 0) {
                sb.append(", ");
            }
            if (propertyName.equalsIgnoreCase(versionNoPropertyName)) {
                if (!this.isVersionNoAutoIncrementOnMemory()) {
                    this.setupVersionNoAutoIncrementOnQuery(sb, columnSqlName);
                    continue;
                }
                Object versionNo = pt.getPropertyDesc().getValue(bean);
                if (versionNo == null) {
                    this.setupVersionNoAutoIncrementOnQuery(sb, columnSqlName);
                    continue;
                }
            }
            if (option != null && option.hasStatement(columnDbName)) {
                String statement = option.buildStatement(columnDbName);
                sb.append(columnSqlName).append(" = ").append(statement);
                continue;
            }
            sb.append(columnSqlName).append(" = ?");
        }
        sb.append(this.ln()).append(" where ");
        for (i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            sb.append(bmd.getPrimaryKeySqlName(i)).append(" = ? and ");
        }
        sb.setLength(sb.length() - 5);
        if (this._optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        if (this._optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        return sb.toString();
    }

    protected void setupVersionNoAutoIncrementOnQuery(StringBuilder sb, ColumnSqlName columnSqlName) {
        sb.append(columnSqlName).append(" = ").append(columnSqlName).append(" + 1");
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public TnBeanMetaData getBeanMetaData() {
        return this._beanMetaData;
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this._beanMetaData = beanMetaData;
    }

    public DBMeta getTargetDBMeta() {
        return this._targetDBMeta;
    }

    public void setTargetDBMeta(DBMeta targetDBMeta) {
        this._targetDBMeta = targetDBMeta;
    }

    public String[] getPropertyNames() {
        return this._propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this._propertyNames = propertyNames;
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this._optimisticLockHandling = optimisticLockHandling;
    }

    protected boolean isVersionNoAutoIncrementOnMemory() {
        return this._versionNoAutoIncrementOnMemory;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this._versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }
}

