/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnSqlLogRegistry {
    protected static final String PKG_ORG_SEASAR = "org.seasar.";
    protected static final String NAME_SqlLogRegistryLocator = "org.seasar.extension.jdbc.SqlLogRegistryLocator";
    protected static final String NAME_getInstance = "getInstance";
    protected static final String NAME_setInstance = "setInstance";
    protected static final String NAME_SqlLogRegistry = "org.seasar.extension.jdbc.SqlLogRegistry";
    protected static final String NAME_SqlLogRegistryImpl = "org.seasar.extension.jdbc.impl.SqlLogRegistryImpl";
    protected static final String NAME_SqlLog = "org.seasar.extension.jdbc.SqlLog";
    protected static final String NAME_SqlLogImpl = "org.seasar.extension.jdbc.impl.SqlLogImpl";
    protected static final boolean exists = TnSqlLogRegistry.forNameContainerSqlLogRegistryLocator() != null;

    public static boolean exists() {
        return exists;
    }

    public static boolean setupSqlLogRegistry() {
        if (!exists) {
            return false;
        }
        Class<?> sqlLogRegistryLocatorType = TnSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (sqlLogRegistryLocatorType == null) {
            return false;
        }
        Class<?> sqlLogRegistryType = TnSqlLogRegistry.forNameContainerSqlLogRegistry();
        if (sqlLogRegistryType == null) {
            return false;
        }
        Object sqlLogRegistryImpl = TnSqlLogRegistry.createContainerSqlLogRegistryImpl();
        if (sqlLogRegistryImpl == null) {
            return false;
        }
        try {
            Method method = sqlLogRegistryLocatorType.getMethod(NAME_setInstance, sqlLogRegistryType);
            method.invoke(null, sqlLogRegistryImpl);
            return true;
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.setupSqlLogRegistry() threw the exception:";
            msg = msg + " sqlLogRegistryLocatorType=" + sqlLogRegistryLocatorType;
            msg = msg + " NAME_setInstance=" + NAME_setInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void clearSqlLogRegistry() {
        if (!exists) {
            return;
        }
        Class<?> sqlLogRegistryLocatorType = TnSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (sqlLogRegistryLocatorType == null) {
            return;
        }
        Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
        if (sqlLogRegistry == null) {
            return;
        }
        Class<?> sqlLogRegistryType = sqlLogRegistry.getClass();
        try {
            Method method = sqlLogRegistryType.getMethod("clear", new Class[0]);
            method.invoke(sqlLogRegistry, new Object[0]);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.clearSqlLogRegistry() threw the exception:";
            msg = msg + " sqlLogRegistryLocatorType=" + sqlLogRegistryLocatorType;
            throw new IllegalStateException(msg, e);
        }
    }

    public static Object findContainerSqlLogRegistry() {
        if (!exists) {
            return null;
        }
        Class<?> sqlLogRegistryLocatorType = TnSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (sqlLogRegistryLocatorType == null) {
            return null;
        }
        try {
            Method method = sqlLogRegistryLocatorType.getMethod(NAME_getInstance, null);
            return method.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.findContainerSqlLogRegistry() threw the exception:";
            msg = msg + " sqlLogRegistryLocatorType=" + sqlLogRegistryLocatorType;
            msg = msg + " NAME_getInstance=" + NAME_getInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void closeRegistration() {
        if (!exists) {
            return;
        }
        Class<?> sqlLogRegistryLocatorType = TnSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (sqlLogRegistryLocatorType == null) {
            return;
        }
        Class<?> sqlLogRegistryType = TnSqlLogRegistry.forNameContainerSqlLogRegistry();
        if (sqlLogRegistryType == null) {
            return;
        }
        try {
            Method method = sqlLogRegistryLocatorType.getMethod(NAME_setInstance, sqlLogRegistryType);
            method.invoke(null, new Object[]{null});
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.closeRegistration() threw the exception:";
            msg = msg + " sqlLogRegistryLocatorType=" + sqlLogRegistryLocatorType;
            msg = msg + " NAME_setInstance=" + NAME_setInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void push(String rawSql, String completeSql, Object[] bindArgs, Class<?>[] bindArgTypes, Object sqlLogRegistry) {
        if (!exists) {
            return;
        }
        if (sqlLogRegistry == null) {
            throw new IllegalArgumentException("sqlLogRegistry should not be null!");
        }
        Object sqlLogImpl = TnSqlLogRegistry.createContainerSqlLogImpl(rawSql, completeSql, bindArgs, bindArgTypes);
        TnSqlLogRegistry.reflectSqlLogToContainerSqlLogRegistry(sqlLogImpl, sqlLogRegistry);
    }

    public static String peekCompleteSql() {
        if (!exists) {
            return null;
        }
        Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
        if (sqlLogRegistry == null) {
            return null;
        }
        Object sqlLog = TnSqlLogRegistry.findLastContainerSqlLog(sqlLogRegistry);
        if (sqlLog == null) {
            return null;
        }
        return TnSqlLogRegistry.extractCompleteSqlFromContainerSqlLog(sqlLog);
    }

    protected static Object createContainerSqlLogRegistryImpl() {
        try {
            Class<?> clazz = TnSqlLogRegistry.forNameContainerSqlLogRegistryImpl();
            if (clazz == null) {
                return null;
            }
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
            return constructor.newInstance(3);
        }
        catch (Exception e) {
            String msg = "org.seasar.extension.jdbc.SqlLogRegistry.class.newInstance threw the exception:";
            msg = msg + " NAME_SqlLogRegistry=" + NAME_SqlLogRegistry;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Object createContainerSqlLogImpl(String rawSql, String completeSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
        try {
            Class<?> sqlLogImplType = Class.forName(NAME_SqlLogImpl);
            Class[] argTypes = new Class[]{String.class, String.class, Object[].class, Class[].class};
            Constructor<?> constructor = sqlLogImplType.getConstructor(argTypes);
            return constructor.newInstance(rawSql, completeSql, bindArgs, bindArgTypes);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.createContainerSqlLogImpl() threw the exception:";
            msg = msg + " completeSql=" + completeSql;
            msg = msg + " NAME_SqlLogImpl=" + NAME_SqlLogImpl;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static void reflectSqlLogToContainerSqlLogRegistry(Object sqlLog, Object sqlLogRegistry) {
        if (sqlLog == null || sqlLogRegistry == null) {
            return;
        }
        try {
            Class<?> sqlLogRegistryType = sqlLogRegistry.getClass();
            Class<?> sqlLogType = Class.forName(NAME_SqlLog);
            Method method = sqlLogRegistryType.getMethod("add", sqlLogType);
            method.invoke(sqlLogRegistry, sqlLog);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.reflectToContainerSqlLogRegistry() threw the exception:";
            msg = msg + " sqlLog=" + sqlLog + " sqlLogRegistry=" + sqlLogRegistry;
            msg = msg + " NAME_SqlLog=" + NAME_SqlLog;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Object findLastContainerSqlLog(Object sqlLogRegistry) {
        if (sqlLogRegistry == null) {
            return null;
        }
        try {
            Class<?> sqlLogRegistryType = sqlLogRegistry.getClass();
            Method method = sqlLogRegistryType.getMethod("getLast", null);
            return method.invoke(sqlLogRegistry, (Object[])null);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.findLastContainerSqlLog() threw the exception:";
            msg = msg + " sqlLogRegistry=" + sqlLogRegistry;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static String extractCompleteSqlFromContainerSqlLog(Object sqlLog) {
        if (sqlLog == null) {
            return null;
        }
        try {
            Class<?> sqlLogType = sqlLog.getClass();
            Method method = sqlLogType.getMethod("getCompleteSql", null);
            return (String)method.invoke(sqlLog, (Object[])null);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.extractCompleteSqlFromContainerSqlLog() threw the exception:";
            msg = msg + " sqlLog=" + sqlLog;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Class<?> forNameContainerSqlLogRegistryLocator() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistryLocator);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLogRegistry() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistry);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLogRegistryImpl() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistryImpl);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }
}

