/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.dbflute.cbean.OrderByBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDefault;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.exception.PagingPageSizeNotPlusException;
import org.seasar.dbflute.twowaysql.pmbean.MapParameterBean;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePagingBean
implements PagingBean,
MapParameterBean<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SqlClause _sqlClause = new SqlClauseDefault("dummy");
    protected Map<String, Object> _parameterMap;
    protected int _safetyMaxResultSize;
    protected boolean _paging = true;
    protected boolean _pagingCountLater;
    protected boolean _pagingReSelect = true;
    protected boolean _fetchNarrowing = true;

    @Override
    public boolean isPaging() {
        return this._paging;
    }

    @Override
    public boolean canPagingCountLater() {
        return this._pagingCountLater;
    }

    @Override
    public boolean canPagingReSelect() {
        return this._pagingReSelect;
    }

    @Override
    public void paging(int pageSize, int pageNumber) {
        if (pageSize <= 0) {
            this.throwPagingPageSizeNotPlusException(pageSize, pageNumber);
        }
        this.fetchFirst(pageSize);
        this.fetchPage(pageNumber);
    }

    protected void throwPagingPageSizeNotPlusException(int pageSize, int pageNumber) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Page size for paging should not be minus or zero!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Confirm the value of your parameter 'pageSize'." + this.ln();
        msg = msg + "The first parameter of paging() should be a plus value!" + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - pmb.paging(0, 1);" + this.ln();
        msg = msg + "    (x) - pmb.paging(-3, 2);" + this.ln();
        msg = msg + "    (o) - pmb.paging(4, 3);" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Page Size]" + this.ln();
        msg = msg + pageSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Page Number]" + this.ln();
        msg = msg + pageNumber + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new PagingPageSizeNotPlusException(msg);
    }

    @Override
    public void xsetPaging(boolean paging) {
        if (paging) {
            this.getSqlClause().makeFetchScopeEffective();
        } else {
            this.getSqlClause().ignoreFetchScope();
        }
        this._paging = paging;
    }

    @Override
    public void enablePagingCountLater() {
        this._pagingCountLater = true;
    }

    @Override
    public void disablePagingReSelect() {
        this._pagingReSelect = false;
    }

    @Override
    public PagingBean fetchFirst(int fetchSize) {
        this.getSqlClause().fetchFirst(fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchScope(int fetchStartIndex, int fetchSize) {
        this.getSqlClause().fetchScope(fetchStartIndex, fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchPage(int fetchPageNumber) {
        this.getSqlClause().fetchPage(fetchPageNumber);
        return this;
    }

    @Override
    public <ENTITY> PagingInvoker<ENTITY> createPagingInvoker(String tableDbName) {
        return new PagingInvoker(tableDbName);
    }

    @Override
    public int getFetchStartIndex() {
        return this.getSqlClause().getFetchStartIndex();
    }

    @Override
    public int getFetchSize() {
        return this.getSqlClause().getFetchSize();
    }

    @Override
    public int getFetchPageNumber() {
        return this.getSqlClause().getFetchPageNumber();
    }

    @Override
    public int getPageStartIndex() {
        return this.getSqlClause().getPageStartIndex();
    }

    @Override
    public int getPageEndIndex() {
        return this.getSqlClause().getPageEndIndex();
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this.getSqlClause().isFetchScopeEffective();
    }

    @Override
    public int getSafetyMaxResultSize() {
        return this._safetyMaxResultSize;
    }

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getSqlClause().getFetchNarrowingSkipStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getSqlClause().getFetchNarrowingLoopCount();
    }

    @Override
    public boolean isFetchNarrowingSkipStartIndexEffective() {
        return !this.getSqlClause().isFetchStartIndexSupported();
    }

    @Override
    public boolean isFetchNarrowingLoopCountEffective() {
        return !this.getSqlClause().isFetchSizeSupported();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this._fetchNarrowing && this.getSqlClause().isFetchNarrowingEffective();
    }

    @Override
    public void ignoreFetchNarrowing() {
        this._fetchNarrowing = false;
    }

    @Override
    public void restoreIgnoredFetchNarrowing() {
        this._fetchNarrowing = true;
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this.getSqlClause().getSqlComponentOfOrderByClause();
    }

    @Override
    public String getOrderByClause() {
        return this.getSqlClause().getOrderByClause();
    }

    @Override
    public OrderByBean clearOrderBy() {
        this.getSqlClause().clearOrderBy();
        return this;
    }

    @Override
    public OrderByBean ignoreOrderBy() {
        this.getSqlClause().ignoreOrderBy();
        return this;
    }

    @Override
    public OrderByBean makeOrderByEffective() {
        this.getSqlClause().makeOrderByEffective();
        return this;
    }

    @Override
    public void checkSafetyResult(int safetyMaxResultSize) {
        this._safetyMaxResultSize = safetyMaxResultSize;
    }

    @Override
    public Map<String, Object> getParameterMap() {
        this.initializeParameterMapIfNeeds();
        return this._parameterMap;
    }

    public void addParameter(String key, Object value) {
        this.initializeParameterMapIfNeeds();
        this._parameterMap.put(key, value);
    }

    protected void initializeParameterMapIfNeeds() {
        if (this._parameterMap == null) {
            this._parameterMap = new LinkedHashMap<String, Object>();
        }
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected SqlClause getSqlClause() {
        return this._sqlClause;
    }
}

