/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.AndQuery;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.OrQuery;
import org.seasar.dbflute.cbean.OrderByBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.chelper.HpAbstractSpecification;
import org.seasar.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseFilter;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.exception.ColumnQueryCalculationUnsupportedColumnTypeException;
import org.seasar.dbflute.exception.ConditionInvokingFailureException;
import org.seasar.dbflute.exception.OrScopeQueryAndPartUnsupportedOperationException;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.twowaysql.factory.SqlAnalyzerFactory;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionBean
implements ConditionBean {
    protected final SqlClause _sqlClause = this.createSqlClause();
    private int _safetyMaxResultSize;
    private StatementConfig _statementConfig;
    private boolean _pagingCountLater;
    private boolean _pagingReSelect = true;
    private Map<String, Object> _freeParameterMap;
    private UnionQuery<ConditionBean> _unionQuerySynchronizer;
    protected HpCBPurpose _purpose = HpCBPurpose.NORMAL_USE;
    protected Map<String, ConditionBean> _colQyCBMap;
    protected boolean _isSelectCountIgnoreFetchScope;

    @Override
    public DBMeta getDBMeta() {
        return this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
    }

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    protected abstract SqlClause createSqlClause();

    protected abstract DBMetaProvider getDBMetaProvider();

    protected void doSetupSelect(SsCall callback) {
        String foreignPropertyName = callback.qf().xgetForeignPropertyName();
        this.assertSetupSelectPurpose(foreignPropertyName);
        this.assertSetupSelectBeforeUnion(foreignPropertyName);
        String foreignTableAliasName = callback.qf().xgetAliasName();
        String localRelationPath = this.localCQ().xgetRelationPath();
        this.getSqlClause().registerSelectedSelectColumn(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, localRelationPath);
        this.getSqlClause().registerSelectedForeignInfo(callback.qf().xgetRelationPath(), foreignPropertyName);
    }

    protected void assertSetupSelectPurpose(String foreignPropertyName) {
        if (this._purpose.isNoSetupSelect()) {
            String titleName = DfTypeUtil.toClassTitle(this);
            this.throwSetupSelectIllegalPurposeException(titleName, foreignPropertyName);
        }
    }

    protected void throwSetupSelectIllegalPurposeException(String className, String foreignPropertyName) {
        this.createCBExThrower().throwSetupSelectIllegalPurposeException(this._purpose, this, foreignPropertyName);
    }

    protected void assertSetupSelectBeforeUnion(String foreignPropertyName) {
        if (this.hasUnionQueryOrUnionAllQuery()) {
            this.throwSetupSelectAfterUnionException(foreignPropertyName);
        }
    }

    protected void throwSetupSelectAfterUnionException(String foreignPropertyName) {
        this.createCBExThrower().throwSetupSelectAfterUnionException(this, foreignPropertyName);
    }

    protected abstract boolean hasSpecifiedColumn();

    protected abstract HpAbstractSpecification<? extends ConditionQuery> localSp();

    protected void assertSpecifyPurpose() {
        if (this._purpose.isNoSpecify()) {
            this.throwSpecifyIllegalPurposeException();
        }
    }

    protected void throwSpecifyIllegalPurposeException() {
        this.createCBExThrower().throwSpecifyIllegalPurposeException(this._purpose, this);
    }

    protected void assertQueryPurpose() {
        if (this._purpose.isNoQuery()) {
            this.throwQueryIllegalPurposeException();
        }
    }

    protected void throwQueryIllegalPurposeException() {
        this.createCBExThrower().throwQueryIllegalPurposeException(this._purpose, this);
    }

    public Map<String, ConditionBean> getColQyCBMap() {
        return this._colQyCBMap;
    }

    protected <CB extends ConditionBean> HpCalculator xcolqy(CB leftCB, CB rightCB, SpecifyQuery<CB> leftSp, SpecifyQuery<CB> rightSp, String operand) {
        this.assertQueryPurpose();
        leftSp.specify(leftCB);
        String leftColumn = this.xbuildLeftColumn(leftCB);
        HpCalcSpecification<CB> rightCalcSp = this.xcreateCalcSpecification(rightSp);
        rightCalcSp.specify(rightCB);
        String rightColumn = this.xbuildRightColumn(rightCB, rightCalcSp);
        QueryClause queryClause = this.xcreateColQyClause(leftColumn, operand, rightColumn, rightCalcSp);
        this.getSqlClause().registerWhereClause(queryClause);
        return rightCalcSp;
    }

    protected <CB extends ConditionBean> String xbuildLeftColumn(CB leftCB) {
        ColumnRealName realName = leftCB.getSqlClause().getSpecifiedColumnRealNameAsOne();
        String leftSource = realName != null ? realName.toString() : leftCB.getSqlClause().getSpecifiedDerivingSubQueryAsOne();
        if (leftSource == null) {
            this.createCBExThrower().throwColumnQueryInvalidColumnSpecificationException();
        }
        return this.xbuildColQyColumn(leftCB, leftSource, "left");
    }

    protected <CB extends ConditionBean> String xbuildRightColumn(CB rightCB, HpCalcSpecification<CB> rightCalcSp) {
        ColumnRealName realName = rightCalcSp.getSpecifiedColumnRealName();
        if (realName == null) {
            this.createCBExThrower().throwColumnQueryInvalidColumnSpecificationException();
        }
        return this.xbuildColQyColumn(rightCB, realName.toString(), "right");
    }

    protected <CB extends ConditionBean> String xbuildColQyColumn(CB cb, String source, String keyPrefix) {
        if (this._colQyCBMap == null) {
            this._colQyCBMap = DfCollectionUtil.newHashMap();
        }
        int colQyCBIndex = this._colQyCBMap.size();
        String key = keyPrefix + colQyCBIndex;
        this._colQyCBMap.put(key, cb);
        String from = "/*pmb.conditionQuery.";
        String to = "/*pmb.colQyCBMap." + key + ".conditionQuery.";
        String result = source;
        result = Srl.replace(result, "/*pmb.conditionQuery.", to);
        return result;
    }

    protected <CB extends ConditionBean> HpCalcSpecification<CB> xcreateCalcSpecification(SpecifyQuery<CB> rightSp) {
        return new HpCalcSpecification<CB>(rightSp);
    }

    protected <CB extends ConditionBean> QueryClause xcreateColQyClause(final String leftColumn, final String operand, final String rightColumn, final HpCalcSpecification<CB> rightCalcSp) {
        return new QueryClause(){

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(leftColumn).append(" ").append(operand).append(" ");
                String statement = rightCalcSp.buildStatementAsRealName();
                if (statement != null) {
                    ColumnInfo columnInfo = rightCalcSp.getSpecifiedColumnInfo();
                    if (!columnInfo.isPropertyTypeNumber()) {
                        String msg = "Not number column specified: " + columnInfo;
                        throw new ColumnQueryCalculationUnsupportedColumnTypeException(msg);
                    }
                    sb.append(statement);
                } else {
                    sb.append(rightColumn);
                }
                return sb.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <CB extends ConditionBean> void xorSQ(CB cb, OrQuery<CB> orQuery) {
        this.assertQueryPurpose();
        if (this.getSqlClause().isOrScopeQueryAndPartEffective()) {
            String msg = "The OrScopeQuery in and-part is unsupported: " + this.getTableDbName();
            throw new OrScopeQueryAndPartUnsupportedOperationException(msg);
        }
        this.getSqlClause().makeOrScopeQueryEffective();
        try {
            orQuery.query(cb);
        }
        finally {
            this.getSqlClause().closeOrScopeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <CB extends ConditionBean> void xorSQAP(CB cb, AndQuery<CB> andQuery) {
        this.assertQueryPurpose();
        if (!this.getSqlClause().isOrScopeQueryEffective()) {
            this.createCBExThrower().throwOrScopeQueryAndPartNotOrScopeException(cb);
        }
        if (this.getSqlClause().isOrScopeQueryAndPartEffective()) {
            this.createCBExThrower().throwOrScopeQueryAndPartAlreadySetupException(cb);
        }
        this.getSqlClause().beginOrScopeQueryAndPart();
        try {
            andQuery.query(cb);
        }
        finally {
            this.getSqlClause().endOrScopeQueryAndPart();
        }
    }

    @Override
    public void checkInvalidQuery() {
        this.getSqlClause().checkInvalidQuery();
    }

    @Override
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        if (!this.getDBMeta().hasPrimaryKey()) {
            String msg = "The table has no primary-keys: " + this.getTableDbName();
            throw new UnsupportedOperationException(msg);
        }
        Entity entity = this.getDBMeta().newEntity();
        this.getDBMeta().acceptPrimaryKeyMap(entity, primaryKeyMap);
        Map<String, Object> filteredMap = this.getDBMeta().extractPrimaryKeyMap(entity);
        Set<Map.Entry<String, Object>> entrySet = filteredMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            this.localCQ().invokeQuery(entry.getKey(), "equal", entry.getValue());
        }
    }

    @Override
    public boolean isPaging() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean canPagingCountLater() {
        return this._pagingCountLater;
    }

    @Override
    public boolean canPagingReSelect() {
        return this._pagingReSelect;
    }

    @Override
    public void paging(int pageSize, int pageNumber) {
        if (pageSize <= 0) {
            this.throwPagingPageSizeNotPlusException(pageSize, pageNumber);
        }
        this.fetchFirst(pageSize);
        this.fetchPage(pageNumber);
    }

    protected void throwPagingPageSizeNotPlusException(int pageSize, int pageNumber) {
        this.createCBExThrower().throwPagingPageSizeNotPlusException(this, pageSize, pageNumber);
    }

    @Override
    public void xsetPaging(boolean paging) {
    }

    @Override
    public void enablePagingCountLater() {
        this._pagingCountLater = true;
    }

    @Override
    public void disablePagingReSelect() {
        this._pagingReSelect = false;
    }

    @Override
    public PagingBean fetchFirst(int fetchSize) {
        this.getSqlClause().fetchFirst(fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchScope(int fetchStartIndex, int fetchSize) {
        this.getSqlClause().fetchScope(fetchStartIndex, fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchPage(int fetchPageNumber) {
        this.getSqlClause().fetchPage(fetchPageNumber);
        return this;
    }

    @Override
    public <ENTITY> PagingInvoker<ENTITY> createPagingInvoker(String tableDbName) {
        return new PagingInvoker(tableDbName);
    }

    @Override
    public int getFetchStartIndex() {
        return this.getSqlClause().getFetchStartIndex();
    }

    @Override
    public int getFetchSize() {
        return this.getSqlClause().getFetchSize();
    }

    @Override
    public int getFetchPageNumber() {
        return this.getSqlClause().getFetchPageNumber();
    }

    @Override
    public int getPageStartIndex() {
        return this.getSqlClause().getPageStartIndex();
    }

    @Override
    public int getPageEndIndex() {
        return this.getSqlClause().getPageEndIndex();
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this.getSqlClause().isFetchScopeEffective();
    }

    public String getSelectHint() {
        return this.getSqlClause().getSelectHint();
    }

    public String getFromBaseTableHint() {
        return this.getSqlClause().getFromBaseTableHint();
    }

    public String getFromHint() {
        return this.getSqlClause().getFromHint();
    }

    public String getSqlSuffix() {
        return this.getSqlClause().getSqlSuffix();
    }

    @Override
    public void checkSafetyResult(int safetyMaxResultSize) {
        this._safetyMaxResultSize = safetyMaxResultSize;
    }

    @Override
    public int getSafetyMaxResultSize() {
        return this._safetyMaxResultSize;
    }

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getSqlClause().getFetchNarrowingSkipStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getSqlClause().getFetchNarrowingLoopCount();
    }

    @Override
    public boolean isFetchNarrowingSkipStartIndexEffective() {
        return !this.getSqlClause().isFetchStartIndexSupported();
    }

    @Override
    public boolean isFetchNarrowingLoopCountEffective() {
        return !this.getSqlClause().isFetchSizeSupported();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this.getSqlClause().isFetchNarrowingEffective();
    }

    @Override
    public void ignoreFetchNarrowing() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void restoreIgnoredFetchNarrowing() {
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this.getSqlClause().getSqlComponentOfOrderByClause();
    }

    @Override
    public String getOrderByClause() {
        return this._sqlClause.getOrderByClause();
    }

    @Override
    public OrderByBean clearOrderBy() {
        this.getSqlClause().clearOrderBy();
        return this;
    }

    @Override
    public OrderByBean ignoreOrderBy() {
        this.getSqlClause().ignoreOrderBy();
        return this;
    }

    @Override
    public OrderByBean makeOrderByEffective() {
        this.getSqlClause().makeOrderByEffective();
        return this;
    }

    @Override
    public ConditionBean lockForUpdate() {
        this.getSqlClause().lockForUpdate();
        return this;
    }

    @Override
    public ConditionBean xsetupSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = true;
        this.getSqlClause().classifySelectClauseType(SqlClause.SelectClauseType.COUNT);
        this.getSqlClause().ignoreOrderBy();
        this.getSqlClause().ignoreFetchScope();
        return this;
    }

    @Override
    public ConditionBean xafterCareSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = false;
        this.getSqlClause().rollbackSelectClauseType();
        this.getSqlClause().makeOrderByEffective();
        this.getSqlClause().makeFetchScopeEffective();
        return this;
    }

    @Override
    public boolean isSelectCountIgnoreFetchScope() {
        return this._isSelectCountIgnoreFetchScope;
    }

    @Override
    public void configure(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    @Override
    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void embedCondition(Set<ColumnInfo> embeddedColumnInfoSet, boolean quote) {
        if (embeddedColumnInfoSet == null) {
            String msg = "The argument[embedCondition] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (quote) {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet));
        } else {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedSimpleFilter(embeddedColumnInfoSet));
        }
    }

    private QueryClauseFilter newToEmbeddedQuotedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new QueryClauseFilter.QueryClauseToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet);
    }

    private QueryClauseFilter newToEmbeddedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new QueryClauseFilter.QueryClauseToEmbeddedSimpleFilter(embeddedColumnInfoSet);
    }

    private void addWhereClauseSimpleFilter(QueryClauseFilter whereClauseSimpleFilter) {
        this._sqlClause.addWhereClauseSimpleFilter(whereClauseSimpleFilter);
    }

    @Override
    public String toDisplaySql() {
        SqlAnalyzerFactory factory = this.getSqlAnalyzerFactory();
        String dateFormat = this.getLogDateFormat();
        String timestampFormat = this.getLogTimestampFormat();
        return ConditionBeanContext.convertConditionBean2DisplaySql(factory, this, dateFormat, timestampFormat);
    }

    protected abstract SqlAnalyzerFactory getSqlAnalyzerFactory();

    protected abstract String getLogDateFormat();

    protected abstract String getLogTimestampFormat();

    @Override
    public boolean hasWhereClause() {
        return this.getSqlClause().hasWhereClause();
    }

    @Override
    public boolean hasOrderByClause() {
        return this.getSqlClause().hasOrderByClause();
    }

    @Override
    public void invokeSetupSelect(String foreignPropertyNamePath) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyNamePath", foreignPropertyNamePath);
        String delimiter = ".";
        Object currentObj = this;
        String remainder = foreignPropertyNamePath;
        int count = 0;
        boolean last = false;
        do {
            String propertyName;
            int deimiterIndex;
            if ((deimiterIndex = remainder.indexOf(".")) < 0) {
                propertyName = remainder;
                last = true;
            } else {
                propertyName = remainder.substring(0, deimiterIndex);
                remainder = remainder.substring(deimiterIndex + ".".length(), remainder.length());
            }
            String methodName = (count == 0 ? "setupSelect_" : "with") + this.initCap(propertyName);
            Method method = DfReflectionUtil.getPublicMethod(currentObj.getClass(), methodName, new Class[0]);
            if (method == null) {
                String msg = "Not found the method for setupSelect:";
                msg = msg + " foreignPropertyNamePath=" + foreignPropertyNamePath;
                msg = msg + " methodName=" + methodName;
                throw new ConditionInvokingFailureException(msg);
            }
            try {
                currentObj = DfReflectionUtil.invoke(method, currentObj, new Object[0]);
            }
            catch (DfReflectionUtil.ReflectionFailureException e) {
                String msg = "Failed to invoke the method:";
                msg = msg + " foreignPropertyNamePath=" + foreignPropertyNamePath;
                msg = msg + " methodName=" + methodName;
                throw new ConditionInvokingFailureException(msg, e);
            }
            ++count;
        } while (!last);
    }

    public Map<String, Object> getFreeParameterMap() {
        return this._freeParameterMap;
    }

    @Override
    public void xregisterFreeParameter(String key, Object value) {
        if (this._freeParameterMap == null) {
            this._freeParameterMap = new LinkedHashMap<String, Object>();
        }
        this._freeParameterMap.put(key, value);
    }

    protected void xsyncUQ(ConditionBean unionCB) {
        if (this._unionQuerySynchronizer != null) {
            this._unionQuerySynchronizer.query(unionCB);
        }
    }

    @Override
    public void xregisterUnionQuerySynchronizer(UnionQuery<ConditionBean> unionQuerySynchronizer) {
        this._unionQuerySynchronizer = unionQuerySynchronizer;
    }

    @Override
    public HpCBPurpose getPurpose() {
        return this._purpose;
    }

    public void xsetupForUnion(ConditionBean mainCB) {
        this.xinheritSubQueryInfo(mainCB.localCQ());
        this.xchangePurposeSqlClause(HpCBPurpose.UNION_QUERY);
    }

    public void xsetupForExistsReferrer(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.EXISTS_REFERRER);
    }

    public void xsetupForInScopeRelation(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.IN_SCOPE_RELATION);
    }

    public void xsetupForDerivedReferrer(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.DERIVED_REFERRER);
    }

    public void xsetupForScalarSelect() {
        this.xchangePurposeSqlClause(HpCBPurpose.SCALAR_SELECT);
    }

    public void xsetupForScalarCondition(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.SCALAR_CONDITION);
    }

    protected void xinheritSubQueryInfo(ConditionQuery mainCQ) {
        if (mainCQ.xgetSqlClause().isForSubQuery()) {
            this.getSqlClause().setupForSubQuery(mainCQ.xgetSqlClause().getSubQueryLevel());
        }
    }

    protected void xprepareSubQueryInfo(ConditionQuery mainCQ) {
        int nextSubQueryLevel = mainCQ.xgetSqlClause().getSubQueryLevel() + 1;
        this.getSqlClause().setupForSubQuery(nextSubQueryLevel);
    }

    protected void xchangePurposeSqlClause(HpCBPurpose purpose) {
        this._purpose = purpose;
        this.getSqlClause().setPurpose(purpose);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String titleName = DfTypeUtil.toClassTitle(this);
        sb.append(titleName).append(":").append(this.ln());
        try {
            sb.append(this.toDisplaySql());
        }
        catch (RuntimeException e) {
            sb.append(this.getSqlClause().getClause());
        }
        return sb.toString();
    }

    protected static interface SsCall {
        public ConditionQuery qf();
    }
}

