/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core;

import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.FetchAssistContext;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStack {
    private static ThreadLocal<Stack<ContextStack>> _threadLocal = new ThreadLocal();
    private ConditionBean _conditionBean;
    private EntityRowHandler<? extends Entity> _entityRowHandler;
    private OutsideSqlContext _outsideSqlContext;
    private FetchBean _fetchBean;
    private Map<String, Object> _internalMap;
    private ResourceContext _resourceContext;

    public static Stack<ContextStack> getContextStackOnThread() {
        return _threadLocal.get();
    }

    public static boolean isExistContextStackOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearContextStackOnThread() {
        _threadLocal.set(null);
    }

    public static void saveAllContextOnThread() {
        if (!ContextStack.isExistContextStackOnThread()) {
            _threadLocal.set(new Stack());
        }
        ContextStack contextStack = new ContextStack();
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            contextStack.setConditionBean(ConditionBeanContext.getConditionBeanOnThread());
        }
        if (ConditionBeanContext.isExistEntityRowHandlerOnThread()) {
            contextStack.setEntityRowHandler(ConditionBeanContext.getEntityRowHandlerOnThread());
        }
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            contextStack.setOutsideSqlContext(OutsideSqlContext.getOutsideSqlContextOnThread());
        }
        if (FetchAssistContext.isExistFetchBeanOnThread()) {
            contextStack.setFetchBean(FetchAssistContext.getFetchBeanOnThread());
        }
        if (InternalMapContext.isExistInternalMapContextOnThread()) {
            contextStack.setInternalMap(InternalMapContext.getInternalMap());
        }
        if (ResourceContext.isExistResourceContextOnThread()) {
            contextStack.setResourceContext(ResourceContext.getResourceContextOnThread());
        }
        ContextStack.getContextStackOnThread().push(contextStack);
    }

    public static void restoreAllContextOnThreadIfExists() {
        ResourceContext resourceContext;
        Map<String, Object> internalMap;
        FetchBean fetchBean;
        OutsideSqlContext outsideSqlContext;
        EntityRowHandler<? extends Entity> entityRowHandler;
        if (!ContextStack.isExistContextStackOnThread()) {
            return;
        }
        Stack<ContextStack> stackOnThread = ContextStack.getContextStackOnThread();
        if (stackOnThread.isEmpty()) {
            ContextStack.clearContextStackOnThread();
            return;
        }
        ContextStack contextStack = stackOnThread.pop();
        ConditionBean cb = contextStack.getConditionBean();
        if (cb != null) {
            ConditionBeanContext.setConditionBeanOnThread(cb);
        }
        if ((entityRowHandler = contextStack.getEntityRowHandler()) != null) {
            ConditionBeanContext.setEntityRowHandlerOnThread(entityRowHandler);
        }
        if ((outsideSqlContext = contextStack.getOutsideSqlContext()) != null) {
            OutsideSqlContext.setOutsideSqlContextOnThread(outsideSqlContext);
        }
        if ((fetchBean = contextStack.getFetchBean()) != null) {
            FetchAssistContext.setFetchBeanOnThread(fetchBean);
        }
        if ((internalMap = contextStack.getInternalMap()) != null) {
            InternalMapContext.clearInternalMapContextOnThread();
            Set<Map.Entry<String, Object>> entrySet = internalMap.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                InternalMapContext.setObject(entry.getKey(), entry.getValue());
            }
        }
        if ((resourceContext = contextStack.getResourceContext()) != null) {
            ResourceContext.setResourceContextOnThread(resourceContext);
        }
    }

    public static void clearAllCurrentContext() {
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            ConditionBeanContext.clearConditionBeanOnThread();
        }
        if (ConditionBeanContext.isExistEntityRowHandlerOnThread()) {
            ConditionBeanContext.clearEntityRowHandlerOnThread();
        }
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext.clearOutsideSqlContextOnThread();
        }
        if (FetchAssistContext.isExistFetchBeanOnThread()) {
            FetchAssistContext.clearFetchBeanOnThread();
        }
        if (InternalMapContext.isExistInternalMapContextOnThread()) {
            InternalMapContext.clearInternalMapContextOnThread();
        }
        if (ResourceContext.isExistResourceContextOnThread()) {
            ResourceContext.clearResourceContextOnThread();
        }
    }

    public ConditionBean getConditionBean() {
        return this._conditionBean;
    }

    public void setConditionBean(ConditionBean conditionBean) {
        this._conditionBean = conditionBean;
    }

    public EntityRowHandler<? extends Entity> getEntityRowHandler() {
        return this._entityRowHandler;
    }

    public void setEntityRowHandler(EntityRowHandler<? extends Entity> entityRowHandler) {
        this._entityRowHandler = entityRowHandler;
    }

    public OutsideSqlContext getOutsideSqlContext() {
        return this._outsideSqlContext;
    }

    public void setOutsideSqlContext(OutsideSqlContext outsideSqlContext) {
        this._outsideSqlContext = outsideSqlContext;
    }

    public FetchBean getFetchBean() {
        return this._fetchBean;
    }

    public void setFetchBean(FetchBean fetchBean) {
        this._fetchBean = fetchBean;
    }

    public Map<String, Object> getInternalMap() {
        return this._internalMap;
    }

    public void setInternalMap(Map<String, Object> internalMap) {
        this._internalMap = internalMap;
    }

    public ResourceContext getResourceContext() {
        return this._resourceContext;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this._resourceContext = resourceContext;
    }
}

