/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.metadata.LanguageMetaData;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfTypeMappingProperties
extends DfAbstractHelperProperties {
    public static final String KEY_typeMappingMap = "typeMappingMap";
    protected Map<String, Object> _typeMappingMap;
    protected Map<String, Object> _jdbcToJavaNativeMap;
    protected Map<String, String> _nameToJdbcTypeMap;
    protected LanguageMetaData _languageMetaData;

    public DfTypeMappingProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, Object> getTypeMappingMap() {
        if (this._typeMappingMap == null) {
            this._typeMappingMap = this.mapProp("torque.typeMappingMap", DEFAULT_EMPTY_MAP);
        }
        return this._typeMappingMap;
    }

    protected Map<String, Object> getJdbcTypeMappingMap() {
        Map<String, Object> typeMappingMap = this.getTypeMappingMap();
        LinkedHashMap<String, Object> jdbcTypeMappingMap = new LinkedHashMap<String, Object>();
        Set<String> keySet = typeMappingMap.keySet();
        for (String key : keySet) {
            String msg;
            if (key == null) {
                String msg2 = "Invalid typeMappingMap! The key should not be null! But: ";
                msg2 = msg2 + " key=" + key;
                msg2 = msg2 + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg2);
            }
            if (DfTypeMappingProperties.isNameTypeMappingKey(key)) continue;
            Object value = typeMappingMap.get(key);
            if (value == null) {
                msg = "Invalid typeMappingMap! The value should not be null! But: ";
                msg = msg + " key=" + key + " value=" + value;
                msg = msg + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg);
            }
            if (!(value instanceof String)) {
                msg = "Invalid typeMappingMap! The type of the value should be String! But: ";
                msg = msg + " type=" + value.getClass() + " key=" + key + " value=" + value;
                msg = msg + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg);
            }
            String strVal = (String)value;
            if (strVal.trim().length() == 0) {
                String msg3 = "Invalid typeMappingMap! The value should not be empty! But: ";
                msg3 = msg3 + " key=" + key + " value=" + value;
                msg3 = msg3 + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg3);
            }
            jdbcTypeMappingMap.put(key, value);
        }
        return jdbcTypeMappingMap;
    }

    protected Map<String, String> getNameTypeMappingMap() {
        Map<String, Object> typeMappingMap = this.getTypeMappingMap();
        LinkedHashMap<String, String> nameTypeMappingMap = new LinkedHashMap<String, String>();
        Set<String> keySet = typeMappingMap.keySet();
        for (String key : keySet) {
            String msg;
            if (key == null) {
                String msg2 = "Invalid typeMappingMap! The key should not be null! But: ";
                msg2 = msg2 + " key=" + key;
                msg2 = msg2 + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg2);
            }
            if (!DfTypeMappingProperties.isNameTypeMappingKey(key)) continue;
            Object value = typeMappingMap.get(key);
            if (value == null) {
                msg = "Invalid typeMappingMap! The value should not be null! But: ";
                msg = msg + " key=" + key + " value=" + value;
                msg = msg + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg);
            }
            if (!(value instanceof String)) {
                msg = "Invalid typeMappingMap! The type of the value should be String! But: ";
                msg = msg + " type=" + value.getClass() + " key=" + key + " value=" + value;
                msg = msg + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg);
            }
            String strVal = (String)value;
            if (strVal.trim().length() == 0) {
                String msg3 = "Invalid typeMappingMap! The value should not be empty! But: ";
                msg3 = msg3 + " key=" + key + " value=" + value;
                msg3 = msg3 + " typeMappingMap=" + typeMappingMap;
                throw new IllegalStateException(msg3);
            }
            nameTypeMappingMap.put(DfTypeMappingProperties.extractDbTypeName(key), strVal);
        }
        return nameTypeMappingMap;
    }

    static boolean isNameTypeMappingKey(String key) {
        return key.startsWith("$$") && key.endsWith("$$") && key.length() > "$$$$".length();
    }

    static String extractDbTypeName(String key) {
        String realKey = key.substring("$$".length());
        realKey = realKey.substring(0, realKey.length() - "$$".length());
        return realKey;
    }

    public Map<String, Object> getJdbcToJavaNativeMap() {
        if (this._jdbcToJavaNativeMap != null) {
            return this._jdbcToJavaNativeMap;
        }
        if (this.getBasicProperties().isTargetLanguageJava()) {
            Map<String, Object> typeMappingMap = this.getJdbcTypeMappingMap();
            if (typeMappingMap.isEmpty()) {
                Map<String, Object> defaultMap = this.getLanguageMetaData().getJdbcToJavaNativeMap();
                this._jdbcToJavaNativeMap = this.mapProp("torque.jdbcToJavaNativeMap", defaultMap);
            } else {
                this._jdbcToJavaNativeMap = typeMappingMap;
            }
            return this._jdbcToJavaNativeMap;
        }
        Map<String, Object> metaMap = this.getLanguageMetaData().getJdbcToJavaNativeMap();
        if (metaMap.isEmpty()) {
            String msg = "The jdbcToJavaNamtiveMap should not be null: metaData=" + this.getLanguageMetaData();
            throw new IllegalStateException(msg);
        }
        Map<String, Object> typeMappingMap = this.getJdbcTypeMappingMap();
        if (typeMappingMap.isEmpty()) {
            Map<String, Object> defaultMap = this.getLanguageMetaData().getJdbcToJavaNativeMap();
            this._jdbcToJavaNativeMap = this.mapProp("torque.jdbcToJavaNativeMap", defaultMap);
        } else {
            this._jdbcToJavaNativeMap = typeMappingMap;
        }
        if (this._jdbcToJavaNativeMap.isEmpty()) {
            this._jdbcToJavaNativeMap = metaMap;
            return this._jdbcToJavaNativeMap;
        }
        Set<String> keySet = metaMap.keySet();
        for (String key : keySet) {
            Object value = metaMap.get(key);
            if (this._jdbcToJavaNativeMap.containsKey(key)) continue;
            this._jdbcToJavaNativeMap.put(key, value);
        }
        return this._jdbcToJavaNativeMap;
    }

    public Map<String, String> getNameToJdbcTypeMap() {
        if (this._nameToJdbcTypeMap != null) {
            return this._nameToJdbcTypeMap;
        }
        this._nameToJdbcTypeMap = this.getNameTypeMappingMap();
        return this._nameToJdbcTypeMap;
    }

    public List<Object> getJavaNativeStringList() {
        return this.getLanguageMetaData().getStringList();
    }

    public List<Object> getJavaNativeBooleanList() {
        return this.getLanguageMetaData().getBooleanList();
    }

    public List<Object> getJavaNativeNumberList() {
        return this.getLanguageMetaData().getNumberList();
    }

    public List<Object> getJavaNativeDateList() {
        return this.getLanguageMetaData().getDateList();
    }

    public List<Object> getJavaNativeBinaryList() {
        return this.getLanguageMetaData().getBinaryList();
    }

    protected LanguageMetaData getLanguageMetaData() {
        if (this._languageMetaData != null) {
            return this._languageMetaData;
        }
        DfLanguageDependencyInfo languageDependencyInfo = this.getBasicProperties().getLanguageDependencyInfo();
        this._languageMetaData = languageDependencyInfo.createLanguageMetaData();
        return this._languageMetaData;
    }
}

