/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfNameHintUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfFlexDtoProperties
extends DfAbstractHelperProperties {
    protected Map<String, Object> flexDtoDefinitionMap;

    public DfFlexDtoProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, Object> getFlexDtoDefinitionMap() {
        if (this.flexDtoDefinitionMap == null) {
            this.flexDtoDefinitionMap = this.mapProp("torque.flexDtoDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this.flexDtoDefinitionMap;
    }

    public boolean hasFlexDtoDefinition() {
        return !this.getFlexDtoDefinitionMap().isEmpty();
    }

    public boolean isOverrideExtended() {
        return this.isDtoProperty("overrideExtended");
    }

    public boolean isBindable(String tableName) {
        return this.isDtoProperty("bindable") && !this.isBindableTableExcept(tableName);
    }

    protected boolean isBindableTableExcept(String tableName) {
        List<String> exceptList;
        List<String> targetList = this.getBindableTableTargetList();
        return !this.isTargetByHint(tableName, targetList, exceptList = this.getBindableTableExceptList());
    }

    protected boolean isTargetByHint(String name, List<String> targetList, List<String> exceptList) {
        return DfNameHintUtil.isTargetByHint(name, targetList, exceptList);
    }

    protected boolean isHintMatchTheName(String name, String hint) {
        return DfNameHintUtil.isHitByTheHint(name, hint);
    }

    public String getOutputDirectory() {
        String value = (String)this.getFlexDtoDefinitionMap().get("outputDirectory");
        if (value == null) {
            return this.getBasicProperties().getGenerateOutputDirectory();
        }
        return this.getBasicProperties().getGenerateOutputDirectory() + "/" + value;
    }

    public Map<String, String> getJavaToFlexNativeMap() {
        Map<String, Object> map = this.getDtoPropertyMap("javaToFlexNativeMap");
        if (map == null) {
            return new LinkedHashMap<String, String>();
        }
        Set<String> keySet = map.keySet();
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String value = (String)map.get(key);
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public List<String> getBindableTableTargetList() {
        List<String> ls = this.getDtoPropertyList("bindableTableTargetList");
        if (ls == null) {
            return new ArrayList<String>();
        }
        return ls;
    }

    public List<String> getBindableTableExceptList() {
        List<String> ls = this.getDtoPropertyList("bindableTableExceptList");
        if (ls == null) {
            return new ArrayList<String>();
        }
        return ls;
    }

    public String getBaseDtoPackage() {
        return this.getDtoPropertyAsRequired("baseDtoPackage");
    }

    public String getExtendedDtoPackage() {
        return this.getDtoPropertyAsRequired("extendedDtoPackage");
    }

    public String getBaseDtoPrefix() {
        return this.getDtoPropertyIfNullEmpty("baseDtoPrefix");
    }

    public String getBaseDtoSuffix() {
        return this.getDtoPropertyIfNullEmpty("baseDtoSuffix");
    }

    public String getExtendedDtoPrefix() {
        return this.getDtoPropertyIfNullEmpty("extendedDtoPrefix");
    }

    public String getExtendedDtoSuffix() {
        return this.getDtoPropertyIfNullEmpty("extendedDtoSuffix");
    }

    protected String getDtoPropertyAsRequired(String key) {
        String value = this.getDtoProperty(key);
        if (value == null || value.trim().length() == 0) {
            String msg = "The property '" + key + "' should not be null or empty:";
            msg = msg + " flexDtoDefinitionMap=" + this.getFlexDtoDefinitionMap();
            throw new IllegalStateException(msg);
        }
        return value;
    }

    protected String getDtoPropertyIfNullEmpty(String key) {
        String value = this.getDtoProperty(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getDtoProperty(String key) {
        String value = (String)this.getFlexDtoDefinitionMap().get(key);
        return value;
    }

    protected boolean isDtoProperty(String key) {
        String value = (String)this.getFlexDtoDefinitionMap().get(key);
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected Map<String, Object> getDtoPropertyMap(String key) {
        return (Map)this.getFlexDtoDefinitionMap().get(key);
    }

    protected List<String> getDtoPropertyList(String key) {
        return (List)this.getFlexDtoDefinitionMap().get(key);
    }
}

