/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.Map;
import java.util.Properties;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.config.DfDatabaseNameMapping;
import org.seasar.dbflute.exception.DfRequiredPropertyNotFoundException;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfoCSharp;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfoJava;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfoPhp;
import org.seasar.dbflute.helper.language.properties.DfGeneratedClassPackageDefault;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfBasicProperties
extends DfAbstractHelperProperties {
    protected DfLanguageDependencyInfo _languageDependencyInfo;
    public static final String KEY_basicInfoMap = "basicInfoMap";
    protected Map<String, Object> _basicInfoMap;
    protected DBDef _currentDBDef;

    public DfBasicProperties(Properties prop) {
        super(prop);
    }

    public Map<String, Object> getBasicInfoMap() {
        if (this._basicInfoMap == null) {
            this._basicInfoMap = this.mapProp("torque.basicInfoMap", DEFAULT_EMPTY_MAP);
        }
        return this._basicInfoMap;
    }

    public String getProperty(String key, String defaultValue) {
        return this.getPropertyIfNotBuildProp(key, defaultValue, this.getBasicInfoMap());
    }

    public boolean isProperty(String key, boolean defaultValue) {
        return this.isProperty(key, defaultValue, this.getBasicInfoMap());
    }

    public void checkBasicInfo() {
        String databaseName = this.getDatabaseType();
        if (databaseName == null || databaseName.trim().length() == 0) {
            String msg = "Not found the property 'database' in basicInfoMap.dfprop: " + databaseName;
            throw new DfRequiredPropertyNotFoundException(msg);
        }
    }

    public String getProjectName() {
        return this.stringProp("torque.project", "");
    }

    public String getDatabaseType() {
        String databaseType = this.getProperty("database", null);
        if (databaseType == null || databaseType.trim().length() == 0) {
            String msg = "Not found the property 'database' in basicInfoMap.dfprop: " + databaseType;
            throw new DfRequiredPropertyNotFoundException(msg);
        }
        return databaseType;
    }

    public DBDef getCurrentDBDef() {
        if (this._currentDBDef != null) {
            return this._currentDBDef;
        }
        DfDatabaseNameMapping databaseNameMapping = DfDatabaseNameMapping.getInstance();
        this._currentDBDef = databaseNameMapping.findDBDef(this.getDatabaseType());
        return this._currentDBDef;
    }

    public boolean isDatabaseMySQL() {
        return this.getDatabaseType().equalsIgnoreCase("mysql");
    }

    public boolean isDatabasePostgreSQL() {
        return this.getDatabaseType().equalsIgnoreCase("postgresql");
    }

    public boolean isDatabaseOracle() {
        return this.getDatabaseType().equalsIgnoreCase("oracle");
    }

    public boolean isDatabaseDB2() {
        return this.getDatabaseType().equalsIgnoreCase("db2");
    }

    public boolean isDatabaseSqlServer() {
        return this.getDatabaseType().equalsIgnoreCase("mssql");
    }

    public boolean isDatabaseH2() {
        return this.getDatabaseType().equalsIgnoreCase("h2");
    }

    public boolean isDatabaseDerby() {
        return this.getDatabaseType().equalsIgnoreCase("derby");
    }

    public boolean isDatabaseMsAccess() {
        return this.getDatabaseType().equalsIgnoreCase("msaccess");
    }

    public boolean isDatabaseSchemaCanBeOmitted() {
        return this.isDatabaseH2() || this.isDatabasePostgreSQL() || this.isDatabaseMySQL();
    }

    public String getTargetLanguage() {
        return this.getProperty("targetLanguage", "java");
    }

    public String getResourceDirectory() {
        String targetLanguage = this.getTargetLanguage();
        if (this.isTargetLanguageJava() && this.getTargetLanguageVersion().startsWith("1.4")) {
            return targetLanguage + "j14";
        }
        return targetLanguage;
    }

    public boolean isTargetLanguageMain() {
        return this.getBasicProperties().isTargetLanguageJava() || this.getBasicProperties().isTargetLanguageCSharp();
    }

    public boolean isTargetLanguageJava() {
        return "java".equals(this.getTargetLanguage());
    }

    public boolean isTargetLanguageCSharp() {
        return "csharp".equals(this.getTargetLanguage());
    }

    public boolean isTargetLanguagePhp() {
        return "php".equals(this.getTargetLanguage());
    }

    public DfLanguageDependencyInfo getLanguageDependencyInfo() {
        if (this._languageDependencyInfo == null) {
            if (this.isTargetLanguageJava()) {
                this._languageDependencyInfo = new DfLanguageDependencyInfoJava();
            } else if (this.isTargetLanguageCSharp()) {
                this._languageDependencyInfo = new DfLanguageDependencyInfoCSharp();
            } else if (this.isTargetLanguagePhp()) {
                this._languageDependencyInfo = new DfLanguageDependencyInfoPhp();
            } else {
                String msg = "The language is supported: " + this.getTargetLanguage();
                throw new IllegalStateException(msg);
            }
        }
        return this._languageDependencyInfo;
    }

    public String getTargetLanguageVersion() {
        return this.getProperty("targetLanguageVersion", "5.0");
    }

    public boolean isJavaVersionGreaterEqualTiger() {
        String targetLanguageVersion = this.getBasicProperties().getTargetLanguageVersion();
        return this.isTargetLanguageJava() && targetLanguageVersion.compareToIgnoreCase("5.0") >= 0;
    }

    public boolean isJavaVersionGreaterEqualMustang() {
        String targetLanguageVersion = this.getBasicProperties().getTargetLanguageVersion();
        return this.isTargetLanguageJava() && targetLanguageVersion.compareToIgnoreCase("6.0") >= 0;
    }

    public String getTargetContainerName() {
        String containerName = this.getProperty("targetContainer", "seasar");
        this.checkContainer(containerName);
        return containerName;
    }

    public boolean isTargetContainerSeasar() {
        return this.getTargetContainerName().trim().equalsIgnoreCase("seasar");
    }

    public boolean isTargetContainerSpring() {
        return this.getTargetContainerName().trim().equalsIgnoreCase("spring");
    }

    public boolean isTargetContainerLucy() {
        return this.getTargetContainerName().trim().equalsIgnoreCase("lucy");
    }

    public boolean isTargetContainerGuice() {
        return this.getTargetContainerName().trim().equalsIgnoreCase("guice");
    }

    public boolean isTargetContainerSlim3() {
        return this.getTargetContainerName().trim().equalsIgnoreCase("slim3");
    }

    protected void checkContainer(String containerName) {
        if (!((containerName = containerName.toLowerCase()).equals("seasar") || containerName.equals("spring") || containerName.equals("lucy") || containerName.equals("guice") || containerName.equals("slim3"))) {
            String msg = "The targetContainer should be 'seasar' or 'spring' or 'lucy' or 'guice' or 'slim3':";
            msg = msg + " targetContainer=" + containerName;
            throw new IllegalStateException(msg);
        }
    }

    public String getSourceFileEncoding() {
        return this.getProperty("sourceFileEncoding", "UTF-8");
    }

    public String getTemplateFileEncoding() {
        return this.getProperty("templateFileEncoding", "UTF-8");
    }

    public String getProejctSchemaXMLFilePath() {
        StringBuilder sb = new StringBuilder();
        String projectName = this.getBasicProperties().getProjectName();
        sb.append("./schema/project-schema-").append(projectName).append(".xml");
        return sb.toString();
    }

    public String getProejctSchemaXMLEncoding() {
        return this.getProperty("projectSchemaXMLEncoding", "UTF-8");
    }

    public String getTemplateFileExtension() {
        return this.getLanguageDependencyInfo().getTemplateFileExtension();
    }

    public String getClassFileExtension() {
        return this.getLanguageDependencyInfo().getGrammarInfo().getClassFileExtension();
    }

    public String getPackageBase() {
        return this.getProperty("packageBase", "");
    }

    public String getBaseCommonPackage() {
        return this.filterBase(this.getProperty("baseCommonPackage", this.getPackageInfo().getBaseCommonPackage()));
    }

    public String getBaseBehaviorPackage() {
        return this.filterBase(this.getProperty("baseBehaviorPackage", this.getPackageInfo().getBaseBehaviorPackage()));
    }

    public String getBaseDaoPackage() {
        return this.filterBase(this.getProperty("baseDaoPackage", this.getPackageInfo().getBaseDaoPackage()));
    }

    public String getBaseEntityPackage() {
        return this.filterBase(this.getProperty("baseEntityPackage", this.getPackageInfo().getBaseEntityPackage()));
    }

    public String getDBMetaPackage() {
        return this.getBaseEntityPackage() + "." + this.getPackageInfo().getDBMetaSimplePackageName();
    }

    public String getConditionBeanPackage() {
        return this.filterBase(this.getProperty("conditionBeanPackage", this.getPackageInfo().getConditionBeanPackage()));
    }

    public String getExtendedConditionBeanPackage() {
        String pkg = this.getProperty("extendedConditionBeanPackage", null);
        if (pkg != null) {
            return this.filterBase(pkg);
        }
        return this.getConditionBeanPackage();
    }

    protected boolean hasConditionBeanPackage() {
        return this.getProperty("conditionBeanPackage", null) != null;
    }

    public String getExtendedBehaviorPackage() {
        return this.filterBase(this.getProperty("extendedBehaviorPackage", this.getPackageInfo().getExtendedBehaviorPackage()));
    }

    public String getExtendedDaoPackage() {
        return this.filterBase(this.getProperty("extendedDaoPackage", this.getPackageInfo().getExtendedDaoPackage()));
    }

    public String getExtendedEntityPackage() {
        return this.filterBase(this.getProperty("extendedEntityPackage", this.getPackageInfo().getExtendedEntityPackage()));
    }

    protected String filterBase(String packageString) {
        if (this.getPackageBase().trim().length() > 0) {
            return this.getPackageBase() + "." + packageString;
        }
        return packageString;
    }

    protected DfGeneratedClassPackageDefault getPackageInfo() {
        DfLanguageDependencyInfo languageDependencyInfo = this.getBasicProperties().getLanguageDependencyInfo();
        return languageDependencyInfo.getGeneratedClassPackageInfo();
    }

    public String getGenerateOutputDirectory() {
        String property = this.getProperty("generateOutputDirectory", null);
        if (property != null) {
            return property;
        }
        String defaultDirectory = this.getLanguageDependencyInfo().getDefaultGenerateOutputDirectory();
        return this.getProperty("java.dir", defaultDirectory);
    }

    public String getResourceOutputDirectory() {
        return this.getProperty("resourceOutputDirectory", null);
    }

    public String getDefaultResourceOutputDirectory() {
        return this.getLanguageDependencyInfo().getDefaultResourceOutputDirectory();
    }

    public boolean isTableNameCamelCase() {
        boolean defaultProperty = false;
        boolean property = this.isProperty("isTableNameCamelCase", false);
        if (property) {
            return true;
        }
        return this.isProperty("isJavaNameOfTableSameAsDbName", false);
    }

    public boolean isColumnNameCamelCase() {
        boolean defaultProperty = false;
        boolean property = this.isProperty("isColumnNameCamelCase", false);
        if (property) {
            return true;
        }
        return this.isProperty("isJavaNameOfColumnSameAsDbName", false);
    }

    public String getProjectPrefix() {
        return this.getProperty("projectPrefix", "");
    }

    public String getBasePrefix() {
        return "Bs";
    }

    public String getClassAuthor() {
        return this.getProperty("classAuthor", "DBFlute(AutoGenerator)");
    }

    public String getSourceCodeLineSeparator() {
        return "\r\n";
    }

    public boolean isFlatDirectoryPackageValid() {
        String str = this.getFlatDirectoryPackage();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getFlatDirectoryPackage() {
        return this.getProperty("flatDirectoryPackage", null);
    }

    public boolean isOmitDirectoryPackageValid() {
        String str = this.getOmitDirectoryPackage();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getOmitDirectoryPackage() {
        return this.getProperty("omitDirectoryPackage", null);
    }

    public void checkDirectoryPackage() {
        String flatDirectoryPackage = this.getFlatDirectoryPackage();
        String omitDirectoryPackage = this.getOmitDirectoryPackage();
        if (flatDirectoryPackage == null && omitDirectoryPackage == null) {
            return;
        }
        DfLanguageDependencyInfo languageDependencyInfo = this.getBasicProperties().getLanguageDependencyInfo();
        if (!languageDependencyInfo.isFlatOrOmitDirectorySupported()) {
            String msg = "The language does not support flatDirectoryPackage or omitDirectoryPackage:";
            msg = msg + " language=" + this.getBasicProperties().getTargetLanguage();
            throw new IllegalStateException(msg);
        }
    }

    public boolean isAvailableHotDeploy() {
        return this.isProperty("isAvailableHotDeploy", false);
    }

    public String getBehaviorQueryPathBeginMark() {
        return "/*df:BehaviorQueryPathBegin*/";
    }

    public String getBehaviorQueryPathEndMark() {
        return "/*df:BehaviorQueryPathEnd*/";
    }

    public String filterGenericsString(String genericsString) {
        return "<" + genericsString + ">";
    }

    public String filterGenericsDowncast(String genericsDowncast) {
        return "(" + genericsDowncast + ")";
    }

    public String filterGenericsParamOutput(String variableName, String description) {
        return this.filterGenericsGeneralOutput("@param " + variableName + " " + description);
    }

    public String filterGenericsGeneralOutput(String genericsGeneralOutput) {
        return genericsGeneralOutput;
    }

    public String filterGenericsGeneralOutputAfterNewLineOutput(String genericsGeneralOutput) {
        return this.getLineSeparator() + this.filterGenericsGeneralOutput(genericsGeneralOutput);
    }

    public String outputOverrideAnnotation() {
        return this.filterGenericsGeneralOutput("@Override()");
    }

    public String outputOverrideAnnotationAfterNewLineOutput() {
        return this.filterGenericsGeneralOutputAfterNewLineOutput("    @Override()");
    }

    public String outputSuppressWarningsAfterLineSeparator() {
        return this.filterGenericsGeneralOutputAfterNewLineOutput("@SuppressWarnings(\"unchecked\")");
    }

    protected String getLineSeparator() {
        return "\n";
    }
}

