/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfAdditionalForeignKeyProperties
extends DfAbstractHelperProperties {
    public static final String KEY_LOCAL_TABLE_NAME = "localTableName";
    public static final String KEY_FOREIGN_TABLE_NAME = "foreignTableName";
    public static final String KEY_LOCAL_COLUMN_NAME = "localColumnName";
    public static final String KEY_FOREIGN_COLUMN_NAME = "foreignColumnName";
    public static final String KEY_FIXED_CONDITION = "fixedCondition";
    public static final String KEY_FIXED_SUFFIX = "fixedSuffix";
    public static final String KEY_additionalForeignKeyMap = "additionalForeignKeyMap";
    protected Map<String, Map<String, String>> _additionalForeignKeyMap;

    public DfAdditionalForeignKeyProperties(Properties prop) {
        super(prop);
    }

    public Map<String, Map<String, String>> getAdditionalForeignKeyMap() {
        if (this._additionalForeignKeyMap == null) {
            this._additionalForeignKeyMap = this.newLinkedHashMap();
            Map<String, Object> generatedMap = this.mapProp("torque.additionalForeignKeyMap", DEFAULT_EMPTY_MAP);
            Set<String> fisrtKeySet = generatedMap.keySet();
            for (String foreignName : fisrtKeySet) {
                Object firstValue = generatedMap.get(foreignName);
                if (!(firstValue instanceof Map)) {
                    String msg = "The value type should be Map: tableName=" + foreignName + " property=CustomizeDao";
                    msg = msg + " actualType=" + firstValue.getClass() + " actualValue=" + firstValue;
                    throw new IllegalStateException(msg);
                }
                Map foreignDefinitionMap = (Map)firstValue;
                Set secondKeySet = foreignDefinitionMap.keySet();
                LinkedHashMap genericForeignDefinitiontMap = this.newLinkedHashMap();
                for (Object componentName : secondKeySet) {
                    Object secondValue = foreignDefinitionMap.get(componentName);
                    if (secondValue == null) continue;
                    if (!(componentName instanceof String)) {
                        String msg = "The key type should be String: foreignName=" + foreignName;
                        msg = msg + " property=AdditionalForeignKey";
                        msg = msg + " actualType=" + componentName.getClass() + " actualKey=" + componentName;
                        throw new IllegalStateException(msg);
                    }
                    if (!(secondValue instanceof String)) {
                        String msg = "The value type should be String: foreignName=" + foreignName;
                        msg = msg + " property=AdditionalForeignKey";
                        msg = msg + " actualType=" + secondValue.getClass() + " actualValue=" + secondValue;
                        throw new IllegalStateException(msg);
                    }
                    genericForeignDefinitiontMap.put((String)componentName, (String)secondValue);
                }
                this._additionalForeignKeyMap.put(foreignName, genericForeignDefinitiontMap);
            }
        }
        return this._additionalForeignKeyMap;
    }

    public String findLocalTableName(String foreignName) {
        Map<String, String> componentMap = this.getAdditionalForeignKeyMap().get(foreignName);
        return componentMap.get(KEY_LOCAL_TABLE_NAME);
    }

    public String findForeignTableName(String foreignName) {
        Map<String, String> componentMap = this.getAdditionalForeignKeyMap().get(foreignName);
        return componentMap.get(KEY_FOREIGN_TABLE_NAME);
    }

    protected String findLocalColumnName(String foreignName) {
        Map<String, String> componentMap = this.getAdditionalForeignKeyMap().get(foreignName);
        return componentMap.get(KEY_LOCAL_COLUMN_NAME);
    }

    protected String findForeignColumnName(String foreignName) {
        Map<String, String> componentMap = this.getAdditionalForeignKeyMap().get(foreignName);
        return componentMap.get(KEY_FOREIGN_COLUMN_NAME);
    }

    public String findFixedCondition(String foreignName) {
        Map<String, String> componentMap = this.getAdditionalForeignKeyMap().get(foreignName);
        String fixedCondition = componentMap.get(KEY_FIXED_CONDITION);
        if (fixedCondition != null && fixedCondition.trim().length() > 0) {
            fixedCondition = DfStringUtil.replace((String)fixedCondition, (String)"$$ALIAS$$", (String)"$$alias$$");
            fixedCondition = DfStringUtil.replace((String)fixedCondition, (String)"$$ForeignAlias$$", (String)"$$foreignAlias$$");
            fixedCondition = DfStringUtil.replace((String)fixedCondition, (String)"$$LocalAlias$$", (String)"$$localAlias$$");
        }
        return fixedCondition;
    }

    public String findFixedSuffix(String foreignName) {
        Map<String, String> componentMap = this.getAdditionalForeignKeyMap().get(foreignName);
        return componentMap.get(KEY_FIXED_SUFFIX);
    }

    public List<String> findLocalColumnNameList(String foreignName) {
        String property = this.findLocalColumnName(foreignName);
        if (property == null || property.trim().length() == 0) {
            return null;
        }
        ArrayList<String> localColumnNameList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(property, "/");
        while (st.hasMoreElements()) {
            localColumnNameList.add(st.nextToken());
        }
        return localColumnNameList;
    }

    public List<String> findForeignColumnNameList(String foreignName) {
        String property = this.findForeignColumnName(foreignName);
        if (property == null || property.trim().length() == 0) {
            return null;
        }
        ArrayList<String> foreignColumnNameList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(property, "/");
        while (st.hasMoreElements()) {
            foreignColumnNameList.add(st.nextToken());
        }
        return foreignColumnNameList;
    }
}

