/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.schemainitializer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.logic.jdbc.handler.DfForeignKeyHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfTableHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerJdbc
implements DfSchemaInitializer {
    private static final Log _log = LogFactory.getLog(DfSchemaInitializerJdbc.class);
    protected DataSource _dataSource;
    protected String _schema;
    protected boolean _tableNameWithSchema;
    protected List<String> _dropObjectTypeList;
    protected List<String> _dropTableTargetList;
    protected List<String> _dropTableExceptList;
    protected boolean _dropGenerateTableOnly;
    protected boolean _dropGenerateProcedureOnly;
    protected boolean _suppressTruncateTable;
    protected boolean _suppressDropForeignKey;
    protected boolean _suppressDropTable;
    protected boolean _suppressDropSequence;
    protected boolean _suppressDropProcedure;
    protected boolean _suppressDropDBLink;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initializeSchema() {
        List<DfTableMetaInfo> tableMetaInfoList;
        Connection conn = null;
        conn = this._dataSource.getConnection();
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            DfTableHandler tableNameHandler = new DfTableHandler(){

                @Override
                protected String[] getRealObjectTypeTargetArray(String schemaName) {
                    if (DfSchemaInitializerJdbc.this._dropObjectTypeList != null) {
                        return DfSchemaInitializerJdbc.this._dropObjectTypeList.toArray(new String[0]);
                    }
                    return super.getRealObjectTypeTargetArray(schemaName);
                }

                @Override
                protected List<String> getRealTableExceptList(String schemaName) {
                    if (DfSchemaInitializerJdbc.this._dropTableExceptList != null) {
                        return DfSchemaInitializerJdbc.this._dropTableExceptList;
                    }
                    if (DfSchemaInitializerJdbc.this._dropGenerateTableOnly) {
                        return super.getRealTableExceptList(schemaName);
                    }
                    return new ArrayList<String>();
                }

                @Override
                protected List<String> getRealTableTargetList(String schemaName) {
                    if (DfSchemaInitializerJdbc.this._dropTableTargetList != null) {
                        return DfSchemaInitializerJdbc.this._dropTableTargetList;
                    }
                    if (DfSchemaInitializerJdbc.this._dropGenerateTableOnly) {
                        return super.getRealTableTargetList(schemaName);
                    }
                    return new ArrayList<String>();
                }
            };
            tableMetaInfoList = tableNameHandler.getTableList(dbMetaData, this._schema);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.executeObject(conn, tableMetaInfoList);
        Object var6_8 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException ignored) {
            _log.info((Object)"connection.close() threw the exception!", (Throwable)ignored);
        }
        return;
        {
            catch (SQLException e) {
                String msg = "Failed to the initialize schema: " + this._schema;
                throw new SQLFailureException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                _log.info((Object)"connection.close() threw the exception!", (Throwable)ignored);
            }
            throw throwable;
        }
    }

    protected void executeObject(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        if (!this._suppressTruncateTable) {
            this.truncateTableIfPossible(conn, tableMetaInfoList);
        } else {
            _log.info((Object)"*Suppress truncating tables");
        }
        if (!this._suppressDropForeignKey) {
            this.dropForeignKey(conn, tableMetaInfoList);
        } else {
            _log.info((Object)"*Suppress dropping foreign keys");
        }
        if (!this._suppressDropTable) {
            this.dropTable(conn, tableMetaInfoList);
        } else {
            _log.info((Object)"*Suppress dropping tables");
        }
        if (!this._suppressDropSequence) {
            this.dropSequence(conn, tableMetaInfoList);
        } else {
            _log.info((Object)"*Suppress dropping sequences");
        }
        if (!this._suppressDropProcedure) {
            this.dropProcedure(conn, tableMetaInfoList);
        } else {
            _log.info((Object)"*Suppress dropping procedures");
        }
        if (!this._suppressDropDBLink) {
            this.dropDBLink(conn, tableMetaInfoList);
        } else {
            _log.info((Object)"*Suppress dropping DB links");
        }
    }

    protected void truncateTableIfPossible(Connection connection, List<DfTableMetaInfo> tableMetaInfoList) {
        DfTruncateTableByJdbcCallback callback = new DfTruncateTableByJdbcCallback(){

            public String buildTruncateTableSql(DfTableMetaInfo metaInfo) {
                StringBuilder sb = new StringBuilder();
                sb.append("truncate table ").append(DfSchemaInitializerJdbc.this.filterTableName(metaInfo.getTableName()));
                return sb.toString();
            }
        };
        this.callbackTruncateTableByJdbc(connection, tableMetaInfoList, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void callbackTruncateTableByJdbc(Connection connection, List<DfTableMetaInfo> tableMetaInfoList, DfTruncateTableByJdbcCallback callback) {
        for (DfTableMetaInfo metaInfo : tableMetaInfoList) {
            String truncateTableSql = callback.buildTruncateTableSql(metaInfo);
            Statement statement = null;
            statement = connection.createStatement();
            statement.execute(truncateTableSql);
            _log.info((Object)truncateTableSql);
            Object var10_9 = null;
            if (statement == null) continue;
            try {
                statement.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
            }
            continue;
            {
                catch (Exception e) {
                    var10_9 = null;
                    if (statement == null) continue;
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
                    }
                }
                throw throwable;
            }
        }
    }

    protected void dropForeignKey(Connection connection, List<DfTableMetaInfo> tableMetaInfoList) {
        DfDropForeignKeyByJdbcCallback callback = new DfDropForeignKeyByJdbcCallback(){

            public String buildDropForeignKeySql(DfForeignKeyMetaInfo metaInfo) {
                String foreignKeyName = metaInfo.getForeignKeyName();
                String localTableName = DfSchemaInitializerJdbc.this.filterTableName(metaInfo.getLocalTableName());
                StringBuilder sb = new StringBuilder();
                sb.append("alter table ").append(localTableName).append(" drop constraint ").append(foreignKeyName);
                return sb.toString();
            }
        };
        this.callbackDropForeignKeyByJdbc(connection, tableMetaInfoList, callback);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void callbackDropForeignKeyByJdbc(Connection conn, List<DfTableMetaInfo> tableMetaInfoList, DfDropForeignKeyByJdbcCallback callback) {
        Statement statement = null;
        statement = conn.createStatement();
        for (DfTableMetaInfo tableMetaInfo : tableMetaInfoList) {
            if (this.isSkipDropForeignKey(tableMetaInfo)) continue;
            DfForeignKeyHandler handler = new DfForeignKeyHandler(){

                @Override
                protected List<String> getRealTableExceptList(String schemaName) {
                    if (DfSchemaInitializerJdbc.this._dropTableExceptList != null) {
                        return DfSchemaInitializerJdbc.this._dropTableExceptList;
                    }
                    if (DfSchemaInitializerJdbc.this._dropGenerateTableOnly) {
                        return super.getRealTableExceptList(schemaName);
                    }
                    return new ArrayList<String>();
                }

                @Override
                protected List<String> getRealTableTargetList(String schemaName) {
                    if (DfSchemaInitializerJdbc.this._dropTableTargetList != null) {
                        return DfSchemaInitializerJdbc.this._dropTableTargetList;
                    }
                    if (DfSchemaInitializerJdbc.this._dropGenerateTableOnly) {
                        return super.getRealTableTargetList(schemaName);
                    }
                    return new ArrayList<String>();
                }
            };
            DatabaseMetaData dbMetaData = conn.getMetaData();
            Map<String, DfForeignKeyMetaInfo> foreignKeyMetaInfoMap = handler.getForeignKeyMetaInfo(dbMetaData, this._schema, tableMetaInfo);
            Set<String> keySet = foreignKeyMetaInfoMap.keySet();
            for (String foreignKeyName : keySet) {
                DfForeignKeyMetaInfo foreignKeyMetaInfo = foreignKeyMetaInfoMap.get(foreignKeyName);
                String dropForeignKeySql = callback.buildDropForeignKeySql(foreignKeyMetaInfo);
                _log.info((Object)dropForeignKeySql);
                statement.execute(dropForeignKeySql);
            }
        }
        Object var16_17 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException ignored) {
            _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
        }
        return;
        {
            catch (SQLException e) {
                String msg = "Failed to drop foreign keys!";
                throw new SQLFailureException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
            }
            throw throwable;
        }
    }

    protected boolean isSkipDropForeignKey(DfTableMetaInfo tableMetaInfo) {
        return false;
    }

    protected void dropTable(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        ArrayList<DfTableMetaInfo> viewList = new ArrayList<DfTableMetaInfo>();
        ArrayList<DfTableMetaInfo> otherList = new ArrayList<DfTableMetaInfo>();
        for (DfTableMetaInfo tableMetaInfo : tableMetaInfoList) {
            if (tableMetaInfo.isTableTypeView()) {
                viewList.add(tableMetaInfo);
                continue;
            }
            otherList.add(tableMetaInfo);
        }
        ArrayList<DfTableMetaInfo> sortedList = new ArrayList<DfTableMetaInfo>();
        sortedList.addAll(viewList);
        sortedList.addAll(otherList);
        this.callbackDropTableByJdbc(conn, sortedList, new DfDropTableByJdbcCallback(){

            public String buildDropTableSql(DfTableMetaInfo metaInfo) {
                StringBuilder sb = new StringBuilder();
                DfSchemaInitializerJdbc.this.setupDropTable(sb, metaInfo);
                return sb.toString();
            }

            public String buildDropMaterializedViewSql(DfTableMetaInfo metaInfo) {
                StringBuilder sb = new StringBuilder();
                sb.append("drop materialized view ").append(metaInfo.getTableName());
                return sb.toString();
            }
        });
    }

    protected void setupDropTable(StringBuilder sb, DfTableMetaInfo metaInfo) {
        String tableName = this.filterTableName(metaInfo.getTableName());
        if (metaInfo.isTableTypeView()) {
            sb.append("drop view ").append(tableName);
        } else {
            sb.append("drop table ").append(tableName);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void callbackDropTableByJdbc(Connection conn, List<DfTableMetaInfo> tableMetaInfoList, DfDropTableByJdbcCallback callback) {
        String currentSql = null;
        Statement st = null;
        st = conn.createStatement();
        for (DfTableMetaInfo metaInfo : tableMetaInfoList) {
            String dropTableSql;
            currentSql = dropTableSql = callback.buildDropTableSql(metaInfo);
            _log.info((Object)dropTableSql);
            try {
                st.execute(dropTableSql);
            }
            catch (SQLException e) {
                String dropMaterializedViewSql = callback.buildDropMaterializedViewSql(metaInfo);
                try {
                    st.execute(dropMaterializedViewSql);
                    _log.info((Object)("  (o) retry: " + dropMaterializedViewSql));
                }
                catch (SQLException ignored) {
                    _log.info((Object)("  (x) retry: " + dropMaterializedViewSql));
                    throw e;
                }
            }
        }
        Object var13_14 = null;
        if (st == null) return;
        try {
            st.close();
            return;
        }
        catch (SQLException ignored) {
            _log.info((Object)"Statement#close() threw the exception!", (Throwable)ignored);
        }
        return;
        {
            catch (SQLException e) {
                String msg = "Failed to drop the table: " + currentSql;
                throw new SQLFailureException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                _log.info((Object)"Statement#close() threw the exception!", (Throwable)ignored);
            }
            throw throwable;
        }
    }

    protected void dropSequence(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
    }

    protected void dropProcedure(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        List<DfProcedureMetaInfo> procedureList;
        DatabaseMetaData metaData;
        DfProcedureHandler handler = new DfProcedureHandler();
        handler.suppressAdditionalSchema();
        try {
            metaData = conn.getMetaData();
        }
        catch (SQLException e) {
            String msg = "Failed to get meta data of the connection:";
            msg = msg + " connection=" + conn;
            throw new SQLFailureException(msg, e);
        }
        try {
            if (this._dropGenerateProcedureOnly) {
                Map<String, DfProcedureMetaInfo> procedureMap = handler.getAvailableProcedureMap(metaData);
                procedureList = new ArrayList<DfProcedureMetaInfo>(procedureMap.values());
            } else {
                procedureList = handler.getPlainProcedureList(metaData, this._schema);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get procedure meta data: " + this._schema;
            throw new IllegalStateException(msg, e);
        }
        this.callbackDropProcedureByJdbc(conn, procedureList, this.createDropProcedureByJdbcCallback());
    }

    protected DfDropProcedureByJdbcCallback createDropProcedureByJdbcCallback() {
        return new DfDropProcedureByJdbcCallback(){

            public String buildDropProcedureSql(DfProcedureMetaInfo metaInfo) {
                return "drop procedure " + DfSchemaInitializerJdbc.this.buildProcedureSqlName(metaInfo);
            }

            public String buildDropFunctionSql(DfProcedureMetaInfo metaInfo) {
                return "drop function " + DfSchemaInitializerJdbc.this.buildProcedureSqlName(metaInfo);
            }
        };
    }

    protected String buildProcedureSqlName(DfProcedureMetaInfo metaInfo) {
        return metaInfo.getProcedureSqlName();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void callbackDropProcedureByJdbc(Connection conn, List<DfProcedureMetaInfo> procedureMetaInfoList, DfDropProcedureByJdbcCallback callback) {
        String currentSql = null;
        Statement st = null;
        st = conn.createStatement();
        for (DfProcedureMetaInfo metaInfo : procedureMetaInfoList) {
            String dropProcedureSql;
            currentSql = dropProcedureSql = callback.buildDropProcedureSql(metaInfo);
            _log.info((Object)dropProcedureSql);
            try {
                st.execute(dropProcedureSql);
            }
            catch (SQLException e) {
                String dropFunctionSql = callback.buildDropFunctionSql(metaInfo);
                try {
                    st.execute(dropFunctionSql);
                    _log.info((Object)("  (o) retry: " + dropFunctionSql));
                }
                catch (SQLException ignored) {
                    _log.info((Object)("  (x) retry: " + dropFunctionSql));
                    this.handlePackageProcedure(metaInfo, st, e);
                }
            }
        }
        Object var13_14 = null;
        if (st == null) return;
        try {
            st.close();
            return;
        }
        catch (SQLException ignored) {
            _log.info((Object)"Statement#close() threw the exception!", (Throwable)ignored);
        }
        return;
        {
            catch (SQLException e) {
                String msg = "Failed to drop the procedure: " + currentSql;
                throw new SQLFailureException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                _log.info((Object)"Statement#close() threw the exception!", (Throwable)ignored);
            }
            throw throwable;
        }
    }

    protected void handlePackageProcedure(DfProcedureMetaInfo metaInfo, Statement st, SQLException e) throws SQLException {
        throw e;
    }

    protected void dropDBLink(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
    }

    protected String filterTableName(String tableName) {
        if (this._tableNameWithSchema && this._schema != null && this._schema.trim().length() > 0) {
            tableName = this._schema + "." + tableName;
        }
        return tableName;
    }

    protected String ln() {
        return "\n";
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public boolean isTableNameWithSchema() {
        return this._tableNameWithSchema;
    }

    public void setTableNameWithSchema(boolean tableNameWithSchema) {
        this._tableNameWithSchema = tableNameWithSchema;
    }

    public void setDropObjectTypeList(List<String> dropObjectTypeList) {
        this._dropObjectTypeList = dropObjectTypeList;
    }

    public void setDropTableTargetList(List<String> dropTableTargetList) {
        this._dropTableTargetList = dropTableTargetList;
    }

    public void setDropTableExceptList(List<String> dropTableExceptList) {
        this._dropTableExceptList = dropTableExceptList;
    }

    public void setDropGenerateTableOnly(boolean dropGenerateTableOnly) {
        this._dropGenerateTableOnly = dropGenerateTableOnly;
    }

    public void setDropGenerateProcedureOnly(boolean dropGenerateProcedureOnly) {
        this._dropGenerateProcedureOnly = dropGenerateProcedureOnly;
    }

    public boolean isSuppressTruncateTable() {
        return this._suppressTruncateTable;
    }

    public void setSuppressTruncateTable(boolean suppressTruncateTable) {
        this._suppressTruncateTable = suppressTruncateTable;
    }

    public boolean isSuppressDropForeignKey() {
        return this._suppressDropForeignKey;
    }

    public void setSuppressDropForeignKey(boolean suppressDropForeignKey) {
        this._suppressDropForeignKey = suppressDropForeignKey;
    }

    public boolean isSuppressDropTable() {
        return this._suppressDropTable;
    }

    public void setSuppressDropTable(boolean suppressDropTable) {
        this._suppressDropTable = suppressDropTable;
    }

    public boolean isSuppressDropSequence() {
        return this._suppressDropSequence;
    }

    public void setSuppressDropSequence(boolean suppressDropSequence) {
        this._suppressDropSequence = suppressDropSequence;
    }

    public boolean isSuppressDropProcedure() {
        return this._suppressDropProcedure;
    }

    public void setSuppressDropProcedure(boolean suppressDropProcedure) {
        this._suppressDropProcedure = suppressDropProcedure;
    }

    public boolean isSuppressDropDBLink() {
        return this._suppressDropDBLink;
    }

    public void setSuppressDropDBLink(boolean suppressDropDBLink) {
        this._suppressDropDBLink = suppressDropDBLink;
    }

    public static interface DfDropProcedureByJdbcCallback {
        public String buildDropProcedureSql(DfProcedureMetaInfo var1);

        public String buildDropFunctionSql(DfProcedureMetaInfo var1);
    }

    protected static interface DfDropTableByJdbcCallback {
        public String buildDropTableSql(DfTableMetaInfo var1);

        public String buildDropMaterializedViewSql(DfTableMetaInfo var1);
    }

    protected static interface DfDropForeignKeyByJdbcCallback {
        public String buildDropForeignKeySql(DfForeignKeyMetaInfo var1);
    }

    protected static interface DfTruncateTableByJdbcCallback {
        public String buildTruncateTableSql(DfTableMetaInfo var1);
    }
}

