/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.schemahtml;

import org.apache.torque.engine.database.model.ForeignKey;
import org.seasar.dbflute.properties.DfDocumentProperties;

public class DfSchemaHtmlBuilder {
    protected DfDocumentProperties _documentProperties;

    public DfSchemaHtmlBuilder(DfDocumentProperties documentProperties) {
        this._documentProperties = documentProperties;
    }

    public String buildRelatedTableLink(ForeignKey fk, String name, String delimiter) {
        String contentName;
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter);
        String baseTitle = fk.getName();
        if (fk.isAdditionalForeignKey()) {
            String addtionalBaseTitle = baseTitle;
            if (fk.hasFixedCondition()) {
                String fixedCondition = fk.getFixedCondition();
                String title = this.resolveTitle(addtionalBaseTitle + ": fixedCondition=\"" + fixedCondition + "\"");
                sb.append("<a href=\"#" + name + "\" class=\"additionalfk\" title=\"" + title + "\">");
            } else {
                String title = this.resolveTitle(addtionalBaseTitle);
                sb.append("<a href=\"#" + name + "\" class=\"additionalfk\" title=\"" + title + "\">");
            }
            contentName = name + (fk.hasFixedSuffix() ? "(" + fk.getFixedSuffix() + ")" : "");
        } else {
            String title = this.resolveTitle(baseTitle);
            sb.append("<a href=\"#" + name + "\" title=\"" + title + "\">");
            contentName = name;
        }
        sb.append(contentName).append("</a>");
        return sb.toString();
    }

    protected String resolveTitle(String title) {
        return this._documentProperties.resolveAttributeForSchemaHtml(title);
    }
}

