/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.synonym;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfProcedureSynonymExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureSynonymExtractorOracle
implements DfProcedureSynonymExtractor {
    private static final Log _log = LogFactory.getLog(DfProcedureSynonymExtractorOracle.class);
    protected DataSource _dataSource;
    protected List<String> _allSchemaList;

    /*
     * Loose catch block
     */
    @Override
    public Map<String, DfProcedureSynonymMetaInfo> extractProcedureSynonymMap() {
        StringKeyMap procedureSynonymMap;
        block23: {
            SQLException ignored2222;
            ResultSet rs;
            Statement statement;
            Connection conn;
            String sql;
            block21: {
                procedureSynonymMap = StringKeyMap.createAsFlexibleOrdered();
                sql = this.buildSynonymSelect();
                conn = null;
                statement = null;
                rs = null;
                conn = this._dataSource.getConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                LinkedHashMap<String, DfProcedureMetaInfo> procedureFullNameKeyMap = new LinkedHashMap<String, DfProcedureMetaInfo>();
                ArrayList<DfProcedureMetaInfo> procedureList = new ArrayList<DfProcedureMetaInfo>();
                DfProcedureHandler procedureHandler = new DfProcedureHandler();
                for (String schemaName : this._allSchemaList) {
                    procedureList.addAll(procedureHandler.getPlainProcedureList(metaData, schemaName));
                }
                for (DfProcedureMetaInfo metaInfo : procedureList) {
                    String procedureFullName = metaInfo.getProcedureFullName();
                    procedureFullNameKeyMap.put(procedureFullName, metaInfo);
                }
                statement = conn.createStatement();
                _log.info((Object)sql);
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String procedureKey;
                    DfProcedureMetaInfo procedureMetaInfo;
                    String synonymOwner = rs.getString("OWNER");
                    String synonymName = rs.getString("SYNONYM_NAME");
                    String tableOwner = rs.getString("TABLE_OWNER");
                    String tableName = rs.getString("TABLE_NAME");
                    String dbLinkName = rs.getString("DB_LINK");
                    DfSynonymMetaInfo synonymMetaInfo = new DfSynonymMetaInfo();
                    synonymMetaInfo.setSynonymOwner(synonymOwner);
                    synonymMetaInfo.setSynonymName(synonymName);
                    synonymMetaInfo.setTableOwner(tableOwner);
                    synonymMetaInfo.setTableName(tableName);
                    synonymMetaInfo.setDbLinkName(dbLinkName);
                    this.judgeSynonymSelectable(synonymMetaInfo);
                    if (synonymMetaInfo.isSelectable() || dbLinkName != null && dbLinkName.trim().length() > 0 || tableOwner == null || tableOwner.trim().length() == 0 || (procedureMetaInfo = (DfProcedureMetaInfo)procedureFullNameKeyMap.get(procedureKey = tableOwner + "." + tableName)) == null) continue;
                    procedureMetaInfo.setProcedureSynonym(true);
                    DfProcedureSynonymMetaInfo procedureSynonymMetaInfo = new DfProcedureSynonymMetaInfo();
                    procedureSynonymMetaInfo.setProcedureMetaInfo(procedureMetaInfo);
                    procedureSynonymMetaInfo.setSynonymMetaInfo(synonymMetaInfo);
                    String synonymKey = this.buildSynonymMapKey(synonymOwner, synonymName);
                    procedureSynonymMap.put(synonymKey, procedureSynonymMetaInfo);
                }
                Object var21_22 = null;
                if (statement == null) break block21;
                try {
                    statement.close();
                }
                catch (SQLException ignored2222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignored2222) {}
            }
            break block23;
            {
                catch (SQLException e) {
                    String msg = "Failed to get procedure synonyms: sql=" + sql;
                    throw new SQLFailureException(msg, e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored2222;
                Object var21_23 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return procedureSynonymMap;
    }

    protected String buildSynonymSelect() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String schema : this._allSchemaList) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("'").append(schema).append("'");
            ++count;
        }
        String sql = "select * from ALL_SYNONYMS where OWNER in (" + sb.toString() + ")";
        return sql;
    }

    protected String buildSynonymMapKey(String synonymOwner, String synonymName) {
        return synonymOwner + "." + synonymName;
    }

    protected void judgeSynonymSelectable(DfSynonymMetaInfo info) {
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String synonymOwner = info.getSynonymOwner();
        String synonymName = info.getSynonymName();
        String sql = "select * from " + synonymOwner + "." + synonymName + " where 0=1";
        try {
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add("dummy");
            facade.selectStringList(sql, columnList);
            info.setSelectable(true);
        }
        catch (RuntimeException ignored) {
            info.setSelectable(false);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setAllSchemaList(List<String> allSchemaList) {
        this._allSchemaList = allSchemaList;
    }
}

