/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureMetaInfo {
    protected String procedureCatalog;
    protected String procedureSchema;
    protected String procedureName;
    protected String procedureFullName;
    protected String procedureSqlName;
    protected DfProcedureType procedureType;
    protected String procedureUniqueName;
    protected String procedureComment;
    protected boolean procedureSynonym;
    protected List<DfProcedureColumnMetaInfo> procedureColumnMetaInfoList = new ArrayList<DfProcedureColumnMetaInfo>();

    public String getProcedureDisplayNameForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        DfBasicProperties basicProp = DfBuildProperties.getInstance().getBasicProperties();
        DfDatabaseProperties databaseProp = DfBuildProperties.getInstance().getDatabaseProperties();
        if (basicProp.isDatabaseOracle()) {
            if (databaseProp.hasAdditionalSchema() && DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.procedureSchema)) {
                sb.append(this.procedureSchema).append(".");
            }
            if (DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.procedureCatalog)) {
                sb.append(this.procedureCatalog).append(".");
            }
        } else {
            if (DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.procedureCatalog)) {
                sb.append(this.procedureCatalog).append(".");
            }
            if (databaseProp.hasAdditionalSchema() && DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.procedureSchema)) {
                sb.append(this.procedureSchema).append(".");
            }
        }
        sb.append(this.procedureName);
        String typeDisp = this.procedureType.alias() + (this.procedureSynonym ? ", Synonym" : "");
        sb.append(" <span class=\"type\">(").append(typeDisp).append(")</span>");
        return sb.toString();
    }

    public boolean hasProcedureComment() {
        return DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.procedureComment);
    }

    public String getProcedureCommentForSchemaHtml() {
        DfDocumentProperties prop = DfBuildProperties.getInstance().getDocumentProperties();
        String comment = this.procedureComment;
        comment = prop.resolvePreTextForSchemaHtml(comment);
        return comment;
    }

    public String toString() {
        return "{" + this.procedureFullName + ", " + (Object)((Object)this.procedureType) + ", " + this.procedureComment + ", " + this.procedureColumnMetaInfoList + "}";
    }

    public String getProcedureCatalog() {
        return this.procedureCatalog;
    }

    public void setProcedureCatalog(String procedureCatalog) {
        this.procedureCatalog = procedureCatalog;
    }

    public String getProcedureSchema() {
        return this.procedureSchema;
    }

    public void setProcedureSchema(String procedureSchema) {
        this.procedureSchema = procedureSchema;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getProcedureFullName() {
        return this.procedureFullName;
    }

    public void setProcedureFullName(String procedureFullName) {
        this.procedureFullName = procedureFullName;
    }

    public String getProcedureSqlName() {
        return this.procedureSqlName;
    }

    public void setProcedureSqlName(String procedureSqlName) {
        this.procedureSqlName = procedureSqlName;
    }

    public String getProcedureUniqueName() {
        return this.procedureUniqueName;
    }

    public void setProcedureUniqueName(String procedureUniqueName) {
        this.procedureUniqueName = procedureUniqueName;
    }

    public DfProcedureType getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(DfProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    public String getProcedureComment() {
        return this.procedureComment;
    }

    public void setProcedureComment(String procedureComment) {
        this.procedureComment = procedureComment;
    }

    public boolean isProcedureSynonym() {
        return this.procedureSynonym;
    }

    public void setProcedureSynonym(boolean procedureSynonym) {
        this.procedureSynonym = procedureSynonym;
    }

    public List<DfProcedureColumnMetaInfo> getProcedureColumnMetaInfoList() {
        return this.procedureColumnMetaInfoList;
    }

    public void addProcedureColumnMetaInfo(DfProcedureColumnMetaInfo procedureColumnMetaInfo) {
        this.procedureColumnMetaInfoList.add(procedureColumnMetaInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DfProcedureType {
        procedureResultUnknown("ResultUnknown"),
        procedureNoResult("NoResult"),
        procedureReturnsResult("ReturnsResult");

        private String _alias;

        private DfProcedureType(String alias) {
            this._alias = alias;
        }

        public String alias() {
            return this._alias;
        }
    }
}

