/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.identity;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.logic.jdbc.metadata.identity.DfIdentityExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfIdentityExtractorDB2
implements DfIdentityExtractor {
    protected DataSource _dataSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> extractIdentityMap() {
        HashMap<String, String> hashMap;
        Connection conn;
        try {
            conn = this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        try {
            try {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                Statement statement = conn.createStatement();
                ResultSet rs = statement.executeQuery("select * from SYSCAT.COLUMNS where GENERATED != ' '");
                while (rs.next()) {
                    String tableName = rs.getString("TABNAME");
                    String columnName = rs.getString("COLNAME");
                    String generated = rs.getString("GENERATED");
                    if (generated == null || generated.trim().length() == 0) continue;
                    resultMap.put(tableName, columnName);
                }
                hashMap = resultMap;
                Object var9_10 = null;
                if (conn == null) return hashMap;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException ignored) {
            // empty catch block
            return hashMap;
        }
        conn.close();
        return hashMap;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }
}

