/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfForeignKeyHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfForeignKeyHandler.class);
    protected Set<String> _refTableCheckSet;

    public Map<String, DfForeignKeyMetaInfo> getForeignKeyMetaInfo(DatabaseMetaData dbMeta, String schemaName, DfTableMetaInfo tableMetaInfo) throws SQLException {
        schemaName = this.filterSchemaName(schemaName);
        schemaName = tableMetaInfo.selectMetaExtractingSchemaName(schemaName);
        String tableName = tableMetaInfo.getTableName();
        return this.getForeignKeyMetaInfo(dbMeta, schemaName, tableName);
    }

    public Map<String, DfForeignKeyMetaInfo> getForeignKeyMetaInfo(DatabaseMetaData dbMeta, String schemaName, String tableName) throws SQLException {
        Map<String, DfForeignKeyMetaInfo> resultMap = this.doGetForeignKeyMetaInfo(dbMeta, schemaName, tableName);
        if (resultMap.isEmpty()) {
            resultMap = this.doGetForeignKeyMetaInfo(dbMeta, schemaName, tableName.toLowerCase());
        }
        if (resultMap.isEmpty()) {
            resultMap = this.doGetForeignKeyMetaInfo(dbMeta, schemaName, tableName.toUpperCase());
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, DfForeignKeyMetaInfo> doGetForeignKeyMetaInfo(DatabaseMetaData dbMeta, String schemaName, String tableName) throws SQLException {
        LinkedHashMap<String, String> exceptedFKKeyMap;
        LinkedHashMap<String, DfForeignKeyMetaInfo> fkMap;
        block10: {
            fkMap = new LinkedHashMap<String, DfForeignKeyMetaInfo>();
            if (!this.isForeignKeyExtractingSupported()) {
                return fkMap;
            }
            exceptedFKKeyMap = new LinkedHashMap<String, String>();
            ResultSet foreignKeys = null;
            try {
                foreignKeys = dbMeta.getImportedKeys(null, schemaName, tableName);
                while (foreignKeys.next()) {
                    String foreignSchemaName = foreignKeys.getString(2);
                    String foreignTableName = foreignKeys.getString(3);
                    String fkName = foreignKeys.getString(12);
                    if (fkName == null) {
                        fkName = foreignTableName;
                    }
                    if (this._refTableCheckSet != null && !this._refTableCheckSet.contains(foreignTableName)) {
                        exceptedFKKeyMap.put(fkName, foreignTableName);
                        continue;
                    }
                    String localColumnName = foreignKeys.getString(8);
                    String foreignColumnName = foreignKeys.getString(4);
                    this.assertFKColumnNotExcepted(schemaName, tableName, localColumnName);
                    this.assertPKColumnNotExcepted(foreignSchemaName, foreignTableName, foreignColumnName);
                    DfForeignKeyMetaInfo metaInfo = (DfForeignKeyMetaInfo)fkMap.get(fkName);
                    if (metaInfo == null) {
                        metaInfo = new DfForeignKeyMetaInfo();
                        metaInfo.setForeignKeyName(fkName);
                        metaInfo.setLocalTableName(tableName);
                        metaInfo.setForeignTableName(foreignTableName);
                        fkMap.put(fkName, metaInfo);
                    }
                    metaInfo.putColumnNameMap(localColumnName, foreignColumnName);
                }
                Object var14_13 = null;
                if (foreignKeys == null) break block10;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (foreignKeys != null) {
                    foreignKeys.close();
                }
                throw throwable;
            }
            foreignKeys.close();
        }
        if (!exceptedFKKeyMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("...Excepting foreign keys from the table:").append(this.ln()).append("[Excepted Foreign Key]");
            Set exceptedFKKeySet = exceptedFKKeyMap.keySet();
            for (String exceptedKey : exceptedFKKeySet) {
                sb.append(this.ln()).append(" ").append(exceptedKey);
                sb.append(" (").append(tableName).append(" to ");
                sb.append((String)exceptedFKKeyMap.get(exceptedKey)).append(")");
            }
            _log.info((Object)sb.toString());
        }
        return this.filterSameForeignKeyMetaInfo(fkMap);
    }

    protected void assertFKColumnNotExcepted(String schemaName, String tableName, String columnName) {
        if (this.isColumnExcept(schemaName, tableName, columnName)) {
            String msg = "FK columns are unsupported on 'columnExcept' property:";
            msg = msg + " schemaName=" + schemaName;
            msg = msg + " tableName=" + tableName;
            msg = msg + " columnName=" + columnName;
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected void assertPKColumnNotExcepted(String schemaName, String tableName, String columnName) {
        if (this.isColumnExcept(schemaName, tableName, columnName)) {
            String msg = "PK columns are unsupported on 'columnExcept' property:";
            msg = msg + " schemaName=" + schemaName;
            msg = msg + " tableName=" + tableName;
            msg = msg + " columnName=" + columnName;
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected Map<String, DfForeignKeyMetaInfo> filterSameForeignKeyMetaInfo(Map<String, DfForeignKeyMetaInfo> fks) {
        LinkedHashMap<String, DfForeignKeyMetaInfo> filteredForeignKeyMetaInfoMap = new LinkedHashMap<String, DfForeignKeyMetaInfo>();
        LinkedHashMap checkMap = new LinkedHashMap();
        Set<String> foreignKeyNameSet = fks.keySet();
        for (String foreinKeyName : foreignKeyNameSet) {
            DfForeignKeyMetaInfo metaInfo = fks.get(foreinKeyName);
            LinkedHashMap<String, Object> checkKeyMap = new LinkedHashMap<String, Object>();
            checkKeyMap.put(metaInfo.getForeignTableName(), new Object());
            checkKeyMap.put("columnNameMap:" + metaInfo.getColumnNameMap(), new Object());
            if (checkMap.containsKey(checkKeyMap)) {
                String msg = "A structural one of the same row already exists.";
                msg = msg + "The skipped foreign-key name is " + foreinKeyName + ".";
                msg = msg + " The columns are " + checkKeyMap + ".";
                _log.warn((Object)msg);
                continue;
            }
            checkMap.put(checkKeyMap, new Object());
            filteredForeignKeyMetaInfoMap.put(foreinKeyName, metaInfo);
        }
        return filteredForeignKeyMetaInfoMap;
    }

    public Set<String> getRefTableCheckSet() {
        return this._refTableCheckSet;
    }

    public void setRefTableCheckSet(Set<String> refTableCheckSet) {
        this._refTableCheckSet = refTableCheckSet;
    }
}

