/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.factory;

import javax.sql.DataSource;
import org.seasar.dbflute.helper.jdbc.urlanalyzer.DfUrlAnalyzerMySql;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorMySql;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractorSqlServer;
import org.seasar.dbflute.properties.DfBasicProperties;

public class DfDbCommentExtractorFactory {
    protected DfBasicProperties _basicProperties;
    protected DataSource _dataSource;
    protected String _url;
    protected String _schema;

    public DfDbCommentExtractorFactory(DfBasicProperties basicProperties, DataSource dataSource, String url, String schema) {
        this._basicProperties = basicProperties;
        this._dataSource = dataSource;
        this._url = url;
        this._schema = schema;
    }

    public DfDbCommentExtractor createDbCommentExtractor() {
        if (this._basicProperties.isDatabaseMySQL()) {
            DfDbCommentExtractorMySql extractor = new DfDbCommentExtractorMySql();
            extractor.setDataSource(this._dataSource);
            if (this._schema != null && this._schema.trim().length() > 0) {
                extractor.setSchema(this._schema);
            } else {
                String schema = this.extractSchemaFromMySqlUrl();
                if (schema == null || schema.trim().length() == 0) {
                    return null;
                }
                extractor.setSchema(schema);
            }
            return extractor;
        }
        if (this._basicProperties.isDatabaseOracle()) {
            DfDbCommentExtractorOracle extractor = new DfDbCommentExtractorOracle();
            extractor.setDataSource(this._dataSource);
            extractor.setSchema(this._schema);
            return extractor;
        }
        if (this._basicProperties.isDatabaseSqlServer()) {
            DfDbCommentExtractorSqlServer extractor = new DfDbCommentExtractorSqlServer();
            extractor.setDataSource(this._dataSource);
            extractor.setSchema(this._schema);
            return extractor;
        }
        return null;
    }

    protected String extractSchemaFromMySqlUrl() {
        DfUrlAnalyzerMySql analyzer = new DfUrlAnalyzerMySql();
        analyzer.setUrl(this._url);
        return analyzer.extractSchema();
    }
}

