/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.connection;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.helper.jdbc.connection.DfDataSourceCreator;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;

public class DfSimpleDataSourceCreator
implements DfDataSourceCreator {
    private static Log _log = LogFactory.getLog(DfSimpleDataSourceCreator.class);
    protected String _driver;
    protected String _url;
    protected String _userId;
    protected String _password;
    protected Properties _connectionProperties;
    protected boolean _autoCommit;
    protected Connection _cachedConnection;

    public void create() throws SQLException {
        if (!DfDataSourceContext.isExistDataSource()) {
            _log.info((Object)"...Creating data source:");
            _log.info((Object)("  driver = " + this._driver));
            _log.info((Object)("  url    = " + this._url));
            _log.info((Object)("  user   = " + this._userId));
            DfDataSourceContext.setDataSource(new DfSimpleDataSource(this));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        if (!DfDataSourceContext.isExistDataSource()) return;
        DataSource dataSource = DfDataSourceContext.getDataSource();
        Connection conn = null;
        try {
            try {
                conn = dataSource.getConnection();
                if (!conn.getAutoCommit()) {
                    _log.info((Object)"...commit()");
                    conn.commit();
                }
            }
            catch (SQLException e) {
                String msg = "Failed to commit the conection: conn=" + conn;
                throw new DfJDBCException(msg, e);
            }
            Object var6_3 = null;
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ignored) {}
        conn.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() throws SQLException {
        if (!DfDataSourceContext.isExistDataSource()) return;
        DataSource dataSource = DfDataSourceContext.getDataSource();
        try {
            try {
                Connection conn = dataSource.getConnection();
                if (!conn.getAutoCommit()) {
                    _log.info((Object)"...rollback()");
                    conn.rollback();
                }
                if (conn instanceof DfSimpleConnection) {
                    _log.info((Object)"...closeReally()");
                    ((DfSimpleConnection)conn).closeReally();
                }
                _log.info((Object)"...close()");
                conn.close();
            }
            catch (SQLException sQLException) {
                Object var5_4 = null;
                DfDataSourceContext.clearDataSource();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DfDataSourceContext.clearDataSource();
            throw throwable;
        }
        DfDataSourceContext.clearDataSource();
    }

    public Connection getConnection() throws SQLException {
        if (this._cachedConnection == null) {
            Connection conn = this.createConnection();
            this._cachedConnection = new DfSimpleConnection(conn);
        }
        return this._cachedConnection;
    }

    protected Connection createConnection() throws SQLException {
        Connection conn = null;
        Driver driverInstance = this.newDriver();
        Properties info = new Properties();
        if (this._connectionProperties != null && !this._connectionProperties.isEmpty()) {
            info.putAll((Map<?, ?>)this._connectionProperties);
        }
        info.put("user", this._userId);
        info.put("password", this._password);
        try {
            conn = driverInstance.connect(this._url, info);
        }
        catch (SQLException e) {
            String msg = "Failed to connect to URL:";
            msg = msg + " url=" + this._url + " user=" + this._userId;
            throw new DfJDBCException(msg, e);
        }
        if (conn == null) {
            String msg = "The driver didn't understand the URL: _url=" + this._url;
            throw new DfJDBCException(msg);
        }
        try {
            conn.setAutoCommit(this._autoCommit);
        }
        catch (SQLException e) {
            String msg = "Failed to set auto commit:";
            msg = msg + " autocommit=" + this._autoCommit;
            throw new DfJDBCException(msg, e);
        }
        return conn;
    }

    protected Driver newDriver() {
        Driver driverInstance;
        try {
            Class<?> dc = Class.forName(this._driver);
            driverInstance = (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            String msg = "Class Not Found: JDBC driver " + this._driver + " could not be loaded.";
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal Access: JDBC driver " + this._driver + " could not be loaded.";
            throw new IllegalStateException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Instantiation Exception: JDBC driver " + this._driver + " could not be loaded.";
            throw new IllegalStateException(msg, e);
        }
        return driverInstance;
    }

    public String toString() {
        return "{url=" + this._url + ", user=" + this._userId + ", prop=" + this._connectionProperties + "}";
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this._connectionProperties = connectionProperties;
    }

    public void setAutoCommit(boolean autoCommit) {
        this._autoCommit = autoCommit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DfSimpleConnection
    implements Connection {
        protected Connection _realConnection;

        public DfSimpleConnection(Connection realConnection) {
            this._realConnection = realConnection;
        }

        @Override
        public void clearWarnings() throws SQLException {
            this._realConnection.clearWarnings();
        }

        @Override
        public void close() throws SQLException {
        }

        public void closeReally() throws SQLException {
            this._realConnection.close();
        }

        @Override
        public void commit() throws SQLException {
            this._realConnection.commit();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this._realConnection.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this._realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this._realConnection.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this._realConnection.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this._realConnection.getCatalog();
        }

        @Override
        public int getHoldability() throws SQLException {
            return this._realConnection.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this._realConnection.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this._realConnection.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this._realConnection.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this._realConnection.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this._realConnection.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this._realConnection.isReadOnly();
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this._realConnection.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this._realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this._realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this._realConnection.prepareCall(sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this._realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this._realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this._realConnection.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this._realConnection.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this._realConnection.prepareStatement(sql, columnNames);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this._realConnection.prepareStatement(sql);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this._realConnection.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this._realConnection.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this._realConnection.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this._realConnection.setAutoCommit(autoCommit);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this._realConnection.setCatalog(catalog);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this._realConnection.setHoldability(holdability);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this._realConnection.setReadOnly(readOnly);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this._realConnection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this._realConnection.setSavepoint(name);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this._realConnection.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this._realConnection.setTypeMap(map);
        }
    }

    public static class DfSimpleDataSource
    implements DataSource {
        protected DfSimpleDataSourceCreator _dataSourceProvider;

        public DfSimpleDataSource(DfSimpleDataSourceCreator dataSourceProvider) {
            this._dataSourceProvider = dataSourceProvider;
        }

        public Connection getConnection() throws SQLException {
            return this._dataSourceProvider.getConnection();
        }

        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException("Use getConnection()");
        }

        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("getLogWriter()");
        }

        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException("getLoginTimeout()");
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout()");
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout()");
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this._dataSourceProvider;
        }
    }
}

