/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.xls;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.DfDataSet;
import org.seasar.dbflute.helper.dataset.DfDataSetConstants;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.util.DfBase64Util;
import org.seasar.dbflute.util.DfTypeUtil;

public class DfXlsWriter
implements DfDataSetConstants {
    protected OutputStream out;
    protected HSSFWorkbook workbook;
    protected HSSFCellStyle dateStyle;
    protected HSSFCellStyle base64Style;
    protected boolean stringCellType;

    public DfXlsWriter(File file) {
        this(DfXlsWriter.create(file));
    }

    public DfXlsWriter(OutputStream out) {
        this.setOutputStream(out);
    }

    protected static OutputStream create(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public DfXlsWriter stringCellType() {
        this.stringCellType = true;
        return this;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
        this.workbook = new HSSFWorkbook();
        HSSFDataFormat df = this.workbook.createDataFormat();
        this.dateStyle = this.workbook.createCellStyle();
        this.dateStyle.setDataFormat(df.getFormat("yyyy/MM/dd"));
        this.base64Style = this.workbook.createCellStyle();
        this.base64Style.setDataFormat(df.getFormat("\\B\\:@"));
    }

    public void write(DfDataSet dataSet) {
        for (int i = 0; i < dataSet.getTableSize(); ++i) {
            int j;
            DfDataTable table = dataSet.getTable(i);
            HSSFSheet sheet = this.workbook.createSheet();
            String tableName = table.getTableName();
            try {
                this.workbook.setSheetName(i, tableName);
            }
            catch (RuntimeException e) {
                String msg = "Failed to set the sheet name: " + tableName;
                throw new IllegalStateException(msg, e);
            }
            HSSFRow headerRow = sheet.createRow(0);
            for (j = 0; j < table.getColumnSize(); ++j) {
                HSSFCell cell = headerRow.createCell(j);
                cell.setCellValue(this.createRichTextString(table.getColumnName(j)));
            }
            for (j = 0; j < table.getRowSize(); ++j) {
                HSSFRow row = sheet.createRow(j + 1);
                for (int k = 0; k < table.getColumnSize(); ++k) {
                    DfDataRow dataRow = table.getRow(j);
                    Object value = dataRow.getValue(k);
                    if (value == null) continue;
                    HSSFCell cell = row.createCell(k);
                    this.setValue(cell, value);
                }
            }
        }
        try {
            this.workbook.write(this.out);
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setValue(HSSFCell cell, Object value) {
        if (this.stringCellType) {
            cell.setCellType(1);
        }
        if (value instanceof Number) {
            cell.setCellValue(this.createRichTextString(value.toString()));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
            cell.setCellStyle(this.dateStyle);
        } else if (value instanceof byte[]) {
            cell.setCellValue(this.createRichTextString(DfBase64Util.encode((byte[])((byte[])value))));
            cell.setCellStyle(this.base64Style);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellValue(this.createRichTextString(DfTypeUtil.toString((Object)value, null)));
        }
    }

    protected HSSFRichTextString createRichTextString(String str) {
        return new HSSFRichTextString(str);
    }
}

