/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.friends.torque;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfAdditionalPrimaryKeyProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAdditionalPrimaryKeyInitializer {
    private static final Log _log = LogFactory.getLog(DfAdditionalPrimaryKeyInitializer.class);
    protected Database _database;

    public DfAdditionalPrimaryKeyInitializer(Database database) {
        this._database = database;
    }

    public void initializeAdditionalPrimaryKey() {
        _log.info((Object)"/=======================================");
        _log.info((Object)"...Initializing additional primary keys.");
        Map<String, Map<String, String>> additionalPrimaryKeyMap = this.getAdditionalPrimaryKeyMap();
        Set<String> primaryNameKeySet = additionalPrimaryKeyMap.keySet();
        for (String primaryKeyName : primaryNameKeySet) {
            String tableName = this.getTableName(primaryKeyName);
            this.assertTable(tableName);
            List<String> columnNameList = this.getLocalColumnNameList(primaryKeyName);
            this.assertColumnList(tableName, columnNameList);
            Table table = this.getTable(tableName);
            if (table.hasPrimaryKey()) {
                String msg = "The primary key of the table has already set up: ";
                msg = msg + " tableName=" + tableName + " existing primaryKey=" + table.getPrimaryKeyDispValueString();
                msg = msg + " your specified primaryKey=" + columnNameList;
                _log.info((Object)msg);
                continue;
            }
            for (String columnName : columnNameList) {
                Column column = table.getColumn(columnName);
                column.setPrimaryKey(true);
                column.setAdditionalPrimaryKey(true);
            }
            this.showResult(primaryKeyName, table, columnNameList);
        }
        _log.info((Object)"==========/");
    }

    protected void showResult(String primaryKeyName, Table table, List<String> columnNameList) {
        _log.info((Object)("    " + primaryKeyName));
        if (columnNameList.size() == 1) {
            _log.info((Object)("       Add primary key " + table.getName() + "." + columnNameList.get(0)));
        } else {
            _log.info((Object)("       Add primary key " + table.getName() + "." + columnNameList));
        }
    }

    protected DfAdditionalPrimaryKeyProperties getProperties() {
        return DfBuildProperties.getInstance().getAdditionalPrimaryKeyProperties();
    }

    protected void assertTable(String tableName) {
        if (this.getTable(tableName) == null) {
            String msg = "Not found table by the tableName: " + tableName;
            msg = msg + " additionalPrimaryKeyMap=" + this.getAdditionalPrimaryKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertColumnList(String tableName, List<String> columnNameList) {
        if (!this.getTable(tableName).containsColumn(columnNameList)) {
            String msg = "Not found column by the columnNames: " + columnNameList;
            msg = msg + " of the table '" + tableName + "'";
            msg = msg + " additionalPrimaryKeyMap=" + this.getAdditionalPrimaryKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected String getTableName(String primaryKeyName) {
        return this.getProperties().findTableName(primaryKeyName);
    }

    protected List<String> getLocalColumnNameList(String primaryKeyName) {
        return this.getProperties().findColumnNameList(primaryKeyName);
    }

    protected Map<String, Map<String, String>> getAdditionalPrimaryKeyMap() {
        return this.getProperties().getAdditionalPrimaryKeyMap();
    }

    protected Table getTable(String tableName) {
        return this.getDatabase().getTable(tableName);
    }

    protected Table[] getTables() {
        return this.getDatabase().getTables();
    }

    protected Database getDatabase() {
        return this._database;
    }
}

