/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Inheritance;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.torque.engine.database.model.Unique;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.schemahtml.DfSchemaHtmlBuilder;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfBuriProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.properties.DfIncludeQueryProperties;
import org.seasar.dbflute.util.DfStringUtil;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column {
    private static Log _log = LogFactory.getLog(Column.class);
    private static DfColumnHandler _columnHandler = new DfColumnHandler();
    private String _name;
    private String _javaName;
    private String _description;
    private Table _table;
    private String _dbType;
    private String _columnSize;
    private String _defaultValue;
    private boolean _isNotNull;
    private boolean _isPrimaryKey;
    private String _primaryKeyName;
    private boolean _isAutoIncrement;
    private boolean _additionalPrimaryKey;
    private String _plainComment;
    private List<ForeignKey> _referrers;
    private String _jdbcType;
    private String _sql2EntityRelatedTableName;
    private String _sql2EntityRelatedColumnName;
    private String _sql2EntityForcedJavaNative;
    private int _position;
    private String _inheritanceType;
    private boolean _isInheritance;
    private boolean _isEnumeratedClasses;
    private List<Inheritance> _inheritanceList;
    private String _javaNamingMethod;
    protected boolean _needsJavaNameConvert = true;
    protected List<ForeignKey> _singleKeyRefferrers = null;
    protected Boolean _commonColumn;
    private String _behaviorFilterBeforeInsertColumnExpression;
    private String _behaviorFilterBeforeUpdateColumnExpression;
    protected ColumnHelper _columnHelper;

    public Column() {
        this(null);
    }

    public Column(String name) {
        this._name = name;
    }

    public void loadFromXML(Attributes attrib) {
        this._name = attrib.getValue("name");
        this._javaName = attrib.getValue("javaName");
        this._javaNamingMethod = attrib.getValue("javaNamingMethod");
        if (this._javaNamingMethod == null) {
            this._javaNamingMethod = this._table.getDatabase().getDefaultJavaNamingMethod();
        }
        this._isPrimaryKey = "true".equals(attrib.getValue("primaryKey"));
        this._primaryKeyName = attrib.getValue("pkName");
        String notNull = attrib.getValue("required");
        this._isNotNull = notNull != null && "true".equals(notNull);
        String autoIncrement = attrib.getValue("autoIncrement");
        this._isAutoIncrement = "true".equals(autoIncrement);
        this._plainComment = attrib.getValue("comment");
        this._defaultValue = attrib.getValue("default");
        this._columnSize = attrib.getValue("size");
        this.setJdbcType(attrib.getValue("type"));
        this.setDbType(attrib.getValue("dbType"));
        this._inheritanceType = attrib.getValue("inheritance");
        this._isInheritance = this._inheritanceType != null && !this._inheritanceType.equals("false");
        this._description = attrib.getValue("description");
    }

    public String getFullyQualifiedName() {
        return this._table.getName() + '.' + this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String newName) {
        this._name = newName;
    }

    public boolean hasAlias() {
        String alias = this.getAlias();
        return alias != null && alias.trim().length() > 0;
    }

    public String getAlias() {
        String alias;
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = this._plainComment;
        if (comment != null && (alias = prop.extractAliasFromDbComment(comment)) != null) {
            return alias;
        }
        return "";
    }

    public String getAliasExpression() {
        String alias = this.getAlias();
        if (alias == null || alias.trim().length() == 0) {
            return "";
        }
        return "(" + alias + ")";
    }

    public String getAliasSettingExpression() {
        String alias = this.getAlias();
        if (alias == null || alias.trim().length() == 0) {
            return "null";
        }
        return "\"" + alias + "\"";
    }

    public void setupNeedsJavaNameConvertFalse() {
        this._needsJavaNameConvert = false;
    }

    public boolean needsJavaNameConvert() {
        return this._needsJavaNameConvert;
    }

    public String getJavaName() {
        if (this._javaName == null) {
            this._javaName = this.needsJavaNameConvert() ? this.getDatabaseChecked().convertJavaNameByJdbcNameAsColumn(this.getName()) : this.getName();
            this._javaName = this.filterBuriJavaNameIfNeeds(this._javaName);
        }
        return this._javaName;
    }

    protected String filterBuriJavaNameIfNeeds(String javaName) {
        String arranged;
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        if (buriProperties.isUseBuri() && this.getTable().isBuriInternal() && (arranged = buriProperties.arrangeBuriColumnJavaName(this._javaName)) != null) {
            return arranged;
        }
        return javaName;
    }

    public void setJavaName(String javaName) {
        this._javaName = javaName;
    }

    public String getUncapitalisedJavaName() {
        return StringUtils.uncapitalise((String)this.getJavaName());
    }

    public String getJavaBeansRulePropertyName() {
        return DfStringUtil.decapitalizePropertyName((String)this.getJavaName());
    }

    public String getJavaBeansRulePropertyNameInitCap() {
        return this.initCap(this.getJavaBeansRulePropertyName());
    }

    protected String initCap(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int v) {
        this._position = v;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String newDescription) {
        this._description = newDescription;
    }

    public void setTable(Table parent) {
        this._table = parent;
    }

    public Table getTable() {
        if (this._table == null) {
            String msg = "This Column did not have 'table': columnName=" + this._name;
            throw new IllegalStateException(msg);
        }
        return this._table;
    }

    protected Database getDatabaseChecked() {
        Table tbl = this.getTable();
        if (tbl == null) {
            throw new IllegalStateException("getTable() should not be null at " + this.getName());
        }
        Database db = tbl.getDatabase();
        if (db == null) {
            throw new IllegalStateException("getTable().getDatabase() should not be null at " + this.getName());
        }
        return db;
    }

    public String getTableName() {
        return this._table.getName();
    }

    public String getColumnDefinitionLineDisp() {
        StringBuilder sb = new StringBuilder();
        if (this.isPrimaryKey()) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("PK");
        }
        if (this.isAutoIncrement()) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("ID");
        }
        if (this.isUnique()) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("UQ");
        }
        if (this.isNotNull()) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("NotNull");
        }
        this.plugDelimiterIfNeeds(sb);
        sb.append(this.getDbTypeExpression());
        if (this.getColumnSize() != null && this.getColumnSize().trim().length() > 0) {
            sb.append("(" + this.getColumnSize() + ")");
        }
        if (this.getDefaultValue() != null && this.getDefaultValue().trim().length() > 0 && !this.isAutoIncrement()) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("default=[").append(this.getDefaultValue() + "]");
        }
        if (this.isForeignKey()) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("FK to " + this.getForeignTableName());
        }
        if (this._sql2EntityRelatedTableName != null) {
            this.plugDelimiterIfNeeds(sb);
            sb.append("related to ").append(this._sql2EntityRelatedTableName);
            if (this._sql2EntityRelatedColumnName != null) {
                sb.append(".").append(this._sql2EntityRelatedColumnName);
            }
        }
        return sb.toString();
    }

    private void plugDelimiterIfNeeds(StringBuilder sb) {
        if (sb.length() != 0) {
            sb.append(" : ");
        }
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void setPrimaryKey(boolean pk) {
        this._isPrimaryKey = pk;
    }

    public String getPrimaryKeyName() {
        return this._primaryKeyName;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this._primaryKeyName = primaryKeyName;
    }

    public boolean isAdditionalPrimaryKey() {
        return this._additionalPrimaryKey;
    }

    public void setAdditionalPrimaryKey(boolean additionalPrimaryKey) {
        this._additionalPrimaryKey = additionalPrimaryKey;
    }

    public boolean isTwoOrMoreColumnPrimaryKey() {
        return this.getTable().getPrimaryKey().size() > 1;
    }

    public String getPrimaryKeyMarkForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        if (this.isPrimaryKey()) {
            sb.append("o");
            if (this.isTwoOrMoreColumnPrimaryKey()) {
                sb.append("<span class=\"flgplus\">+</span>");
            }
        } else {
            sb.append("&nbsp;");
        }
        return sb.toString();
    }

    public String getPrimaryKeyTitleForSchemaHtml() {
        String title;
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String value = prop.resolveAttributeForSchemaHtml(this._primaryKeyName);
        if (value == null) {
            return "";
        }
        Table table = this.getTable();
        if (table.isUseSequence()) {
            Integer cacheSize;
            Integer incrementSize;
            BigDecimal maximumValue;
            String sequenceName = table.getDefinedSequenceName();
            BigDecimal minimumValue = table.getSequenceMinimumValue();
            StringBuilder optionSb = new StringBuilder();
            if (minimumValue != null) {
                if (optionSb.length() > 0) {
                    optionSb.append(",");
                }
                optionSb.append("minimum(" + minimumValue + ")");
            }
            if ((maximumValue = table.getSequenceMaximumValue()) != null) {
                if (optionSb.length() > 0) {
                    optionSb.append(",");
                }
                optionSb.append("maximum(" + maximumValue + ")");
            }
            if ((incrementSize = table.getSequenceIncrementSize()) != null) {
                if (optionSb.length() > 0) {
                    optionSb.append(",");
                }
                optionSb.append("increment(" + incrementSize + ")");
            }
            if ((cacheSize = table.getSequenceCacheSize()) != null) {
                if (optionSb.length() > 0) {
                    optionSb.append(",");
                }
                optionSb.append("dfcache(" + cacheSize + ")");
            }
            if (optionSb.length() > 0) {
                optionSb.insert(0, ":");
            }
            title = this._primaryKeyName + " :: sequence=" + sequenceName + optionSb;
        } else {
            title = this._primaryKeyName;
        }
        return " title=\"" + prop.resolveAttributeForSchemaHtml(title) + "\"";
    }

    public boolean isAutoIncrement() {
        return this._isAutoIncrement;
    }

    public void setAutoIncrement(boolean value) {
        this._isAutoIncrement = value;
    }

    public boolean isUnique() {
        List<Unique> uniqueList = this.getTable().getUniqueList();
        for (Unique unique : uniqueList) {
            if (!unique.hasSameColumn(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isUniqueAllAdditional() {
        List<Unique> uniqueList = this.getTable().getUniqueList();
        boolean exists = false;
        for (Unique unique : uniqueList) {
            if (!unique.hasSameColumn(this)) continue;
            exists = true;
            if (unique.isAdditional()) continue;
            return false;
        }
        return exists;
    }

    public boolean hasOnlyOneColumnUnique() {
        List<Unique> uniqueList = this.getTable().getUniqueList();
        for (Unique unique : uniqueList) {
            if (unique.isTwoOrMoreColumn() || !unique.hasSameColumn(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTwoOrMoreColumnUnique() {
        List<Unique> uniqueList = this.getTable().getUniqueList();
        for (Unique unique : uniqueList) {
            if (!unique.isTwoOrMoreColumn() || !unique.hasSameColumn(this)) continue;
            return true;
        }
        return false;
    }

    public String getUniqueKeyMarkForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        if (this.isUnique()) {
            sb.append("o");
            if (this.hasTwoOrMoreColumnUnique()) {
                sb.append("<span class=\"flgplus\">+</span>");
            }
        } else {
            sb.append("&nbsp;");
        }
        return sb.toString();
    }

    public String getUniqueKeyTitleForSchemaHtml() {
        if (!this.isUnique()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<Unique> uniqueList = this.getTable().getUniqueList();
        for (Unique unique : uniqueList) {
            if (!unique.hasSameColumn(this)) continue;
            String uniqueKeyName = unique.getName();
            sb.append(sb.length() > 0 ? ", " : "");
            if (uniqueKeyName != null && uniqueKeyName.trim().length() > 0) {
                sb.append(uniqueKeyName + "(");
            } else {
                sb.append("(");
            }
            Map<Integer, String> indexColumnMap = unique.getIndexColumnMap();
            Set<Map.Entry<Integer, String>> entrySet = indexColumnMap.entrySet();
            StringBuilder oneUniqueSb = new StringBuilder();
            for (Map.Entry<Integer, String> entry : entrySet) {
                String columnName = entry.getValue();
                if (oneUniqueSb.length() > 0) {
                    oneUniqueSb.append(", ");
                }
                oneUniqueSb.append(columnName);
            }
            sb.append((CharSequence)oneUniqueSb);
            sb.append(")");
        }
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String title = prop.resolveAttributeForSchemaHtml(sb.toString());
        return title != null ? " title=\"" + title + "\"" : "";
    }

    public boolean hasIndex() {
        List<Index> indexList = this.getTable().getIndexList();
        for (Index index : indexList) {
            if (!index.hasSameColumn(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlyOneColumnIndex() {
        List<Index> indexList = this.getTable().getIndexList();
        for (Index index : indexList) {
            if (index.isTwoOrMoreColumn() || !index.hasSameColumn(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTwoOrMoreColumnIndex() {
        List<Index> indexList = this.getTable().getIndexList();
        for (Index index : indexList) {
            if (!index.isTwoOrMoreColumn() || !index.hasSameColumn(this)) continue;
            return true;
        }
        return false;
    }

    public String getIndexMarkForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        if (this.hasIndex()) {
            sb.append("o");
            if (this.hasTwoOrMoreColumnIndex()) {
                sb.append("<span class=\"flgplus\">+</span>");
            }
        } else {
            sb.append("&nbsp;");
        }
        return sb.toString();
    }

    public String getIndexTitleForSchemaHtml() {
        if (!this.hasIndex()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<Index> indexList = this.getTable().getIndexList();
        for (Index index : indexList) {
            if (!index.hasSameColumn(this)) continue;
            String indexName = index.getName();
            sb.append(sb.length() > 0 ? ", " : "");
            if (indexName != null && indexName.trim().length() > 0) {
                sb.append(indexName + "(");
            } else {
                sb.append("(");
            }
            Map<Integer, String> indexColumnMap = index.getIndexColumnMap();
            Set<Map.Entry<Integer, String>> entrySet = indexColumnMap.entrySet();
            StringBuilder oneIndexSb = new StringBuilder();
            for (Map.Entry<Integer, String> entry : entrySet) {
                String columnName = entry.getValue();
                if (oneIndexSb.length() > 0) {
                    oneIndexSb.append(", ");
                }
                oneIndexSb.append(columnName);
            }
            sb.append((CharSequence)oneIndexSb);
            sb.append(")");
        }
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String title = prop.resolveAttributeForSchemaHtml(sb.toString());
        return title != null ? " title=\"" + title + "\"" : "";
    }

    public boolean isNotNull() {
        return this._isNotNull;
    }

    public void setNotNull(boolean status) {
        this._isNotNull = status;
    }

    public void setDbType(String dbType) {
        this._dbType = dbType;
    }

    public String getDbType() {
        return this._dbType;
    }

    public String getDbTypeExpression() {
        return this._dbType != null ? this._dbType : "UnknownType";
    }

    public String getColumnSize() {
        return this._columnSize;
    }

    public void setColumnSize(String columnSize) {
        this._columnSize = columnSize;
    }

    public void setupColumnSize(int columnSize, int decimalDigits) {
        if (DfColumnHandler.isColumnSizeValid(columnSize)) {
            if (DfColumnHandler.isDecimalDigitsValid(decimalDigits)) {
                this.setColumnSize(columnSize + ", " + decimalDigits);
            } else {
                this.setColumnSize(String.valueOf(columnSize));
            }
        }
    }

    public boolean hasColumnSize() {
        return this._columnSize != null && this._columnSize.trim().length() > 0;
    }

    protected Integer getIntegerColumnSize() {
        if (this._columnSize == null) {
            return null;
        }
        String realSize = this._columnSize.contains(",") ? this._columnSize.split(",")[0] : this._columnSize;
        try {
            return Integer.parseInt(realSize);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Integer getDecimalDigits() {
        if (this._columnSize == null) {
            return null;
        }
        if (!this._columnSize.contains(",")) {
            return 0;
        }
        return Integer.parseInt(this._columnSize.split(",")[1].trim());
    }

    public String getColumnSizeSettingExpression() {
        Integer columnSize = this.getIntegerColumnSize();
        if (columnSize == null) {
            return "null";
        }
        return String.valueOf(columnSize);
    }

    public String getColumnDecimalDigitsSettingExpression() {
        Integer decimalDigits = this.getDecimalDigits();
        if (decimalDigits == null) {
            return "null";
        }
        return String.valueOf(decimalDigits);
    }

    public String getPlainComment() {
        return this._plainComment;
    }

    public void setPlainComment(String plainComment) {
        this._plainComment = plainComment;
    }

    public boolean hasComment() {
        String comment = this.getComment();
        return comment != null && comment.trim().length() > 0;
    }

    public String getComment() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.extractCommentFromDbComment(this._plainComment);
        return comment != null ? comment : "";
    }

    public void setComment(String comment) {
        this._plainComment = comment;
    }

    public String getCommentForSchemaHtml() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.resolveTextForSchemaHtml(this.getComment());
        return comment != null ? comment : "";
    }

    public boolean isCommentForJavaDocValid() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        return this.hasComment() && prop.isEntityJavaDocDbCommentValid();
    }

    public String getCommentForJavaDoc() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.resolveTextForJavaDoc(this.getComment(), "    ");
        return comment != null ? comment : "";
    }

    public boolean isCommentForDBMetaValid() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        return this.hasComment() && prop.isEntityDBMetaDbCommentValid();
    }

    public String getCommentForDBMetaSettingExpression() {
        if (!this.isCommentForDBMetaValid()) {
            return "null";
        }
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.resolveTextForDBMeta(this.getComment());
        return comment != null ? "\"" + comment + "\"" : "null";
    }

    public void setDefaultValue(String def) {
        this._defaultValue = def;
    }

    public boolean hasDefaultValue() {
        return this._defaultValue != null && this._defaultValue.trim().length() > 0;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isForeignKey() {
        return this.getForeignKey() != null;
    }

    public boolean isMultipleFK() {
        ForeignKey fk = this.getForeignKey();
        if (fk == null) {
            return false;
        }
        String myForeignTableName = fk.getForeignTableName();
        ForeignKey[] fks = this._table.getForeignKeys();
        String myColumnName = this._name;
        for (int i = 0; i < fks.length; ++i) {
            List<String> columnsNameList;
            String foreignTableName = fks[i].getForeignTableName();
            if (!myForeignTableName.equalsIgnoreCase(foreignTableName) || DfStringUtil.containsIgnoreCase((String)myColumnName, columnsNameList = fks[i].getLocalColumns())) continue;
            return true;
        }
        return false;
    }

    protected String filterUnderscore(String name) {
        return DfStringUtil.replace((String)name, (String)"_", (String)"");
    }

    public ForeignKey getForeignKey() {
        return this._table.getForeignKey(this._name);
    }

    public List<ForeignKey> getForeignKeyList() {
        return this._table.getForeignKeyList(this._name);
    }

    public String getForeignTableNameCommaStringWithHtmlHref() {
        StringBuilder sb = new StringBuilder();
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        DfSchemaHtmlBuilder schemaHtmlBuilder = new DfSchemaHtmlBuilder(prop);
        String delimiter = ",<br />";
        List<ForeignKey> foreignKeyList = this.getForeignKeyList();
        int size = foreignKeyList.size();
        if (size == 0) {
            return "&nbsp;";
        }
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = foreignKeyList.get(i);
            String foreignTableName = fk.getForeignTableName();
            sb.append(schemaHtmlBuilder.buildRelatedTableLink(fk, foreignTableName, ",<br />"));
        }
        sb.delete(0, ",<br />".length());
        return sb.toString();
    }

    public String getForeignPropertyNameCommaStringLiteralExpression() {
        StringBuilder sb = new StringBuilder();
        List<ForeignKey> foreignKeyList = this.getForeignKeyList();
        int size = foreignKeyList.size();
        if (size == 0) {
            return "null";
        }
        String delimiter = ",";
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = foreignKeyList.get(i);
            String foreignPropertyName = fk.getForeignJavaBeansRulePropertyName();
            sb.append(",").append(foreignPropertyName);
        }
        List<ForeignKey> referrerList = this.getReferrerList();
        for (ForeignKey referrer : referrerList) {
            if (!referrer.isOneToOne()) continue;
            String propertyNameAsOne = referrer.getReferrerJavaBeansRulePropertyNameAsOne();
            sb.append(",").append(propertyNameAsOne);
        }
        sb.delete(0, ",".length());
        return "\"" + sb.toString() + "\"";
    }

    public String getRelatedTableName() {
        ForeignKey fk = this.getForeignKey();
        return fk == null ? null : fk.getForeignTableName();
    }

    public String getForeignTableName() {
        ForeignKey fk = this.getForeignKey();
        return fk == null ? "" : fk.getForeignTableName();
    }

    public boolean isSingleKeyForeignKey() {
        ForeignKey fk = this.getForeignKey();
        return fk == null ? false : fk.isSimpleKeyFK();
    }

    public String getRelatedColumnName() {
        ForeignKey fk = this.getForeignKey();
        if (fk == null) {
            return null;
        }
        return fk.getLocalForeignMapping().get(this._name).toString();
    }

    public boolean hasReferrer() {
        return !this.getReferrers().isEmpty();
    }

    public void addReferrer(ForeignKey fk) {
        if (this._referrers == null) {
            this._referrers = new ArrayList<ForeignKey>(5);
        }
        this._referrers.add(fk);
    }

    public List<ForeignKey> getReferrerList() {
        if (this._referrers == null) {
            this._referrers = new ArrayList<ForeignKey>(5);
        }
        return this._referrers;
    }

    public List<ForeignKey> getReferrers() {
        return this.getReferrerList();
    }

    public boolean hasSingleKeyReferrer() {
        return !this.getSingleKeyReferrers().isEmpty();
    }

    public List<ForeignKey> getSingleKeyReferrers() {
        if (this._singleKeyRefferrers != null) {
            return this._singleKeyRefferrers;
        }
        this._singleKeyRefferrers = new ArrayList<ForeignKey>(5);
        if (!this.hasReferrer()) {
            return this._singleKeyRefferrers;
        }
        List<ForeignKey> referrerList = this.getReferrers();
        for (ForeignKey referrer : referrerList) {
            if (!referrer.isSimpleKeyFK()) continue;
            this._singleKeyRefferrers.add(referrer);
        }
        return this._singleKeyRefferrers;
    }

    public String getReferrerCommaString() {
        if (this._referrers == null) {
            this._referrers = new ArrayList<ForeignKey>(5);
        }
        StringBuffer sb = new StringBuffer();
        for (ForeignKey fk : this._referrers) {
            Table reffererTable = fk.getTable();
            String name = reffererTable.getName();
            sb.append(", ").append(name);
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public String getReferrerTableCommaStringWithHtmlHref() {
        if (this._referrers == null) {
            this._referrers = new ArrayList<ForeignKey>(5);
        }
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        DfSchemaHtmlBuilder schemaHtmlBuilder = new DfSchemaHtmlBuilder(prop);
        String delimiter = ",<br />";
        StringBuffer sb = new StringBuffer();
        for (ForeignKey fk : this._referrers) {
            Table referrerTable = fk.getTable();
            String referrerTableName = referrerTable.getName();
            sb.append(schemaHtmlBuilder.buildRelatedTableLink(fk, referrerTableName, ",<br />"));
        }
        sb.delete(0, ",<br />".length());
        return sb.toString();
    }

    public String getReferrerPropertyNameCommaStringLiteralExpression() {
        StringBuilder sb = new StringBuilder();
        List<ForeignKey> referrerList = this.getReferrers();
        int size = referrerList.size();
        if (size == 0) {
            return "null";
        }
        String delimiter = ",";
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = referrerList.get(i);
            if (fk.isOneToOne()) continue;
            String referrerPropertyName = fk.getReferrerJavaBeansRulePropertyName();
            sb.append(",").append(referrerPropertyName);
        }
        sb.delete(0, ",".length());
        return "\"" + sb.toString() + "\"";
    }

    public void setJdbcType(String jdbcType) {
        this._jdbcType = jdbcType;
    }

    public String getJdbcType() {
        return this._jdbcType;
    }

    public String getJavaNative() {
        if (this._sql2EntityForcedJavaNative != null && this._sql2EntityForcedJavaNative.trim().length() > 0) {
            return this._sql2EntityForcedJavaNative;
        }
        return TypeMap.findJavaNativeByJdbcType(this._jdbcType, this.getIntegerColumnSize(), this.getDecimalDigits());
    }

    public String getJavaNativeRemovedPackage() {
        String javaNative = this.getJavaNative();
        if (!javaNative.contains(".")) {
            return javaNative;
        }
        return javaNative.substring(javaNative.lastIndexOf(".") + ".".length());
    }

    public String getJavaNativeRemovedCSharpNullable() {
        String javaNative = this.getJavaNative();
        if (javaNative.endsWith("?")) {
            return javaNative.substring(0, javaNative.length() - "?".length());
        }
        return javaNative;
    }

    public String getFlexNative() {
        return TypeMap.findFlexNativeByJavaNative(this.getJavaNative());
    }

    public boolean isJavaNativeStringObject() {
        return this.containsAsEndsWith(this.getJavaNative(), this.getTable().getDatabase().getJavaNativeStringList());
    }

    public boolean isJavaNativeNumberObject() {
        return this.containsAsEndsWith(this.getJavaNative(), this.getTable().getDatabase().getJavaNativeNumberList());
    }

    public boolean isJavaNativeDateObject() {
        return this.containsAsEndsWith(this.getJavaNative(), this.getTable().getDatabase().getJavaNativeDateList());
    }

    public boolean isJavaNativeBooleanObject() {
        return this.containsAsEndsWith(this.getJavaNative(), this.getTable().getDatabase().getJavaNativeBooleanList());
    }

    public boolean isJavaNativeBinaryObject() {
        return this.containsAsEndsWith(this.getJavaNative(), this.getTable().getDatabase().getJavaNativeBinaryList());
    }

    public boolean isJavaNativeUtilDate() {
        return this.getJavaNative().equals("java.util.Date");
    }

    public boolean isJavaNativeByteArray() {
        return this.getJavaNative().equals("byte[]");
    }

    public boolean isJavaNativeUUIDObject() {
        if (this.isJavaNativeStringObject() || this.isJavaNativeNumberObject() || this.isJavaNativeDateObject() || this.isJavaNativeBooleanObject() || this.isJavaNativeBinaryObject()) {
            return false;
        }
        String dbTypeName = this.getDbType();
        if (dbTypeName == null) {
            return false;
        }
        return _columnHandler.isUUID(dbTypeName);
    }

    public boolean isJavaNativeStringClob() {
        String dbTypeName = this.getDbType();
        if (dbTypeName == null) {
            return false;
        }
        return _columnHandler.isOracleStringClob(dbTypeName);
    }

    public boolean isJavaNativeBytesOid() {
        String dbTypeName = this.getDbType();
        if (dbTypeName == null) {
            return false;
        }
        return _columnHandler.isPostgreSQLBytesOid(dbTypeName);
    }

    public boolean isJavaNativeValueOfAbleObject() {
        List<Object> list = Arrays.asList("Integer", "Long", "Short", "Byte", "Boolean", "Character");
        return this.containsAsEndsWith(this.getJavaNative(), list);
    }

    public boolean isJavaNativeCSharpNullable() {
        return this.getJavaNative().startsWith("Nullable") || this.getJavaNative().endsWith("?");
    }

    public boolean isJdbcTypeChar() {
        return "CHAR".equals(this.getJdbcType());
    }

    public boolean isJdbcTypeClob() {
        return "CLOB".equals(this.getJdbcType());
    }

    public boolean isJdbcTypeDate() {
        return "DATE".equals(this.getJdbcType());
    }

    public boolean isJdbcTypeTime() {
        return "TIME".equals(this.getJdbcType());
    }

    public boolean isJdbcTypeTimestamp() {
        return "TIMESTAMP".equals(this.getJdbcType());
    }

    public boolean isJdbcTypeBlob() {
        return "BLOB".equals(this.getJdbcType());
    }

    protected boolean containsAsEndsWith(String str, List<Object> ls) {
        for (Object current : ls) {
            String currentString = (String)current;
            if (!str.endsWith(currentString)) continue;
            return true;
        }
        return false;
    }

    public void setSql2EntityRelatedTableName(String sql2EntityRelatedTableName) {
        this._sql2EntityRelatedTableName = sql2EntityRelatedTableName;
    }

    public void setSql2EntityRelatedColumnName(String sql2EntityRelatedColumnName) {
        this._sql2EntityRelatedColumnName = sql2EntityRelatedColumnName;
    }

    public void setSql2EntityForcedJavaNative(String sql2EntityForcedJavaNative) {
        this._sql2EntityForcedJavaNative = sql2EntityForcedJavaNative;
    }

    public Inheritance addInheritance(Attributes attrib) {
        Inheritance inh = new Inheritance();
        inh.loadFromXML(attrib);
        this.addInheritance(inh);
        return inh;
    }

    public void addInheritance(Inheritance inh) {
        inh.setColumn(this);
        if (this._inheritanceList == null) {
            this._inheritanceList = new ArrayList<Inheritance>();
            this._isEnumeratedClasses = true;
        }
        this._inheritanceList.add(inh);
    }

    public List<Inheritance> getChildren() {
        return this._inheritanceList;
    }

    public boolean isInheritance() {
        return this._isInheritance;
    }

    public boolean isEnumeratedClasses() {
        return this._isEnumeratedClasses;
    }

    public static String makeList(List<String> columns) {
        String obj = columns.get(0);
        boolean isColumnList = obj instanceof Column;
        if (isColumnList) {
            obj = ((Column)((Object)obj)).getName();
        }
        StringBuilder buf = new StringBuilder(obj);
        for (int i = 1; i < columns.size(); ++i) {
            obj = columns.get(i);
            if (isColumnList) {
                obj = ((Column)((Object)obj)).getName();
            }
            buf.append(", ").append((Object)obj);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("    <column name=\"").append(this._name).append('\"');
        if (this._javaName != null) {
            result.append(" javaName=\"").append(this._javaName).append('\"');
        }
        if (this._isPrimaryKey) {
            result.append(" primaryKey=\"").append(this._isPrimaryKey).append('\"');
        }
        if (this._isNotNull) {
            result.append(" required=\"true\"");
        } else {
            result.append(" required=\"false\"");
        }
        result.append(" type=\"").append(this._jdbcType).append('\"');
        if (this._columnSize != null) {
            result.append(" size=\"").append(this._columnSize).append('\"');
        }
        if (this._defaultValue != null) {
            result.append(" default=\"").append(this._defaultValue).append('\"');
        }
        if (this.isInheritance()) {
            result.append(" inheritance=\"").append(this._inheritanceType).append('\"');
        }
        result.append(" />\n");
        return result.toString();
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected boolean hasQueryRestrictionByClassification() {
        return this.hasClassification();
    }

    protected boolean hasQueryRestrictionByFlgClassification() {
        return this.hasQueryRestrictionByClassification() && this.getClassificationMapList().size() <= 2;
    }

    public boolean isAvailableStringNotEqual() {
        if (this.hasQueryRestrictionByFlgClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringNotEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringGreaterThan() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringGreaterThan(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringLessThan() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringLessThan(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringGreaterEqual() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringGreaterEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringLessEqual() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringLessEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringPrefixSearch() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringPrefixSearch(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringLikeSearch() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringLikeSearch(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringNotLikeSearch() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringNotLikeSearch(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringInScope() {
        return this.getIncludeQueryProperties().isAvailableStringInScope(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringNotInScope() {
        if (this.hasQueryRestrictionByFlgClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringNotInScope(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringEmptyString() {
        if (this.hasQueryRestrictionByFlgClassification()) {
            return false;
        }
        if (!this.getDatabaseChecked().isMakeConditionQueryEqualEmptyString()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableStringEmptyString(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberNotEqual() {
        if (this.hasQueryRestrictionByFlgClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableNumberNotEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberGreaterThan() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableNumberGreaterThan(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberLessThan() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableNumberLessThan(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberGreaterEqual() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableNumberGreaterEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberLessEqual() {
        if (this.hasQueryRestrictionByClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableNumberLessEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberInScope() {
        return this.getIncludeQueryProperties().isAvailableNumberInScope(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberNotInScope() {
        if (this.hasQueryRestrictionByFlgClassification()) {
            return false;
        }
        return this.getIncludeQueryProperties().isAvailableNumberNotInScope(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateNotEqual() {
        return this.getIncludeQueryProperties().isAvailableDateNotEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateGreaterThan() {
        return this.getIncludeQueryProperties().isAvailableDateGreaterThan(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateLessThan() {
        return this.getIncludeQueryProperties().isAvailableDateLessThan(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateGreaterEqual() {
        return this.getIncludeQueryProperties().isAvailableDateGreaterEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateLessEqual() {
        return this.getIncludeQueryProperties().isAvailableDateLessEqual(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateFromTo() {
        return this.getIncludeQueryProperties().isAvailableDateFromTo(this.getTableName(), this.getName());
    }

    protected DfIncludeQueryProperties getIncludeQueryProperties() {
        return DfBuildProperties.getInstance().getIncludeQueryProperties();
    }

    public boolean isAvailableStringEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringNotEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringNotEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringGreaterThanOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringGreaterThanOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringLessThanOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringLessThanOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringGreaterEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringGreaterEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringLessEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringLessEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringPrefixSearchOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringPrefixSearchOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringInScopeOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringInScopeOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringNotInScopeOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringNotInScopeOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableStringInScopeSubQueryOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableStringInScopeSubQueryOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberNotEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberNotEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberGreaterThanOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberGreaterThanOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberLessThanOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberLessThanOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberGreaterEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberGreaterEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberLessEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberLessEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberInScopeOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberInScopeOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberNotInScopeOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberNotInScopeOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableNumberInScopeSubQueryOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableNumberInScopeSubQueryOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableDateEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateNotEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableDateNotEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateGreaterThanOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableDateGreaterThanOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateLessThanOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableDateLessThanOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateGreaterEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableDateGreaterEqualOldAsInline(this.getTableName(), this.getName());
    }

    public boolean isAvailableDateLessEqualOldAsInline() {
        return this.getIncludeQueryProperties().isAvailableDateLessEqualOldAsInline(this.getTableName(), this.getName());
    }

    public Map<String, Map<String, String>> getClassificationDeploymentMap() {
        return this.getTable().getDatabase().getClassificationDeploymentMap();
    }

    public Map<String, List<Map<String, String>>> getClassificationDefinitionMap() {
        return this.getTable().getDatabase().getClassificationDefinitionMap();
    }

    public boolean hasClassification() {
        Database database = this.getTable().getDatabase();
        if (this.hasSql2EntityRelatedTableClassification()) {
            return true;
        }
        return database.hasClassification(this.getTableName(), this.getName());
    }

    public boolean isTableClassification() {
        if (!this.hasClassification()) {
            return false;
        }
        Database database = this.getTable().getDatabase();
        return database.isTableClassification(this.getClassificationName());
    }

    public boolean hasClassificationName() {
        Database database = this.getTable().getDatabase();
        if (this.hasSql2EntityRelatedTableClassificationName()) {
            return true;
        }
        return database.hasClassificationName(this.getTableName(), this.getName());
    }

    public boolean hasClassificationAlias() {
        Database database = this.getTable().getDatabase();
        if (this.hasSql2EntityRelatedTableClassificationAlias()) {
            return true;
        }
        return database.hasClassificationAlias(this.getTableName(), this.getName());
    }

    public String getClassificationName() {
        Database database = this.getTable().getDatabase();
        String classificationName = this.getSql2EntityRelatedTableClassificationName();
        if (classificationName != null) {
            return classificationName;
        }
        return database.getClassificationName(this.getTableName(), this.getName());
    }

    public List<Map<String, String>> getClassificationMapList() {
        try {
            Map<String, List<Map<String, String>>> definitionMap = this.getClassificationDefinitionMap();
            String classificationName = this.getClassificationName();
            List<Map<String, String>> classificationMapList = definitionMap.get(classificationName);
            if (classificationMapList == null) {
                String msg = "The definitionMap did not contain the classificationName:";
                msg = msg + " classificationName=" + classificationName;
                msg = msg + " definitionMap=" + definitionMap;
                throw new IllegalStateException(msg);
            }
            return classificationMapList;
        }
        catch (RuntimeException e) {
            _log.warn((Object)"getClassificationMapList() threw the exception: ", (Throwable)e);
            throw e;
        }
    }

    protected boolean hasSql2EntityRelatedTableClassification() {
        if (this._sql2EntityRelatedTableName == null) {
            return false;
        }
        Database database = this.getTable().getDatabase();
        return database.hasClassification(this._sql2EntityRelatedTableName, this.getName());
    }

    protected boolean hasSql2EntityRelatedTableClassificationName() {
        if (this._sql2EntityRelatedTableName == null) {
            return false;
        }
        Database database = this.getTable().getDatabase();
        return database.hasClassificationName(this._sql2EntityRelatedTableName, this.getName());
    }

    protected boolean hasSql2EntityRelatedTableClassificationAlias() {
        if (this._sql2EntityRelatedTableName == null) {
            return false;
        }
        Database database = this.getTable().getDatabase();
        return database.hasClassificationAlias(this._sql2EntityRelatedTableName, this.getName());
    }

    protected String getSql2EntityRelatedTableClassificationName() {
        if (this._sql2EntityRelatedTableName == null) {
            return null;
        }
        Database database = this.getTable().getDatabase();
        return database.getClassificationName(this._sql2EntityRelatedTableName, this.getName());
    }

    public boolean isIdentityOrSequence() {
        if (this.isIdentity()) {
            return true;
        }
        Table table = this.getTable();
        return this.isPrimaryKey() && table.hasOnlyOnePrimaryKey() && table.isUseSequence();
    }

    public boolean isIdentity() {
        if (this._isAutoIncrement) {
            return true;
        }
        String identityPropertyName = this.getTable().getIdentityPropertyName();
        return this.getTable().isUseIdentity() && this.getJavaName().equalsIgnoreCase(identityPropertyName);
    }

    public boolean isCommonColumn() {
        if (this._commonColumn == null) {
            this._commonColumn = false;
            List<Column> commonColumnList = this.getTable().getCommonColumnList();
            if (this.getTable().hasAllCommonColumn()) {
                for (Column column : commonColumnList) {
                    if (!column.getName().equals(this.getName())) continue;
                    this._commonColumn = true;
                    break;
                }
            }
        }
        return this._commonColumn;
    }

    public boolean isOptimisticLock() {
        return this.isVersionNo() || this.isUpdateDate();
    }

    public boolean isVersionNo() {
        String versionNoPropertyName = this.getTable().getVersionNoPropertyName();
        return this.getTable().isUseVersionNo() && this.getJavaName().equalsIgnoreCase(versionNoPropertyName);
    }

    public boolean isUpdateDate() {
        String updateDatePropertyName = this.getTable().getUpdateDatePropertyName();
        return this.getTable().isUseUpdateDate() && this.getJavaName().equalsIgnoreCase(updateDatePropertyName);
    }

    public String getOptimistickLockExpression() {
        if (this.isVersionNo()) {
            return "OptimisticLockType.VERSION_NO";
        }
        if (this.isUpdateDate()) {
            return "OptimisticLockType.UPDATE_DATE";
        }
        return "null";
    }

    public String getOptimistickLockExpressionNotNull() {
        if (this.isVersionNo()) {
            return "OptimisticLockType.VERSION_NO";
        }
        if (this.isUpdateDate()) {
            return "OptimisticLockType.UPDATE_DATE";
        }
        return "OptimisticLockType.NONE";
    }

    public String getBehaviorFilterBeforeInsertColumnExpression() {
        return this._behaviorFilterBeforeInsertColumnExpression;
    }

    public void setBehaviorFilterBeforeInsertColumnExpression(String expression) {
        this._behaviorFilterBeforeInsertColumnExpression = expression;
    }

    public String getBehaviorFilterBeforeUpdateColumnExpression() {
        return this._behaviorFilterBeforeUpdateColumnExpression;
    }

    public void setBehaviorFilterBeforeUpdateColumnExpression(String expression) {
        this._behaviorFilterBeforeUpdateColumnExpression = expression;
    }

    protected ColumnHelper helper() {
        if (this._columnHelper == null) {
            this._columnHelper = new ColumnHelper();
        }
        return this._columnHelper;
    }

    public boolean hasSchemaHtmlColumnNameCssClass() {
        return this.isCommonColumn() || this.isVersionNo() || this.isUpdateDate();
    }

    public String getSchemaHtmlColumnNameCssClass() {
        String delimiter = " ";
        StringBuilder sb = new StringBuilder();
        if (this.isCommonColumn()) {
            sb.append("comcolcell");
        }
        if (this.isVersionNo() || this.isUpdateDate()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("optcell");
        }
        return sb.toString();
    }

    public String getSchemaHtmlColumnAliasCssClass() {
        String delimiter = " ";
        StringBuilder sb = new StringBuilder();
        sb.append("aliascell");
        if (this.isCommonColumn()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("comcolcell");
        }
        if (this.isVersionNo() || this.isUpdateDate()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("optcell");
        }
        return sb.toString();
    }

    protected class ColumnHelper {
        protected ColumnHelper() {
        }

        public DfBasicProperties getBasicProperties() {
            return Column.this.getTable().getProperties().getBasicProperties();
        }

        public DfLanguageDependencyInfo getLanguageDependencyInfo() {
            return this.getBasicProperties().getLanguageDependencyInfo();
        }
    }
}

