/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.mapstring.MapListString;
import org.seasar.dbflute.helper.mapstring.MapStringBuilder;
import org.seasar.dbflute.helper.mapstring.impl.MapListStringImpl;
import org.seasar.dbflute.helper.mapstring.impl.MapStringBuilderImpl;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.util.DfAssertUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBMeta
implements DBMeta {
    protected static final Object DUMMY_VALUE = new Object();
    private volatile StringKeyMap<String> _tableDbNameFlexibleMap;
    private volatile StringKeyMap<String> _tablePropertyNameFlexibleMap;
    private volatile List<ColumnInfo> _columnInfoList;
    private volatile StringKeyMap<ColumnInfo> _columnInfoFlexibleMap;
    private volatile List<ForeignInfo> _foreignInfoList;
    private volatile StringKeyMap<ForeignInfo> _foreignInfoFlexibleMap;
    private volatile List<ReferrerInfo> _referrerInfoList;
    private volatile StringKeyMap<ReferrerInfo> _referrerInfoFlexibleMap;
    private final Map<String, Object> _methodNameMap = this.newConcurrentHashMap();

    protected void initializeInformationResource() {
        this.getTableDbNameFlexibleMap();
        this.getTablePropertyNameFlexibleMap();
        this.getColumnInfoList();
        this.getColumnInfoFlexibleMap();
        this.hasMethod("dummy");
    }

    @Override
    public String getTableAlias() {
        return null;
    }

    @Override
    public String getTableComment() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getTableDbNameFlexibleMap() {
        if (this._tableDbNameFlexibleMap != null) {
            return this._tableDbNameFlexibleMap;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._tableDbNameFlexibleMap != null) {
                return this._tableDbNameFlexibleMap;
            }
            this._tableDbNameFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            this._tableDbNameFlexibleMap.put(this.getTableDbName(), this.getTableDbName());
            return this._tableDbNameFlexibleMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getTablePropertyNameFlexibleMap() {
        if (this._tablePropertyNameFlexibleMap != null) {
            return this._tablePropertyNameFlexibleMap;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._tablePropertyNameFlexibleMap != null) {
                return this._tablePropertyNameFlexibleMap;
            }
            this._tablePropertyNameFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            this._tablePropertyNameFlexibleMap.put(this.getTableDbName(), this.getTablePropertyName());
            return this._tableDbNameFlexibleMap;
        }
    }

    @Override
    public boolean hasColumn(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        return this.getColumnInfoFlexibleMap().containsKey(columnFlexibleName);
    }

    @Override
    public ColumnInfo findColumnInfo(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        ColumnInfo columnInfo = this.getColumnInfoFlexibleMap().get(columnFlexibleName);
        if (columnInfo == null) {
            String msg = "Not found column by columnFlexibleName: " + columnFlexibleName;
            msg = msg + " tableName=" + this.getTableDbName();
            throw new IllegalArgumentException(msg);
        }
        return columnInfo;
    }

    protected ColumnInfo cci(String columnDbName, String columnAlias, boolean notNull, String propertyName, Class<?> propertyType, boolean primary, boolean autoIncrement, String columnDbType, Integer columnSize, Integer columnDecimalDigits, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType, String columnComment, String foreignListExp, String refererrListExp) {
        String delimiter = ",";
        List<String> foreignPropList = null;
        if (foreignListExp != null && foreignListExp.trim().length() > 0) {
            foreignPropList = DfStringUtil.splitList(foreignListExp, ",");
        }
        List<String> refererrPropList = null;
        if (refererrListExp != null && refererrListExp.trim().length() > 0) {
            refererrPropList = DfStringUtil.splitList(refererrListExp, ",");
        }
        return new ColumnInfo(this, columnDbName, columnAlias, notNull, propertyName, propertyType, primary, autoIncrement, columnDbType, columnSize, columnDecimalDigits, commonColumn, optimisticLockType, columnComment, foreignPropList, refererrPropList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnInfo> getColumnInfoList() {
        if (this._columnInfoList != null) {
            return this._columnInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoList != null) {
                return this._columnInfoList;
            }
            this._columnInfoList = this.ccil();
            return this._columnInfoList;
        }
    }

    protected abstract List<ColumnInfo> ccil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ColumnInfo> getColumnInfoFlexibleMap() {
        if (this._columnInfoFlexibleMap != null) {
            return this._columnInfoFlexibleMap;
        }
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoFlexibleMap != null) {
                return this._columnInfoFlexibleMap;
            }
            this._columnInfoFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            for (ColumnInfo columnInfo : columnInfoList) {
                this._columnInfoFlexibleMap.put(columnInfo.getColumnDbName(), columnInfo);
            }
            return this._columnInfoFlexibleMap;
        }
    }

    protected UniqueInfo cpui(ColumnInfo uniqueColumnInfo) {
        return this.cpui(Arrays.asList(uniqueColumnInfo));
    }

    protected UniqueInfo cpui(List<ColumnInfo> uniqueColumnInfoList) {
        UniqueInfo uniqueInfo = new UniqueInfo(this, uniqueColumnInfoList, true);
        return uniqueInfo;
    }

    @Override
    public RelationInfo findRelationInfo(String relationPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("relationPropertyName", relationPropertyName);
        return this.hasForeign(relationPropertyName) ? this.findForeignInfo(relationPropertyName) : this.findReferrerInfo(relationPropertyName);
    }

    @Override
    public boolean hasForeign(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("foreign", foreignPropertyName);
        return this.hasMethod(methodName);
    }

    @Override
    public DBMeta findForeignDBMeta(String foreignPropertyName) {
        return this.findForeignInfo(foreignPropertyName).getForeignDBMeta();
    }

    @Override
    public ForeignInfo findForeignInfo(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("foreign", foreignPropertyName);
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Not found foreign by foreignPropertyName: foreignPropertyName=" + foreignPropertyName;
            msg = msg + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new IllegalStateException(msg, e);
        }
        try {
            return (ForeignInfo)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    protected ForeignInfo cfi(String propName, DBMeta localDbm, DBMeta foreignDbm, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relNo, boolean oneToOne) {
        return new ForeignInfo(propName, localDbm, foreignDbm, localForeignColumnInfoMap, relNo, oneToOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForeignInfo> getForeignInfoList() {
        if (this._foreignInfoList != null) {
            return this._foreignInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoList != null) {
                return this._foreignInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            this._foreignInfoList = this.newArrayList();
            String prefix = "foreign";
            Class<ForeignInfo> returnType = ForeignInfo.class;
            Object[] args = new Object[]{};
            try {
                for (Method method : methods) {
                    if (!method.getName().startsWith(prefix) || !returnType.equals(method.getReturnType())) continue;
                    this._foreignInfoList.add((ForeignInfo)method.invoke((Object)this, args));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return this._foreignInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ForeignInfo> getForeignInfoFlexibleMap() {
        if (this._foreignInfoFlexibleMap != null) {
            return this._foreignInfoFlexibleMap;
        }
        List<ForeignInfo> foreignInfoList = this.getForeignInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoFlexibleMap != null) {
                return this._foreignInfoFlexibleMap;
            }
            this._foreignInfoFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            for (ForeignInfo foreignInfo : foreignInfoList) {
                this._foreignInfoFlexibleMap.put(foreignInfo.getForeignPropertyName(), foreignInfo);
            }
            return this._foreignInfoFlexibleMap;
        }
    }

    @Override
    public boolean hasReferrer(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("referrer", referrerPropertyName);
        return this.hasMethod(methodName);
    }

    @Override
    public DBMeta findReferrerDBMeta(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        return this.findReferrerInfo(referrerPropertyName).getReferrerDBMeta();
    }

    @Override
    public ReferrerInfo findReferrerInfo(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("referrer", referrerPropertyName);
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Not found referrer by referrerPropertyName: referrerPropertyName=" + referrerPropertyName;
            msg = msg + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new IllegalStateException(msg, e);
        }
        try {
            return (ReferrerInfo)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    protected ReferrerInfo cri(String propName, DBMeta localDbm, DBMeta referrerDbm, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne) {
        return new ReferrerInfo(propName, localDbm, referrerDbm, localReferrerColumnInfoMap, oneToOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReferrerInfo> getReferrerInfoList() {
        if (this._referrerInfoList != null) {
            return this._referrerInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._referrerInfoList != null) {
                return this._referrerInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            this._referrerInfoList = this.newArrayList();
            String prefix = "referrer";
            Class<ReferrerInfo> returnType = ReferrerInfo.class;
            Object[] args = new Object[]{};
            try {
                for (Method method : methods) {
                    if (!method.getName().startsWith(prefix) || !returnType.equals(method.getReturnType())) continue;
                    this._referrerInfoList.add((ReferrerInfo)method.invoke((Object)this, args));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return this._referrerInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ReferrerInfo> getReferrerInfoFlexibleMap() {
        if (this._referrerInfoFlexibleMap != null) {
            return this._referrerInfoFlexibleMap;
        }
        List<ReferrerInfo> referrerInfoList = this.getReferrerInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._referrerInfoFlexibleMap != null) {
                return this._referrerInfoFlexibleMap;
            }
            this._referrerInfoFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
            for (ReferrerInfo referrerInfo : referrerInfoList) {
                this._referrerInfoFlexibleMap.put(referrerInfo.getReferrerPropertyName(), referrerInfo);
            }
            return this._referrerInfoFlexibleMap;
        }
    }

    protected String buildRelationInfoGetterMethodNameInitCap(String targetName, String relationPropertyName) {
        return targetName + relationPropertyName.substring(0, 1).toUpperCase() + relationPropertyName.substring(1);
    }

    @Override
    public MapListString createMapListString() {
        return MapStringUtil.createMapListString();
    }

    @Override
    public MapStringBuilder createMapStringBuilder() {
        ArrayList<String> columnDbNameList = new ArrayList<String>();
        for (ColumnInfo columnInfo : this.getColumnInfoList()) {
            columnDbNameList.add(columnInfo.getColumnDbName());
        }
        return MapStringUtil.createMapStringBuilder(columnDbNameList);
    }

    @Override
    public boolean hasIdentity() {
        return false;
    }

    @Override
    public boolean hasSequence() {
        return false;
    }

    @Override
    public String getSequenceName() {
        return null;
    }

    @Override
    public String getSequenceNextValSql() {
        if (!this.hasSequence()) {
            return null;
        }
        return this.getCurrentDBDef().dbway().buildSequenceNextValSql(this.getSequenceName());
    }

    @Override
    public Integer getSequenceIncrementSize() {
        return null;
    }

    @Override
    public Integer getSequenceCacheSize() {
        return null;
    }

    @Override
    public boolean hasVersionNo() {
        return false;
    }

    @Override
    public ColumnInfo getVersionNoColumnInfo() {
        return null;
    }

    @Override
    public boolean hasUpdateDate() {
        return false;
    }

    @Override
    public ColumnInfo getUpdateDateColumnInfo() {
        return null;
    }

    @Override
    public boolean hasCommonColumn() {
        return false;
    }

    @Override
    public boolean hasFlexibleName(String flexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("flexibleName", flexibleName);
        return this.getColumnInfoFlexibleMap().containsKey(flexibleName) || this.getTableDbNameFlexibleMap().containsKey(flexibleName);
    }

    @Override
    public String findDbName(String flexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("flexibleName", flexibleName);
        ColumnInfo columnInfoMap = this.getColumnInfoFlexibleMap().get(flexibleName);
        if (columnInfoMap != null) {
            return columnInfoMap.getColumnDbName();
        }
        String tableDbName = this.getTableDbNameFlexibleMap().get(flexibleName);
        if (tableDbName != null) {
            return tableDbName;
        }
        String msg = "Not found DB name by the flexible name: flexibleName=" + flexibleName;
        throw new IllegalArgumentException(msg);
    }

    @Override
    public String findPropertyName(String flexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("flexibleName", flexibleName);
        ColumnInfo columnInfoMap = this.getColumnInfoFlexibleMap().get(flexibleName);
        if (columnInfoMap != null) {
            return columnInfoMap.getPropertyName();
        }
        String tablePropertyName = this.getTablePropertyNameFlexibleMap().get(flexibleName);
        if (tablePropertyName != null) {
            return tablePropertyName;
        }
        String msg = "Not found property name by the flexible name: flexibleName=" + flexibleName;
        throw new IllegalArgumentException(msg);
    }

    protected <ENTITY extends Entity> void doAcceptPrimaryKeyMap(ENTITY entity, Map<String, ? extends Object> columnValueMap, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        MapAssertUtil.assertColumnValueMapNotNullAndNotEmpty(columnValueMap);
        entity.clearModifiedPropertyNames();
        MapStringValueAnalyzer analyzer = new MapStringValueAnalyzer(columnValueMap);
        List<ColumnInfo> columnInfoList = this.getPrimaryUniqueInfo().getUniqueColumnList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            String uncapPropName = this.initUncap(propertyName);
            Class<?> propertyType = columnInfo.getPropertyType();
            if (!analyzer.init(columnName, uncapPropName, propertyName)) continue;
            Object value = String.class.isAssignableFrom(propertyType) ? analyzer.analyzeString(propertyType) : (Number.class.isAssignableFrom(propertyType) ? analyzer.analyzeNumber(propertyType) : (Date.class.isAssignableFrom(propertyType) ? analyzer.analyzeDate(propertyType) : analyzer.analyzeOther(propertyType)));
            this.findEps(entityPropertySetupperMap, propertyName).setup(entity, value);
        }
    }

    protected <ENTITY extends Entity> void doAcceptColumnValueMap(ENTITY entity, Map<String, ? extends Object> columnValueMap, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        MapAssertUtil.assertColumnValueMapNotNullAndNotEmpty(columnValueMap);
        MapStringValueAnalyzer analyzer = new MapStringValueAnalyzer(columnValueMap);
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            String uncapPropName = this.initUncap(propertyName);
            Class<?> propertyType = columnInfo.getPropertyType();
            if (!analyzer.init(columnName, uncapPropName, propertyName)) continue;
            Object value = String.class.isAssignableFrom(propertyType) ? analyzer.analyzeString(propertyType) : (Number.class.isAssignableFrom(propertyType) ? analyzer.analyzeNumber(propertyType) : (Date.class.isAssignableFrom(propertyType) ? analyzer.analyzeDate(propertyType) : analyzer.analyzeOther(propertyType)));
            this.findEps(entityPropertySetupperMap, propertyName).setup(entity, value);
        }
    }

    protected String doExtractPrimaryKeyMapString(Entity entity, String startBrace, String endBrace, String delimiter, String equal) {
        List<ColumnInfo> uniqueColumnList = this.getPrimaryUniqueInfo().getUniqueColumnList();
        return this.doExtractValueMapMapString(entity, uniqueColumnList, startBrace, endBrace, delimiter, equal);
    }

    protected String doExtractColumnValueMapString(Entity entity, String startBrace, String endBrace, String delimiter, String equal) {
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        return this.doExtractValueMapMapString(entity, columnInfoList, startBrace, endBrace, delimiter, equal);
    }

    protected String doExtractValueMapMapString(Entity entity, List<ColumnInfo> columnInfoList, String startBrace, String endBrace, String delimiter, String equal) {
        String mapMarkAndStartBrace = "map:" + startBrace;
        StringBuilder sb = new StringBuilder();
        try {
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, (Object[])null);
                value = this.filterClassificationValueIfNeeds(value);
                this.helpAppendingColumnValueString(sb, delimiter, equal, columnName, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        sb.delete(0, delimiter.length()).insert(0, mapMarkAndStartBrace).append(endBrace);
        return sb.toString();
    }

    protected Object filterClassificationValueIfNeeds(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Classification) {
            value = ((Classification)value).code();
        }
        return value;
    }

    protected Map<String, Object> doConvertToColumnValueMap(Entity entity) {
        LinkedHashMap<String, Object> valueMap = this.newLinkedHashMap();
        try {
            List<ColumnInfo> columnInfoList = this.getColumnInfoList();
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, (Object[])null);
                valueMap.put(columnName, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return valueMap;
    }

    protected Map<String, String> doConvertToColumnStringValueMap(Entity entity) {
        LinkedHashMap<String, String> valueMap = this.newLinkedHashMap();
        try {
            List<ColumnInfo> columnInfoList = this.getColumnInfoList();
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, (Object[])null);
                valueMap.put(columnName, this.helpGettingColumnStringValue(value));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return valueMap;
    }

    protected <ENTITY extends Entity> void setupEps(Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap, DBMeta.Eps<ENTITY> setupper, ColumnInfo columnInfo) {
        String columnName = columnInfo.getColumnDbName();
        String propertyName = columnInfo.getPropertyName();
        this.registerEntityPropertySetupper(columnName, propertyName, setupper, entityPropertySetupperMap);
    }

    protected <ENTITY extends Entity> void registerEntityPropertySetupper(String columnName, String propertyName, DBMeta.Eps<ENTITY> setupper, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        entityPropertySetupperMap.put(columnName, setupper);
    }

    protected <ENTITY extends Entity> DBMeta.Eps<ENTITY> findEps(Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap, String propertyName) {
        DBMeta.Eps<ENTITY> setupper = entityPropertySetupperMap.get(propertyName);
        if (setupper == null) {
            String msg = "The propertyName was Not Found in the map of setupper of entity property:";
            msg = msg + " propertyName=" + propertyName + " _entityPropertySetupperMap.keySet()=" + entityPropertySetupperMap.keySet();
            throw new IllegalStateException(msg);
        }
        return setupper;
    }

    protected <ENTITY> ENTITY downcast(Entity entity) {
        this.checkDowncast(entity);
        return (ENTITY)entity;
    }

    protected void checkDowncast(Entity entity) {
        this.assertObjectNotNull("entity", entity);
        Class<? extends Entity> entityType = this.getEntityType();
        Class<?> targetType = entity.getClass();
        if (!entityType.isAssignableFrom(targetType)) {
            String name = entityType.getSimpleName();
            String msg = "The entity should be " + name + " but it was: " + targetType;
            throw new IllegalStateException(msg);
        }
    }

    protected void helpAppendingColumnValueString(StringBuilder sb, String delimiter, String equal, String colName, Object value) {
        sb.append(delimiter).append(colName).append(equal);
        sb.append(this.helpGettingColumnStringValue(value));
    }

    protected String helpGettingColumnStringValue(Object value) {
        if (value instanceof Timestamp) {
            return this.helpFormatingTimestamp((Timestamp)value);
        }
        if (value instanceof Date) {
            return this.helpFormatingDate((Date)value);
        }
        return value != null ? value.toString() : "";
    }

    protected String helpFormatingDate(Date date) {
        return MapStringUtil.formatDate(date);
    }

    protected String helpFormatingTimestamp(Timestamp timestamp) {
        return MapStringUtil.formatTimestamp(timestamp);
    }

    protected Map<String, String> setupKeyToLowerMap(boolean dbNameKey) {
        ConcurrentHashMap<String, String> map = dbNameKey ? this.newConcurrentHashMap(this.getTableDbName().toLowerCase(), this.getTablePropertyName()) : this.newConcurrentHashMap(this.getTablePropertyName().toLowerCase(), this.getTableDbName());
        Method[] methods = this.getClass().getMethods();
        String columnInfoMethodPrefix = "column";
        try {
            for (Method method : methods) {
                String name = method.getName();
                if (!name.startsWith(columnInfoMethodPrefix)) continue;
                ColumnInfo columnInfo = (ColumnInfo)method.invoke((Object)this, new Object[0]);
                String dbName = columnInfo.getColumnDbName();
                String propertyName = columnInfo.getPropertyName();
                if (dbNameKey) {
                    map.put(dbName.toLowerCase(), propertyName);
                    continue;
                }
                map.put(propertyName.toLowerCase(), dbName);
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return DfStringUtil.initCap(str);
    }

    protected String initUncap(String str) {
        return DfStringUtil.initUncap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap(KEY key, VALUE value) {
        ConcurrentHashMap<KEY, VALUE> map = this.newConcurrentHashMap();
        map.put(key, value);
        return map;
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key, VALUE value) {
        LinkedHashMap<KEY, VALUE> map = this.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT element) {
        ArrayList<ELEMENT> arrayList = new ArrayList<ELEMENT>();
        arrayList.add(element);
        return arrayList;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return new ArrayList<ELEMENT>(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasMethod(String methodName) {
        this.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        if (this._methodNameMap.isEmpty()) {
            Map<String, Object> map = this._methodNameMap;
            synchronized (map) {
                if (this._methodNameMap.isEmpty()) {
                    Method[] methods;
                    for (Method method : methods = this.getClass().getMethods()) {
                        this._methodNameMap.put(method.getName(), DUMMY_VALUE);
                    }
                }
            }
        }
        return this._methodNameMap.containsKey(methodName);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapStringValueAnalyzer {
        protected Map<String, ? extends Object> _valueMap;
        protected String _columnName;
        protected String _uncapPropName;
        protected String _propertyName;

        public MapStringValueAnalyzer(Map<String, ? extends Object> valueMap) {
            this._valueMap = valueMap;
        }

        public boolean init(String columnName, String uncapPropName, String propertyName) {
            this._columnName = columnName;
            this._uncapPropName = uncapPropName;
            this._propertyName = propertyName;
            return this._valueMap.containsKey(this._columnName);
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeString(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                return null;
            }
            this.helpCheckingTypeString(obj, this._uncapPropName, javaType.getName());
            return (COLUMN_TYPE)obj;
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeNumber(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                return null;
            }
            if (javaType.isAssignableFrom(obj.getClass())) {
                return (COLUMN_TYPE)obj;
            }
            return (COLUMN_TYPE)this.newInstanceByConstructor(javaType, String.class, obj.toString());
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeDate(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                return null;
            }
            if (javaType.isAssignableFrom(obj.getClass())) {
                return (COLUMN_TYPE)obj;
            }
            return (COLUMN_TYPE)this.newInstanceByConstructor(javaType, Long.TYPE, this.helpParsingDateString(obj, this._uncapPropName, javaType.getName()));
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeOther(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                return null;
            }
            if (Classification.class.isAssignableFrom(javaType)) {
                try {
                    Method codeOfMethod = javaType.getMethod("codeOf", Object.class);
                    return (COLUMN_TYPE)codeOfMethod.invoke(null, obj);
                }
                catch (Exception e) {
                    String msg = "The method threw the exception: javaType=" + javaType + " obj=" + obj;
                    throw new IllegalStateException(msg, e);
                }
            }
            return (COLUMN_TYPE)obj;
        }

        private void helpCheckingTypeString(Object value, String uncapPropName, String typeName) {
            MapStringUtil.checkTypeString(value, uncapPropName, typeName);
        }

        private long helpParsingDateString(Object value, String uncapPropName, String typeName) {
            return MapStringUtil.parseDateStringAsMillis(value, uncapPropName, typeName);
        }

        protected Object newInstanceByConstructor(Class targetType, Class argType, Object arg) {
            Constructor constructor;
            try {
                constructor = targetType.getConstructor(argType);
            }
            catch (SecurityException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new IllegalStateException(msg, e);
            }
            catch (NoSuchMethodException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new IllegalStateException(msg, e);
            }
            try {
                return constructor.newInstance(arg);
            }
            catch (IllegalArgumentException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new IllegalStateException(msg, e);
            }
            catch (InstantiationException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new IllegalStateException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new IllegalStateException(msg, e);
            }
            catch (InvocationTargetException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new IllegalStateException(msg, e.getCause());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapAssertUtil {
        protected MapAssertUtil() {
        }

        public static void assertPrimaryKeyMapNotNullAndNotEmpty(Map<String, ? extends Object> primaryKeyMap) {
            if (primaryKeyMap == null) {
                String msg = "The argument[primaryKeyMap] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            if (primaryKeyMap.isEmpty()) {
                String msg = "The argument[primaryKeyMap] should not be empty.";
                throw new IllegalArgumentException(msg);
            }
        }

        public static void assertColumnExistingInPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap, String columnName) {
            if (!primaryKeyMap.containsKey(columnName)) {
                String msg = "The primaryKeyMap must have the value of " + columnName;
                throw new IllegalStateException(msg + ": primaryKeyMap --> " + primaryKeyMap);
            }
        }

        public static void assertColumnValueMapNotNullAndNotEmpty(Map<String, ? extends Object> columnValueMap) {
            if (columnValueMap == null) {
                String msg = "The argument[columnValueMap] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            if (columnValueMap.isEmpty()) {
                String msg = "The argument[columnValueMap] should not be empty.";
                throw new IllegalArgumentException(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapStringUtil {
        protected MapStringUtil() {
        }

        public static void acceptPrimaryKeyMapString(String primaryKeyMapString, Entity entity) {
            if (primaryKeyMapString == null) {
                String msg = "The argument[primaryKeyMapString] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            String prefix = "map:@{";
            String suffix = "@}";
            if (!primaryKeyMapString.trim().startsWith("map:@{")) {
                primaryKeyMapString = "map:@{" + primaryKeyMapString;
            }
            if (!primaryKeyMapString.trim().endsWith("@}")) {
                primaryKeyMapString = primaryKeyMapString + "@}";
            }
            MapListString mapListString = MapStringUtil.createMapListString();
            entity.getDBMeta().acceptPrimaryKeyMap(entity, mapListString.generateMap(primaryKeyMapString));
        }

        public static void acceptColumnValueMapString(String columnValueMapString, Entity entity) {
            if (columnValueMapString == null) {
                String msg = "The argument[columnValueMapString] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            String prefix = "map:@{";
            String suffix = "@}";
            if (!columnValueMapString.trim().startsWith("map:@{")) {
                columnValueMapString = "map:@{" + columnValueMapString;
            }
            if (!columnValueMapString.trim().endsWith("@}")) {
                columnValueMapString = columnValueMapString + "@}";
            }
            MapListString mapListString = MapStringUtil.createMapListString();
            entity.getDBMeta().acceptColumnValueMap(entity, mapListString.generateMap(columnValueMapString));
        }

        public static String extractPrimaryKeyMapString(Entity entity) {
            String startBrace = "@{";
            String endBrace = "@}";
            String delimiter = "@;";
            String equal = "@=";
            return entity.getDBMeta().extractPrimaryKeyMapString(entity, "@{", "@}", "@;", "@=");
        }

        public static String extractColumnValueMapString(Entity entity) {
            String startBrace = "@{";
            String endBrace = "@}";
            String delimiter = "@;";
            String equal = "@=";
            return entity.getDBMeta().extractColumnValueMapString(entity, "@{", "@}", "@;", "@=");
        }

        public static void checkTypeString(Object value, String propertyName, String typeName) {
            if (value == null) {
                throw new IllegalArgumentException("The value should not be null: " + propertyName);
            }
            if (!(value instanceof String)) {
                String msg = "The value of " + propertyName + " should be " + typeName + " or String: ";
                msg = msg + "valueType=" + value.getClass() + " value=" + value;
                throw new IllegalArgumentException(msg);
            }
        }

        public static long parseDateStringAsMillis(Object value, String propertyName, String typeName) {
            MapStringUtil.checkTypeString(value, propertyName, typeName);
            try {
                String valueString = MapStringUtil.filterTimestampValue(((String)value).trim());
                return Timestamp.valueOf(valueString).getTime();
            }
            catch (RuntimeException e) {
                String msg = "The value of " + propertyName + " should be " + typeName + ". but: " + value;
                throw new RuntimeException(msg + " threw the exception: value=[" + value + "]", e);
            }
        }

        public static String filterTimestampValue(String value) {
            if ((value = value.trim()).indexOf("/") == 4 && value.lastIndexOf("/") == 7) {
                value = value.replaceAll("/", "-");
            }
            if (value.indexOf("-") == 4 && value.lastIndexOf("-") == 7 && value.length() == "2007-07-09".length()) {
                value = value + " 00:00:00";
            }
            return value;
        }

        public static String formatDate(Date value) {
            return MapStringUtil.getFormatDateFormat().format(value);
        }

        public static String formatTimestamp(Timestamp value) {
            return MapStringUtil.getFormatDateFormat().format(value);
        }

        public static DateFormat getParseDateFormat() {
            return DateFormat.getDateInstance();
        }

        public static DateFormat getFormatDateFormat() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }

        public static MapListString createMapListString() {
            MapListStringImpl mapListString = new MapListStringImpl();
            mapListString.setMapMark("map:");
            mapListString.setListMark("list:");
            mapListString.setStartBrace("@{");
            mapListString.setEndBrace("@}");
            mapListString.setEqual("@=");
            mapListString.setDelimiter("@;");
            return mapListString;
        }

        public static MapStringBuilder createMapStringBuilder(List<String> columnNameList) {
            MapStringBuilderImpl mapStringBuilder = new MapStringBuilderImpl();
            mapStringBuilder.setMsMapMark("map:");
            mapStringBuilder.setMsStartBrace("@{");
            mapStringBuilder.setMsEndBrace("@}");
            mapStringBuilder.setMsEqual("@=");
            mapStringBuilder.setMsDelimiter("@;");
            mapStringBuilder.setColumnNameList(columnNameList);
            return mapStringBuilder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractRelationTrace
    implements DBMeta.RelationTrace {
        protected List<RelationInfo> _relationList;
        protected List<AbstractRelationTrace> _relationTraceList;
        protected List<RelationInfo> _traceRelationInfoList;
        protected ColumnInfo _traceColumnInfo;
        protected DBMeta.RelationTraceFixHandler _relationTraceFixHandler;

        public AbstractRelationTrace(DBMeta.RelationTraceFixHandler relationTraceFixHandler) {
            this(new ArrayList<RelationInfo>(), new ArrayList<AbstractRelationTrace>());
            this._relationTraceFixHandler = relationTraceFixHandler;
        }

        public AbstractRelationTrace(List<RelationInfo> relationList, List<AbstractRelationTrace> relationTraceList) {
            this._relationList = relationList;
            this._relationTraceList = relationTraceList;
            this._relationTraceList.add(this);
        }

        @Override
        public List<RelationInfo> getTraceRelation() {
            return this._traceRelationInfoList;
        }

        @Override
        public ColumnInfo getTraceColumn() {
            return this._traceColumnInfo;
        }

        protected DBMeta.RelationTrace fixTrace(List<RelationInfo> traceRelationInfoList, ColumnInfo traceColumnInfo) {
            AbstractRelationTrace localRelationTrace = this._relationTraceList.get(0);
            localRelationTrace.setTraceRelation(traceRelationInfoList);
            localRelationTrace.setTraceColumn(traceColumnInfo);
            localRelationTrace.recycle();
            localRelationTrace.handleFixedRelationTrace();
            return localRelationTrace;
        }

        protected void setTraceRelation(List<RelationInfo> traceRelationInfoList) {
            this._traceRelationInfoList = traceRelationInfoList;
        }

        protected void setTraceColumn(ColumnInfo traceColumn) {
            this._traceColumnInfo = traceColumn;
        }

        protected void recycle() {
            this._relationList = new ArrayList<RelationInfo>();
            this._relationTraceList = new ArrayList<AbstractRelationTrace>();
            this._relationTraceList.add(this);
        }

        protected void handleFixedRelationTrace() {
            if (this._relationTraceFixHandler != null) {
                this._relationTraceFixHandler.handleFixedTrace(this);
            }
        }
    }
}

