/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import org.seasar.dbflute.cbean.sqlclause.AbstractSqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.WhereClauseArranger;
import org.seasar.dbflute.dbmeta.DBMeta;

public class SqlClauseOracle
extends AbstractSqlClause {
    protected String _fetchScopeSelectHint = "";
    protected String _fetchScopeSqlSuffix = "";
    protected String _lockSqlSuffix = "";

    public SqlClauseOracle(String tableDbName) {
        super(tableDbName);
    }

    protected String prepareUnionClause(String selectClause) {
        selectClause = this.replaceString(selectClause, "/*$pmb.selectHint*/", "");
        return super.prepareUnionClause(selectClause);
    }

    protected void doFetchFirst() {
        this.doFetchPage();
    }

    protected void doFetchPage() {
        AbstractSqlClause.RownumPagingProcessor processor = new AbstractSqlClause.RownumPagingProcessor(this.getRownumExpression());
        processor.processRowNumberPaging();
        this._fetchScopeSelectHint = processor.getSelectHint();
        this._fetchScopeSqlSuffix = processor.getSqlSuffix();
    }

    protected String getRownumExpression() {
        return "rownum";
    }

    protected void doClearFetchPageClause() {
        this._fetchScopeSelectHint = "";
        this._fetchScopeSqlSuffix = "";
    }

    public SqlClause lockForUpdate() {
        DBMeta dbmeta = this.findDBMeta(this._tableDbName);
        if (dbmeta.hasPrimaryKey()) {
            String primaryKeyColumnName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
            this._lockSqlSuffix = " for update of " + this.getLocalTableAliasName() + "." + primaryKeyColumnName;
        } else {
            String randomColumnName = dbmeta.getColumnInfoList().get(0).getColumnDbName();
            this._lockSqlSuffix = " for update of " + this.getLocalTableAliasName() + "." + randomColumnName;
        }
        return this;
    }

    protected String createSelectHint() {
        return this._fetchScopeSelectHint;
    }

    protected String createFromBaseTableHint() {
        return "";
    }

    protected String createFromHint() {
        return "";
    }

    protected String createSqlSuffix() {
        return this._fetchScopeSqlSuffix + this._lockSqlSuffix;
    }

    public SqlClause lockForUpdateNoWait() {
        this.lockForUpdate();
        this._lockSqlSuffix = this._lockSqlSuffix + " nowait";
        return this;
    }

    public SqlClause lockForUpdateWait(int waitSec) {
        this.lockForUpdate();
        this._lockSqlSuffix = this._lockSqlSuffix + " wait " + waitSec;
        return this;
    }

    public int getInScopeLimit() {
        return 1000;
    }

    public WhereClauseArranger createFullTextSearchClauseArranger() {
        return new FullTextSearchClauseArranger();
    }

    public String escapeFullTextSearchValue(String conditionValue) {
        if (conditionValue.contains("}")) {
            conditionValue = this.replaceString(conditionValue, "}", "}}");
        }
        conditionValue = "{" + conditionValue + "}";
        return conditionValue;
    }

    protected static class FullTextSearchClauseArranger
    implements WhereClauseArranger {
        protected FullTextSearchClauseArranger() {
        }

        public String arrange(String columnName, String operand, String bindExpression, String rearOption) {
            return "contains(" + columnName + ", " + bindExpression + ") > 0";
        }
    }
}

