/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.OrderByElement;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.WhereClauseSimpleFilter;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.util.DfAssertUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlClause
implements SqlClause {
    protected static final SqlClause.SelectClauseType DEFAULT_SELECT_CLAUSE_TYPE = SqlClause.SelectClauseType.COLUMNS;
    protected static final String SELECT_HINT = "/*$pmb.selectHint*/";
    protected final String _tableDbName;
    protected DBMeta _dbmeta;
    protected DBMetaProvider _dbmetaProvider;
    protected final Map<String, DBMeta> _cachedDBMetaMap = StringKeyMap.createAsFlexible();
    protected Map<String, Map<String, SelectedSelectColumnInfo>> _selectedSelectColumnMap = new LinkedHashMap<String, Map<String, SelectedSelectColumnInfo>>();
    protected Map<String, Map<String, String>> _specifiedSelectColumnMap;
    protected Map<String, Map<String, String>> _backupSpecifiedSelectColumnMap;
    protected Map<String, String> _specifiedDeriveSubQueryMap;
    protected Map<String, String> _selectClauseRealColumnAliasMap = new HashMap<String, String>();
    protected SqlClause.SelectClauseType _selectClauseType = DEFAULT_SELECT_CLAUSE_TYPE;
    protected SqlClause.SelectClauseType _previousSelectClauseType;
    protected Map<String, Integer> _selectIndexMap;
    protected boolean _useSelectIndex = true;
    protected Map<String, LeftOuterJoinInfo> _outerJoinMap = new LinkedHashMap<String, LeftOuterJoinInfo>();
    protected boolean _innerJoinEffective = false;
    protected List<String> _whereList = new ArrayList<String>();
    protected List<String> _baseTableInlineWhereList = new ArrayList<String>(2);
    protected final OrderByClause _orderByClause = new OrderByClause();
    protected List<UnionQueryInfo> _unionQueryInfoList;
    protected boolean _orderByEffective = false;
    protected int _fetchStartIndex = 0;
    protected int _fetchSize = 0;
    protected int _fetchPageNumber = 1;
    protected boolean _fetchScopeEffective = false;
    protected boolean _orScopeQueryEffective;
    protected TmpOrScopeQueryInfo _currentTmpOrScopeQueryInfo;
    protected boolean _orScopeQueryAndPart;
    protected List<WhereClauseSimpleFilter> _whereClauseSimpleFilterList;
    protected Map<String, String> _selectedForeignInfo;
    protected boolean _formatClause = true;

    public AbstractSqlClause(String tableDbName) {
        if (tableDbName == null) {
            String msg = "The argument 'tableDbName' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._tableDbName = tableDbName;
    }

    public SqlClause provider(DBMetaProvider dbmetaProvider) {
        if (dbmetaProvider == null) {
            String msg = "The argument 'dbmetaProvider' should not be null:";
            msg = msg + " tableDbName=" + this._tableDbName;
            throw new IllegalArgumentException(msg);
        }
        this._dbmetaProvider = dbmetaProvider;
        this._dbmeta = this.findDBMeta(this._tableDbName);
        return this;
    }

    @Override
    public String getClause() {
        StringBuilder sb = new StringBuilder(512);
        String selectClause = this.getSelectClause();
        sb.append(selectClause);
        sb.append(" ");
        this.buildClauseWithoutMainSelect(sb, selectClause);
        String sql = sb.toString();
        sql = this.filterEnclosingClause(sql);
        sql = this.filterSubQueryIndent(sql);
        return sql;
    }

    protected void buildClauseWithoutMainSelect(StringBuilder sb, String selectClause) {
        this.buildFromClause(sb);
        sb.append(this.getFromHint());
        sb.append(" ");
        this.buildWhereClause(sb);
        String unionClause = this.prepareUnionClause(selectClause);
        unionClause = this.deleteUnionWhereTemplateMark(unionClause);
        sb.append(unionClause);
        if (!this.needsUnionNormalSelectEnclosing()) {
            sb.append(this.prepareClauseOrderBy());
            sb.append(this.prepareClauseSqlSuffix());
        }
    }

    protected String deleteUnionWhereTemplateMark(String unionClause) {
        if (unionClause != null && unionClause.trim().length() > 0) {
            unionClause = this.replaceString(unionClause, this.getUnionWhereClauseMark(), "");
            unionClause = this.replaceString(unionClause, this.getUnionWhereFirstConditionMark(), "");
        }
        return unionClause;
    }

    @Override
    public String getClauseFromWhereWithUnionTemplate() {
        return this.buildClauseFromWhereAsTemplate(false);
    }

    @Override
    public String getClauseFromWhereWithWhereUnionTemplate() {
        return this.buildClauseFromWhereAsTemplate(true);
    }

    protected String buildClauseFromWhereAsTemplate(boolean template) {
        StringBuilder sb = new StringBuilder(256);
        this.buildFromClause(sb);
        sb.append(this.getFromHint());
        sb.append(" ");
        this.buildWhereClause(sb, template);
        sb.append(this.prepareUnionClause(this.getUnionSelectClauseMark()));
        return sb.toString();
    }

    protected String prepareUnionClause(String selectClause) {
        if (!this.hasUnionQuery()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (UnionQueryInfo unionQueryInfo : this._unionQueryInfoList) {
            String unionQueryClause = unionQueryInfo.getUnionQueryClause();
            boolean unionAll = unionQueryInfo.isUnionAll();
            sb.append(this.ln());
            sb.append(unionAll ? " union all " : " union ");
            sb.append(this.ln());
            sb.append(selectClause).append(" ").append(unionQueryClause);
        }
        return sb.toString();
    }

    protected String prepareClauseOrderBy() {
        if (!this._orderByEffective || this._orderByClause.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(this.getOrderByClause());
        return sb.toString();
    }

    protected String prepareClauseSqlSuffix() {
        String sqlSuffix = this.getSqlSuffix();
        if (sqlSuffix == null || sqlSuffix.trim().length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(sqlSuffix);
        return sb.toString();
    }

    protected String filterEnclosingClause(String sql) {
        sql = this.filterUnionNormalSelectEnclosing(sql);
        sql = this.filterUnionCountOrScalarEnclosing(sql);
        return sql;
    }

    protected String filterUnionNormalSelectEnclosing(String sql) {
        if (!this.needsUnionNormalSelectEnclosing()) {
            return sql;
        }
        String selectClause = "select/*$pmb.selectHint*/ *";
        String ln = this.ln();
        String beginMark = this.resolveSubQueryBeginMark("dfmain") + ln;
        String endMark = this.resolveSubQueryEndMark("dfmain");
        String clause = "select/*$pmb.selectHint*/ *" + ln + "  from (" + beginMark + sql + ln + "       ) dfmain" + endMark;
        clause = clause + this.prepareClauseOrderBy() + this.prepareClauseSqlSuffix();
        return clause;
    }

    protected String filterUnionCountOrScalarEnclosing(String sql) {
        if (!this.needsUnionCountOrScalarEnclosing()) {
            return sql;
        }
        String selectClause = this.buildSelectClauseCountOrScalar("dfmain");
        String ln = this.ln();
        String beginMark = this.resolveSubQueryBeginMark("dfmain") + ln;
        String endMark = this.resolveSubQueryEndMark("dfmain");
        return selectClause + ln + "  from (" + beginMark + sql + ln + "       ) dfmain" + endMark;
    }

    protected boolean needsUnionNormalSelectEnclosing() {
        if (!this.isUnionNormalSelectEnclosingRequired()) {
            return false;
        }
        return this.hasUnionQuery() && !this.isSelectClauseTypeCountOrScalar();
    }

    protected boolean isUnionNormalSelectEnclosingRequired() {
        return false;
    }

    protected boolean needsUnionCountOrScalarEnclosing() {
        return this.hasUnionQuery() && this.isSelectClauseTypeCountOrScalar();
    }

    @Override
    public String getSelectClause() {
        if (this.isSelectClauseTypeCountOrScalar() && !this.hasUnionQuery()) {
            return this.buildSelectClauseCountOrScalar("dflocal");
        }
        StringBuilder sb = new StringBuilder();
        DBMeta dbmeta = this.getDBMeta();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        Map<String, String> localSpecifiedMap = null;
        if (this._specifiedSelectColumnMap != null) {
            localSpecifiedMap = this._specifiedSelectColumnMap.get(this.getLocalTableAliasName());
        }
        boolean existsSpecifiedLocal = localSpecifiedMap != null && !localSpecifiedMap.isEmpty();
        Integer selectIndex = 0;
        if (this._useSelectIndex) {
            this._selectIndexMap = StringKeyMap.createAsCaseInsensitiveOrdered();
        }
        boolean needsDelimiter = false;
        for (ColumnInfo columnInfo : columnInfoList) {
            String onQueryName;
            String columnName = columnInfo.getColumnDbName();
            if (existsSpecifiedLocal && !localSpecifiedMap.containsKey(columnName) && (!this.isSelectClauseTypeCountOrScalar() || !this.hasUnionQuery() || dbmeta.hasPrimaryKey() && !columnInfo.isPrimary())) continue;
            if (needsDelimiter) {
                sb.append(", ");
            } else {
                sb.append("select");
                this.appendSelectHint(sb);
                sb.append(" ");
                needsDelimiter = true;
            }
            String realColumnName = this.getLocalTableAliasName() + "." + columnName;
            selectIndex = selectIndex + 1;
            if (this._useSelectIndex) {
                this._selectIndexMap.put(columnName, selectIndex);
                onQueryName = this.buildSelectIndexAliasName(selectIndex);
            } else {
                onQueryName = columnName;
            }
            sb.append(realColumnName).append(" as ").append(onQueryName);
            this._selectClauseRealColumnAliasMap.put(realColumnName, onQueryName);
        }
        Set<String> tableAliasNameSet = this._selectedSelectColumnMap.keySet();
        for (String tableAliasName : tableAliasNameSet) {
            Map<String, SelectedSelectColumnInfo> map = this._selectedSelectColumnMap.get(tableAliasName);
            Collection<SelectedSelectColumnInfo> selectColumnInfoList = map.values();
            Map<String, String> foreginSpecifiedMap = null;
            if (this._specifiedSelectColumnMap != null) {
                foreginSpecifiedMap = this._specifiedSelectColumnMap.get(tableAliasName);
            }
            boolean existsSpecifiedForeign = foreginSpecifiedMap != null && !foreginSpecifiedMap.isEmpty();
            boolean finishedForeignIndent = false;
            for (SelectedSelectColumnInfo selectColumnInfo : selectColumnInfoList) {
                String onQueryName;
                if (existsSpecifiedForeign && !foreginSpecifiedMap.containsKey(selectColumnInfo.getColumnName())) continue;
                String realColumnName = selectColumnInfo.buildRealColumnName();
                String columnAliasName = selectColumnInfo.getColumnAliasName();
                selectIndex = selectIndex + 1;
                if (this._useSelectIndex) {
                    this._selectIndexMap.put(columnAliasName, selectIndex);
                    onQueryName = this.buildSelectIndexAliasName(selectIndex);
                } else {
                    onQueryName = columnAliasName;
                }
                if (!finishedForeignIndent) {
                    sb.append(this.ln()).append("     ");
                    finishedForeignIndent = true;
                }
                sb.append(", ").append(realColumnName).append(" as ").append(onQueryName);
                this._selectClauseRealColumnAliasMap.put(realColumnName, onQueryName);
            }
        }
        if (this._specifiedDeriveSubQueryMap != null && !this._specifiedDeriveSubQueryMap.isEmpty()) {
            Collection<String> deriveSubQuerySet = this._specifiedDeriveSubQueryMap.values();
            for (String deriveSubQuery : deriveSubQuerySet) {
                sb.append(this.ln()).append("     ");
                sb.append(", ").append(deriveSubQuery);
                int beginIndex = deriveSubQuery.lastIndexOf(" as ");
                if (beginIndex < 0) continue;
                String aliasName = deriveSubQuery.substring(beginIndex + " as ".length());
                int endIndex = aliasName.indexOf("--df:");
                if (endIndex >= 0) {
                    aliasName = aliasName.substring(0, endIndex);
                }
                this._selectClauseRealColumnAliasMap.put(aliasName, aliasName);
            }
        }
        return sb.toString();
    }

    protected boolean isSelectClauseTypeCountOrScalar() {
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return true;
        }
        return this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG);
    }

    protected String buildSelectClauseCountOrScalar(String aliasName) {
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT)) {
            return this.buildSelectClauseCount();
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return this.buildSelectClauseMax(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return this.buildSelectClauseMin(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return this.buildSelectClauseSum(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG)) {
            return this.buildSelectClauseAvg(aliasName);
        }
        String msg = "The type of select clause is not for scalar:";
        msg = msg + " type=" + (Object)((Object)this._selectClauseType);
        throw new IllegalStateException(msg);
    }

    protected String buildSelectClauseCount() {
        return "select count(*)";
    }

    protected String buildSelectClauseMax(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select max(" + aliasName + "." + columnName + ")";
    }

    protected String buildSelectClauseMin(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select min(" + aliasName + "." + columnName + ")";
    }

    protected String buildSelectClauseSum(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select sum(" + aliasName + "." + columnName + ")";
    }

    protected String buildSelectClauseAvg(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select avg(" + aliasName + "." + columnName + ")";
    }

    protected void assertScalarSelectSpecifiedColumnOnlyOne(String columnName) {
        if (columnName != null) {
            return;
        }
        String msg = "The specified column exists one";
        msg = msg + " when the type of select clause is for scalar:";
        msg = msg + " specifiedSelectColumnMap=" + this._specifiedSelectColumnMap;
        throw new IllegalStateException(msg);
    }

    @Override
    public Map<String, Integer> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    @Override
    public Map<String, String> getSelectIndexReverseMap() {
        if (this._selectIndexMap == null) {
            return null;
        }
        StringKeyMap<String> selectIndexReverseMap = StringKeyMap.createAsCaseInsensitiveOrdered();
        for (String columnName : this._selectIndexMap.keySet()) {
            Integer selectIndex = this._selectIndexMap.get(columnName);
            selectIndexReverseMap.put(this.buildSelectIndexAliasName(selectIndex), columnName);
        }
        return selectIndexReverseMap;
    }

    @Override
    public void disableSelectIndex() {
        this._useSelectIndex = false;
    }

    protected String buildSelectIndexAliasName(Integer selectIndex) {
        return "c" + selectIndex;
    }

    @Override
    public String getSelectHint() {
        return this.createSelectHint();
    }

    protected void appendSelectHint(StringBuilder sb) {
        sb.append(SELECT_HINT);
    }

    @Override
    public String getFromClause() {
        StringBuilder sb = new StringBuilder();
        this.buildFromClause(sb);
        return sb.toString();
    }

    protected void buildFromClause(StringBuilder sb) {
        sb.append(this.ln()).append("  ");
        sb.append("from ");
        String tableSqlName = this.getDBMeta().getTableSqlName();
        if (this._baseTableInlineWhereList.isEmpty()) {
            sb.append(tableSqlName).append(" dflocal");
        } else {
            sb.append(this.getInlineViewClause(tableSqlName, this._baseTableInlineWhereList)).append(" dflocal");
        }
        sb.append(this.getFromBaseTableHint());
        sb.append(this.getLeftOuterJoinClause());
    }

    protected String getLeftOuterJoinClause() {
        String fixedConditionKey = this.getFixedConditionKey();
        StringBuilder sb = new StringBuilder();
        for (String aliasName : this._outerJoinMap.keySet()) {
            LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
            String joinTableDbName = joinInfo.getJoinTableDbName();
            List<String> inlineWhereClauseList = joinInfo.getInlineWhereClauseList();
            List<String> additionalOnClauseList = joinInfo.getAdditionalOnClauseList();
            Map<String, String> joinOnMap = joinInfo.getJoinOnMap();
            this.assertJoinOnMapNotEmpty(joinOnMap, aliasName);
            sb.append(this.ln()).append("   ");
            if (joinInfo.isInnerJoin()) {
                sb.append(" inner join ");
            } else {
                sb.append(" left outer join ");
            }
            String joinTableSqlName = this.findDBMeta(joinTableDbName).getTableSqlName();
            if (inlineWhereClauseList.isEmpty()) {
                sb.append(joinTableSqlName);
            } else {
                sb.append(this.getInlineViewClause(joinTableSqlName, inlineWhereClauseList));
            }
            sb.append(" ").append(aliasName).append(" on ");
            int count = 0;
            Set<Map.Entry<String, String>> entrySet = joinOnMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String localColumnName = entry.getKey();
                String foreignColumnName = entry.getValue();
                if (count > 0) {
                    sb.append(" and ");
                }
                if (localColumnName.equals(fixedConditionKey)) {
                    sb.append(foreignColumnName);
                } else {
                    sb.append(localColumnName).append(" = ").append(foreignColumnName);
                }
                ++count;
            }
            for (String additionalOnClause : additionalOnClauseList) {
                sb.append(" and ").append(additionalOnClause);
            }
        }
        return sb.toString();
    }

    protected String getInlineViewClause(String joinTableName, List<String> inlineWhereClauseList) {
        StringBuilder sb = new StringBuilder();
        sb.append("(select * from ").append(joinTableName).append(" where ");
        int count = 0;
        for (String clauseElement : inlineWhereClauseList) {
            clauseElement = this.filterWhereClauseSimply(clauseElement);
            if (count > 0) {
                sb.append(" and ");
            }
            sb.append(clauseElement);
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getFromBaseTableHint() {
        return this.createFromBaseTableHint();
    }

    @Override
    public String getFromHint() {
        return this.createFromHint();
    }

    @Override
    public String getWhereClause() {
        StringBuilder sb = new StringBuilder();
        this.buildWhereClause(sb);
        return sb.toString();
    }

    protected void buildWhereClause(StringBuilder sb) {
        this.buildWhereClause(sb, false);
    }

    protected void buildWhereClause(StringBuilder sb, boolean template) {
        if (this._whereList.isEmpty()) {
            if (template) {
                sb.append(this.getWhereClauseMark());
            }
            return;
        }
        int count = 0;
        for (String clauseElement : this._whereList) {
            clauseElement = this.filterWhereClauseSimply(clauseElement);
            if (count == 0) {
                sb.append(this.ln()).append(" ");
                sb.append("where ").append(template ? this.getWhereFirstConditionMark() : "").append(clauseElement);
            } else {
                sb.append(this.ln()).append("  ");
                sb.append(" and ").append(clauseElement);
            }
            ++count;
        }
    }

    @Override
    public String getOrderByClause() {
        String orderByClause = null;
        if (this.hasUnionQuery()) {
            if (this._selectClauseRealColumnAliasMap == null || this._selectClauseRealColumnAliasMap.isEmpty()) {
                String msg = "The selectClauseColumnAliasMap should not be null or empty when union query exists: " + this.toString();
                throw new IllegalStateException(msg);
            }
            orderByClause = this._orderByClause.getOrderByClause(this._selectClauseRealColumnAliasMap);
        } else {
            orderByClause = this._orderByClause.getOrderByClause();
        }
        if (orderByClause != null && orderByClause.trim().length() > 0) {
            return this.ln() + " " + orderByClause;
        }
        return orderByClause;
    }

    @Override
    public String getSqlSuffix() {
        String sqlSuffix = this.createSqlSuffix();
        if (sqlSuffix != null && sqlSuffix.trim().length() > 0) {
            return this.ln() + sqlSuffix;
        }
        return sqlSuffix;
    }

    @Override
    public void registerSelectedSelectColumn(String foreignTableAliasName, String localTableName, String foreignPropertyName, String localRelationPath) {
        this._selectedSelectColumnMap.put(foreignTableAliasName, this.createSelectedSelectColumnInfo(foreignTableAliasName, localTableName, foreignPropertyName, localRelationPath));
    }

    protected Map<String, SelectedSelectColumnInfo> createSelectedSelectColumnInfo(String foreignTableAliasName, String localTableName, String foreignPropertyName, String localRelationPath) {
        DBMeta dbmeta = this.findDBMeta(localTableName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        int relationNo = foreignInfo.getRelationNo();
        String nextRelationPath = "_" + relationNo;
        if (localRelationPath != null) {
            nextRelationPath = localRelationPath + nextRelationPath;
        }
        LinkedHashMap<String, SelectedSelectColumnInfo> resultMap = new LinkedHashMap<String, SelectedSelectColumnInfo>();
        DBMeta foreignDBMeta = foreignInfo.getForeignDBMeta();
        List<ColumnInfo> columnInfoList = foreignDBMeta.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnDbName = columnInfo.getColumnDbName();
            SelectedSelectColumnInfo selectColumnInfo = new SelectedSelectColumnInfo();
            selectColumnInfo.setTableAliasName(foreignTableAliasName);
            selectColumnInfo.setColumnName(columnDbName);
            selectColumnInfo.setColumnAliasName(columnDbName + nextRelationPath);
            resultMap.put(columnDbName, selectColumnInfo);
        }
        return resultMap;
    }

    @Override
    public void registerOuterJoin(String joinTableDbName, String aliasName, Map<String, String> joinOnMap) {
        this.assertAlreadyOuterJoin(aliasName);
        this.assertJoinOnMapNotEmpty(joinOnMap, aliasName);
        LeftOuterJoinInfo joinInfo = new LeftOuterJoinInfo();
        joinInfo.setAliasName(aliasName);
        joinInfo.setJoinTableDbName(joinTableDbName);
        joinInfo.setJoinOnMap(joinOnMap);
        if (this._innerJoinEffective) {
            joinInfo.setInnerJoin(true);
        }
        this._outerJoinMap.put(aliasName, joinInfo);
    }

    @Override
    public void changeToInnerJoin(String aliasName) {
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        if (joinInfo == null) {
            String msg = "The aliasName should be registered:";
            msg = msg + " aliasName=" + aliasName + " outerJoinMap=" + this._outerJoinMap.keySet();
            throw new IllegalStateException(msg);
        }
        joinInfo.setInnerJoin(true);
    }

    @Override
    public SqlClause makeInnerJoinEffective() {
        this._innerJoinEffective = true;
        return this;
    }

    @Override
    public SqlClause backToOuterJoin() {
        this._innerJoinEffective = false;
        return this;
    }

    @Override
    public String getFixedConditionKey() {
        return "$$fixedCondition$$";
    }

    protected void assertAlreadyOuterJoin(String aliasName) {
        if (this._outerJoinMap.containsKey(aliasName)) {
            String msg = "The alias name have already registered in outer join: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertJoinOnMapNotEmpty(Map<String, String> joinOnMap, String aliasName) {
        if (joinOnMap.isEmpty()) {
            String msg = "The joinOnMap should not be empty: aliasName=" + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void registerWhereClause(String columnFullName, ConditionKey key, ConditionValue value) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFullName", columnFullName);
        List<String> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnFullName, key, value);
    }

    @Override
    public void registerWhereClause(String columnFullName, ConditionKey key, ConditionValue value, ConditionOption option) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFullName", columnFullName);
        this.assertObjectNotNull("option of " + columnFullName, option);
        List<String> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnFullName, key, value, option);
    }

    @Override
    public void registerWhereClause(String clause) {
        this.assertStringNotNullAndNotTrimmedEmpty("clause", clause);
        List<String> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, clause);
    }

    protected void doRegisterWhereClause(List<String> clauseList, String columnName, ConditionKey key, ConditionValue value) {
        key.addWhereClause(clauseList, columnName, value);
        this.markOrScopeQueryAndPart(clauseList);
    }

    protected void doRegisterWhereClause(List<String> clauseList, String columnName, ConditionKey key, ConditionValue value, ConditionOption option) {
        key.addWhereClause(clauseList, columnName, value, option);
        this.markOrScopeQueryAndPart(clauseList);
    }

    protected void doRegisterWhereClause(List<String> clauseList, String clause) {
        clauseList.add(clause);
        this.markOrScopeQueryAndPart(clauseList);
    }

    protected List<String> getWhereClauseList4Register() {
        if (this._orScopeQueryEffective) {
            return this.getTmpOrWhereList();
        }
        return this._whereList;
    }

    @Override
    public void exchangeFirstWhereClauseForLastOne() {
        if (this._whereList.size() > 1) {
            String first = this._whereList.get(0);
            String last = this._whereList.get(this._whereList.size() - 1);
            this._whereList.set(0, last);
            this._whereList.set(this._whereList.size() - 1, first);
        }
    }

    @Override
    public boolean hasWhereClause() {
        return this._whereList != null && !this._whereList.isEmpty();
    }

    @Override
    public void registerBaseTableInlineWhereClause(String columnName, ConditionKey key, ConditionValue value) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        List<String> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnName, key, value);
    }

    @Override
    public void registerBaseTableInlineWhereClause(String columnName, ConditionKey key, ConditionValue value, ConditionOption option) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        this.assertObjectNotNull("option of " + columnName, option);
        List<String> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnName, key, value, option);
    }

    @Override
    public void registerBaseTableInlineWhereClause(String value) {
        List<String> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, value);
    }

    protected List<String> getBaseTableInlineWhereClauseList4Register() {
        if (this._orScopeQueryEffective) {
            return this.getTmpOrBaseTableInlineWhereList();
        }
        return this._baseTableInlineWhereList;
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String columnName, ConditionKey key, ConditionValue value, boolean onClauseInline) {
        this.assertNotYetOuterJoin(aliasName);
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        List<String> clauseList = this.getOuterJoinInlineWhereClauseList4Register(aliasName, onClauseInline);
        String realColumnName = (onClauseInline ? aliasName + "." : "") + columnName;
        this.doRegisterWhereClause(clauseList, realColumnName, key, value);
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String columnName, ConditionKey key, ConditionValue value, ConditionOption option, boolean onClauseInline) {
        this.assertNotYetOuterJoin(aliasName);
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        List<String> clauseList = this.getOuterJoinInlineWhereClauseList4Register(aliasName, onClauseInline);
        String realColumnName = (onClauseInline ? aliasName + "." : "") + columnName;
        this.doRegisterWhereClause(clauseList, realColumnName, key, value, option);
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String value, boolean onClauseInline) {
        this.assertNotYetOuterJoin(aliasName);
        List<String> clauseList = this.getOuterJoinInlineWhereClauseList4Register(aliasName, onClauseInline);
        this.doRegisterWhereClause(clauseList, value);
    }

    protected List<String> getOuterJoinInlineWhereClauseList4Register(String aliasName, boolean onClauseInline) {
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        List<String> clauseList = onClauseInline ? (this._orScopeQueryEffective ? this.getTmpOrAdditionalOnClauseList(aliasName) : joinInfo.getAdditionalOnClauseList()) : (this._orScopeQueryEffective ? this.getTmpOrOuterJoinInlineClauseList(aliasName) : joinInfo.getInlineWhereClauseList());
        return clauseList;
    }

    protected void assertNotYetOuterJoin(String aliasName) {
        if (!this._outerJoinMap.containsKey(aliasName)) {
            String msg = "The alias name have not registered in outer join yet: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void makeOrScopeQueryEffective() {
        TmpOrScopeQueryInfo tmpOrScopeQueryInfo = new TmpOrScopeQueryInfo();
        if (this._currentTmpOrScopeQueryInfo != null) {
            this._currentTmpOrScopeQueryInfo.addChildInfo(tmpOrScopeQueryInfo);
        }
        this._currentTmpOrScopeQueryInfo = tmpOrScopeQueryInfo;
        this._orScopeQueryEffective = true;
    }

    @Override
    public void closeOrScopeQuery() {
        this.assertCurrentTmpOrScopeQueryInfo();
        TmpOrScopeQueryInfo parentInfo = this._currentTmpOrScopeQueryInfo.getParentInfo();
        if (parentInfo != null) {
            this._currentTmpOrScopeQueryInfo = parentInfo;
        } else {
            this.reflectTmpOrClauseToRealObject(this._currentTmpOrScopeQueryInfo);
            this.clearOrScopeQuery();
        }
    }

    protected void clearOrScopeQuery() {
        this._currentTmpOrScopeQueryInfo = null;
        this._orScopeQueryEffective = false;
        this._orScopeQueryAndPart = false;
    }

    protected void reflectTmpOrClauseToRealObject(TmpOrScopeQueryInfo localInfo) {
        ArrayList<TmpOrScopeQueryGroupInfo> groupList;
        LeftOuterJoinInfo joinInfo;
        String aliasName;
        List<TmpOrScopeQueryGroupInfo> groupList2 = this.setupTmpOrListList(localInfo, new TmpOrClauseListProvider(){

            @Override
            public List<String> provide(TmpOrScopeQueryInfo tmpOrScopeQueryInfo) {
                return tmpOrScopeQueryInfo.getTmpOrWhereList();
            }
        });
        this.setupOrScopeQuery(groupList2, this._whereList, true);
        groupList2 = this.setupTmpOrListList(localInfo, new TmpOrClauseListProvider(){

            @Override
            public List<String> provide(TmpOrScopeQueryInfo tmpOrScopeQueryInfo) {
                return tmpOrScopeQueryInfo.getTmpOrBaseTableInlineWhereList();
            }
        });
        this.setupOrScopeQuery(groupList2, this._baseTableInlineWhereList, false);
        Set<Map.Entry<String, LeftOuterJoinInfo>> entrySet = this._outerJoinMap.entrySet();
        for (Map.Entry<String, LeftOuterJoinInfo> entry : entrySet) {
            aliasName = entry.getKey();
            joinInfo = entry.getValue();
            groupList = new ArrayList<TmpOrScopeQueryGroupInfo>();
            groupList.addAll(this.setupTmpOrListList(localInfo, new TmpOrClauseListProvider(){

                @Override
                public List<String> provide(TmpOrScopeQueryInfo tmpOrScopeQueryInfo) {
                    return tmpOrScopeQueryInfo.getTmpOrAdditionalOnClauseList(aliasName);
                }
            }));
            this.setupOrScopeQuery(groupList, joinInfo.getAdditionalOnClauseList(), false);
        }
        entrySet = this._outerJoinMap.entrySet();
        for (Map.Entry<String, LeftOuterJoinInfo> entry : entrySet) {
            aliasName = entry.getKey();
            joinInfo = entry.getValue();
            groupList = new ArrayList();
            groupList.addAll(this.setupTmpOrListList(localInfo, new TmpOrClauseListProvider(){

                @Override
                public List<String> provide(TmpOrScopeQueryInfo tmpOrScopeQueryInfo) {
                    return tmpOrScopeQueryInfo.getTmpOrOuterJoinInlineClauseList(aliasName);
                }
            }));
            this.setupOrScopeQuery(groupList, joinInfo.getInlineWhereClauseList(), false);
        }
    }

    protected List<TmpOrScopeQueryGroupInfo> setupTmpOrListList(TmpOrScopeQueryInfo parentInfo, TmpOrClauseListProvider provider) {
        ArrayList<TmpOrScopeQueryGroupInfo> resultList = new ArrayList<TmpOrScopeQueryGroupInfo>();
        TmpOrScopeQueryGroupInfo groupInfo = new TmpOrScopeQueryGroupInfo();
        groupInfo.setOrClauseList(provider.provide(parentInfo));
        resultList.add(groupInfo);
        if (parentInfo.hasChildInfo()) {
            for (TmpOrScopeQueryInfo childInfo : parentInfo.getChildInfoList()) {
                resultList.addAll(this.setupTmpOrListList(childInfo, provider));
            }
        }
        return resultList;
    }

    protected void setupOrScopeQuery(List<TmpOrScopeQueryGroupInfo> tmpOrGroupList, List<String> realList, boolean line) {
        if (tmpOrGroupList == null || tmpOrGroupList.isEmpty()) {
            return;
        }
        String or = " or ";
        String and = " and ";
        String lnIndentOr = line ? this.ln() + "   " : "";
        String lnIndentAnd = "";
        String andPartMark = this.getOrScopeQueryAndPartMark();
        StringBuilder sb = new StringBuilder();
        boolean exists = false;
        int validCount = 0;
        int groupListIndex = 0;
        for (TmpOrScopeQueryGroupInfo groupInfo : tmpOrGroupList) {
            List<String> orClauseList = groupInfo.getOrClauseList();
            if (orClauseList == null || orClauseList.isEmpty()) continue;
            int listIndex = 0;
            boolean inAndPart = false;
            for (String orClause : orClauseList) {
                boolean secondAndPart;
                boolean beginAndPart;
                boolean currentAndPart = orClause.startsWith(andPartMark);
                if (currentAndPart) {
                    if (inAndPart) {
                        beginAndPart = false;
                        secondAndPart = true;
                    } else {
                        beginAndPart = true;
                        secondAndPart = false;
                        inAndPart = true;
                    }
                    orClause = orClause.substring(andPartMark.length());
                } else {
                    if (inAndPart) {
                        sb.append(")");
                        inAndPart = false;
                    }
                    beginAndPart = false;
                    secondAndPart = false;
                }
                if (groupListIndex == 0) {
                    if (listIndex == 0) {
                        sb.append("(");
                    } else {
                        sb.append(secondAndPart ? "" : lnIndentOr);
                        sb.append(secondAndPart ? " and " : " or ");
                    }
                } else if (listIndex == 0) {
                    sb.append(lnIndentOr);
                    sb.append(" or ");
                    sb.append("(");
                } else {
                    sb.append(secondAndPart ? "" : lnIndentOr);
                    sb.append(secondAndPart ? " and " : " or ");
                }
                sb.append(beginAndPart ? "(" : "");
                sb.append(orClause);
                ++validCount;
                if (!exists) {
                    exists = true;
                }
                ++listIndex;
            }
            if (inAndPart) {
                sb.append(")");
                inAndPart = false;
            }
            if (groupListIndex > 0) {
                sb.append(")");
            }
            ++groupListIndex;
        }
        if (exists) {
            sb.append(line && validCount > 1 ? this.ln() + "       " : "").append(")");
            realList.add(sb.toString());
        }
    }

    @Override
    public boolean isOrScopeQueryEffective() {
        return this._orScopeQueryEffective;
    }

    protected List<String> getTmpOrWhereList() {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrWhereList();
    }

    protected List<String> getTmpOrBaseTableInlineWhereList() {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrBaseTableInlineWhereList();
    }

    protected List<String> getTmpOrAdditionalOnClauseList(String aliasName) {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrAdditionalOnClauseList(aliasName);
    }

    protected List<String> getTmpOrOuterJoinInlineClauseList(String aliasName) {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrOuterJoinInlineClauseList(aliasName);
    }

    @Override
    public void beginOrScopeQueryAndPart() {
        this.assertCurrentTmpOrScopeQueryInfo();
        this._orScopeQueryAndPart = true;
    }

    @Override
    public void endOrScopeQueryAndPart() {
        this.assertCurrentTmpOrScopeQueryInfo();
        this._orScopeQueryAndPart = false;
    }

    protected void markOrScopeQueryAndPart(List<String> clauseList) {
        if (this._orScopeQueryEffective && this._orScopeQueryAndPart && !clauseList.isEmpty()) {
            String original = clauseList.remove(clauseList.size() - 1);
            clauseList.add(this.getOrScopeQueryAndPartMark() + original);
        }
    }

    protected String getOrScopeQueryAndPartMark() {
        return "$$df:AndPart$$";
    }

    protected void assertCurrentTmpOrScopeQueryInfo() {
        if (this._currentTmpOrScopeQueryInfo == null) {
            String msg = "The attribute 'currentTmpOrScopeQueryInfo' should not be null in or-scope query:";
            msg = msg + " orScopeQueryEffective=" + this._orScopeQueryEffective;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this._orderByClause;
    }

    @Override
    public SqlClause clearOrderBy() {
        this._orderByEffective = false;
        this._orderByClause.clear();
        return this;
    }

    @Override
    public SqlClause makeOrderByEffective() {
        if (!this._orderByClause.isEmpty()) {
            this._orderByEffective = true;
        }
        return this;
    }

    @Override
    public SqlClause ignoreOrderBy() {
        this._orderByEffective = false;
        return this;
    }

    @Override
    public void reverseOrderBy_Or_OverrideOrderBy(String orderByProperty, String registeredOrderByProperty, boolean ascOrDesc) {
        this._orderByEffective = true;
        if (!this._orderByClause.isSameOrderByColumn(orderByProperty)) {
            this.clearOrderBy();
            this.registerOrderBy(orderByProperty, registeredOrderByProperty, ascOrDesc);
        } else {
            this._orderByClause.reverseAll();
        }
    }

    @Override
    public void registerOrderBy(String orderByProperty, String registeredOrderByProperty, boolean ascOrDesc) {
        try {
            this._orderByEffective = true;
            ArrayList<String> orderByList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(orderByProperty, "/");
            while (st.hasMoreElements()) {
                orderByList.add(st.nextToken());
            }
            if (registeredOrderByProperty == null || registeredOrderByProperty.trim().length() == 0) {
                registeredOrderByProperty = orderByProperty;
            }
            ArrayList<String> registeredOrderByList = new ArrayList<String>();
            StringTokenizer st2 = new StringTokenizer(registeredOrderByProperty, "/");
            while (st2.hasMoreElements()) {
                registeredOrderByList.add(st2.nextToken());
            }
            int count = 0;
            for (String orderBy : orderByList) {
                String registeredOrderBy = (String)registeredOrderByList.get(count);
                this._orderByEffective = true;
                String aliasName = null;
                String columnName = null;
                String registeredAliasName = null;
                String registeredColumnName = null;
                if (orderBy.indexOf(".") < 0) {
                    columnName = orderBy;
                } else {
                    aliasName = orderBy.substring(0, orderBy.lastIndexOf("."));
                    columnName = orderBy.substring(orderBy.lastIndexOf(".") + 1);
                }
                if (registeredOrderBy.indexOf(".") < 0) {
                    registeredColumnName = registeredOrderBy;
                } else {
                    registeredAliasName = registeredOrderBy.substring(0, registeredOrderBy.lastIndexOf("."));
                    registeredColumnName = registeredOrderBy.substring(registeredOrderBy.lastIndexOf(".") + 1);
                }
                OrderByElement element = new OrderByElement();
                element.setAliasName(aliasName);
                element.setColumnName(columnName);
                element.setRegisteredAliasName(registeredAliasName);
                element.setRegisteredColumnName(registeredColumnName);
                if (ascOrDesc) {
                    element.setupAsc();
                } else {
                    element.setupDesc();
                }
                this._orderByClause.addOrderByElement(element);
                ++count;
            }
        }
        catch (RuntimeException e) {
            String msg = "registerOrderBy() threw the exception: orderByProperty=" + orderByProperty;
            msg = msg + " registeredColumnFullName=" + registeredOrderByProperty;
            msg = msg + " ascOrDesc=" + ascOrDesc;
            msg = msg + " sqlClause=" + this.toString();
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public void addNullsFirstToPreviousOrderBy() {
        this._orderByClause.addNullsFirstToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    @Override
    public void addNullsLastToPreviousOrderBy() {
        this._orderByClause.addNullsLastToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupper() {
        return new OrderByClause.OrderByNullsSetupper(){

            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                return orderByElementClause + " nulls " + (nullsFirst ? "first" : "last");
            }
        };
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupperByCaseWhen() {
        return new OrderByClause.OrderByNullsSetupper(){

            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                String thenNumber = nullsFirst ? "1" : "0";
                String elseNumber = nullsFirst ? "0" : "1";
                String caseWhen = "case when " + columnName + " is not null then " + thenNumber + " else " + elseNumber + " end asc";
                return caseWhen + ", " + orderByElementClause;
            }
        };
    }

    @Override
    public void addManualOrderToPreviousOrderByElement(OrderByClause.ManumalOrderInfo manumalOrderInfo) {
        this.assertObjectNotNull("manumalOrderInfo", manumalOrderInfo);
        if (this.hasUnionQuery()) {
            String msg = "Manual Order with Union is unavailable: " + manumalOrderInfo.getManualValueList();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._orderByClause.addManualOrderByElement(manumalOrderInfo);
    }

    @Override
    public boolean hasOrderByClause() {
        return this._orderByClause != null && !this._orderByClause.isEmpty();
    }

    @Override
    public void registerUnionQuery(String unionQueryClause, boolean unionAll) {
        this.assertStringNotNullAndNotTrimmedEmpty("unionQueryClause", unionQueryClause);
        UnionQueryInfo unionQueryInfo = new UnionQueryInfo();
        unionQueryInfo.setUnionQueryClause(unionQueryClause);
        unionQueryInfo.setUnionAll(unionAll);
        this.addUnionQueryInfo(unionQueryInfo);
    }

    protected void addUnionQueryInfo(UnionQueryInfo unionQueryInfo) {
        if (this._unionQueryInfoList == null) {
            this._unionQueryInfoList = new ArrayList<UnionQueryInfo>();
        }
        this._unionQueryInfoList.add(unionQueryInfo);
    }

    @Override
    public boolean hasUnionQuery() {
        return this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty();
    }

    @Override
    public SqlClause fetchFirst(int fetchSize) {
        this._fetchScopeEffective = true;
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = 0;
        this._fetchSize = fetchSize;
        this._fetchPageNumber = 1;
        this.doClearFetchPageClause();
        this.doFetchFirst();
        return this;
    }

    @Override
    public SqlClause fetchScope(int fetchStartIndex, int fetchSize) {
        this._fetchScopeEffective = true;
        if (fetchStartIndex < 0) {
            String msg = "Argument[fetchStartIndex] must be plus or zero: " + fetchStartIndex;
            throw new IllegalArgumentException(msg);
        }
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = fetchStartIndex;
        this._fetchSize = fetchSize;
        return this.fetchPage(1);
    }

    @Override
    public SqlClause fetchPage(int fetchPageNumber) {
        this._fetchScopeEffective = true;
        if (fetchPageNumber <= 0) {
            fetchPageNumber = 1;
        }
        if (this._fetchSize <= 0) {
            this.throwFetchSizeNotPlusException(fetchPageNumber);
        }
        this._fetchPageNumber = fetchPageNumber;
        if (this._fetchPageNumber == 1 && this._fetchStartIndex == 0) {
            return this.fetchFirst(this._fetchSize);
        }
        this.doClearFetchPageClause();
        this.doFetchPage();
        return this;
    }

    protected void throwFetchSizeNotPlusException(int fetchPageNumber) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Fetch size should not be minus or zero!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Fetch Size]" + this.ln();
        msg = msg + "fetchSize=" + this._fetchSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Fetch Page Number]" + this.ln();
        msg = msg + "fetchPageNumber=" + fetchPageNumber + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg);
    }

    protected abstract void doFetchFirst();

    protected abstract void doFetchPage();

    protected abstract void doClearFetchPageClause();

    @Override
    public int getFetchStartIndex() {
        return this._fetchStartIndex;
    }

    @Override
    public int getFetchSize() {
        return this._fetchSize;
    }

    @Override
    public int getFetchPageNumber() {
        return this._fetchPageNumber;
    }

    @Override
    public int getPageStartIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * (this._fetchPageNumber - 1);
    }

    @Override
    public int getPageEndIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * this._fetchPageNumber;
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this._fetchScopeEffective;
    }

    @Override
    public SqlClause ignoreFetchScope() {
        this._fetchScopeEffective = false;
        this.doClearFetchPageClause();
        return this;
    }

    @Override
    public SqlClause makeFetchScopeEffective() {
        if (this.getFetchSize() > 0 && this.getFetchPageNumber() > 0) {
            this.fetchPage(this.getFetchPageNumber());
        }
        return this;
    }

    @Override
    public boolean isFetchStartIndexSupported() {
        return true;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    protected abstract String createSelectHint();

    protected abstract String createFromBaseTableHint();

    protected abstract String createFromHint();

    protected abstract String createSqlSuffix();

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getPageStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getFetchSize();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this._fetchScopeEffective;
    }

    @Override
    public String resolveJoinAliasName(String relationPath, int cqNestNo) {
        return this.resolveNestLevelExpression("dfrelation" + relationPath, cqNestNo);
    }

    @Override
    public String resolveNestLevelExpression(String name, int cqNestNo) {
        return name;
    }

    @Override
    public int resolveRelationNo(String localTableName, String foreignPropertyName) {
        DBMeta dbmeta = this.findDBMeta(localTableName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        return foreignInfo.getRelationNo();
    }

    @Override
    public String getLocalTableAliasName() {
        return "dflocal";
    }

    @Override
    public String getForeignTableAliasPrefix() {
        return "dfrelation";
    }

    @Override
    public String getWhereClauseMark() {
        return "#df:whereClause#";
    }

    @Override
    public String getWhereFirstConditionMark() {
        return "#df:whereFirstCondition#";
    }

    @Override
    public String getUnionSelectClauseMark() {
        return "#df:unionSelectClause#";
    }

    @Override
    public String getUnionWhereClauseMark() {
        return "#df:unionWhereClause#";
    }

    @Override
    public String getUnionWhereFirstConditionMark() {
        return "#df:unionWhereFirstCondition#";
    }

    @Override
    public void addWhereClauseSimpleFilter(WhereClauseSimpleFilter whereClauseSimpleFilter) {
        if (this._whereClauseSimpleFilterList == null) {
            this._whereClauseSimpleFilterList = new ArrayList<WhereClauseSimpleFilter>();
        }
        this._whereClauseSimpleFilterList.add(whereClauseSimpleFilter);
    }

    protected String filterWhereClauseSimply(String clauseElement) {
        if (this._whereClauseSimpleFilterList == null || this._whereClauseSimpleFilterList.isEmpty()) {
            return clauseElement;
        }
        for (WhereClauseSimpleFilter filter : this._whereClauseSimpleFilterList) {
            if (filter == null) {
                String msg = "The list of filter should not have null: _whereClauseSimpleFilterList=" + this._whereClauseSimpleFilterList;
                throw new IllegalStateException(msg);
            }
            clauseElement = filter.filterClauseElement(clauseElement);
        }
        return clauseElement;
    }

    @Override
    public boolean isSelectedForeignInfoEmpty() {
        if (this._selectedForeignInfo == null) {
            return true;
        }
        return this._selectedForeignInfo.isEmpty();
    }

    @Override
    public boolean hasSelectedForeignInfo(String relationPath) {
        if (this._selectedForeignInfo == null) {
            return false;
        }
        return this._selectedForeignInfo.containsKey(relationPath);
    }

    @Override
    public void registerSelectedForeignInfo(String relationPath, String foreignPropertyName) {
        if (this._selectedForeignInfo == null) {
            this._selectedForeignInfo = new HashMap<String, String>();
        }
        this._selectedForeignInfo.put(relationPath, foreignPropertyName);
    }

    @Override
    public String resolveSubQueryBeginMark(String subQueryIdentity) {
        return this.getSubQueryBeginMarkPrefix() + subQueryIdentity + this.getSubQueryIdentityTerminal();
    }

    @Override
    public String resolveSubQueryEndMark(String subQueryIdentity) {
        return this.getSubQueryEndMarkPrefix() + subQueryIdentity + this.getSubQueryIdentityTerminal();
    }

    protected String getSubQueryBeginMarkPrefix() {
        return "--df:SubQueryBegin#";
    }

    protected String getSubQueryEndMarkPrefix() {
        return "--df:SubQueryEnd#";
    }

    protected String getSubQueryIdentityTerminal() {
        return "#IdentityTerminal#";
    }

    @Override
    public String filterSubQueryIndent(String sql) {
        return this.filterSubQueryIndent(sql, "", sql);
    }

    protected String filterSubQueryIndent(String sql, String preIndent, String originalSql) {
        if (!sql.contains(this.getSubQueryBeginMarkPrefix())) {
            return sql;
        }
        String[] lines = sql.split(this.ln());
        String beginMarkPrefix = this.getSubQueryBeginMarkPrefix();
        String endMarkPrefix = this.getSubQueryEndMarkPrefix();
        String identityTerminal = this.getSubQueryIdentityTerminal();
        int terminalLength = identityTerminal.length();
        StringBuilder mainSb = new StringBuilder();
        StringBuilder subSb = null;
        boolean throughBegin = false;
        boolean throughBeginFirst = false;
        String subQueryIdentity = null;
        String indent = null;
        for (String line : lines) {
            String clause;
            String msg;
            int terminalIndex;
            int markIndex;
            if (!throughBegin) {
                if (line.contains(beginMarkPrefix)) {
                    throughBegin = true;
                    subSb = new StringBuilder();
                    markIndex = line.indexOf(beginMarkPrefix);
                    terminalIndex = line.indexOf(identityTerminal);
                    if (terminalIndex < 0) {
                        msg = "Identity terminal was Not Found at the begin line: [" + line + "]";
                        throw new SubQueryIndentFailureException(msg);
                    }
                    clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                    subQueryIdentity = line.substring(markIndex + beginMarkPrefix.length(), terminalIndex);
                    subSb.append(clause);
                    indent = this.buildSpaceBar(markIndex - preIndent.length());
                    continue;
                }
                mainSb.append(line).append(this.ln());
                continue;
            }
            if (line.contains(endMarkPrefix + subQueryIdentity)) {
                markIndex = line.indexOf(endMarkPrefix);
                terminalIndex = line.indexOf(identityTerminal);
                if (terminalIndex < 0) {
                    msg = "Identity terminal was Not Found at the begin line: [" + line + "]";
                    throw new SubQueryIndentFailureException(msg);
                }
                clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                subSb.append(clause).append(this.ln());
                String currentSql = this.filterSubQueryIndent(subSb.toString(), preIndent + indent, originalSql);
                mainSb.append(currentSql);
                throughBegin = false;
                throughBeginFirst = false;
                continue;
            }
            if (!throughBeginFirst) {
                subSb.append(line.trim()).append(this.ln());
                throughBeginFirst = true;
                continue;
            }
            subSb.append(indent).append(line).append(this.ln());
        }
        String filteredSql = mainSb.toString();
        if (throughBegin) {
            String msg = "End Mark Not Found!";
            msg = msg + this.ln() + "[Current SubQueryIdentity]" + this.ln();
            msg = msg + subQueryIdentity + this.ln();
            msg = msg + this.ln() + "[Before Filter]" + this.ln() + sql;
            msg = msg + this.ln() + "[After Filter]" + this.ln() + filteredSql;
            msg = msg + this.ln() + "[Original SQL]" + this.ln() + originalSql;
            throw new SubQueryIndentFailureException(msg);
        }
        if (filteredSql.contains(beginMarkPrefix)) {
            String msg = "Any begin marks are not filtered!";
            msg = msg + this.ln() + "[Current SubQueryIdentity]" + this.ln();
            msg = msg + subQueryIdentity + this.ln();
            msg = msg + this.ln() + "[Before Filter]" + this.ln() + sql;
            msg = msg + this.ln() + "[After Filter]" + this.ln() + filteredSql;
            msg = msg + this.ln() + "[Original SQL]" + this.ln() + originalSql;
            throw new SubQueryIndentFailureException(msg);
        }
        return filteredSql;
    }

    protected String buildSpaceBar(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void specifySelectColumn(String tableAliasName, String columnName) {
        if (this._specifiedSelectColumnMap == null) {
            this._specifiedSelectColumnMap = new HashMap<String, Map<String, String>>();
        }
        if (!this._specifiedSelectColumnMap.containsKey(tableAliasName)) {
            this._specifiedSelectColumnMap.put(tableAliasName, new LinkedHashMap());
        }
        Map<String, String> elementMap = this._specifiedSelectColumnMap.get(tableAliasName);
        elementMap.put(columnName, null);
        this._specifiedSelectColumnMap.put(tableAliasName, elementMap);
    }

    @Override
    public void specifyDeriveSubQuery(String aliasName, String deriveSubQuery) {
        if (this._specifiedDeriveSubQueryMap == null) {
            this._specifiedDeriveSubQueryMap = new LinkedHashMap<String, String>();
        }
        this._specifiedDeriveSubQueryMap.put(aliasName, deriveSubQuery);
    }

    @Override
    public boolean hasSpecifiedDeriveSubQuery(String aliasName) {
        if (this._specifiedDeriveSubQueryMap == null) {
            return false;
        }
        return this._specifiedDeriveSubQueryMap.containsKey(aliasName);
    }

    @Override
    public String getSpecifiedColumnNameAsOne() {
        String tableAliasName;
        Map<String, String> elementMap;
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1 && (elementMap = this._specifiedSelectColumnMap.get(tableAliasName = this._specifiedSelectColumnMap.keySet().iterator().next())) != null && elementMap.size() == 1) {
            return elementMap.keySet().iterator().next();
        }
        return null;
    }

    @Override
    public String getSpecifiedColumnRealNameAsOne() {
        return this.doGetSpecifiedColumnRealNameAsOne(false);
    }

    @Override
    public String removeSpecifiedColumnRealNameAsOne() {
        return this.doGetSpecifiedColumnRealNameAsOne(true);
    }

    private String doGetSpecifiedColumnRealNameAsOne(boolean remove) {
        String tableAliasName;
        Map<String, String> elementMap;
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1 && (elementMap = this._specifiedSelectColumnMap.get(tableAliasName = this._specifiedSelectColumnMap.keySet().iterator().next())) != null && elementMap.size() == 1) {
            String columnName = elementMap.keySet().iterator().next();
            String realName = tableAliasName + "." + columnName;
            if (remove) {
                elementMap.remove(columnName);
            }
            return realName;
        }
        return null;
    }

    @Override
    public void backupSpecifiedSelectColumn() {
        this._backupSpecifiedSelectColumnMap = this._specifiedSelectColumnMap;
    }

    @Override
    public void restoreSpecifiedSelectColumn() {
        this._specifiedSelectColumnMap = this._backupSpecifiedSelectColumnMap;
        this._backupSpecifiedSelectColumnMap = null;
    }

    @Override
    public void clearSpecifiedSelectColumn() {
        if (this._specifiedSelectColumnMap != null) {
            this._specifiedSelectColumnMap.clear();
            this._specifiedSelectColumnMap = null;
        }
    }

    @Override
    public String getClauseQueryUpdate(Map<String, String> columnParameterMap) {
        String msg;
        String subQuery;
        if (columnParameterMap.isEmpty()) {
            return null;
        }
        String aliasName = this.getLocalTableAliasName();
        DBMeta dbmeta = this.getDBMeta();
        String tableSqlName = dbmeta.getTableSqlName();
        String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        String selectClause = "select " + aliasName + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        StringBuilder sb = new StringBuilder();
        String ln = this.ln();
        sb.append("update ").append(tableSqlName).append(ln);
        int index = 0;
        Set<Map.Entry<String, String>> entrySet = columnParameterMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String columnName = entry.getKey();
            String parameter = entry.getValue();
            if (index == 0) {
                sb.append("   set ").append(columnName).append(" = ").append(parameter).append(ln);
            } else {
                sb.append("     , ").append(columnName).append(" = ").append(parameter).append(ln);
            }
            ++index;
        }
        if (this.isUpdateSubQueryUseLocalTableSupported() && !dbmeta.hasTwoOrMorePrimaryKeys()) {
            subQuery = this.filterSubQueryIndent(selectClause + " " + fromWhereClause);
            sb.append(" where ").append(primaryKeyName);
            sb.append(" in (").append(ln).append(subQuery).append(ln).append(")");
            return sb.toString();
        }
        if (this._outerJoinMap != null && !this._outerJoinMap.isEmpty()) {
            msg = "The queryUpdate() with outer join is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty()) {
            msg = "The queryUpdate() with union is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        subQuery = this.filterSubQueryIndent(fromWhereClause);
        subQuery = this.replaceString(subQuery, aliasName + ".", "");
        int whereIndex = (subQuery = this.replaceString(subQuery, " " + aliasName + " ", " ")).indexOf("where ");
        if (whereIndex < 0) {
            return sb.toString();
        }
        subQuery = subQuery.substring(whereIndex);
        sb.append(" ").append(subQuery);
        return sb.toString();
    }

    @Override
    public String getClauseQueryDelete() {
        String aliasName = this.getLocalTableAliasName();
        DBMeta dbmeta = this.getDBMeta();
        String tableSqlName = dbmeta.getTableSqlName();
        String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        String selectClause = "select " + aliasName + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        if (this.isUpdateSubQueryUseLocalTableSupported() && !dbmeta.hasTwoOrMorePrimaryKeys()) {
            String subQuery = this.filterSubQueryIndent(selectClause + " " + fromWhereClause);
            StringBuilder sb = new StringBuilder();
            String ln = this.ln();
            sb.append("delete from ").append(tableSqlName).append(ln);
            sb.append(" where ").append(primaryKeyName);
            sb.append(" in (").append(ln).append(subQuery).append(ln).append(")");
            return sb.toString();
        }
        if (this._outerJoinMap != null && !this._outerJoinMap.isEmpty()) {
            String msg = "The queryDelete() with outer join is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty()) {
            String msg = "The queryDelete() with union is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        String subQuery = this.filterSubQueryIndent(fromWhereClause);
        subQuery = this.replaceString(subQuery, aliasName + ".", "");
        subQuery = this.replaceString(subQuery, " " + aliasName + " ", " ");
        subQuery = subQuery.substring(subQuery.indexOf("from "));
        return "delete " + subQuery;
    }

    protected boolean isUpdateSubQueryUseLocalTableSupported() {
        return true;
    }

    @Override
    public void classifySelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.changeSelectClauseType(selectClauseType);
    }

    protected void changeSelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.savePreviousSelectClauseType();
        this._selectClauseType = selectClauseType;
    }

    protected void savePreviousSelectClauseType() {
        this._previousSelectClauseType = this._selectClauseType;
    }

    @Override
    public void rollbackSelectClauseType() {
        this._selectClauseType = this._previousSelectClauseType != null ? this._previousSelectClauseType : DEFAULT_SELECT_CLAUSE_TYPE;
    }

    @Override
    public int getInScopeLimit() {
        return 0;
    }

    protected DBMeta getDBMeta() {
        if (this._dbmeta == null) {
            String msg = "The DB meta of local table should not be null when using getDBMeta():";
            msg = msg + " tableDbName=" + this._tableDbName;
            throw new IllegalStateException(msg);
        }
        return this._dbmeta;
    }

    protected DBMeta findDBMeta(String tableDbName) {
        DBMeta dbmeta = this._cachedDBMetaMap.get(tableDbName);
        if (dbmeta != null) {
            return dbmeta;
        }
        if (this._dbmetaProvider == null) {
            String msg = "The DB meta provider should not be null when using findDBMeta():";
            msg = msg + " tableDbName=" + tableDbName;
            throw new IllegalStateException(msg);
        }
        dbmeta = this._dbmetaProvider.provideDBMetaChecked(tableDbName);
        this._cachedDBMetaMap.put(tableDbName, dbmeta);
        return dbmeta;
    }

    protected String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    public static class SubQueryIndentFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SubQueryIndentFailureException(String msg) {
            super(msg);
        }
    }

    protected class RownumPagingProcessor {
        protected String _rownumExpression;
        protected String _selectHint = "";
        protected String _sqlSuffix = "";

        public RownumPagingProcessor(String rownumExpression) {
            this._rownumExpression = rownumExpression;
        }

        public void processRowNumberPaging() {
            boolean offset = AbstractSqlClause.this.isFetchStartIndexSupported();
            boolean limit = AbstractSqlClause.this.isFetchSizeSupported();
            if (!offset && !limit) {
                return;
            }
            StringBuilder hintSb = new StringBuilder();
            String rownum = this._rownumExpression;
            hintSb.append(" *").append(AbstractSqlClause.this.ln());
            hintSb.append("  from (").append(AbstractSqlClause.this.ln());
            hintSb.append("select plain.*, ").append(rownum).append(" as rn").append(AbstractSqlClause.this.ln());
            hintSb.append("  from (").append(AbstractSqlClause.this.ln());
            hintSb.append("select");
            StringBuilder suffixSb = new StringBuilder();
            String fromEnd = "       ) plain" + AbstractSqlClause.this.ln() + "       ) ext" + AbstractSqlClause.this.ln();
            if (offset) {
                int pageStartIndex = AbstractSqlClause.this.getPageStartIndex();
                suffixSb.append(fromEnd).append(" where ext.rn > ").append(pageStartIndex);
            }
            if (limit) {
                int pageEndIndex = AbstractSqlClause.this.getPageEndIndex();
                if (offset) {
                    suffixSb.append(AbstractSqlClause.this.ln()).append("   and ext.rn <= ").append(pageEndIndex);
                } else {
                    suffixSb.append(fromEnd).append(" where ext.rn <= ").append(pageEndIndex);
                }
            }
            this._selectHint = hintSb.toString();
            this._sqlSuffix = suffixSb.toString();
        }

        public String getSelectHint() {
            return this._selectHint;
        }

        public String getSqlSuffix() {
            return this._sqlSuffix;
        }
    }

    protected static class UnionQueryInfo {
        protected String _unionQueryClause;
        protected boolean _unionAll;

        protected UnionQueryInfo() {
        }

        public String getUnionQueryClause() {
            return this._unionQueryClause;
        }

        public void setUnionQueryClause(String unionQueryClause) {
            this._unionQueryClause = unionQueryClause;
        }

        public boolean isUnionAll() {
            return this._unionAll;
        }

        public void setUnionAll(boolean unionAll) {
            this._unionAll = unionAll;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TmpOrScopeQueryGroupInfo {
        protected List<String> _orClauseList;

        protected TmpOrScopeQueryGroupInfo() {
        }

        public String toString() {
            return "{orClauseList=" + (this._orClauseList != null ? Integer.valueOf(this._orClauseList.size()) : "null") + "}";
        }

        public List<String> getOrClauseList() {
            return this._orClauseList;
        }

        public void setOrClauseList(List<String> orClauseList) {
            this._orClauseList = orClauseList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TmpOrScopeQueryInfo {
        protected List<String> _tmpOrWhereList;
        protected List<String> _tmpOrBaseTableInlineWhereList;
        protected Map<String, List<String>> _tmpOrAdditionalOnClauseListMap;
        protected Map<String, List<String>> _tmpOrOuterJoinInlineClauseListMap;
        protected TmpOrScopeQueryInfo _parentInfo;
        protected List<TmpOrScopeQueryInfo> _childInfoList;

        protected TmpOrScopeQueryInfo() {
        }

        public List<String> getTmpOrAdditionalOnClauseList(String aliasName) {
            List<String> orClauseList = this.getTmpOrAdditionalOnClauseListMap().get(aliasName);
            if (orClauseList != null) {
                return orClauseList;
            }
            orClauseList = new ArrayList<String>();
            this._tmpOrAdditionalOnClauseListMap.put(aliasName, orClauseList);
            return orClauseList;
        }

        public List<String> getTmpOrOuterJoinInlineClauseList(String aliasName) {
            List<String> orClauseList = this.getTmpOrOuterJoinInlineClauseListMap().get(aliasName);
            if (orClauseList != null) {
                return orClauseList;
            }
            orClauseList = new ArrayList<String>();
            this._tmpOrOuterJoinInlineClauseListMap.put(aliasName, orClauseList);
            return orClauseList;
        }

        public List<String> getTmpOrWhereList() {
            if (this._tmpOrWhereList == null) {
                this._tmpOrWhereList = new ArrayList<String>();
            }
            return this._tmpOrWhereList;
        }

        public void setTmpOrWhereList(List<String> tmpOrWhereList) {
            this._tmpOrWhereList = tmpOrWhereList;
        }

        public List<String> getTmpOrBaseTableInlineWhereList() {
            if (this._tmpOrBaseTableInlineWhereList == null) {
                this._tmpOrBaseTableInlineWhereList = new ArrayList<String>();
            }
            return this._tmpOrBaseTableInlineWhereList;
        }

        public void setTmpOrBaseTableInlineWhereList(List<String> tmpOrBaseTableInlineWhereList) {
            this._tmpOrBaseTableInlineWhereList = tmpOrBaseTableInlineWhereList;
        }

        public Map<String, List<String>> getTmpOrAdditionalOnClauseListMap() {
            if (this._tmpOrAdditionalOnClauseListMap == null) {
                this._tmpOrAdditionalOnClauseListMap = new LinkedHashMap<String, List<String>>();
            }
            return this._tmpOrAdditionalOnClauseListMap;
        }

        public void setTmpOrAdditionalOnClauseListMap(Map<String, List<String>> tmpOrAdditionalOnClauseListMap) {
            this._tmpOrAdditionalOnClauseListMap = tmpOrAdditionalOnClauseListMap;
        }

        public Map<String, List<String>> getTmpOrOuterJoinInlineClauseListMap() {
            if (this._tmpOrOuterJoinInlineClauseListMap == null) {
                this._tmpOrOuterJoinInlineClauseListMap = new LinkedHashMap<String, List<String>>();
            }
            return this._tmpOrOuterJoinInlineClauseListMap;
        }

        public void setTmpOrOuterJoinInlineClauseListMap(Map<String, List<String>> tmpOrOuterJoinInlineClauseListMap) {
            this._tmpOrOuterJoinInlineClauseListMap = tmpOrOuterJoinInlineClauseListMap;
        }

        public boolean hasChildInfo() {
            return this._childInfoList != null && !this._childInfoList.isEmpty();
        }

        public TmpOrScopeQueryInfo getParentInfo() {
            return this._parentInfo;
        }

        public void setParentInfo(TmpOrScopeQueryInfo parentInfo) {
            this._parentInfo = parentInfo;
        }

        public List<TmpOrScopeQueryInfo> getChildInfoList() {
            if (this._childInfoList == null) {
                this._childInfoList = new ArrayList<TmpOrScopeQueryInfo>();
            }
            return this._childInfoList;
        }

        public void addChildInfo(TmpOrScopeQueryInfo childInfo) {
            childInfo.setParentInfo(this);
            this.getChildInfoList().add(childInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TmpOrClauseListProvider {
        public List<String> provide(TmpOrScopeQueryInfo var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LeftOuterJoinInfo {
        protected String _aliasName;
        protected String _joinTableDbName;
        protected List<String> _inlineWhereClauseList = new ArrayList<String>();
        protected List<String> _additionalOnClauseList = new ArrayList<String>();
        protected Map<String, String> _joinOnMap;
        protected boolean _innerJoin;

        protected LeftOuterJoinInfo() {
        }

        public String getAliasName() {
            return this._aliasName;
        }

        public void setAliasName(String value) {
            this._aliasName = value;
        }

        public String getJoinTableDbName() {
            return this._joinTableDbName;
        }

        public void setJoinTableDbName(String value) {
            this._joinTableDbName = value;
        }

        public List<String> getInlineWhereClauseList() {
            return this._inlineWhereClauseList;
        }

        public void addInlineWhereClause(String value) {
            this._inlineWhereClauseList.add(value);
        }

        public List<String> getAdditionalOnClauseList() {
            return this._additionalOnClauseList;
        }

        public void addAdditionalOnClause(String value) {
            this._additionalOnClauseList.add(value);
        }

        public Map<String, String> getJoinOnMap() {
            return this._joinOnMap;
        }

        public void setJoinOnMap(Map<String, String> value) {
            this._joinOnMap = value;
        }

        public boolean isInnerJoin() {
            return this._innerJoin;
        }

        public void setInnerJoin(boolean value) {
            this._innerJoin = value;
        }
    }

    public static class SelectedSelectColumnInfo {
        protected String tableAliasName;
        protected String columnName;
        protected String columnAliasName;

        public String buildRealColumnName() {
            if (this.tableAliasName != null) {
                return this.tableAliasName + "." + this.columnName;
            }
            return this.columnName;
        }

        public String getTableAliasName() {
            return this.tableAliasName;
        }

        public void setTableAliasName(String tableAliasName) {
            this.tableAliasName = tableAliasName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnAliasName() {
            return this.columnAliasName;
        }

        public void setColumnAliasName(String columnAliasName) {
            this.columnAliasName = columnAliasName;
        }
    }
}

