/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.data.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.io.data.DfSeparatedDataWriter;
import org.seasar.dbflute.helper.io.data.impl.DfAbsractDataWriter;
import org.seasar.dbflute.helper.io.data.impl.internal.DfInternalSqlBuilder;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSeparatedDataWriterImpl
extends DfAbsractDataWriter
implements DfSeparatedDataWriter {
    private static final Log _log = LogFactory.getLog(DfSeparatedDataWriterImpl.class);
    protected DataSource _dataSource;
    protected String _schemaName;
    protected boolean _loggingInsertSql;
    protected String _filename;
    protected String _encoding;
    protected String _delimiter;
    protected boolean _errorContinue;
    protected Map<String, Map<String, String>> _convertValueMap;
    protected Map<String, String> _defaultValueMap;
    protected Map<String, Map<String, DfColumnMetaInfo>> _metaInfoCacheMap = StringKeyMap.createAsFlexible();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void writeData(Map<String, Set<String>> notFoundColumnMap) throws FileNotFoundException, IOException {
        block48: {
            DfSeparatedDataWriterImpl._log.info((Object)"/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ");
            DfSeparatedDataWriterImpl._log.info((Object)("writeData(" + this._filename + ", " + this._encoding + ")"));
            DfSeparatedDataWriterImpl._log.info((Object)"= = = = = = =/");
            fis = null;
            ir = null;
            br = null;
            tableName = this._filename.substring(this._filename.lastIndexOf("/") + 1, this._filename.lastIndexOf("."));
            if (tableName.indexOf("-") >= 0) {
                tableName = tableName.substring(tableName.indexOf("-") + "-".length());
            }
            if ((columnMetaInfoMap = this.getColumnMetaInfo(this._dataSource, tableName)).isEmpty()) {
                msg = "The tableName[" + tableName + "] was not found: filename=" + this._filename;
                throw new IllegalStateException(msg);
            }
            lineString = null;
            preContinueString = "";
            valueList = new ArrayList<String>();
            additionalDefaultColumnNameToLowerKeyMap = null;
            targetConvertColumnNameKeyToLowerMap = null;
            columnNameList = null;
            fis = new FileInputStream(this._filename);
            ir = new InputStreamReader((InputStream)fis, this._encoding);
            br = new BufferedReader(ir);
            firstLineInfo = null;
            count = -1;
            while (true) {
                block46: {
                    ++count;
                    lineString = br.readLine();
                    if (lineString == null) break;
                    if (count == 0) {
                        firstLineInfo = this.getColumnNameList(this._delimiter, lineString);
                        additionalDefaultColumnNameToLowerKeyMap = this.getAdditionalDefaultColumnNameToLowerKeyMap(firstLineInfo);
                        targetConvertColumnNameKeyToLowerMap = this.getTargetConvertColumnNameKeyToLowerMap(firstLineInfo);
                        columnNameList = firstLineInfo.getColumnNameList();
                        columnNameList.addAll(additionalDefaultColumnNameToLowerKeyMap.values());
                        continue;
                    }
                    realLineString = preContinueString.equals("") != false ? lineString : preContinueString + "\n" + lineString;
                    valueLineInfo = this.arrangeValueList(realLineString, this._delimiter);
                    ls = valueLineInfo.getValueList();
                    if (valueLineInfo.isContinueNextLine()) {
                        preContinueString = ls.remove(ls.size() - 1);
                        valueList.addAll(ls);
                        continue;
                    }
                    valueList.addAll(ls);
                    try {
                        if (this.isDifferentColumnValueCount(columnNameList, additionalDefaultColumnNameToLowerKeyMap, valueList, lineString)) {
                            msg = "The count of values wasn't correct:";
                            msg = msg + " valueSize=" + valueList.size() + " columnNameSize=" + columnNameList.size();
                            msg = msg + " lineString=" + lineString + " valueList=" + valueList;
                            DfSeparatedDataWriterImpl._log.warn((Object)msg);
                            var31_38 = null;
                            valueList.clear();
                            preContinueString = "";
                            continue;
                        }
                        sqlBuilder = new DfInternalSqlBuilder();
                        sqlBuilder.setTableName(tableName);
                        sqlBuilder.setColumnMap(columnMetaInfoMap);
                        sqlBuilder.setColumnNameList(columnNameList);
                        sqlBuilder.setValueList(valueList);
                        sqlBuilder.setNotFoundColumnMap(notFoundColumnMap);
                        sqlBuilder.setTargetConvertColumnNameKeyToLowerMap(targetConvertColumnNameKeyToLowerMap);
                        sqlBuilder.setAdditionalDefaultColumnNameToLowerMap(additionalDefaultColumnNameToLowerKeyMap);
                        sqlBuilder.setConvertValueMap(this._convertValueMap);
                        sqlBuilder.setDefaultValueMap(this._defaultValueMap);
                        sqlBuildingResult = sqlBuilder.buildSql();
                        ps = null;
                        sql = sqlBuildingResult.getSql();
                        columnValueMap = sqlBuildingResult.getColumnValueMap();
                        if (this._loggingInsertSql) {
                            DfSeparatedDataWriterImpl._log.info((Object)this.buildSql4Log(tableName, columnNameList, columnValueMap.values()));
                        }
                        ps = this._dataSource.getConnection().prepareStatement(sql);
                        bindCount = 1;
                        entrySet = columnValueMap.entrySet();
                        for (Map.Entry<String, Object> entry : entrySet) {
                            columnName = entry.getKey();
                            if (this.processNotNullNotString(tableName, columnName, obj = entry.getValue(), (PreparedStatement)ps, bindCount)) {
                                ++bindCount;
                                continue;
                            }
                            if (this.processNull(tableName, columnName, obj, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            value = (String)obj;
                            if (value != null && value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                                value = this.removeDoubleQuotation(value);
                            }
                            if (this.processTimestamp(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            if (this.processTime(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            if (this.processBoolean(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            if (this.processNumber(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            ps.setString(bindCount, value);
                            ++bindCount;
                        }
                        ps.execute();
                        var28_36 = null;
                        ** if (ps == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                ps.close();
                            }
                            catch (SQLException ignored) {
                                DfSeparatedDataWriterImpl._log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block46;
                            catch (SQLException e) {
                                if (this._errorContinue) {
                                    simpleName = e.getClass().getSimpleName();
                                    sb = new StringBuilder();
                                    sb.append("The statement threw ").append(simpleName).append("! The detail is as follows:");
                                    sb.append(this.ln()).append("  Message    = ");
                                    sb.append(e.getMessage());
                                    sb.append(this.ln()).append("  Parameters = ");
                                    sb.append(sqlBuildingResult.getColumnValueMap());
                                    DfSeparatedDataWriterImpl._log.warn((Object)sb);
                                    var28_36 = null;
                                    if (ps != null) {
                                        try {
                                            ps.close();
                                        }
                                        catch (SQLException ignored) {
                                            DfSeparatedDataWriterImpl._log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
                                        }
                                    }
                                    var31_38 = null;
                                    valueList.clear();
                                    preContinueString = "";
                                    continue;
                                }
                                try {
                                    throw e;
                                }
                                catch (Throwable var27_39) {
                                    var28_36 = null;
                                    if (ps != null) {
                                        try {
                                            ps.close();
                                        }
                                        catch (SQLException ignored) {
                                            DfSeparatedDataWriterImpl._log.info((Object)"statement.close() threw the exception!", (Throwable)ignored);
                                        }
                                    }
                                    throw var27_39;
                                }
                            }
                        }
                    }
                    catch (Throwable var30_40) {
                        var31_38 = null;
                        valueList.clear();
                        preContinueString = "";
                        throw var30_40;
                    }
                }
                var31_38 = null;
                valueList.clear();
                preContinueString = "";
            }
            var33_41 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (ir != null) {
                    ir.close();
                }
                if (br != null) {
                    br.close();
                }
                break block48;
            }
            catch (IOException ignored) {
                DfSeparatedDataWriterImpl._log.warn((Object)"File-close threw the exception: ", (Throwable)ignored);
            }
            break block48;
            {
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (SQLException e) {
                    msg = "SQLException: filename=" + this._filename + " encoding=" + this._encoding;
                    msg = msg + " columnNameList=" + columnNameList + " lineString=" + lineString + " defaultValueMap=" + this._defaultValueMap;
                    throw new RuntimeException(msg, e);
                }
                catch (RuntimeException e) {
                    msg = "RuntimeException: filename=" + this._filename + " encoding=" + this._encoding;
                    msg = msg + " columnNameList=" + columnNameList + " lineString=" + lineString + " defaultValueMap=" + this._defaultValueMap;
                    throw new RuntimeException(msg, e);
                }
            }
            catch (Throwable var32_45) {
                var33_42 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (ir != null) {
                        ir.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ignored) {
                    DfSeparatedDataWriterImpl._log.warn((Object)"File-close threw the exception: ", (Throwable)ignored);
                }
                throw var32_45;
            }
        }
    }

    @Override
    protected boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String str = (String)value;
        return str.length() == 0 || str.equals("\"\"");
    }

    protected Map<String, DfColumnMetaInfo> getColumnMetaInfo(DataSource dataSource, String tableName) {
        if (this._metaInfoCacheMap.containsKey(tableName)) {
            return this._metaInfoCacheMap.get(tableName);
        }
        StringKeyMap columnMetaInfoMap = StringKeyMap.createAsFlexible();
        try {
            DatabaseMetaData metaData = dataSource.getConnection().getMetaData();
            List<DfColumnMetaInfo> columnMetaDataList = this._columnHandler.getColumnList(metaData, this._schemaName, tableName);
            for (DfColumnMetaInfo columnMetaInfo : columnMetaDataList) {
                columnMetaInfoMap.put(columnMetaInfo.getColumnName(), columnMetaInfo);
            }
            this._metaInfoCacheMap.put(tableName, (Map<String, DfColumnMetaInfo>)columnMetaInfoMap);
            return columnMetaInfoMap;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected FirstLineInfo getColumnNameList(String delimiter, String lineString) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        String[] values = lineString.split(delimiter);
        int count = 0;
        boolean quotated = false;
        for (String value : values) {
            if (count == 0 && value != null && value.startsWith("\"") && value.endsWith("\"")) {
                quotated = true;
            }
            this.addValueToList(columnNameList, value);
            ++count;
        }
        FirstLineInfo firstLineInformation = new FirstLineInfo();
        firstLineInformation.setColumnNameList(columnNameList);
        firstLineInformation.setQuotated(quotated);
        return firstLineInformation;
    }

    protected void addValueToList(List<String> ls, String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            ls.add(value.substring(1, value.length() - 1));
        } else {
            ls.add(value != null ? value : "");
        }
    }

    protected String buildSql4Log(String tableName, List<String> columnNameList, Collection<Object> bindParameters) {
        String bindParameterString = bindParameters.toString();
        bindParameterString = bindParameterString.substring(1, bindParameterString.length() - 1);
        return tableName + ":{" + bindParameterString + "}";
    }

    protected Map<String, String> getTargetConvertColumnNameKeyToLowerMap(FirstLineInfo firstLineInfo) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Set<String> keySet = this._convertValueMap.keySet();
        List<String> ls = firstLineInfo.getColumnNameToLowerList();
        for (String columnName : keySet) {
            String toLowerColumnName = columnName.toLowerCase();
            if (ls.contains(toLowerColumnName)) continue;
            resultMap.put(toLowerColumnName, columnName);
        }
        return resultMap;
    }

    protected Map<String, String> getAdditionalDefaultColumnNameToLowerKeyMap(FirstLineInfo firstLineInfo) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Set<String> keySet = this._defaultValueMap.keySet();
        List<String> ls = firstLineInfo.getColumnNameToLowerList();
        for (String columnName : keySet) {
            String toLowerColumnName = columnName.toLowerCase();
            if (ls.contains(toLowerColumnName)) continue;
            resultMap.put(toLowerColumnName, columnName);
        }
        return resultMap;
    }

    protected ValueLineInfo arrangeValueList(String lineString, String delimiter) {
        String[] values;
        ArrayList<String> valueList = new ArrayList<String>();
        for (String value : values = DfSeparatedDataWriterImpl.tokenToArgs(lineString, delimiter)) {
            valueList.add(value);
        }
        return this.arrangeValueList(valueList, delimiter);
    }

    protected static String[] tokenToArgs(String value, String delimiter) {
        List<String> list = DfSeparatedDataWriterImpl.tokenToList(value, delimiter);
        return list.toArray(new String[list.size()]);
    }

    protected static List<String> tokenToList(String value, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int j = value.indexOf(delimiter);
        int h = 0;
        while (j >= 0) {
            list.add(value.substring(i, j));
            i = j + delimiter.length();
            j = value.indexOf(delimiter, i);
            ++h;
        }
        list.add(value.substring(i));
        return list;
    }

    protected ValueLineInfo arrangeValueList(List<String> valueList, String delimiter) {
        ValueLineInfo valueLineInfo = new ValueLineInfo();
        ArrayList<String> resultList = new ArrayList<String>();
        String preString = "";
        for (int i = 0; i < valueList.size(); ++i) {
            String value = valueList.get(i);
            if (value == null) continue;
            if (i == valueList.size() - 1) {
                if (preString.equals("")) {
                    if (this.isFrontQOnly(value)) {
                        valueLineInfo.setContinueNextLine(true);
                        resultList.add(value);
                        break;
                    }
                    if (this.isRearQOnly(value)) {
                        resultList.add(value);
                        break;
                    }
                    if (this.isNotBothQ(value)) {
                        resultList.add(value);
                        break;
                    }
                    resultList.add(this.removeDoubleQuotation(value));
                    break;
                }
                if (this.endsQuote(value, false)) {
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                    break;
                }
                valueLineInfo.setContinueNextLine(true);
                resultList.add(this.connectPreString(preString, delimiter, value));
                break;
            }
            if (preString.equals("")) {
                if (this.isFrontQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isRearQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isNotBothQ(value)) {
                    resultList.add(value);
                } else {
                    resultList.add(this.removeDoubleQuotation(value));
                }
            } else if (this.endsQuote(value, false)) {
                resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
            } else {
                preString = this.connectPreString(preString, delimiter, value);
                continue;
            }
            preString = "";
        }
        valueLineInfo.setValueList(resultList);
        return valueLineInfo;
    }

    protected String connectPreString(String preString, String delimiter, String value) {
        if (preString.equals("")) {
            return value;
        }
        return preString + delimiter + value;
    }

    protected boolean isNotBothQ(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && !this.endsQuote(value, false);
    }

    protected boolean isRearQOnly(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && this.endsQuote(value, false);
    }

    protected boolean isFrontQOnly(String value) {
        return !this.isQQ(value) && value.startsWith("\"") && !this.endsQuote(value, true);
    }

    protected boolean isQQ(String value) {
        return value.equals("\"\"");
    }

    protected boolean endsQuote(String value, boolean startsQuote) {
        char ch;
        value = startsQuote ? value.substring(1) : value;
        int length = value.length();
        int count = 0;
        for (int i = 0; i < length && (ch = value.charAt(length - (i + 1))) == '\"'; ++i) {
            ++count;
        }
        return count > 0 && this.isOddNumber(count);
    }

    protected boolean isOddNumber(int number) {
        return number % 2 != 0;
    }

    protected String removeDoubleQuotation(String value) {
        if (!value.startsWith("\"") && !value.endsWith("\"")) {
            return value;
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        value = DfStringUtil.replace((String)value, (String)"\"\"", (String)"\"");
        return value;
    }

    protected String removeRightDoubleQuotation(String value) {
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected boolean isDifferentColumnValueCount(List<String> columnNameList, Map<String, String> appendDefaultColumnNameToLowerMap, List<String> valueList, String lineString) {
        return valueList.size() < columnNameList.size() - appendDefaultColumnNameToLowerMap.size();
    }

    @Override
    protected String ln() {
        return "\n";
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public boolean isLoggingInsertSql() {
        return this._loggingInsertSql;
    }

    public void setLoggingInsertSql(boolean loggingInsertSql) {
        this._loggingInsertSql = loggingInsertSql;
    }

    public boolean isErrorContinue() {
        return this._errorContinue;
    }

    public void setErrorContinue(boolean errorContinue) {
        this._errorContinue = errorContinue;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public Map<String, Map<String, String>> getConvertValueMap() {
        return this._convertValueMap;
    }

    public void setConvertValueMap(Map<String, Map<String, String>> convertValueMap) {
        this._convertValueMap = convertValueMap;
    }

    public Map<String, String> getDefaultValueMap() {
        return this._defaultValueMap;
    }

    public void setDefaultValueMap(Map<String, String> defaultValueMap) {
        this._defaultValueMap = defaultValueMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueLineInfo {
        protected List<String> valueList;
        protected boolean continueNextLine;

        public List<String> getValueList() {
            return this.valueList;
        }

        public void setValueList(List<String> valueList) {
            this.valueList = valueList;
        }

        public boolean isContinueNextLine() {
            return this.continueNextLine;
        }

        public void setContinueNextLine(boolean continueNextLine) {
            this.continueNextLine = continueNextLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirstLineInfo {
        protected List<String> columnNameList;
        protected boolean quotated;

        public List<String> getColumnNameToLowerList() {
            ArrayList<String> ls = new ArrayList<String>();
            for (String columnName : this.columnNameList) {
                ls.add(columnName.toLowerCase());
            }
            return ls;
        }

        public List<String> getColumnNameList() {
            return this.columnNameList;
        }

        public void setColumnNameList(List<String> columnNameList) {
            this.columnNameList = columnNameList;
        }

        public boolean isQuotated() {
            return this.quotated;
        }

        public void setQuotated(boolean quotated) {
            this.quotated = quotated;
        }
    }
}

