/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.friends.log4j;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;

public class DfOriginalRollingFileAppender
extends RollingFileAppender {
    public DfOriginalRollingFileAppender() {
    }

    public DfOriginalRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public void rollOver() {
        if (this.qw != null) {
            LogLog.debug((String)("rolling over count=" + ((CountingQuietWriter)this.qw).getCount()));
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        if (this.maxBackupIndex > 0) {
            File file = null;
            File target = null;
            String oldestBackupFileName = this.buildBackupFileName(this.fileName, this.maxBackupIndex);
            file = new File(oldestBackupFileName);
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                file = new File(this.buildBackupFileName(this.fileName, i));
                if (!file.exists()) continue;
                target = new File(this.buildBackupFileName(this.fileName, i + 1));
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                file.renameTo(target);
            }
            String newestBackupFile = this.buildBackupFileName(this.fileName, 1);
            target = new File(newestBackupFile);
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected String buildBackupFileName(String baseFileName, int index) {
        String logExt = ".log";
        if (baseFileName.endsWith(".log") && baseFileName.length() > ".log".length()) {
            int extIndex = baseFileName.lastIndexOf(".log");
            return baseFileName.substring(0, extIndex) + "-backup" + index + ".log";
        }
        return baseFileName + "." + index;
    }
}

