/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.bs;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.texen.ant.TexenTask;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfEnvironmentType;
import org.seasar.dbflute.config.DfSpecifiedSqlFile;
import org.seasar.dbflute.friends.velocity.DfGenerator;
import org.seasar.dbflute.friends.velocity.DfOriginalLog4JLogSystem;
import org.seasar.dbflute.helper.jdbc.connection.DfConnectionMetaInfo;
import org.seasar.dbflute.helper.jdbc.connection.DfDataSourceHandler;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.logic.DfDBFluteTaskUtil;
import org.seasar.dbflute.logic.jdbc.connection.DfCurrentSchemaConnector;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfSqlFileCollector;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfRefreshProperties;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractTexenTask
extends TexenTask {
    public static final Log _log = LogFactory.getLog(DfAbstractTexenTask.class);
    protected String _driver;
    protected String _url;
    protected UnifiedSchema _mainSchema;
    protected String _userId;
    protected String _password;
    protected Properties _connectionProperties;
    protected final DfDataSourceHandler _dataSourceHandler = new DfDataSourceHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute() {
        block55: {
            long before;
            Throwable cause;
            block49: {
                cause = null;
                before = this.getTaskBeforeTimeMillis();
                this.initializeDatabaseInfo();
                if (this.isUseDataSource()) {
                    this.setupDataSource();
                }
                this.initializeVariousEnvironment();
                this.doExecute();
                Object var7_3 = null;
                if (!this.isUseDataSource()) break block49;
                this.commitDataSource();
                Object var10_7 = null;
                try {
                    this.destroyDataSource();
                }
                catch (Exception ignored2) {
                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                }
                break block49;
                {
                    catch (Exception ignored) {
                        Object var10_8 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (Exception ignored2) {
                            _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                        }
                        break block49;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    try {
                        this.destroyDataSource();
                    }
                    catch (Exception ignored2) {
                        _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                    }
                    throw throwable;
                }
            }
            if (this.isValidTaskEndInformation() || cause != null) {
                try {
                    long after = this.getTaskAfterTimeMillis();
                    this.showFinalMessage(before, after, cause != null);
                }
                catch (RuntimeException e2) {
                    _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                }
            }
            if (cause != null) {
                this.throwTaskFailure();
            }
            break block55;
            {
                catch (Exception e) {
                    block52: {
                        cause = e;
                        try {
                            this.logException(e);
                        }
                        catch (Throwable ignored) {
                            _log.warn((Object)"*Ignored exception occured!", ignored);
                            _log.error((Object)"*Failed to execute DBFlute Task!", (Throwable)e);
                        }
                        Object var7_4 = null;
                        if (this.isUseDataSource()) {
                            this.commitDataSource();
                            Object var10_10 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (Exception ignored2) {
                                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                            }
                            break block52;
                            {
                                catch (Exception ignored) {
                                    Object var10_11 = null;
                                    try {
                                        this.destroyDataSource();
                                    }
                                    catch (Exception ignored2) {
                                        _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                    }
                                    break block52;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (Exception ignored2) {
                                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                }
                                throw throwable;
                            }
                        }
                    }
                    if (this.isValidTaskEndInformation() || cause != null) {
                        try {
                            long after = this.getTaskAfterTimeMillis();
                            this.showFinalMessage(before, after, cause != null);
                        }
                        catch (RuntimeException e2) {
                            _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                        }
                    }
                    if (cause != null) {
                        this.throwTaskFailure();
                    }
                    break block55;
                }
                catch (Error e) {
                    block56: {
                        cause = e;
                        try {
                            this.logError(e);
                        }
                        catch (Throwable ignored) {
                            _log.warn((Object)"*Ignored exception occured!", ignored);
                            _log.error((Object)"*Failed to execute DBFlute Task!", (Throwable)e);
                        }
                        Object var7_5 = null;
                        if (this.isUseDataSource()) {
                            this.commitDataSource();
                            Object var10_13 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (Exception ignored2) {
                                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                            }
                            break block56;
                            {
                                catch (Exception ignored) {
                                    Object var10_14 = null;
                                    try {
                                        this.destroyDataSource();
                                    }
                                    catch (Exception ignored2) {
                                        _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                    }
                                    break block56;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var10_15 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (Exception ignored2) {
                                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                }
                                throw throwable;
                            }
                        }
                    }
                    if (this.isValidTaskEndInformation() || cause != null) {
                        try {
                            long after = this.getTaskAfterTimeMillis();
                            this.showFinalMessage(before, after, cause != null);
                        }
                        catch (RuntimeException e2) {
                            _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                        }
                    }
                    if (cause != null) {
                        this.throwTaskFailure();
                    }
                }
            }
            catch (Throwable throwable) {
                block59: {
                    Object var7_6 = null;
                    if (this.isUseDataSource()) {
                        this.commitDataSource();
                        Object var10_16 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (Exception ignored2) {
                            _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                        }
                        break block59;
                        {
                            catch (Exception ignored) {
                                Object var10_17 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (Exception ignored2) {
                                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            Object var10_18 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (Exception ignored2) {
                                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                            }
                            throw throwable2;
                        }
                    }
                }
                if (this.isValidTaskEndInformation() || cause != null) {
                    try {
                        long after = this.getTaskAfterTimeMillis();
                        this.showFinalMessage(before, after, cause != null);
                    }
                    catch (RuntimeException e2) {
                        _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                    }
                }
                if (cause != null) {
                    this.throwTaskFailure();
                }
                throw throwable;
            }
        }
    }

    protected long getTaskBeforeTimeMillis() {
        return System.currentTimeMillis();
    }

    protected long getTaskAfterTimeMillis() {
        return System.currentTimeMillis();
    }

    protected void logException(Exception e) {
        DfDBFluteTaskUtil.logException(e, this.getDisplayTaskName(), this.getConnectionMetaInfo());
    }

    protected void logError(Error e) {
        DfDBFluteTaskUtil.logError(e, this.getDisplayTaskName(), this.getConnectionMetaInfo());
    }

    protected boolean isValidTaskEndInformation() {
        return true;
    }

    protected void showFinalMessage(long before, long after, boolean abort) {
        String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
        StringBuilder sb = new StringBuilder();
        String ln = this.ln();
        sb.append(ln);
        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
        sb.append(ln).append("[Task End]: ").append(this.getPerformanceView(after - before));
        if (abort) {
            sb.append(" *Abort");
        }
        sb.append(ln);
        DfConnectionMetaInfo metaInfo = this.getConnectionMetaInfo();
        String productDisp = metaInfo != null ? " (" + metaInfo.getProductDisp() + ")" : "";
        String databaseType = this.getBasicProperties().getDatabaseType() + productDisp;
        sb.append(ln).append("  DBFLUTE_CLIENT: {" + this.getBasicProperties().getProjectName() + "}");
        sb.append(ln).append("    database  = " + databaseType);
        sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
        sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
        sb.append(ln).append("    package   = " + this.getBasicProperties().getPackageBase());
        sb.append(ln);
        sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
        sb.append(ln).append("    driver = " + this._driver);
        sb.append(ln).append("    url    = " + this._url);
        sb.append(ln).append("    schema = " + this._mainSchema);
        sb.append(ln).append("    user   = " + this._userId);
        sb.append(ln).append("    props  = " + this._connectionProperties);
        String additionalSchemaDisp = this.buildAdditionalSchemaDisp();
        sb.append(ln).append("    additionalSchema = " + additionalSchemaDisp);
        DfReplaceSchemaProperties replaceSchemaProp = this.getProperties().getReplaceSchemaProperties();
        sb.append(ln).append("    dataLoadingType  = " + replaceSchemaProp.getDataLoadingType());
        String refreshProjectDisp = this.buildRefreshProjectDisp();
        sb.append(ln).append("    refreshProject   = " + refreshProjectDisp);
        String finalInformation = this.getFinalInformation();
        if (finalInformation != null) {
            sb.append(ln);
            sb.append(finalInformation);
        }
        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
        _log.info((Object)sb.toString());
    }

    private String buildAdditionalSchemaDisp() {
        String disp;
        DfDatabaseProperties databaseProp = this.getDatabaseProperties();
        List<UnifiedSchema> additionalSchemaList = databaseProp.getAdditionalSchemaList();
        if (additionalSchemaList.size() == 1) {
            String identifiedSchema;
            UnifiedSchema unifiedSchema = additionalSchemaList.get(0);
            disp = identifiedSchema = unifiedSchema.getIdentifiedSchema();
            if (unifiedSchema.isCatalogAdditionalSchema()) {
                disp = disp + "(catalog)";
            } else if (unifiedSchema.isMainSchema()) {
                disp = disp + "(main)";
            } else if (unifiedSchema.isUnknownSchema()) {
                disp = disp + "(unknown)";
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : additionalSchemaList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                String identifiedSchema = unifiedSchema.getIdentifiedSchema();
                sb.append(identifiedSchema);
                if (unifiedSchema.isCatalogAdditionalSchema()) {
                    sb.append("(catalog)");
                    continue;
                }
                if (unifiedSchema.isMainSchema()) {
                    sb.append("(main)");
                    continue;
                }
                if (!unifiedSchema.isUnknownSchema()) continue;
                sb.append("(unknown)");
            }
            disp = sb.toString();
        }
        return disp;
    }

    private String buildRefreshProjectDisp() {
        String disp;
        DfRefreshProperties refreshProp = this.getProperties().getRefreshProperties();
        if (!refreshProp.hasRefreshDefinition()) {
            return "";
        }
        List<String> refreshProjectList = refreshProp.getProjectNameList();
        if (refreshProjectList.size() == 1) {
            disp = refreshProjectList.get(0);
        } else {
            StringBuilder sb = new StringBuilder();
            for (String refreshProject : refreshProjectList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(refreshProject);
            }
            disp = sb.toString();
        }
        return disp;
    }

    protected String getDisplayTaskName() {
        String taskName = this.getTaskName();
        return DfDBFluteTaskUtil.getDisplayTaskName(taskName);
    }

    protected String getFinalInformation() {
        return null;
    }

    protected void throwTaskFailure() {
        DfDBFluteTaskUtil.throwTaskFailure(this.getDisplayTaskName());
    }

    protected void initializeDatabaseInfo() {
        this._driver = this.getDatabaseProperties().getDatabaseDriver();
        this._url = this.getDatabaseProperties().getDatabaseUrl();
        this._userId = this.getDatabaseProperties().getDatabaseUser();
        this._mainSchema = this.getDatabaseProperties().getDatabaseSchema();
        this._password = this.getDatabaseProperties().getDatabasePassword();
        this._connectionProperties = this.getDatabaseProperties().getDatabaseConnectionProperties();
    }

    protected void initializeVariousEnvironment() {
        if (this.getBasicProperties().isDatabaseOracle()) {
            DBDef currentDBDef = ResourceContext.currentDBDef();
            TnValueTypes.registerBasicValueType((DBDef)currentDBDef, Date.class, (ValueType)TnValueTypes.UTILDATE_AS_TIMESTAMP);
        }
    }

    protected abstract void doExecute();

    protected String getPerformanceView(long mil) {
        if (mil < 0L) {
            return String.valueOf(mil);
        }
        long sec = mil / 1000L;
        long min = sec / 60L;
        sec %= 60L;
        mil %= 1000L;
        StringBuffer sb = new StringBuffer();
        if (min >= 10L) {
            sb.append(min).append("m");
        } else if (min < 10L && min >= 0L) {
            sb.append("0").append(min).append("m");
        }
        if (sec >= 10L) {
            sb.append(sec).append("s");
        } else if (sec < 10L && sec >= 0L) {
            sb.append("0").append(sec).append("s");
        }
        if (mil >= 100L) {
            sb.append(mil).append("ms");
        } else if (mil < 100L && mil >= 10L) {
            sb.append("0").append(mil).append("ms");
        } else if (mil < 10L && mil >= 0L) {
            sb.append("00").append(mil).append("ms");
        }
        return sb.toString();
    }

    protected void fireVelocityProcess() {
        this.assertBasicAntParameter();
        this.setInputEncoding(this.getBasicProperties().getTemplateFileEncoding());
        this.setOutputEncoding(this.getBasicProperties().getSourceFileEncoding());
        try {
            this.initializeVelocityInstance();
            DfGenerator generator = this.setupGenerator();
            Context ctx = this.setupControlContext();
            _log.info((Object)("generator.parse(\"" + this.controlTemplate + "\", c);"));
            generator.parse(this.controlTemplate, ctx);
            generator.shutdown();
            this.cleanup();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            String msg = "Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'.";
            throw new IllegalStateException(msg, e.getWrappedThrowable());
        }
        catch (ParseErrorException e) {
            throw new IllegalStateException("Velocity syntax error.", e);
        }
        catch (ResourceNotFoundException e) {
            throw new IllegalStateException("Resource not found.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Generation failed.", e);
        }
    }

    private void assertBasicAntParameter() {
        if (this.templatePath == null && !this.useClasspath) {
            String msg = "The template path needs to be defined if you are not using the classpath for locating templates!";
            throw new IllegalStateException(msg);
        }
        if (this.controlTemplate == null) {
            throw new IllegalStateException("The control template needs to be defined!");
        }
    }

    private void initializeVelocityInstance() {
        if (this.templatePath != null) {
            this.log("Using templatePath: " + this.templatePath, 3);
            this.setupVelocityTemplateProperty();
        }
        if (this.useClasspath) {
            this.log("Using classpath");
            this.setupVelocityClasspathProperty();
        }
        this.setupVelocityLogProperty();
        try {
            Velocity.init();
        }
        catch (Exception e) {
            String msg = "Failed to initialize Velocity:";
            msg = msg + " templatePath=" + this.templatePath + " useClasspath=" + this.useClasspath;
            throw new IllegalStateException(msg, e);
        }
    }

    private void setupVelocityTemplateProperty() {
        Velocity.setProperty((String)"file.resource.loader.path", (Object)this.templatePath);
    }

    private void setupVelocityClasspathProperty() {
        String resourceLoaderName = "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader";
        Velocity.addProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"classpath.resource.loader.cache", (Object)"false");
        Velocity.setProperty((String)"classpath.resource.loader.modificationCheckInterval", (Object)"2");
    }

    private void setupVelocityLogProperty() {
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)DfOriginalLog4JLogSystem.class.getName());
    }

    private DfGenerator setupGenerator() {
        DfGenerator generator = this.getGeneratorHandler();
        generator.setInputEncoding(this.inputEncoding);
        generator.setOutputEncoding(this.outputEncoding);
        if (this.templatePath != null) {
            generator.setTemplatePath(this.templatePath);
        }
        return generator;
    }

    private Context setupControlContext() {
        Context ctx;
        try {
            ctx = this.initControlContext();
        }
        catch (Exception e) {
            String msg = "Failed to initialize control context:";
            msg = msg + " templatePath=" + this.templatePath + " useClasspath=" + this.useClasspath;
            throw new IllegalStateException(msg, e);
        }
        try {
            this.populateInitialContext(ctx);
        }
        catch (Exception e) {
            String msg = "Failed to populate initial context:";
            msg = msg + " templatePath=" + this.templatePath + " useClasspath=" + this.useClasspath;
            throw new IllegalStateException(msg, e);
        }
        if (this.contextProperties != null) {
            Iterator i = this.contextProperties.getKeys();
            while (i.hasNext()) {
                String property = (String)i.next();
                String value = this.contextProperties.getString(property);
                try {
                    ctx.put(property, (Object)new Integer(value));
                }
                catch (NumberFormatException nfe) {
                    String booleanString = this.contextProperties.testBoolean(value);
                    if (booleanString != null) {
                        ctx.put(property, (Object)Boolean.valueOf(booleanString));
                        continue;
                    }
                    if (property.endsWith("file.contents")) {
                        String canonicalPath;
                        try {
                            canonicalPath = this.getProject().resolveFile(value).getCanonicalPath();
                        }
                        catch (IOException e) {
                            String msg = "Failed to get the canonical path:";
                            msg = msg + " property=" + property + " value=" + value;
                            throw new IllegalStateException(msg, e);
                        }
                        value = DfAbstractTexenTask.fileContentsToString(canonicalPath);
                        property = property.substring(0, property.indexOf("file.contents") - 1);
                    }
                    ctx.put(property, (Object)value);
                }
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String fileContentsToString(String file) {
        String contents = "";
        File f = new File(file);
        if (!f.exists()) return contents;
        FileReader fr = null;
        fr = new FileReader(f);
        char[] template = new char[(int)f.length()];
        fr.read(template);
        contents = new String(template);
        Object var6_6 = null;
        if (fr == null) return contents;
        try {
            fr.close();
            return contents;
        }
        catch (IOException ignored) {}
        return contents;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var6_7 = null;
                if (fr == null) return contents;
                try {
                    fr.close();
                    return contents;
                }
                catch (IOException ignored) {}
                return contents;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fr == null) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected abstract boolean isUseDataSource();

    protected void setupDataSource() throws SQLException {
        this._dataSourceHandler.setUserId(this._userId);
        this._dataSourceHandler.setPassword(this._password);
        this._dataSourceHandler.setDriver(this._driver);
        this._dataSourceHandler.setUrl(this._url);
        this._dataSourceHandler.setConnectionProperties(this._connectionProperties);
        this._dataSourceHandler.setAutoCommit(true);
        this._dataSourceHandler.create();
        this.connectSchema();
    }

    protected void commitDataSource() throws SQLException {
        this._dataSourceHandler.commit();
    }

    protected void destroyDataSource() throws SQLException {
        this._dataSourceHandler.destroy();
        if (this.getBasicProperties().isDatabaseDerby()) {
            DfDBFluteTaskUtil.shutdownIfDerbyEmbedded(this._driver);
        }
    }

    protected DataSource getDataSource() {
        return DfDataSourceContext.getDataSource();
    }

    protected void connectSchema() throws SQLException {
        DfCurrentSchemaConnector connector = new DfCurrentSchemaConnector(this._mainSchema, this.getBasicProperties());
        connector.connectSchema(this.getDataSource());
    }

    protected DfConnectionMetaInfo getConnectionMetaInfo() {
        return this._dataSourceHandler.getConnectionMetaInfo();
    }

    public void setContextProperties(String file) {
        try {
            Properties prop = DfDBFluteTaskUtil.getBuildProperties(file, this.getProject());
            DfBuildProperties.getInstance().setProperties(prop);
            this.contextProperties = new ExtendedProperties();
            Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                this.contextProperties.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        catch (RuntimeException e) {
            String msg = "Failed to set context properties:";
            msg = msg + " file=" + file + " contextProperties=" + this.contextProperties;
            _log.warn((Object)msg, (Throwable)e);
            throw e;
        }
    }

    protected List<File> collectSqlFileList() {
        String sqlDirectory = this.getProperties().getOutsideSqlProperties().getSqlDirectory();
        DfSqlFileCollector sqlFileCollector = new DfSqlFileCollector(sqlDirectory, this.getBasicProperties());
        return sqlFileCollector.collectSqlFileList();
    }

    protected void refreshResources() {
        if (!this.isRefresh()) {
            return;
        }
        List<String> projectNameList = this.getRefreshProjectNameList();
        for (String projectName : projectNameList) {
            this.doRefreshResources(projectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRefreshResources(String projectName) {
        StringBuilder sb = new StringBuilder().append("refresh?");
        sb.append(projectName).append("=INFINITE");
        URL url = this.getRefreshRequestURL(sb.toString());
        if (url == null) {
            return;
        }
        InputStream is = null;
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        _log.info((Object)("...Refreshing the project: " + projectName));
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(this.getRefreshRequestReadTimeout());
        connection.connect();
        is = connection.getInputStream();
        _log.info((Object)"");
        _log.info((Object)"    --> OK, Look the refreshed project!");
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)"");
        Object var7_7 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException ignored2) {}
        return;
        {
            catch (IOException ignored) {
                _log.info((Object)"");
                _log.info((Object)("    --> Oh, no! " + ignored.getMessage() + ": " + url));
                _log.info((Object)"- - - - - - - - - -/");
                _log.info((Object)"");
                Object var7_8 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException ignored2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignored2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean isRefresh() {
        DfRefreshProperties prop = this.getProperties().getRefreshProperties();
        return prop.hasRefreshDefinition();
    }

    protected int getRefreshRequestReadTimeout() {
        return 3000;
    }

    protected List<String> getRefreshProjectNameList() {
        DfRefreshProperties prop = this.getProperties().getRefreshProperties();
        return prop.getProjectNameList();
    }

    protected URL getRefreshRequestURL(String path) {
        DfRefreshProperties prop = this.getProperties().getRefreshProperties();
        String requestUrl = prop.getRequestUrl();
        if (requestUrl.length() > 0) {
            if (!requestUrl.endsWith("/")) {
                requestUrl = requestUrl + "/";
            }
            try {
                return new URL(requestUrl + path);
            }
            catch (MalformedURLException e) {
                _log.warn((Object)("The URL was invalid: " + requestUrl), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected void showTargetSqlFileInformation(List<File> sqlFileList) {
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        _log.info((Object)("Target SQL files: " + sqlFileList.size()));
        _log.info((Object)" ");
        for (File sqlFile : sqlFileList) {
            _log.info((Object)("  " + sqlFile.getName()));
        }
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)" ");
        String specifiedSqlFile = DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile();
        if (specifiedSqlFile != null) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)("Specified SQL file: " + specifiedSqlFile));
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)" ");
        }
    }

    protected void showSkippedFileInformation() {
        boolean skipGenerateIfSameFile = this.getProperties().getLittleAdjustmentProperties().isSkipGenerateIfSameFile();
        if (!skipGenerateIfSameFile) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)"All class files have been generated. (overrided)");
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)"");
            return;
        }
        List<String> parseFileNameList = DfGenerator.getInstance().getParseFileNameList();
        int parseSize = parseFileNameList.size();
        if (parseSize == 0) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)"No class file has been parsed.");
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)"");
            return;
        }
        List<String> skipFileNameList = DfGenerator.getInstance().getSkipFileNameList();
        int skipSize = skipFileNameList.size();
        if (skipSize == 0) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)"All class files have been generated. (overrided)");
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)"");
            return;
        }
        _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
        if (skipSize == parseSize) {
            _log.info((Object)"All class files have been skipped generating");
            _log.info((Object)"                because they have no change.");
        } else {
            _log.info((Object)"Several class files have been skipped generating");
            _log.info((Object)"                    because they have no change.");
        }
        _log.info((Object)"");
        _log.info((Object)("    --> " + skipSize + " skipped (in " + parseSize + " files)"));
        _log.info((Object)"- - - - - - - - - -/");
        _log.info((Object)"");
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    public DfGenerator getGeneratorHandler() {
        return DfGenerator.getInstance();
    }

    protected String ln() {
        return "\n";
    }

    public String getTargetDatabase() {
        return this.getBasicProperties().getDatabaseType();
    }

    public void setEnvironmentType(String environmentType) {
        DfEnvironmentType.getInstance().setEnvironmentType(environmentType);
    }
}

