/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.assistant.classification;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationElement;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfClassificationTop {
    public static final String KEY_TOP_COMMENT = "topComment";
    public static final String KEY_CODE_TYPE = "codeType";
    public static final String KEY_DATA_TYPE = "dataType";
    public static final String CODE_TYPE_STRING = "String";
    public static final String CODE_TYPE_NUMBER = "Number";
    public static final String CODE_TYPE_BOOLEAN = "Boolean";
    public static final String DEFAULT_CODE_TYPE = "String";
    protected String _classificationName;
    protected String _topComment;
    protected String _codeType;
    protected String _relatedColumnName;
    protected List<DfClassificationElement> _elementList = new ArrayList<DfClassificationElement>();

    public void acceptClassificationTopElementMap(Map<?, ?> elementMap) {
        this.acceptTopMap(elementMap, KEY_TOP_COMMENT, KEY_CODE_TYPE, KEY_DATA_TYPE);
    }

    protected void acceptTopMap(Map<?, ?> elementMap, String commentKey, String codeTypeKey, String dataTypeKey) {
        String codeType;
        String topComment = (String)elementMap.get(commentKey);
        if (topComment == null) {
            String msg = "The elementMap should have " + commentKey + ".";
            throw new IllegalStateException(msg);
        }
        this._topComment = topComment;
        String tmpType = (String)elementMap.get(codeTypeKey);
        if (Srl.is_Null_or_TrimmedEmpty((String)tmpType)) {
            tmpType = (String)elementMap.get(dataTypeKey);
        }
        this._codeType = codeType = tmpType;
    }

    public String toString() {
        return "{" + this._classificationName + ", " + this._topComment + ", " + this._codeType + ", " + this._relatedColumnName + ", " + this._elementList + "}";
    }

    public String getClassificationName() {
        return this._classificationName;
    }

    public void setClassificationName(String classificationName) {
        this._classificationName = classificationName;
    }

    public String getTopComment() {
        return this._topComment;
    }

    public void setTopComment(String topComment) {
        this._topComment = topComment;
    }

    public String getCodeType() {
        return this._codeType;
    }

    public void setCodeType(String codeType) {
        this._codeType = codeType;
    }

    public String getRelatedColumnName() {
        return this._relatedColumnName;
    }

    public void setRelatedColumnName(String relatedColumnName) {
        this._relatedColumnName = relatedColumnName;
    }

    public List<DfClassificationElement> getClassificationElementList() {
        return this._elementList;
    }

    public void addClassificationElement(DfClassificationElement classificationElement) {
        this._elementList.add(classificationElement);
    }
}

