/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.cmentity;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.exception.DfProcedureExecutionMetaGettingFailureException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureNotParamResultMetaInfo;
import org.seasar.dbflute.logic.sql2entity.cmentity.DfCustomizeEntityMetaExtractor;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.properties.DfTypeMappingProperties;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureExecutionMetaExtractor {
    private static final Log _log = LogFactory.getLog(DfProcedureExecutionMetaExtractor.class);
    protected final DfCustomizeEntityMetaExtractor _extractor = new DfCustomizeEntityMetaExtractor();
    protected final DfColumnHandler _columnHandler = new DfColumnHandler();
    protected final ValueType _stringType = TnValueTypes.STRING;
    protected final ValueType _stringClobType = TnValueTypes.STRING_CLOB;
    protected final ValueType _bytesOidType = TnValueTypes.BYTES_OID;
    protected final ValueType _fixedLengthStringType = TnValueTypes.FIXED_LENGTH_STRING;
    protected final ValueType _objectBindingBigDecimalType = TnValueTypes.OBJECT_BINDING_BIGDECIMAL;
    protected final ValueType _uuidAsDirectType = TnValueTypes.UUID_AS_DIRECT;
    protected final ValueType _uuidAsStringType = TnValueTypes.UUID_AS_STRING;
    protected final ValueType _postgreSqlResultSetType = TnValueTypes.POSTGRESQL_RESULT_SET;
    protected final ValueType _oracleResultSetType = TnValueTypes.ORACLE_RESULT_SET;
    protected final Map<String, String> _continuedFailureMessageMap = DfCollectionUtil.newLinkedHashMap();

    public void extractExecutionMetaData(DataSource dataSource, List<DfProcedureMetaInfo> procedureList) throws SQLException {
        DfOutsideSqlProperties prop = this.getProperties().getOutsideSqlProperties();
        for (DfProcedureMetaInfo procedure : procedureList) {
            String procedureFullQualifiedName = procedure.getProcedureFullQualifiedName();
            String procedureSchemaQualifiedName = procedure.getProcedureSchemaQualifiedName();
            String procedureName = procedure.getProcedureName();
            if (!prop.isExecutionMetaProcedureName(procedureFullQualifiedName) && !prop.isExecutionMetaProcedureName(procedureSchemaQualifiedName) && !prop.isExecutionMetaProcedureName(procedureName)) continue;
            this.doExtractExecutionMetaData(dataSource, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExtractExecutionMetaData(DataSource dataSource, DfProcedureMetaInfo procedure) throws SQLException {
        Connection conn;
        block22: {
            List<DfProcedureColumnMetaInfo> columnList = procedure.getProcedureColumnList();
            if (!this.needsToCall(columnList)) {
                String name = procedure.buildProcedureLoggingName();
                _log.info((Object)("*not needed to call: " + name + " params=" + this.buildParameterTypeView(columnList)));
                return;
            }
            List testValueList = DfCollectionUtil.newArrayList();
            this.setupTestValueList(columnList, testValueList);
            boolean existsReturn = this.existsReturnValue(columnList);
            String sql = this.createSql(procedure, existsReturn, true);
            conn = null;
            Statement cs = null;
            try {
                try {
                    boolean executed;
                    _log.info((Object)("...Calling: " + sql));
                    conn = dataSource.getConnection();
                    conn.setAutoCommit(false);
                    cs = conn.prepareCall(sql);
                    List boundColumnList = DfCollectionUtil.newArrayList();
                    this.setupBindParameter(conn, (CallableStatement)cs, columnList, testValueList, boundColumnList);
                    ResultSet rs = null;
                    try {
                        executed = cs.execute();
                    }
                    catch (SQLException e) {
                        String retrySql = this.createSql(procedure, existsReturn, false);
                        try {
                            try {
                                cs.close();
                            }
                            catch (SQLException ignored) {
                                // empty catch block
                            }
                            cs = conn.prepareCall(retrySql);
                            this.setupBindParameter(conn, (CallableStatement)cs, columnList, testValueList, boundColumnList);
                            executed = cs.execute();
                            _log.info((Object)("  (o) retry: " + retrySql));
                        }
                        catch (SQLException ignored) {
                            _log.info((Object)("  (x) retry: " + retrySql));
                            throw e;
                        }
                    }
                    if (executed) {
                        int closetIndex = 0;
                        while ((rs = cs.getResultSet()) != null) {
                            Map<String, DfColumnMetaInfo> columnMetaInfoMap = this.extractColumnMetaInfoMap(rs, sql);
                            DfProcedureNotParamResultMetaInfo notParamResult = new DfProcedureNotParamResultMetaInfo();
                            String propertyName = procedure.isCalledBySelect() && closetIndex == 0 ? "returnResult" : "notParamResult" + (closetIndex + 1);
                            notParamResult.setPropertyName(propertyName);
                            notParamResult.setResultSetColumnInfoMap(columnMetaInfoMap);
                            procedure.addNotParamResult(notParamResult);
                            ++closetIndex;
                            if (cs.getMoreResults()) continue;
                        }
                    }
                    int index = 0;
                    for (DfProcedureColumnMetaInfo column : boundColumnList) {
                        DfProcedureColumnMetaInfo.DfProcedureColumnType columnType = column.getProcedureColumnType();
                        if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn.equals((Object)columnType)) {
                            ++index;
                            continue;
                        }
                        int paramIndex = index + 1;
                        Object obj = column.isPostgreSQLCursor() ? this._postgreSqlResultSetType.getValue((CallableStatement)cs, paramIndex) : (column.isOracleCursor() ? this._oracleResultSetType.getValue((CallableStatement)cs, paramIndex) : cs.getObject(paramIndex));
                        if (obj instanceof ResultSet) {
                            rs = (ResultSet)obj;
                            Map<String, DfColumnMetaInfo> columnMetaInfoMap = this.extractColumnMetaInfoMap(rs, sql);
                            column.setResultSetColumnInfoMap(columnMetaInfoMap);
                        }
                        ++index;
                    }
                    Object var20_29 = null;
                    if (cs == null) break block22;
                }
                catch (SQLException e) {
                    ExceptionMessageBuilder br = new ExceptionMessageBuilder();
                    br.addNotice("Failed to execute the procedure for getting meta data.");
                    br.addItem("SQL");
                    br.addElement((Object)sql);
                    br.addItem("Parameter");
                    for (DfProcedureColumnMetaInfo column : columnList) {
                        br.addElement((Object)column.getColumnDisplayName());
                    }
                    br.addItem("Test Value");
                    br.addElement((Object)this.buildTestValueDisp(testValueList));
                    br.addItem("Exception Message");
                    br.addElement((Object)DfJDBCException.extractMessage(e));
                    SQLException nextEx = e.getNextException();
                    if (nextEx != null) {
                        br.addElement((Object)DfJDBCException.extractMessage(nextEx));
                    }
                    String msg = br.buildExceptionMessage();
                    DfOutsideSqlProperties prop = this.getProperties().getOutsideSqlProperties();
                    if (prop.hasSpecifiedExecutionMetaProcedure()) {
                        throw new DfProcedureExecutionMetaGettingFailureException(msg, e);
                    }
                    this._continuedFailureMessageMap.put(procedure.getProcedureFullQualifiedName(), msg);
                    _log.info((Object)msg);
                    Object var20_30 = null;
                    if (cs != null) {
                        cs.close();
                    }
                    if (conn == null) return;
                    conn.rollback();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var20_31 = null;
                if (cs != null) {
                    cs.close();
                }
                if (conn == null) throw throwable;
                conn.rollback();
                throw throwable;
            }
            cs.close();
        }
        if (conn == null) return;
        conn.rollback();
    }

    protected String buildTestValueDisp(List<Object> testValueList) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Object value : testValueList) {
            if (value instanceof String) {
                sb.append("\"").append(value).append("\"");
                continue;
            }
            sb.append(value);
        }
        sb.append("}");
        return sb.toString();
    }

    protected boolean existsReturnValue(List<DfProcedureColumnMetaInfo> columnList) {
        for (DfProcedureColumnMetaInfo column : columnList) {
            DfProcedureColumnMetaInfo.DfProcedureColumnType columnType = column.getProcedureColumnType();
            if (!DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn.equals((Object)columnType)) continue;
            return true;
        }
        return false;
    }

    protected boolean needsToCall(List<DfProcedureColumnMetaInfo> columnList) {
        if (!this.isOracle() && !this.isPostgreSQL()) {
            return true;
        }
        for (DfProcedureColumnMetaInfo column : columnList) {
            DfProcedureColumnMetaInfo.DfProcedureColumnType columnType = column.getProcedureColumnType();
            if (!DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut.equals((Object)columnType) && !DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut.equals((Object)columnType) && !DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn.equals((Object)columnType)) continue;
            return true;
        }
        return false;
    }

    protected String buildParameterTypeView(List<DfProcedureColumnMetaInfo> columnList) {
        StringBuilder sb = new StringBuilder();
        String prefix = "procedureColumn";
        for (DfProcedureColumnMetaInfo column : columnList) {
            String name = column.getProcedureColumnType().name();
            if (name.startsWith("procedureColumn")) {
                name = name.substring("procedureColumn".length());
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected void setupTestValueList(List<DfProcedureColumnMetaInfo> columnList, List<Object> testValueList) {
        for (DfProcedureColumnMetaInfo column : columnList) {
            this.doSetupTestValueList(column, testValueList);
        }
    }

    protected void doSetupTestValueList(DfProcedureColumnMetaInfo column, List<Object> testValueList) {
        Object testValue;
        if (!column.isInputParameter()) {
            return;
        }
        if (column.isPostgreSQLUuid() || column.isSQLServerUniqueIdentifier()) {
            testValueList.add("FD8C7155-3A0A-DB11-BAC4-0011F5099158");
            return;
        }
        String stringValue = "0";
        String jdbcType = this.findJdbcType(column);
        String javaNative = this.findNativeType(jdbcType, column);
        if (this.isJavaNativeStringObject(javaNative)) {
            testValue = "0";
        } else if (this.isJavaNativeNumberObject(javaNative)) {
            testValue = 0;
        } else if (this.isJavaNativeDateObject(javaNative)) {
            testValue = TypeMap.isJdbcTypeDate(jdbcType) ? DfTypeUtil.toSqlDate((Object)"2006-09-26") : (TypeMap.isJdbcTypeTime(jdbcType) ? DfTypeUtil.toTime((Object)"18:21:00") : DfTypeUtil.toTimestamp((Object)"2006-09-26 18:21:00"));
        } else if (this.isJavaNativeBooleanObject(javaNative)) {
            testValue = Boolean.FALSE;
        } else if (this.isJavaNativeBinaryObject(javaNative)) {
            String encoding = "UTF-8";
            try {
                testValue = "0".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                String msg = "Unsupported encoding: UTF-8";
                throw new IllegalStateException(msg, e);
            }
        } else {
            testValue = "0";
        }
        testValueList.add(testValue);
    }

    protected String findJdbcType(DfProcedureColumnMetaInfo column) {
        int jdbcDefType = column.getJdbcDefType();
        String dbTypeName = column.getDbTypeName();
        return this._columnHandler.getColumnJdbcType(jdbcDefType, dbTypeName);
    }

    protected String findNativeType(String jdbcType, DfProcedureColumnMetaInfo column) {
        Integer columnSize = column.getColumnSize();
        Integer decimalDigits = column.getDecimalDigits();
        return TypeMap.findJavaNativeByJdbcType(jdbcType, columnSize, decimalDigits);
    }

    protected boolean isJavaNativeStringObject(String javaNative) {
        return this.getTypeMappingProperties().isJavaNativeStringObject(javaNative);
    }

    protected boolean isJavaNativeNumberObject(String javaNative) {
        return this.getTypeMappingProperties().isJavaNativeNumberObject(javaNative);
    }

    protected boolean isJavaNativeDateObject(String javaNative) {
        return this.getTypeMappingProperties().isJavaNativeDateObject(javaNative);
    }

    protected boolean isJavaNativeBooleanObject(String javaNative) {
        return this.getTypeMappingProperties().isJavaNativeBooleanObject(javaNative);
    }

    protected boolean isJavaNativeBinaryObject(String javaNative) {
        return this.getTypeMappingProperties().isJavaNativeBinaryObject(javaNative);
    }

    public String createSql(DfProcedureMetaInfo procedure, boolean existsReturn, boolean escape) {
        int argSize;
        boolean calledBySelect = procedure.isCalledBySelect();
        if (calledBySelect) {
            existsReturn = false;
            escape = false;
        }
        String procedureSqlName = procedure.buildProcedureSqlName();
        int bindSize = procedure.getBindParameterCount();
        StringBuilder sb = new StringBuilder();
        if (escape) {
            sb.append("{");
        }
        if (existsReturn) {
            sb.append("? = ");
            argSize = bindSize - 1;
        } else {
            argSize = bindSize;
        }
        if (calledBySelect) {
            sb.append("select * from ");
        } else {
            sb.append("call ");
        }
        sb.append(procedureSqlName).append("(");
        for (int i = 0; i < argSize; ++i) {
            sb.append("?, ");
        }
        if (argSize > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        if (escape) {
            sb.append("}");
        }
        return sb.toString();
    }

    protected void setupBindParameter(Connection conn, CallableStatement cs, List<DfProcedureColumnMetaInfo> columnList, List<Object> testValueList, List<DfProcedureColumnMetaInfo> boundColumnList) throws SQLException {
        boundColumnList.clear();
        int index = 0;
        int testValueIndex = 0;
        for (DfProcedureColumnMetaInfo column : columnList) {
            if (!column.isBindParameter()) continue;
            int paramIndex = index + 1;
            DfProcedureColumnMetaInfo.DfProcedureColumnType columnType = column.getProcedureColumnType();
            int jdbcDefType = column.getJdbcDefType();
            if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn.equals((Object)columnType)) {
                this.registerOutParameter(conn, cs, paramIndex, jdbcDefType, column);
                boundColumnList.add(column);
            } else if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn.equals((Object)columnType)) {
                this.bindObject(conn, cs, paramIndex, jdbcDefType, testValueList.get(testValueIndex), column);
                ++testValueIndex;
                boundColumnList.add(column);
            } else if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut.equals((Object)columnType)) {
                this.registerOutParameter(conn, cs, paramIndex, jdbcDefType, column);
                boundColumnList.add(column);
            } else if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut.equals((Object)columnType)) {
                this.registerOutParameter(conn, cs, paramIndex, jdbcDefType, column);
                this.bindObject(conn, cs, paramIndex, jdbcDefType, testValueList.get(testValueIndex), column);
                ++testValueIndex;
                boundColumnList.add(column);
            }
            ++index;
        }
    }

    protected void registerOutParameter(Connection conn, CallableStatement cs, int paramIndex, int jdbcDefType, DfProcedureColumnMetaInfo column) throws SQLException {
        ValueType forcedType = this.getForcedValueType(column);
        ValueType valueType = forcedType != null ? forcedType : (column.isPostgreSQLCursor() ? this._postgreSqlResultSetType : (column.isOracleCursor() ? this._oracleResultSetType : TnValueTypes.getValueType((int)jdbcDefType)));
        try {
            if (column.isOracleTreatedAsArray() && column.hasTypeArrayInfo()) {
                cs.registerOutParameter(paramIndex, 2003, column.getTypeArrayInfo().getTypeSqlName());
            } else if (column.isOracleStruct() && column.hasTypeStructInfo()) {
                cs.registerOutParameter(paramIndex, 2002, column.getTypeStructInfo().getTypeSqlName());
            } else {
                valueType.registerOutParameter(conn, cs, paramIndex);
            }
        }
        catch (SQLException e) {
            String msg = this.buildOutParameterExceptionMessage(paramIndex, jdbcDefType, column, valueType);
            throw new DfJDBCException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = this.buildOutParameterExceptionMessage(paramIndex, jdbcDefType, column, valueType);
            throw new IllegalStateException(msg, e);
        }
    }

    protected String buildOutParameterExceptionMessage(int paramIndex, int jdbcDefType, DfProcedureColumnMetaInfo column, ValueType valueType) {
        String msg = "Failed to register OUT parameter(" + paramIndex + "|" + jdbcDefType + "):";
        msg = msg + " " + column.getColumnNameDisp() + " - " + column.getColumnDefinitionLineDisp();
        msg = msg + " :: " + valueType.getClass().getName();
        return msg;
    }

    protected void bindObject(Connection conn, CallableStatement cs, int paramIndex, int jdbcDefType, Object value, DfProcedureColumnMetaInfo column) throws SQLException {
        ValueType forcedType = this.getForcedValueType(column);
        ValueType valueType = forcedType != null ? forcedType : TnValueTypes.findByValueOrJdbcDefType((Object)value, (int)jdbcDefType);
        try {
            if (column.isOracleTreatedAsArray() && column.hasTypeArrayInfo()) {
                cs.setNull(paramIndex, 2003, column.getTypeArrayInfo().getTypeSqlName());
            } else if (column.isOracleStruct() && column.hasTypeStructInfo()) {
                cs.setNull(paramIndex, 2002, column.getTypeStructInfo().getTypeSqlName());
            } else {
                valueType.bindValue(conn, (PreparedStatement)cs, paramIndex, value);
            }
        }
        catch (SQLException e) {
            String msg = this.buildBindingExceptionMessage(paramIndex, jdbcDefType, value, column, valueType);
            throw new DfJDBCException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = this.buildBindingExceptionMessage(paramIndex, jdbcDefType, value, column, valueType);
            throw new IllegalStateException(msg, e);
        }
    }

    protected String buildBindingExceptionMessage(int paramIndex, int jdbcDefType, Object value, DfProcedureColumnMetaInfo column, ValueType valueType) {
        String msg = "Failed to bind parameter(" + paramIndex + "|" + jdbcDefType + "):";
        msg = msg + " " + column.getColumnNameDisp() + " - " + column.getColumnDefinitionLineDisp();
        msg = msg + " :: " + value + ", " + valueType.getClass().getName();
        return msg;
    }

    protected ValueType getForcedValueType(DfProcedureColumnMetaInfo column) {
        Object valueType = column.isOracleNCharOrNVarchar() ? this._stringType : (column.isConceptTypeStringClob() ? this._stringClobType : (column.isConceptTypeBytesOid() ? this._bytesOidType : (column.isConceptTypeFixedLengthString() ? this._fixedLengthStringType : (column.isConceptTypeObjectBindingBigDecimal() ? this._objectBindingBigDecimalType : (column.isPostgreSQLUuid() ? this._uuidAsDirectType : (column.isSQLServerUniqueIdentifier() ? this._uuidAsStringType : null))))));
        return valueType;
    }

    protected Map<String, DfColumnMetaInfo> extractColumnMetaInfoMap(ResultSet rs, String sql) throws SQLException {
        return this._extractor.extractColumnMetaInfoMap(rs, sql, null);
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfTypeMappingProperties getTypeMappingProperties() {
        return this.getProperties().getTypeMappingProperties();
    }

    protected boolean isOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    protected boolean isPostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    protected boolean isDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    protected boolean isSQLServer() {
        return this.getBasicProperties().isDatabaseSQLServer();
    }

    protected boolean isSQLite() {
        return this.getBasicProperties().isDatabaseSQLite();
    }

    protected boolean isMsAccess() {
        return this.getBasicProperties().isDatabaseMSAccess();
    }

    protected String ln() {
        return "\n";
    }

    public Map<String, String> getContinuedFailureMessageMap() {
        return this._continuedFailureMessageMap;
    }
}

