/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.helper.jdbc.connection.DfConnectionMetaInfo;
import org.seasar.dbflute.helper.jdbc.connection.DfConnectionProvider;
import org.seasar.dbflute.helper.jdbc.connection.DfSimpleConnection;
import org.seasar.dbflute.helper.jdbc.connection.DfSimpleDataSource;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;

public class DfDataSourceHandler
implements DfConnectionProvider {
    private static Log _log = LogFactory.getLog(DfDataSourceHandler.class);
    protected String _driver;
    protected String _url;
    protected String _userId;
    protected String _password;
    protected Properties _connectionProperties;
    protected boolean _autoCommit;
    protected Connection _cachedConnection;
    protected DfConnectionMetaInfo _connectionMetaInfo;
    protected boolean _alreadySetupMeta;

    public void create() throws SQLException {
        if (!DfDataSourceContext.isExistDataSource()) {
            _log.info((Object)"...Creating data source:");
            _log.info((Object)("  driver = " + this._driver));
            _log.info((Object)("  url    = " + this._url));
            _log.info((Object)("  user   = " + this._userId));
            DfDataSourceContext.setDataSource(new DfSimpleDataSource(this));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        block12: {
            block11: {
                conn = null;
                try {
                    try {
                        conn = this.getCachedConnection();
                        if (conn == null) {
                            var5_2 = null;
                            if (conn == null) return;
                            break block11;
                        }
                        if (!conn.getAutoCommit()) {
                            DfDataSourceHandler._log.info((Object)"...commit()");
                            conn.commit();
                        }
                        break block12;
                    }
                    catch (SQLException e) {
                        msg = "Failed to commit the conection: conn=" + conn;
                        throw new DfJDBCException(msg, e);
                    }
                }
                catch (Throwable var4_10) {
                    var5_4 = null;
                    if (conn == null) throw var4_10;
                    try {
                        conn.close();
                        throw var4_10;
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    throw var4_10;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 91->100)] { 
lbl29:
            // 1 sources

            conn.close();
            return;
lbl31:
            // 1 sources

            catch (SQLException ignored) {
                // empty catch block
            }
            return;
        }
        var5_3 = null;
        if (conn == null) return;
        try {}
        catch (SQLException ignored) {}
        conn.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() throws SQLException {
        block10: {
            block9: {
                try {
                    try {
                        Connection conn = this.getCachedConnection();
                        if (conn == null) {
                            Object var3_3 = null;
                            break block9;
                        }
                        if (!conn.getAutoCommit()) {
                            _log.info((Object)"...rollback()");
                            conn.rollback();
                        }
                        if (conn instanceof DfSimpleConnection) {
                            _log.info((Object)"...closeReally()");
                            ((DfSimpleConnection)conn).closeReally();
                            break block10;
                        } else {
                            _log.info((Object)"...close()");
                            conn.close();
                        }
                        break block10;
                    }
                    catch (SQLException sQLException) {
                        Object var3_5 = null;
                        if (!DfDataSourceContext.isExistDataSource()) return;
                        DfDataSourceContext.clearDataSource();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    if (!DfDataSourceContext.isExistDataSource()) throw throwable;
                    DfDataSourceContext.clearDataSource();
                    throw throwable;
                }
            }
            if (!DfDataSourceContext.isExistDataSource()) return;
            DfDataSourceContext.clearDataSource();
            return;
        }
        Object var3_4 = null;
        if (!DfDataSourceContext.isExistDataSource()) return;
        DfDataSourceContext.clearDataSource();
    }

    public Connection getConnection() throws SQLException {
        return this.processCachedConnection();
    }

    public Connection getCachedConnection() {
        return this._cachedConnection;
    }

    protected Connection processCachedConnection() throws SQLException {
        if (this._cachedConnection != null) {
            return this._cachedConnection;
        }
        Connection conn = this.createConnection();
        this._cachedConnection = new DfSimpleConnection(conn);
        this.processConnectionMetaInfo(conn);
        return this._cachedConnection;
    }

    protected Connection createConnection() throws SQLException {
        Connection conn = null;
        Driver driverInstance = this.newDriver();
        Properties info = new Properties();
        if (this._connectionProperties != null && !this._connectionProperties.isEmpty()) {
            info.putAll((Map<?, ?>)this._connectionProperties);
        }
        info.put("user", this._userId);
        info.put("password", this._password);
        try {
            _log.info((Object)"...Connecting to the database:");
            conn = driverInstance.connect(this._url, info);
        }
        catch (SQLException e) {
            String msg = "Failed to connect:";
            msg = msg + " url=" + this._url + " user=" + this._userId;
            throw new DfJDBCException(msg, e);
        }
        if (conn == null) {
            String msg = "The driver didn't understand the URL: " + this._url;
            throw new DfJDBCException(msg);
        }
        try {
            conn.setAutoCommit(this._autoCommit);
        }
        catch (SQLException e) {
            String msg = "Failed to set auto commit:";
            msg = msg + " autocommit=" + this._autoCommit;
            throw new DfJDBCException(msg, e);
        }
        return conn;
    }

    protected Driver newDriver() {
        Driver driverInstance;
        String driver = this._driver;
        try {
            Class<?> dc = Class.forName(driver);
            driverInstance = (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            String msg = "Class Not Found: JDBC driver " + driver + " could not be loaded.";
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal Access: JDBC driver " + driver + " could not be loaded.";
            throw new IllegalStateException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Instantiation Exception: JDBC driver " + driver + " could not be loaded.";
            throw new IllegalStateException(msg, e);
        }
        return driverInstance;
    }

    protected void processConnectionMetaInfo(Connection conn) throws SQLException {
        if (this._alreadySetupMeta) {
            return;
        }
        try {
            DfConnectionMetaInfo metaInfo = new DfConnectionMetaInfo();
            DatabaseMetaData metaData = conn.getMetaData();
            metaInfo.setProductName(metaData.getDatabaseProductName());
            metaInfo.setProductVersion(metaData.getDatabaseProductVersion());
            metaInfo.setDriverName(metaData.getDriverName());
            metaInfo.setDriverVersion(metaData.getDriverVersion());
            int majorVersion = metaData.getJDBCMajorVersion();
            int minorVersion = metaData.getJDBCMinorVersion();
            metaInfo.setJdbcVersion(majorVersion + "." + minorVersion);
            _log.info((Object)("  product = " + metaInfo.getProductDisp()));
            _log.info((Object)("  driver  = " + metaInfo.getDriverDisp()));
            this._connectionMetaInfo = metaInfo;
        }
        catch (SQLException continued) {
            _log.info((Object)("*Failed to get connection meta: " + continued.getMessage()));
            this._connectionMetaInfo = null;
        }
        this._alreadySetupMeta = true;
    }

    public String toString() {
        return "{url=" + this._url + ", user=" + this._userId + ", prop=" + this._connectionProperties + "}";
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this._connectionProperties = connectionProperties;
    }

    public void setAutoCommit(boolean autoCommit) {
        this._autoCommit = autoCommit;
    }

    public DfConnectionMetaInfo getConnectionMetaInfo() {
        return this._connectionMetaInfo;
    }
}

